/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.apply;

import java.math.BigDecimal;
import java.util.TreeSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;

public class PurApplyBillQtyValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject bill = entity.getDataEntity();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            TreeSet<Integer> indexs = new TreeSet<Integer>();
            if (entrys.size() == 0) continue;
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                BigDecimal qty = entry.getBigDecimal("qty");
                if (qty.compareTo(BigDecimal.ZERO) != 0) continue;
                indexs.add(i + 1);
            }
            if (indexs.size() <= 0) continue;
            this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%1$s\u884c\u201c\u6838\u51c6\u6570\u91cf\u201d\u3002", (String)"PurApplyBillQtyValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), indexs), ErrorLevel.Error);
            indexs.clear();
        }
    }
}

