/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.apply;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.pm.business.helper.PurApplyMalHelper;

public class PurApplyMalValidator
extends AbstractValidator {
    public void validate() {
        String key;
        switch (key = this.getOperateKey()) {
            case "malpurchase": {
                this.malPurchase();
                break;
            }
            case "showmalorder": {
                this.getMalOrderIds();
                break;
            }
        }
    }

    private void malPurchase() {
        Map result = PurApplyMalHelper.malPurchase((OperateOption)this.getOption(), (ExtendedDataEntity[])this.dataEntities);
        if (result == null) {
            return;
        }
        Boolean success = (Boolean)result.get("success");
        if (success == null || !success.booleanValue()) {
            this.batchErrorMessage((String)result.get("message"));
        }
    }

    private void getMalOrderIds() {
        HashSet<String> billIds = new HashSet<String>(this.dataEntities.length << 1);
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            billIds.add(String.valueOf(extendedDataEntity.getBillPkId()));
        }
        Set malOrderIds = PurApplyMalHelper.getMalOrderIds(billIds, (OperateOption)this.getOption());
        if (malOrderIds == null || malOrderIds.isEmpty()) {
            this.batchErrorMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"PurApplyMalValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]));
        }
    }

    private void batchErrorMessage(String message) {
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            this.addErrorMessage(extendedDataEntity, message);
        }
    }
}

