/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.apply;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.scmc.pm.enums.ChangeTypeEnum;

public class XPurApplyBillQtyValidator
extends AbstractValidator {
    private final BigDecimal ZERO = BigDecimal.ZERO;

    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            if (entrys == null || entrys.size() <= 0) continue;
            for (DynamicObject entry : entrys) {
                BigDecimal baseQty;
                int seq = entry.getInt("seq");
                String entryChangeType = entry.getString("entrychangetype");
                BigDecimal joinBaseQty = entry.getBigDecimal("joinbaseqty");
                if (this.ZERO.compareTo(joinBaseQty) < 0 && ChangeTypeEnum.CANCEL.getValue().equals(entryChangeType)) {
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u7684\u201c\u5173\u8054\u6570\u91cf\u201d\u5927\u4e8e0\uff0c\u4e0d\u80fd\u53d6\u6d88\u3002", (String)"XPurApplyBillQtyValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), seq), ErrorLevel.Error);
                }
                if ((baseQty = entry.getBigDecimal("baseqty")) == null || baseQty.compareTo(joinBaseQty) >= 0 || !ChangeTypeEnum.UPDATE.getValue().equals(entryChangeType)) continue;
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u53d8\u66f4\u540e\u7684\u201c\u6838\u51c6\u6570\u91cf\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u201c\u5173\u8054\u6570\u91cf\u201d\u3002", (String)"XPurApplyBillQtyValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), seq), ErrorLevel.Error);
            }
        }
    }
}

