/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.basedata;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class QuotaDateValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject quota = data.getDataEntity();
            DynamicObjectCollection entrys = quota.getDynamicObjectCollection("entryentity");
            if (entrys == null || entrys.size() <= 0) continue;
            HashSet<Date> set = new HashSet<Date>(16);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            for (DynamicObject entry : entrys) {
                Date effectdate = entry.getDate("effectdate");
                Date expirtdate = entry.getDate("expirydate");
                if (effectdate == null || expirtdate == null) continue;
                if (effectdate.compareTo(expirtdate) == 0) {
                    if (set.add(effectdate)) continue;
                    String date1 = sdf.format(effectdate);
                    this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e3a%1$s\u7684\u6709\u6548\u671f\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"QuotaDateValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), date1));
                    continue;
                }
                if (!set.add(effectdate)) {
                    String date2 = sdf.format(effectdate);
                    this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e3a%1$s\u7684\u6709\u6548\u671f\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"QuotaDateValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), date2));
                    continue;
                }
                if (set.add(expirtdate)) continue;
                String date3 = sdf.format(expirtdate);
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u6709\u6548\u671f\u4e3a%1$s\u7684\u65e5\u671f\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"QuotaDateValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), date3));
            }
        }
    }
}

