/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.basedata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.quotamodel.business.helper.QuotaCategoryHelper;

public class QuotaDimensionValidator
extends AbstractValidator {
    private static final String sysTem = "scmc-pm-opplugin";
    private static final Log log = LogFactory.getLog(QuotaDimensionValidator.class);

    public void validate() {
        HashMap<Long, List<ExtendedDataEntity>> curBillMap = new HashMap<Long, List<ExtendedDataEntity>>();
        HashMap<Long, DynamicObject> quotaCategoryMap = new HashMap<Long, DynamicObject>();
        this.prepareData(curBillMap, quotaCategoryMap);
        HashSet<DynamicObject> quotaCategorySet = new HashSet<DynamicObject>(8);
        for (Map.Entry quotaCategory : quotaCategoryMap.entrySet()) {
            quotaCategorySet.add((DynamicObject)quotaCategory.getValue());
        }
        Map quotaDimensionMap = QuotaCategoryHelper.getQuotaDimension(quotaCategorySet);
        for (Map.Entry listEntry : curBillMap.entrySet()) {
            Long categoryId = (Long)listEntry.getKey();
            List<ExtendedDataEntity> bills = (List<ExtendedDataEntity>)listEntry.getValue();
            bills = this.filter(bills);
            DynamicObject quotaCategory = (DynamicObject)quotaCategoryMap.get(categoryId);
            if (quotaCategory != null && !CommonUtils.isNull((Object)quotaDimensionMap) && !CommonUtils.isNull(quotaDimensionMap.get(categoryId))) {
                try {
                    DataSet pmQuota = this.queryData(bills, categoryId, (Map)quotaDimensionMap.get(categoryId));
                    Throwable throwable = null;
                    try {
                        DataSet curData = this.convertToDataSet(bills, pmQuota.getRowMeta());
                        Throwable throwable2 = null;
                        try {
                            this.checkDataUnique(pmQuota, curData.copy(), (Map)quotaDimensionMap.get(categoryId));
                            this.checkResultUnique(curData.copy(), (Map)quotaDimensionMap.get(categoryId));
                            this.checkQuotaRatio(curData.copy(), (Map)quotaDimensionMap.get(categoryId));
                            continue;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (curData == null) continue;
                            if (throwable2 != null) {
                                try {
                                    curData.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            curData.close();
                            continue;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (pmQuota == null) continue;
                        if (throwable != null) {
                            try {
                                pmQuota.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        pmQuota.close();
                        continue;
                    }
                }
                catch (Exception e) {
                    log.error("quota validator error", (Throwable)e);
                    throw new KDBizException(ResManager.loadKDString((String)"\u6821\u9a8c\u5f02\u5e38\u3002", (String)"QuotaDimensionValidator_3", (String)sysTem, (Object[])new Object[0]));
                }
            }
            if (quotaCategory != null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4e0e\u914d\u989d\u57fa\u7840\u6a21\u578b\u7684\u6620\u5c04\u3002", (String)"QuotaDimensionValidator_7", (String)sysTem, (Object[])new Object[0]));
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5ID\u4e3a%s\u7684\u914d\u989d\u7c7b\u578b\u3002", (String)"QuotaDimensionValidator_8", (String)sysTem, (Object[])new Object[]{categoryId}));
        }
    }

    private List<ExtendedDataEntity> filter(List<ExtendedDataEntity> bills) {
        return bills.stream().filter((? super T e) -> e.getDataEntity().getString("status").equals("A")).collect(Collectors.toList());
    }

    private void checkDataUnique(DataSet pmQuota, DataSet curData, Map<String, Object> quotaDimensionMap) {
        HashSet<Integer> errorData = new HashSet<Integer>();
        this.checkDateUniqueInSelf(curData.copy(), quotaDimensionMap, errorData);
        DataSet union = pmQuota.union(curData.copy());
        this.checkDateUniqueInAll(union.copy(), quotaDimensionMap, errorData);
        this.checkDataUniqueInAll(union.copy(), quotaDimensionMap, errorData);
    }

    private void checkDataUniqueInAll(DataSet pmQuota, Map<String, Object> quotaDimensionMap, Set<Integer> errorData) {
        List conditionDimensions = (List)quotaDimensionMap.get("conditiondimension");
        String conditionDimensionsName = "";
        if (!CommonUtils.isNull((Object)quotaDimensionMap.get("condimensionallname"))) {
            conditionDimensionsName = ((String)quotaDimensionMap.get("condimensionallname")).replace('+', '\u3001');
        }
        HashSet<String> selectFields = new HashSet<String>(16);
        selectFields.add("dataindex");
        for (String dimension : conditionDimensions) {
            selectFields.add(dimension);
            if (!dimension.startsWith("entryentity.")) continue;
            selectFields.add("entryentity.seq");
        }
        pmQuota = pmQuota.select(selectFields.toArray(new String[selectFields.size()])).distinct();
        if (!conditionDimensions.contains("entryentity.effectdate") && !conditionDimensions.contains("entryentity.expirydate")) {
            DataSet[] splitByGroup = pmQuota.splitByGroup(conditionDimensions.toArray(new String[conditionDimensions.size()]));
            String msg = String.format(ResManager.loadKDString((String)"\u76f8\u540c\u914d\u989d\u7c7b\u578b\u4e2d\uff0c\u201c%s\u201d\u7684\u7ec4\u5408\u503c\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"QuotaDimensionValidator_0", (String)sysTem, (Object[])new Object[0]), conditionDimensionsName);
            for (DataSet dataSet : splitByGroup) {
                int count = 0;
                while (dataSet.hasNext()) {
                    Integer dataIndex;
                    Row row = dataSet.next();
                    if (++count <= 1 || !(dataIndex = row.getInteger("dataindex")).equals(0) || !errorData.add(dataIndex)) continue;
                    this.addErrorMessage(this.getDataEntities()[dataIndex], msg);
                }
            }
        }
    }

    private void checkDateUniqueInSelf(DataSet pmQuota, Map<String, Object> quotaDimensionMap, Set<Integer> errorData) {
        ArrayList<String> conditionDimensions = new ArrayList<String>(8);
        conditionDimensions.addAll((List)quotaDimensionMap.get("conditiondimension"));
        String conditionDimensionsName = "";
        if (!CommonUtils.isNull((Object)quotaDimensionMap.get("condimensionallname"))) {
            conditionDimensionsName = ((String)quotaDimensionMap.get("condimensionallname")).replace('+', '\u3001');
        }
        if (conditionDimensions.contains("entryentity.effectdate") && conditionDimensions.contains("entryentity.expirydate")) {
            conditionDimensions.remove("entryentity.effectdate");
            conditionDimensions.remove("entryentity.expirydate");
            conditionDimensions.add("dataindex");
            DataSet[] splitByGroup = pmQuota.splitByGroup(conditionDimensions.toArray(new String[conditionDimensions.size()]));
            String msg = String.format(ResManager.loadKDString((String)"\u76f8\u540c\u914d\u989d\u7c7b\u578b\u4e2d\uff0c\u914d\u989d\u7c7b\u578b\u6761\u4ef6\u7ef4\u5ea6\u503c\u76f8\u540c\u7684\u6570\u636e\uff0c\u751f\u6548\u65e5\u671f\u548c\u5931\u6548\u65e5\u671f\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"QuotaDimensionValidator_4", (String)sysTem, (Object[])new Object[0]), conditionDimensionsName);
            ArrayList groupList = new ArrayList(16);
            for (DataSet dataSet : splitByGroup) {
                DataSet orderBy = dataSet.orderBy(new String[]{"entryentity.effectdate asc", "entryentity.expirydate asc"});
                HashMap<Integer, List> groupBillMap = new HashMap<Integer, List>();
                while (orderBy.hasNext()) {
                    Row row = orderBy.next();
                    Integer dataIndex = row.getInteger("dataindex");
                    Date effectdate = row.getDate("entryentity.effectdate");
                    Date expirydate = row.getDate("entryentity.expirydate");
                    List list = groupBillMap.computeIfAbsent(dataIndex, a -> new ArrayList());
                    list.add(new Object[]{dataIndex, effectdate, expirydate});
                }
                groupList.add(groupBillMap);
            }
            for (Map map : groupList) {
                for (Map.Entry entry : map.entrySet()) {
                    Integer dataIndex = (Integer)entry.getKey();
                    Date preValidDate = null;
                    Date preInValidDate = null;
                    List value = (List)entry.getValue();
                    for (Object[] obj : value) {
                        Date curValidDate = (Date)obj[1];
                        Date curInValidDate = (Date)obj[2];
                        if (preValidDate != null && preInValidDate != null && (preValidDate.compareTo(curValidDate) != 0 || preInValidDate.compareTo(curInValidDate) != 0) && preInValidDate.compareTo(curValidDate) >= 0) {
                            if (errorData.add(dataIndex)) {
                                this.addErrorMessage(this.getDataEntities()[dataIndex], msg);
                            }
                            return;
                        }
                        preValidDate = curValidDate;
                        preInValidDate = curInValidDate;
                    }
                }
            }
        }
    }

    private void checkDateUniqueInAll(DataSet pmQuota, Map<String, Object> quotaDimensionMap, Set<Integer> errorData) {
        ArrayList conditionDimensions = new ArrayList(8);
        conditionDimensions.addAll((List)quotaDimensionMap.get("conditiondimension"));
        HashSet<String> selectFields = new HashSet<String>(16);
        selectFields.add("dataindex");
        for (String dimension : conditionDimensions) {
            selectFields.add(dimension);
            if (!dimension.startsWith("entryentity.")) continue;
            selectFields.add("entryentity.seq");
        }
        pmQuota = pmQuota.select(selectFields.toArray(new String[selectFields.size()])).distinct();
        if (conditionDimensions.contains("entryentity.effectdate") && conditionDimensions.contains("entryentity.expirydate")) {
            conditionDimensions.remove("entryentity.effectdate");
            conditionDimensions.remove("entryentity.expirydate");
            DataSet[] splitByGroup = pmQuota.splitByGroup(conditionDimensions.toArray(new String[conditionDimensions.size()]));
            String msg = ResManager.loadKDString((String)"\u76f8\u540c\u914d\u989d\u7c7b\u578b\u4e2d\uff0c\u914d\u989d\u7c7b\u578b\u6761\u4ef6\u7ef4\u5ea6\u503c\u76f8\u540c\u7684\u6570\u636e\uff0c\u751f\u6548\u65e5\u671f\u548c\u5931\u6548\u65e5\u671f\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"QuotaDimensionValidator_4", (String)sysTem, (Object[])new Object[0]);
            for (DataSet dataSet : splitByGroup) {
                DataSet orderByDate = dataSet.orderBy(new String[]{"entryentity.effectdate asc", "entryentity.expirydate asc"});
                Date preDate = null;
                Integer preDataIndex = null;
                while (orderByDate.hasNext()) {
                    Row row = orderByDate.next();
                    Date curValidDate = row.getDate("entryentity.effectdate");
                    Date curInValidDate = row.getDate("entryentity.expirydate");
                    Integer dataIndex = row.getInteger("dataindex");
                    if (preDataIndex == null) {
                        preDataIndex = dataIndex;
                        preDate = curInValidDate;
                        continue;
                    }
                    if (curValidDate == null || curInValidDate == null) continue;
                    if (!dataIndex.equals(preDataIndex) && preDate != null && preDate.compareTo(curValidDate) >= 0) {
                        if (dataIndex != -1 && errorData.add(dataIndex)) {
                            this.addErrorMessage(this.getDataEntities()[dataIndex], msg);
                        }
                        if (preDataIndex != -1 && errorData.add(preDataIndex)) {
                            this.addErrorMessage(this.getDataEntities()[preDataIndex], msg);
                        }
                    }
                    preDate = curInValidDate;
                    preDataIndex = dataIndex;
                }
            }
        }
    }

    private void checkQuotaRatio(DataSet dataSet, Map<String, Object> quotaDimensionMap) {
        DataSet[] dimensionGroups;
        List dimensionFields = (List)quotaDimensionMap.get("conditiondimension");
        dimensionFields.add("dataindex");
        for (DataSet group : dimensionGroups = dataSet.splitByGroup(dimensionFields.toArray(new String[dimensionFields.size()]))) {
            DataSet[] priorityGroups;
            for (DataSet priorityGroup : priorityGroups = group.splitByGroup(new String[]{"entryentity.supplyrank"})) {
                ArrayList<Object[]> ratioList = new ArrayList<Object[]>(16);
                priorityGroup = priorityGroup.orderBy(new String[]{"entryentity.seq desc"});
                BigDecimal ratio = BigDecimal.ZERO;
                while (priorityGroup.hasNext()) {
                    Row row = priorityGroup.next();
                    Integer dataIndex = row.getInteger("dataindex");
                    Integer seq = row.getInteger("entryentity.seq");
                    BigDecimal quotarate = row.getBigDecimal("entryentity.quotarate");
                    ratio = ratio.add(quotarate);
                    ratioList.add(new Object[]{dataIndex, seq});
                }
                if (ratio.compareTo(new BigDecimal(100)) != 0) {
                    for (Object[] obj : ratioList) {
                        Integer dataIndex = (Integer)obj[0];
                        Integer seq = (Integer)obj[1];
                        if (dataIndex == null || dataIndex == -1) continue;
                        this.addErrorMessage(this.getDataEntities()[dataIndex], String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u914d\u989d\u7c7b\u578b\u4e2d\u6761\u4ef6\u7ef4\u5ea6\u503c\u76f8\u540c\u7684\u6570\u636e\uff0c\u540c\u4e00\u4f18\u5148\u7ea7\u914d\u989d\u6bd4\u4f8b\u4e0d\u4e3a100\uff0c\u8bf7\u4fee\u6539\u3002", (String)"QuotaDimensionValidator_6", (String)sysTem, (Object[])new Object[0]), seq));
                    }
                }
                ratioList.clear();
            }
        }
    }

    private void checkResultUnique(DataSet dataSet, Map<String, Object> quotaDimensionMap) {
        List conDimensions = (List)quotaDimensionMap.get("conditiondimension");
        conDimensions.add("dataindex");
        List resultDimensions = (List)quotaDimensionMap.get("resultdimension");
        DataSet[] splitByGroups = dataSet.splitByGroup(conDimensions.toArray(new String[conDimensions.size()]));
        ArrayList<Object[]> repeatData = new ArrayList<Object[]>(16);
        for (DataSet splitByGroup : splitByGroups) {
            DataSet[] resultGroups = splitByGroup.splitByGroup(resultDimensions.toArray(new String[resultDimensions.size()]));
            String conDimensionsName = "";
            if (!CommonUtils.isNull((Object)quotaDimensionMap.get("condimensionallname"))) {
                conDimensionsName = ((String)quotaDimensionMap.get("condimensionallname")).replace('+', '\u3001');
            }
            String resultDimensionsName = "";
            if (!CommonUtils.isNull((Object)quotaDimensionMap.get("rsltdimensionallname"))) {
                resultDimensionsName = ((String)quotaDimensionMap.get("rsltdimensionallname")).replace('+', '\u3001');
            }
            for (DataSet result : resultGroups) {
                while (result.hasNext()) {
                    Row row = result.next();
                    Integer dataIndex = row.getInteger("dataindex");
                    Integer seq = row.getInteger("entryentity.seq");
                    repeatData.add(new Object[]{dataIndex, seq});
                }
                if (repeatData.size() > 1) {
                    String resourceID = "QuotaDimensionValidator_1";
                    String msg = ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u914d\u989d\u7c7b\u578b\u6761\u4ef6\u7ef4\u5ea6\u503c\u76f8\u540c\u7684\u6570\u636e\uff0c\u7ed3\u679c\u7ef4\u5ea6\u5b57\u6bb5\u503c\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)resourceID, (String)sysTem, (Object[])new Object[0]);
                    for (Object[] data : repeatData) {
                        Integer dataIndex = (Integer)data[0];
                        if (-1 == dataIndex) continue;
                        this.addErrorMessage(this.getDataEntities()[dataIndex], String.format(msg, data[1], conDimensionsName, resultDimensionsName));
                    }
                }
                repeatData.clear();
            }
        }
    }

    private void prepareData(Map<Long, List<ExtendedDataEntity>> curBillMap, Map<Long, DynamicObject> quotaCategoryMap) {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObject quotaCategory = bill.getDynamicObject("quotacategory");
            if (quotaCategory == null) continue;
            Long quotaCategoryId = (Long)quotaCategory.getPkValue();
            List<ExtendedDataEntity> groupList = curBillMap.get(quotaCategoryId);
            if (groupList == null) {
                groupList = new ArrayList<ExtendedDataEntity>();
                curBillMap.put(quotaCategoryId, groupList);
            }
            groupList.add(data);
            quotaCategoryMap.put(quotaCategoryId, quotaCategory);
        }
    }

    private DataSet queryData(List<ExtendedDataEntity> bills, Long quotaCategoryId, Map<String, Object> quotaDimensionMap) {
        QFilter qFilter = new QFilter("quotacategory", "=", (Object)quotaCategoryId);
        qFilter = qFilter.and(new QFilter("status", "!=", (Object)"A"));
        MainEntityType purquotaEntityType = MetadataServiceHelper.getDataEntityType((String)"pm_purquota");
        Map purquotaFld = purquotaEntityType.getFields();
        List condimensionall = (List)quotaDimensionMap.get("conditiondimensionall");
        for (String condDimension : condimensionall) {
            String[] strs;
            HashSet<Long> fldIds = new HashSet<Long>(16);
            if (purquotaFld.containsKey(condDimension) && purquotaFld.get(condDimension) instanceof BasedataProp) {
                for (ExtendedDataEntity extendedDataEntity : bills) {
                    DynamicObject bill = extendedDataEntity.getDataEntity();
                    fldIds.add(bill.getLong(condDimension + ".id"));
                }
                qFilter = qFilter.and(new QFilter(condDimension, "in", fldIds));
            }
            if (!condDimension.contains(".") || (strs = condDimension.split("\\.")).length != 2) continue;
            for (ExtendedDataEntity dataEntity3 : bills) {
                DynamicObject bill = dataEntity3.getDataEntity();
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection(strs[0]);
                EntryType entrysType = (EntryType)entrys.getDynamicObjectType();
                Map entryFld = entrysType.getFields();
                if (!entryFld.containsKey(strs[1]) || !(entryFld.get(strs[1]) instanceof BasedataProp)) continue;
                for (DynamicObject entry : entrys) {
                    fldIds.add(entry.getLong(strs[1] + ".id"));
                }
                qFilter = qFilter.and(new QFilter(condDimension, "in", fldIds));
            }
        }
        QFilter[] filters = new QFilter[]{qFilter};
        HashSet<String> selectFields = new HashSet<String>();
        List conditiondimensionall = (List)quotaDimensionMap.get("conditiondimensionall");
        List resultdimensionall = (List)quotaDimensionMap.get("resultdimensionall");
        selectFields.addAll(conditiondimensionall);
        selectFields.addAll(resultdimensionall);
        selectFields.add("number");
        selectFields.add("quotacategory");
        selectFields.add("status");
        selectFields.add("enable");
        selectFields.add("entryentity.seq");
        selectFields.add("entryentity.quotarate");
        selectFields.add("entryentity.supplyrank");
        selectFields.add("-1 as dataindex");
        StringJoiner stringJoiner = new StringJoiner(",");
        for (String field : selectFields) {
            stringJoiner.add(field);
        }
        return QueryServiceHelper.queryDataSet((String)"queryPmQuota", (String)"pm_purquota", (String)stringJoiner.toString(), (QFilter[])filters, null);
    }

    private DataSet convertToDataSet(List<ExtendedDataEntity> bills, RowMeta rowMeta) {
        String[] fields = rowMeta.getFieldNames();
        ArrayList<Object[]> currentData = new ArrayList<Object[]>();
        for (ExtendedDataEntity dataEntity : bills) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObjectType mainObjectType = bill.getDynamicObjectType();
            DynamicObjectCollection entryEntity = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                Object[] row = new Object[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    String field = fields[i];
                    if (field.equals("dataindex")) {
                        row[i] = dataEntity.getDataEntityIndex();
                        continue;
                    }
                    if (field.contains("entryentity.")) {
                        String entryField = field.replace("entryentity.", "");
                        DynamicProperty property = entryEntity.getDynamicObjectType().getProperty(entryField);
                        if (property instanceof BasedataProp) {
                            DynamicObject object = (DynamicObject)entry.get(entryField);
                            if (object != null) {
                                row[i] = object.getLong("id");
                                continue;
                            }
                            row[i] = null;
                            continue;
                        }
                        row[i] = entry.get(entryField);
                        continue;
                    }
                    DynamicProperty property = mainObjectType.getProperty(field);
                    if (property instanceof BasedataProp) {
                        DynamicObject object = (DynamicObject)bill.get(field);
                        if (object != null) {
                            row[i] = object.getLong("id");
                            continue;
                        }
                        row[i] = null;
                        continue;
                    }
                    row[i] = bill.get(field);
                }
                currentData.add(row);
            }
        }
        DataSet quotaData = Algo.create((String)"createCurrentQuotaData").createDataSet(currentData, rowMeta);
        return quotaData;
    }
}

