/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.basedata;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class QuotaRateValidator
extends AbstractValidator {
    public void validate() {
        HashSet<Long> set = new HashSet<Long>();
        ArrayListValuedHashMap map = new ArrayListValuedHashMap();
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject qouta = data.getDataEntity();
            DynamicObjectCollection entrys = qouta.getDynamicObjectCollection("entryentity");
            if (entrys != null && entrys.size() > 0) {
                for (DynamicObject entry : entrys) {
                    DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection("subentryentity");
                    if (subEntrys != null && subEntrys.size() > 0) {
                        Integer row;
                        for (DynamicObject subEntry : subEntrys) {
                            DynamicObject supplier = subEntry.getDynamicObject("supplier");
                            BigDecimal quotaRate = subEntry.getBigDecimal("quotarate");
                            Integer supplyRank = subEntry.getInt("supplyrank");
                            if (supplier == null || quotaRate.compareTo(BigDecimal.ZERO) == 0) continue;
                            map.put((Object)supplyRank, (Object)quotaRate);
                            if (set.add((Long)supplier.getPkValue())) continue;
                            row = entry.getInt("seq");
                            String suppliername = supplier.getString("name");
                            String warnMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u6709\u6548\u671f\u5185\u7684\u4f9b\u5e94\u5546\u201c%2$s\u201d\u4e0d\u552f\u4e00\uff0c\u8bf7\u4fee\u6539\u3002", (String)"QuotaRateValidator_2", (String)"scmc-pm-opplugin", (Object[])new Object[0]), row, suppliername);
                            this.addErrorMessage(data, warnMsg);
                        }
                        set.clear();
                        for (Integer key : map.keySet()) {
                            Collection collection = map.get((Object)key);
                            BigDecimal rateSum = BigDecimal.ZERO;
                            Iterator iterator = collection.iterator();
                            while (iterator.hasNext()) {
                                rateSum = rateSum.add((BigDecimal)iterator.next());
                            }
                            if (rateSum.compareTo(new BigDecimal("100")) == 0) continue;
                            row = entry.getInt("seq");
                            String warnMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u6709\u6548\u671f\u5185\uff0c\u4f18\u5148\u7ea7\u4e3a%2$s\u7684\u914d\u989d\u6bd4\u4f8b(%%)\u4e0d\u662f100%3$s\uff0c\u8bf7\u4fee\u6539\u3002 ", (String)"QuotaRateValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), row, key, "%");
                            this.addErrorMessage(data, warnMsg);
                        }
                    }
                    map.clear();
                }
            }
            set.clear();
        }
    }
}

