/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.basedata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.common.utils.MethodParameterUtil;
import kd.scmc.pm.enums.EnableStatusEnum;
import kd.scmc.pm.enums.SourceListTypeEnum;
import kd.scmc.pm.enums.StatusEnum;

public class SourceListImportValidator
extends AbstractValidator {
    public static String PARA_ISSUPPLIERERROR = "issuppliererror";
    public static String PARA_ISSUREERROR = "issureerror";
    public static String PARA_ISSUPPLIERVMIERROR = "issuppliervmierror";
    public static String PARA_ISTYPEERROR = "istypeerror";
    public static String PARA_ISOTHERERROR = "isothererror";
    public static String PARA_ISREPEATDATAERROR = "isrepeatdataerror";

    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>(32);
        }
        String customparameter = (String)this.getValidation().get("customparameter");
        String BILLNO = MethodParameterUtil.getProperytMappingValue((Object)customparameter, (String)"number");
        preparePropertys.add(BILLNO);
        preparePropertys.add("org");
        preparePropertys.add("supplier");
        preparePropertys.add("type");
        preparePropertys.add("srctype");
        preparePropertys.add("material");
        preparePropertys.add("isvmi");
        preparePropertys.add("materialsort");
        preparePropertys.add("maxbillqty");
        preparePropertys.add("minbillqty");
        preparePropertys.add("packagebatchqty");
        preparePropertys.add("effectdate");
        preparePropertys.add("expirydate");
        preparePropertys.add("discounttype");
        preparePropertys.add("discountrate");
        preparePropertys.add("exchangetype");
        preparePropertys.add("indirectexrate");
        preparePropertys.add("purchaseunit");
        preparePropertys.add("packingqty");
        return preparePropertys;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        String customparameter = "";
        if (this.getValidation() != null) {
            customparameter = (String)this.getValidation().get("customparameter");
        }
        for (ExtendedDataEntity data : this.getDataEntities()) {
            DynamicObjectCollection entrys;
            DynamicObject supplier;
            DynamicObject org;
            DynamicObject bill = data.getDataEntity();
            if (bill == null || (org = bill.getDynamicObject("org")) == null || (supplier = bill.getDynamicObject("supplier")) == null || (entrys = bill.getDynamicObjectCollection("entryentity")) == null || entrys.size() <= 0) continue;
            for (int i = 0; i < entrys.size(); ++i) {
                int loadRowIndex;
                int thisRowIndex;
                DynamicObject sourceList;
                int n;
                DynamicObject entry = (DynamicObject)entrys.get(i);
                if (entry == null) continue;
                int lineNo = i + 1;
                if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISSUREERROR))) {
                    ArrayList<String> types = new ArrayList<String>();
                    types.add(SourceListTypeEnum.MATERIAL.getValue());
                    types.add(SourceListTypeEnum.MATERIALGROUP.getValue());
                    if (!types.contains(entry.get("type"))) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7c7b\u578b\u201c%1$s\u201d\u7684\u7c7b\u578b\u503c\u65e0\u6548\u3002", (String)"SourceListImportValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), entry.getString("type")), ErrorLevel.Error);
                        return;
                    }
                    if (!"A".equals(entry.get("srctype")) && !"B".equals(entry.get("srctype"))) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u6765\u6e90\u7c7b\u578b\u201c%2$s\u201d\u4e3a\u65e0\u6548\u6765\u6e90\u7c7b\u578b\u503c\u3002", (String)"SourceListImportValidator_2", (String)"scmc-pm-opplugin", (Object[])new Object[0]), lineNo, entry.getString("srctype")), ErrorLevel.Error);
                        return;
                    }
                }
                if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISSUPPLIERVMIERROR)) && entry != null && entry.getBoolean("isvmi") && supplier != null && !supplier.getBoolean("enablevmi")) {
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884cVMI\u4e3a\u201c\u662f\u201d\uff0c\u4f9b\u5e94\u5546\u7f16\u7801\u201c%2$s\u201d\u53efVMI\u4e0d\u4e3a\u201c\u662f\u201d\u3002", (String)"SourceListImportValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), lineNo, supplier.getString("number")), ErrorLevel.Error);
                    return;
                }
                if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISTYPEERROR))) {
                    if (SourceListTypeEnum.MATERIALGROUP.getValue().equals(entry.get("type"))) {
                        DynamicObject materialsort;
                        if (entry.get("material") != null) {
                            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u7c7b\u578b\u4e3a\u7c7b\u522b\uff0c\u4e0d\u80fd\u586b\u5199\u7269\u6599\u7f16\u7801\u3002", (String)"SourceListImportValidator_6", (String)"scmc-pm-opplugin", (Object[])new Object[0]), lineNo), ErrorLevel.Error);
                        }
                        if (entry.get("materialsort") == null) {
                            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%1$s\u884c\u201c\u7c7b\u522b\u7f16\u7801\u201d\uff0c\u7c7b\u578b\u4e3a\u7c7b\u522b\u3002", (String)"SourceListImportValidator_7", (String)"scmc-pm-opplugin", (Object[])new Object[0]), lineNo), ErrorLevel.Error);
                        }
                        if (entry.getBigDecimal("maxbillqty") != null && BigDecimal.ZERO.compareTo(entry.getBigDecimal("maxbillqty")) != 0) {
                            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u7b2c%1$s\u884c\u7684\u201c\u6700\u5927\u8ba2\u5355\u91cf\u201d\u4e3a\u201c\u7a7a\u201d\uff0c\u7c7b\u578b\u4e3a\u7c7b\u522b\u3002", (String)"SourceListImportValidator_8", (String)"scmc-pm-opplugin", (Object[])new Object[0]), lineNo), ErrorLevel.Error);
                        }
                        if (entry.getBigDecimal("minbillqty") != null && BigDecimal.ZERO.compareTo(entry.getBigDecimal("minbillqty")) != 0) {
                            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u7c7b\u578b\u4e3a\u7c7b\u522b\uff0c\u4e0d\u80fd\u586b\u5199\u6700\u5c0f\u8ba2\u5355\u91cf\u3002", (String)"SourceListImportValidator_9", (String)"scmc-pm-opplugin", (Object[])new Object[0]), lineNo), ErrorLevel.Error);
                        }
                        if (entry.get("isvmi") != null && entry.getBoolean("isvmi")) {
                            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u7c7b\u578b\u4e3a\u7c7b\u522b\uff0cVMI\u4e0d\u80fd\u4e3a\u201c\u662f\u201d\u3002", (String)"SourceListImportValidator_11", (String)"scmc-pm-opplugin", (Object[])new Object[0]), lineNo), ErrorLevel.Error);
                        }
                        if ((materialsort = entry.getDynamicObject("materialsort")) != null && materialsort.getString("enable") != null && "0".equals(materialsort.getString("enable"))) {
                            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7c7b\u522b\u7f16\u7801\u201c%1$s\u201d\u4e0d\u53ef\u7528\u3002", (String)"SourceListImportValidator_20", (String)"scmc-pm-opplugin", (Object[])new Object[0]), materialsort.getString("number"), org.getString("number")), ErrorLevel.Error);
                        }
                        if (entry.getBigDecimal("packingqty") != null && BigDecimal.ZERO.compareTo(entry.getBigDecimal("packingqty")) != 0) {
                            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u7c7b\u578b\u4e3a\u7c7b\u522b\uff0c\u4e0d\u80fd\u586b\u5199\u5305\u88c5\u6279\u91cf\u3002", (String)"SourceListImportValidator_10", (String)"scmc-pm-opplugin", (Object[])new Object[0]), lineNo), ErrorLevel.Error);
                        }
                        if (entry.get("purchaseunit") != null) {
                            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u7c7b\u578b\u4e3a\u7c7b\u522b\uff0c\u4e0d\u80fd\u586b\u5199\u8ba1\u91cf\u5355\u4f4d\u3002", (String)"SourceListImportValidator_25", (String)"scmc-pm-opplugin", (Object[])new Object[0]), lineNo), ErrorLevel.Error);
                        }
                    }
                    if (SourceListTypeEnum.MATERIAL.getValue().equals(entry.get("type"))) {
                        DynamicObject materialDyn;
                        DynamicObject materialpurchase;
                        if (entry.get("materialsort") != null) {
                            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u7c7b\u578b\u4e3a\u7269\u6599\uff0c\u4e0d\u80fd\u586b\u5199\u7c7b\u522b\u7f16\u7801\u3002", (String)"SourceListImportValidator_12", (String)"scmc-pm-opplugin", (Object[])new Object[0]), lineNo), ErrorLevel.Error);
                        }
                        if (entry.getDynamicObject("material") == null) {
                            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u7c7b\u578b\u4e3a\u7269\u6599\uff0c\u8bf7\u586b\u5199\u7269\u6599\u7f16\u7801\u3002", (String)"SourceListImportValidator_13", (String)"scmc-pm-opplugin", (Object[])new Object[0]), lineNo), ErrorLevel.Error);
                        }
                        if ((materialpurchase = entry.getDynamicObject("material")) == null || (materialDyn = materialpurchase.getDynamicObject("masterid")) == null) continue;
                        String materialNumber = materialDyn.getString("number");
                        if (entry.get("isvmi") != null && entry.getBoolean("isvmi") && !materialDyn.getBoolean("enablevmi")) {
                            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884cVMI\u4e3a\u201c\u662f\u201d\uff0c\u7269\u6599\u4e0d\u662f\u53efVMI\u3002", (String)"SourceListImportValidator_5", (String)"scmc-pm-opplugin", (Object[])new Object[0]), lineNo), ErrorLevel.Error);
                        }
                    }
                }
                if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISOTHERERROR))) {
                    Date effDate = (Date)entry.get("effectdate");
                    Date expDate = (Date)entry.get("expirydate");
                    if (expDate != null && effDate != null && effDate.compareTo(expDate) > 0) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5931\u6548\u65e5\u671f\u3002", (String)"SourceListImportValidator_14", (String)"scmc-pm-opplugin", (Object[])new Object[0]), lineNo), ErrorLevel.Error);
                    }
                    BigDecimal maxbillqty = entry.getBigDecimal("maxbillqty");
                    BigDecimal minbillqty = entry.getBigDecimal("minbillqty");
                    if (maxbillqty != null && minbillqty != null && BigDecimal.ZERO.compareTo(maxbillqty) != 0 && BigDecimal.ZERO.compareTo(minbillqty) != 0 && maxbillqty.compareTo(minbillqty) < 0) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u6700\u5927\u8ba2\u5355\u91cf\u5e94\u5927\u4e8e\u7b49\u4e8e\u6700\u5c0f\u8ba2\u5355\u91cf\u3002", (String)"SourceListImportValidator_15", (String)"scmc-pm-opplugin", (Object[])new Object[0]), lineNo), ErrorLevel.Error);
                    }
                }
                if (!"true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISREPEATDATAERROR))) continue;
                Long dataId = (Long)bill.getPkValue();
                Long orgId = (Long)org.getPkValue();
                Long supplierId = (Long)supplier.getPkValue();
                QFilter qFilter = new QFilter("id", "<>", (Object)dataId);
                qFilter.and(new QFilter("org", "=", (Object)orgId));
                qFilter.and(new QFilter("supplier", "=", (Object)supplierId));
                qFilter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
                qFilter.and(new QFilter("status", "!=", (Object)StatusEnum.SAVE.getValue()));
                String selectProperties = "number,entryentity.type,entryentity.material,entryentity.materialsort,entryentity.seq,entryentity.effectdate,entryentity.expirydate";
                DynamicObject[] temp = BusinessDataServiceHelper.load((String)"pm_sourcelist", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
                Date effectDate = entry.getDate("effectdate");
                Date expiryDate = entry.getDate("expirydate");
                if (effectDate == null || expiryDate == null) continue;
                String type = entry.getString("type");
                if (!CommonUtils.isNull((Object)type) && SourceListTypeEnum.MATERIAL.getValue().equals(type)) {
                    DynamicObject material = entry.getDynamicObject("material");
                    if (material == null) continue;
                    DynamicObject[] dynamicObjectArray = temp;
                    int n2 = dynamicObjectArray.length;
                    for (n = 0; n < n2; ++n) {
                        sourceList = dynamicObjectArray[n];
                        for (DynamicObject row : sourceList.getDynamicObjectCollection("entryentity")) {
                            if (!SourceListTypeEnum.MATERIAL.getValue().equals(row.getString("type")) || row.getDynamicObject("material") == null || !material.getPkValue().equals(row.getDynamicObject("material").getPkValue()) || effectDate.after(row.getDate("expirydate")) || expiryDate.before(row.getDate("effectdate"))) continue;
                            thisRowIndex = entry.getInt("seq");
                            loadRowIndex = row.getInt("seq");
                            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u201c\u6709\u6548\u671f\u95f4\u201d\u6216\u201c\u7269\u6599\u201d\uff0c\u7b2c%1$s\u884c\u7269\u6599\u4e0e\u7f16\u53f7\u4e3a%2$s\u7684\u8d27\u6e90\u6e05\u5355\u7684\u7b2c%3$s\u884c\u51b2\u7a81\u3002", (String)"SourceListImportValidator_22", (String)"scmc-pm-opplugin", (Object[])new Object[0]), thisRowIndex, sourceList.getString("number"), loadRowIndex));
                        }
                    }
                    if (i <= 0 || entry.get("material") == null || entry.getDate("effectdate") == null || entry.getDate("expirydate") == null) continue;
                    for (int j = 0; j < entrys.size(); ++j) {
                        DynamicObject srcRow = (DynamicObject)entrys.get(j);
                        if (srcRow.get("material") == null || srcRow.getDate("effectdate") == null || srcRow.getDate("expirydate") == null || j == entry.getInt("seq") - 1 || !srcRow.getDynamicObject("material").getPkValue().equals(entry.getDynamicObject("material").getPkValue()) || entry.getDate("effectdate").after(srcRow.getDate("expirydate")) || entry.getDate("expirydate").before(srcRow.getDate("effectdate"))) continue;
                        this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u201c\u7269\u6599\u7f16\u7801\u201d\u4e0e\u7b2c%2$s\u884c\u201c\u6709\u6548\u671f\u201d\u91cd\u53e0\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"SourceListImportValidator_26", (String)"scmc-pm-opplugin", (Object[])new Object[0]), lineNo, j + 1));
                        return;
                    }
                    continue;
                }
                if (!SourceListTypeEnum.MATERIALGROUP.getValue().equals(type)) continue;
                DynamicObject materialsort = entry.getDynamicObject("materialsort");
                if (materialsort == null) {
                    return;
                }
                DynamicObject[] j = temp;
                int srcRow = j.length;
                for (n = 0; n < srcRow; ++n) {
                    sourceList = j[n];
                    for (DynamicObject row : sourceList.getDynamicObjectCollection("entryentity")) {
                        if (!SourceListTypeEnum.MATERIALGROUP.getValue().equals(row.getString("type")) || row.getDynamicObject("materialsort") == null || !materialsort.getPkValue().equals(row.getDynamicObject("materialsort").getPkValue()) || effectDate.after(row.getDate("expirydate")) || expiryDate.before(row.getDate("effectdate"))) continue;
                        thisRowIndex = entry.getInt("seq");
                        loadRowIndex = row.getInt("seq");
                        this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u201c\u6709\u6548\u671f\u95f4\u201d\u6216\u201c\u7c7b\u522b\u7f16\u7801\u201d\uff0c\u7b2c%1$s\u884c\u7c7b\u522b\u7f16\u7801\u4e0e\u7f16\u53f7\u4e3a%2$s\u7684\u8d27\u6e90\u6e05\u5355\u7684\u7b2c%3$s\u884c\u51b2\u7a81\u3002", (String)"SourceListImportValidator_21", (String)"scmc-pm-opplugin", (Object[])new Object[0]), thisRowIndex, sourceList.getString("number"), loadRowIndex));
                    }
                }
                if (i <= 0 || entry.get("materialsort") == null || entry.getDate("effectdate") == null || entry.getDate("expirydate") == null) continue;
                for (int j2 = 0; j2 < entrys.size(); ++j2) {
                    DynamicObject srcRow2 = (DynamicObject)entrys.get(j2);
                    if (srcRow2.get("materialsort") == null || srcRow2.getDate("effectdate") == null || srcRow2.getDate("expirydate") == null || j2 == entry.getInt("seq") - 1 || !srcRow2.getDynamicObject("materialsort").getPkValue().equals(entry.getDynamicObject("materialsort").getPkValue()) || entry.getDate("effectdate").after(srcRow2.getDate("expirydate")) || entry.getDate("expirydate").before(srcRow2.getDate("effectdate"))) continue;
                    this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u201c\u7c7b\u522b\u7f16\u7801\u201d\u4e0e\u7b2c%2$s\u884c\u201c\u6709\u6548\u671f\u201d\u91cd\u53e0\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"SourceListImportValidator_27", (String)"scmc-pm-opplugin", (Object[])new Object[0]), lineNo, j2 + 1));
                    return;
                }
            }
        }
    }
}

