/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.basedata;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.pm.enums.EnableStatusEnum;
import kd.scmc.pm.enums.SourceListTypeEnum;
import kd.scmc.pm.enums.StatusEnum;

public class SourceListSubmitValidator
extends AbstractValidator {
    public void validate() {
        List<ExtendedDataEntity> checkRepeatedInMemory = this.checkRepeatedInMemory();
        for (ExtendedDataEntity data : checkRepeatedInMemory) {
            DynamicObject baseData = data.getDataEntity();
            Long dataId = (Long)baseData.getPkValue();
            DynamicObject org = baseData.getDynamicObject("org");
            if (org == null) continue;
            Long orgId = (Long)org.getPkValue();
            DynamicObject supplier = baseData.getDynamicObject("supplier");
            if (supplier == null) continue;
            Long supplierId = (Long)supplier.getPkValue();
            QFilter qFilter = new QFilter("id", "<>", (Object)dataId);
            qFilter.and(new QFilter("org", "=", (Object)orgId));
            qFilter.and(new QFilter("supplier", "=", (Object)supplierId));
            qFilter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
            qFilter.and(new QFilter("status", "!=", (Object)StatusEnum.SAVE.getValue()));
            String selectProperties = "number,entryentity.type,entryentity.material,entryentity.materialsort,entryentity.seq,entryentity.effectdate,entryentity.expirydate";
            DynamicObject[] temp = BusinessDataServiceHelper.load((String)"pm_sourcelist", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
            DynamicObjectCollection entrys = baseData.getDynamicObjectCollection("entryentity");
            if (temp.length <= 0 || entrys == null || entrys.size() <= 0) continue;
            for (int i = 0; i < entrys.size(); ++i) {
                int loadRowIndex;
                int thisRowIndex;
                DynamicObject entry = (DynamicObject)entrys.get(i);
                Date effectDate = entry.getDate("effectdate");
                Date expiryDate = entry.getDate("expirydate");
                if (effectDate == null || expiryDate == null) {
                    return;
                }
                String type = entry.getString("type");
                if (type.equals(SourceListTypeEnum.MATERIAL.getValue())) {
                    DynamicObject material = entry.getDynamicObject("material");
                    if (material == null) {
                        return;
                    }
                    for (DynamicObject sourceList : temp) {
                        for (DynamicObject row : sourceList.getDynamicObjectCollection("entryentity")) {
                            if (!row.getString("type").equals(SourceListTypeEnum.MATERIAL.getValue()) || !material.getPkValue().equals(row.getDynamicObject("material").getPkValue()) || effectDate.after(row.getDate("expirydate")) || expiryDate.before(row.getDate("effectdate"))) continue;
                            thisRowIndex = entry.getInt("seq");
                            loadRowIndex = row.getInt("seq");
                            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u4e0e\u7f16\u53f7\u4e3a%2$s\u7684\u8d27\u6e90\u6e05\u5355\u7684\u7b2c%3$s\u884c\u51b2\u7a81\uff0c\u8bf7\u4fee\u6539\u6709\u6548\u671f\u95f4\u6216\u7269\u6599\u3002", (String)"SourceListSubmitValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), thisRowIndex, sourceList.getString("number"), loadRowIndex));
                        }
                    }
                    continue;
                }
                if (!type.equals(SourceListTypeEnum.MATERIALGROUP.getValue())) continue;
                DynamicObject materialsort = entry.getDynamicObject("materialsort");
                if (materialsort == null) {
                    return;
                }
                for (DynamicObject sourceList : temp) {
                    for (DynamicObject row : sourceList.getDynamicObjectCollection("entryentity")) {
                        if (!row.getString("type").equals(SourceListTypeEnum.MATERIALGROUP.getValue()) || !materialsort.getPkValue().equals(row.getDynamicObject("materialsort").getPkValue()) || effectDate.after(row.getDate("expirydate")) || expiryDate.before(row.getDate("effectdate"))) continue;
                        thisRowIndex = entry.getInt("seq");
                        loadRowIndex = row.getInt("seq");
                        this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u201c\u6709\u6548\u671f\u95f4\u201d\u6216\u201c\u7c7b\u522b\u7f16\u7801\u201d\uff0c\u7b2c%1$s\u884c\u7c7b\u522b\u7f16\u7801\u4e0e\u7f16\u53f7\u4e3a\u201c%2$s\u201d\u7684\u8d27\u6e90\u6e05\u5355\u7684\u7b2c%3$s\u884c\u51b2\u7a81\u3002", (String)"SourceListSubmitValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), thisRowIndex, sourceList.getString("number"), loadRowIndex));
                    }
                }
            }
        }
    }

    private List<ExtendedDataEntity> checkRepeatedInMemory() {
        ArrayList<ExtendedDataEntity> checkEntities = new ArrayList<ExtendedDataEntity>();
        HashMap<Long, DynamicObject> pkDyn = new HashMap<Long, DynamicObject>(this.dataEntities.length);
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject baseData = data.getDataEntity();
            Long pkValue = (Long)baseData.getPkValue();
            pkDyn.put(pkValue, baseData);
        }
        HashMap<String, Long> uniqueMaterialBizColl = new HashMap<String, Long>();
        HashMap<String, Long> uniqueGroupBizColl = new HashMap<String, Long>();
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject baseData = data.getDataEntity();
            Long pkValue = (Long)baseData.getPkValue();
            DynamicObject org = baseData.getDynamicObject("org");
            if (org == null) continue;
            Long orgId = (Long)org.getPkValue();
            DynamicObject supplier = baseData.getDynamicObject("supplier");
            if (supplier == null) continue;
            Long supplierId = (Long)supplier.getPkValue();
            boolean flag = false;
            DynamicObjectCollection entrys = baseData.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject materialsort;
                int loadRowIndex;
                int thisRowIndex;
                DynamicObjectCollection rows;
                Long billID;
                DynamicObject bill;
                String bizUniqueKey;
                DynamicObject entry = (DynamicObject)entrys.get(i);
                Date effectDate = entry.getDate("effectdate");
                Date expiryDate = entry.getDate("expirydate");
                if (effectDate == null || expiryDate == null) continue;
                String type = entry.getString("type");
                if (type.equals(SourceListTypeEnum.MATERIAL.getValue())) {
                    DynamicObject material = entry.getDynamicObject("material");
                    if (material == null) continue;
                    Long materialId = (Long)material.getPkValue();
                    bizUniqueKey = this.getBizUniqueKey(orgId, supplierId, materialId);
                    Long existPkvalue = (Long)uniqueMaterialBizColl.get(bizUniqueKey);
                    if (existPkvalue != null) {
                        bill = (DynamicObject)pkDyn.get(uniqueMaterialBizColl.get(bizUniqueKey));
                        billID = (Long)bill.getPkValue();
                        if (pkValue.equals(billID)) continue;
                        rows = bill.getDynamicObjectCollection("entryentity");
                        for (DynamicObject row : rows) {
                            if (!materialId.equals((Long)row.getDynamicObject("material").getPkValue())) continue;
                            thisRowIndex = entry.getInt("seq");
                            loadRowIndex = row.getInt("seq");
                            if (effectDate.after(row.getDate("expirydate")) || expiryDate.before(row.getDate("effectdate"))) continue;
                            flag = true;
                            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u4e0e\u7f16\u53f7\u4e3a%2$s\u7684\u8d27\u6e90\u6e05\u5355\u7684\u7b2c%3$s\u884c\u51b2\u7a81\uff0c\u8bf7\u4fee\u6539\u6709\u6548\u671f\u95f4\u6216\u7269\u6599\u3002", (String)"SourceListSubmitValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), thisRowIndex, bill.getString("number"), loadRowIndex));
                        }
                        continue;
                    }
                    uniqueMaterialBizColl.put(bizUniqueKey, pkValue);
                    continue;
                }
                if (!type.equals(SourceListTypeEnum.MATERIALGROUP.getValue()) || (materialsort = entry.getDynamicObject("materialsort")) == null) continue;
                Long materialsortId = (Long)materialsort.getPkValue();
                bizUniqueKey = this.getBizUniqueKey(orgId, supplierId, materialsortId);
                Long uniqueID = (Long)uniqueGroupBizColl.get(bizUniqueKey);
                if (uniqueID != null) {
                    bill = (DynamicObject)pkDyn.get(uniqueID);
                    billID = (Long)bill.getPkValue();
                    if (pkValue.equals(billID)) continue;
                    rows = bill.getDynamicObjectCollection("entryentity");
                    for (DynamicObject row : rows) {
                        if (!materialsortId.equals((Long)row.getDynamicObject("materialsort").getPkValue())) continue;
                        thisRowIndex = entry.getInt("seq");
                        loadRowIndex = row.getInt("seq");
                        if (effectDate.after(row.getDate("expirydate")) || expiryDate.before(row.getDate("effectdate"))) continue;
                        flag = true;
                        this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u201c\u6709\u6548\u671f\u95f4\u201d\u6216\u201c\u7c7b\u522b\u7f16\u7801\u201d\uff0c\u7b2c%1$s\u884c\u7c7b\u522b\u7f16\u7801\u4e0e\u7f16\u53f7\u4e3a\u201c%2$s\u201d\u7684\u8d27\u6e90\u6e05\u5355\u7684\u7b2c%3$s\u884c\u51b2\u7a81\u3002", (String)"SourceListSubmitValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), thisRowIndex, bill.getString("number"), loadRowIndex));
                    }
                    continue;
                }
                uniqueGroupBizColl.put(bizUniqueKey, pkValue);
            }
            if (flag) continue;
            checkEntities.add(data);
        }
        return checkEntities;
    }

    private String getBizUniqueKey(Long orgId, Long supplierId, Long bizPkvalue) {
        StringBuilder bizKey = new StringBuilder();
        bizKey.append(orgId).append('_');
        bizKey.append(supplierId).append('_');
        bizKey.append(bizPkvalue);
        return bizKey.toString();
    }
}

