/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.core.apply;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.common.utils.MethodParameterUtil;
import kd.scmc.pm.business.helper.AmountHelper;
import kd.scmc.pm.business.pojo.AmountInfo;

public class ApplyAmountValidator
extends AbstractValidator {
    public static String PARA_ISCHECKPRICEERROR = "ischeckpriceerror";
    public static String PARA_ISCHECKAMOUNTERROR = "ischeckamounterror";
    public static String PARA_ISCHECKTOTALAMOUNTERROR = "ischecktotalamounterror";

    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("istax");
        preparePropertys.add("biztime");
        preparePropertys.add("currency");
        preparePropertys.add("qty");
        preparePropertys.add("price");
        preparePropertys.add("priceandtax");
        preparePropertys.add("taxrate");
        preparePropertys.add("taxrateid");
        preparePropertys.add("amount");
        preparePropertys.add("amountandtax");
        preparePropertys.add("totalallamount");
        return preparePropertys;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        String customparameter = (String)this.getValidation().get("customparameter");
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            boolean isTax = bill.getBoolean("istax");
            Date bizTime = bill.getDate("biztime");
            DynamicObject currency = bill.getDynamicObject("currency");
            int currencyAmtPrecision = currency == null ? 10 : currency.getInt("amtprecision");
            int currencyPricePrecision = 10;
            BigDecimal totalAllAmount = BigDecimal.ZERO;
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (int i = 0; i < entrys.size(); ++i) {
                String tipMsg;
                DynamicObject entry = (DynamicObject)entrys.get(i);
                BigDecimal qty = entry.getBigDecimal("qty");
                BigDecimal price = entry.getBigDecimal("price");
                BigDecimal priceAndTax = entry.getBigDecimal("priceandtax");
                BigDecimal taxRate = entry.getBigDecimal("taxrate");
                DynamicObject taxrateid = entry.getDynamicObject("taxrateid");
                if (taxrateid != null) {
                    Date activedate = taxrateid.getDate("activedate");
                    Date expdate = taxrateid.getDate("expdate");
                    if (activedate != null && activedate.compareTo(bizTime) > 0 || expdate != null && expdate.compareTo(bizTime) < 0) {
                        String tipMsg2 = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u201c\u7533\u8bf7\u65e5\u671f\u201d\u672a\u5728\u7a0e\u7387\u201c%2$s\u201d\u7684\u6709\u6548\u65e5\u671f\u8303\u56f4\u5185\u3002", (String)"PurApplyAmountValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1, taxrateid.getString("number"));
                        this.addMessage(dataEntity, tipMsg2, ErrorLevel.Error);
                    }
                }
                AmountInfo amountInfo = new AmountInfo();
                amountInfo.setTax(isTax);
                amountInfo.setQty(qty);
                amountInfo.setPrice(price);
                amountInfo.setPriceAndTax(priceAndTax);
                amountInfo.setTaxRate(taxRate);
                amountInfo.setSettlePricePrecision(currencyPricePrecision);
                amountInfo.setSettleAmtPrecision(currencyAmtPrecision);
                amountInfo = AmountHelper.getAmount((AmountInfo)amountInfo);
                if (!(!"true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKPRICEERROR)) || BigDecimalUtil.equals((BigDecimal)entry.getBigDecimal("price"), (BigDecimal)amountInfo.getPrice()) && BigDecimalUtil.equals((BigDecimal)entry.getBigDecimal("priceandtax"), (BigDecimal)amountInfo.getPriceAndTax()))) {
                    tipMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u201c\u5355\u4ef7\u201d\u548c\u201c\u542b\u7a0e\u5355\u4ef7\u201d\u8ba1\u7b97\u4e0d\u6b63\u786e\u3002", (String)"PurApplyAmountValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                    this.addMessage(dataEntity, tipMsg, ErrorLevel.Error);
                }
                if (!(!"true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKAMOUNTERROR)) || BigDecimalUtil.equals((BigDecimal)entry.getBigDecimal("amount"), (BigDecimal)amountInfo.getAmount()) && BigDecimalUtil.equals((BigDecimal)entry.getBigDecimal("amountandtax"), (BigDecimal)amountInfo.getAmountAndTax()))) {
                    tipMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u201c\u91d1\u989d\u201d\u548c\u201c\u4ef7\u7a0e\u5408\u8ba1\u201d\u8ba1\u7b97\u4e0d\u6b63\u786e\u3002", (String)"PurApplyAmountValidator_2", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                    this.addMessage(dataEntity, tipMsg, ErrorLevel.Error);
                }
                totalAllAmount = totalAllAmount.add(amountInfo.getAmountAndTax());
            }
            if (!"true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKTOTALAMOUNTERROR)) || BigDecimalUtil.equals((BigDecimal)bill.getBigDecimal("totalallamount"), (BigDecimal)totalAllAmount)) continue;
            String tipMsg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u603b\u201c\u4ef7\u7a0e\u5408\u8ba1\u201d\u8ba1\u7b97\u4e0d\u6b63\u786e\u3002", (String)"PurApplyAmountValidator_3", (String)"scmc-pm-opplugin", (Object[])new Object[0]), new Object[0]);
            this.addMessage(dataEntity, tipMsg, ErrorLevel.Error);
        }
    }
}

