/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.core.apply;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.business.helper.OperatorGroupHelper;
import kd.mpscmm.msbd.business.helper.OrgHelper;
import kd.mpscmm.msbd.common.enums.OperatorGrpTypeEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.common.utils.MethodParameterUtil;

public class ApplyOrgValidator
extends AbstractValidator {
    public static String PARA_ISCHECKAPPLYDEPT = "ischeckapplydept";
    public static String PARA_ISCHECKPURDEPT = "ischeckpurdept";
    public static String PARA_ISCHECKREQDEPT = "ischeckreqdept";
    public static String PARA_ISCHECKRECDEPT = "ischeckrecdept";

    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("org");
        preparePropertys.add("dept");
        preparePropertys.add("bizuser");
        preparePropertys.add("entrypurdept");
        preparePropertys.add("entryoperatorgroup");
        preparePropertys.add("entryoperator");
        preparePropertys.add("entryreqorg");
        preparePropertys.add("entryreqdept");
        preparePropertys.add("entryrecorg");
        preparePropertys.add("entryrecdept");
        return preparePropertys;
    }

    public void validate() {
        String customparameter = (String)this.getValidation().get("customparameter");
        HashMap<String, List<Long>> cacheMap = new HashMap<String, List<Long>>(8);
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null) {
                return;
            }
            if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKAPPLYDEPT))) {
                boolean checkDept;
                DynamicObject dept = bill.getDynamicObject("dept");
                DynamicObject bizUser = bill.getDynamicObject("bizuser");
                if (dept != null && !(checkDept = OrgHelper.checkDepartment((Long)((Long)org.getPkValue()), (Long)(bizUser == null ? null : (Long)bizUser.getPkValue()), (Long)((Long)dept.getPkValue())))) {
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u90e8\u95e8\u201c%1$s\u201d\u4e0d\u662f\u7533\u8bf7\u7ec4\u7ec7\u53ef\u7528\u7684\u884c\u653f\u7ec4\u7ec7\u3002", (String)"PurApplyOrgValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), dept.getString("number")), ErrorLevel.Error);
                }
            }
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject recDept;
                DynamicObject recOrg;
                DynamicObject reqDept;
                DynamicObject reqOrg;
                DynamicObject purDept;
                DynamicObject entry = (DynamicObject)entrys.get(i);
                if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKPURDEPT)) && (purDept = entry.getDynamicObject("entrypurdept")) != null) {
                    String cacheKey = String.valueOf(purDept.getPkValue()) + "entrypurdept";
                    List purDeptIds = new ArrayList(8);
                    if (ApplyOrgValidator.isCache(cacheMap, cacheKey)) {
                        purDeptIds.addAll((Collection)cacheMap.get(cacheKey));
                    } else {
                        purDeptIds = OrgHelper.getOrgRelationIncludeSelf((Long)((Long)org.getPkValue()), (String)"15", (String)"01", (String)"toorg");
                        cacheMap.put(cacheKey, purDeptIds);
                    }
                    if (purDeptIds != null && purDeptIds.size() > 0 && !purDeptIds.contains(purDept.getPkValue())) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u91c7\u8d2d\u90e8\u95e8\u201c%2$s\u201d\u4e0d\u662f\u91c7\u8d2d\u7ec4\u7ec7\u7ec4\u7ec7\u53ef\u7528\u7684\u91c7\u8d2d\u90e8\u95e8\u3002", (String)"PurApplyOrgValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1, purDept.getString("name")), ErrorLevel.Error);
                    }
                }
                DynamicObject operatorGroup = entry.getDynamicObject("entryoperatorgroup");
                DynamicObject operator = entry.getDynamicObject("entryoperator");
                if (operator != null) {
                    boolean checkOperatorGroup;
                    DynamicObject operatorUser;
                    Long operatorgrpId = operator.getLong("operatorgrpid");
                    if (operatorGroup != null && !operatorGroup.getPkValue().equals(operatorgrpId)) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u91c7\u8d2d\u5458\u201c%2$s\u201d\u4e0d\u662f\u91c7\u8d2d\u7ec4\u201c%3$s\u201d\u4e0b\u7684\u91c7\u8d2d\u5458\u3002", (String)"PurApplyOrgValidator_2", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1, operator.getString("operatornumber")), operatorGroup.getString("number"), ErrorLevel.Error);
                    } else if (operatorgrpId != null && (operatorUser = operator.getDynamicObject("operatorid")) != null && !(checkOperatorGroup = OperatorGroupHelper.checkOperatorGroupByOrgAndUser((Long)((Long)org.getPkValue()), (String)OperatorGrpTypeEnum.PURCHASEGRP.getValue(), (Long)((Long)operatorUser.getPkValue()), (Long)operatorgrpId))) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u91c7\u8d2d\u5458\u201c%2$s\u201d\u4e0d\u662f\u91c7\u8d2d\u7ec4\u7ec7\u8303\u56f4\u5185\u6709\u6548\u7684\u91c7\u8d2d\u5458\u3002", (String)"PurApplyOrgValidator_3", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1, operator.getString("operatornumber")), ErrorLevel.Error);
                    }
                }
                if ((reqOrg = entry.getDynamicObject("entryreqorg")) != null) {
                    String cacheKey = String.valueOf(org.getPkValue()) + "entryreqorg";
                    List reqOrgIds = new ArrayList(8);
                    if (ApplyOrgValidator.isCache(cacheMap, cacheKey)) {
                        reqOrgIds.addAll((Collection)cacheMap.get(cacheKey));
                    } else {
                        reqOrgIds = OrgHelper.getOrgRelationIncludeSelf((Long)((Long)org.getPkValue()), (String)"", (String)"02", (String)"fromorg");
                        cacheMap.put(cacheKey, reqOrgIds);
                    }
                    if (reqOrgIds != null && reqOrgIds.size() > 0 && !reqOrgIds.contains(reqOrg.getPkValue())) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u9700\u6c42\u7ec4\u7ec7\u201c%2$s\u201d\u4e0d\u662f\u91c7\u8d2d\u7ec4\u7ec7\u53ef\u7528\u7684\u9700\u6c42\u7ec4\u7ec7\u3002", (String)"PurApplyOrgValidator_4", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1, reqOrg.getString("name")), ErrorLevel.Error);
                    }
                }
                if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKREQDEPT)) && (reqDept = entry.getDynamicObject("entryreqdept")) != null && reqOrg != null) {
                    String cacheKey = String.valueOf(reqDept.getPkValue()) + "entryreqdept";
                    List reqDeptIds = new ArrayList(8);
                    if (ApplyOrgValidator.isCache(cacheMap, cacheKey)) {
                        reqDeptIds.addAll((Collection)cacheMap.get(cacheKey));
                    } else {
                        reqDeptIds = OrgHelper.getOrgRelationIncludeSelf((Long)((Long)reqOrg.getPkValue()), (String)"15", (String)"01", (String)"toorg");
                        cacheMap.put(cacheKey, reqDeptIds);
                    }
                    if (reqDeptIds != null && reqDeptIds.size() > 0 && !reqDeptIds.contains(reqDept.getPkValue())) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u9700\u6c42\u90e8\u95e8\u201c%2$s\u201d\u4e0d\u662f\u201c\u9700\u6c42\u7ec4\u7ec7\u53ef\u7528\u7684\u9700\u6c42\u90e8\u95e8\u3002", (String)"PurApplyOrgValidator_5", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1, reqDept.getString("name")), ErrorLevel.Error);
                    }
                }
                if ((recOrg = entry.getDynamicObject("entryrecorg")) != null) {
                    String cacheKey = String.valueOf(recOrg.getPkValue()) + "entryrecorg";
                    List recOrgIds = new ArrayList(8);
                    if (ApplyOrgValidator.isCache(cacheMap, cacheKey)) {
                        recOrgIds.addAll((Collection)cacheMap.get(cacheKey));
                    } else {
                        recOrgIds = OrgHelper.getOrgRelationIncludeSelf((Long)((Long)org.getPkValue()), (String)"02", (String)"05", (String)"toorg");
                        cacheMap.put(cacheKey, recOrgIds);
                    }
                    if (recOrgIds != null && recOrgIds.size() > 0 && !recOrgIds.contains(recOrg.getPkValue())) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u6536\u8d27\u7ec4\u7ec7\u201c%2$s\u201d\u4e0d\u662f\u91c7\u8d2d\u7ec4\u7ec7\u53ef\u7528\u7684\u6536\u8d27\u7ec4\u7ec7\u3002", (String)"PurApplyOrgValidator_6", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1, recOrg.getString("name")), ErrorLevel.Error);
                    }
                }
                if (!"true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKRECDEPT)) || (recDept = entry.getDynamicObject("entryrecdept")) == null || recOrg == null) continue;
                String cacheKey = String.valueOf(recDept.getPkValue()) + "entryrecdept";
                List recDeptIds = new ArrayList(8);
                if (ApplyOrgValidator.isCache(cacheMap, cacheKey)) {
                    recDeptIds.addAll((Collection)cacheMap.get(cacheKey));
                } else {
                    recDeptIds = OrgHelper.getOrgRelationIncludeSelf((Long)((Long)recOrg.getPkValue()), (String)"15", (String)"01", (String)"toorg");
                    cacheMap.put(cacheKey, recDeptIds);
                }
                if (recDeptIds == null || recDeptIds.size() <= 0 || recDeptIds.contains(recDept.getPkValue())) continue;
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u6536\u8d27\u90e8\u95e8\u201c%2$s\u201d\u4e0d\u662f\u6536\u8d27\u7ec4\u7ec7\u53ef\u7528\u7684\u6536\u8d27\u90e8\u95e8\u3002", (String)"PurApplyOrgValidator_7", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1, recDept.getString("name")), ErrorLevel.Error);
            }
        }
    }

    private static boolean isCache(Map<String, List<Long>> map, String key) {
        return map.containsKey(key);
    }
}

