/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.core.apply;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.business.helper.BizCategoryHelper;
import kd.scmc.pm.business.helper.SupplierHelper;
import kd.scmc.pm.enums.SupplierFunction;

public class ApplySupplierValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("org");
        preparePropertys.add("biztype");
        preparePropertys.add("supplier");
        return preparePropertys;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        HashSet<Object> supplierIds = new HashSet<Object>(8);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            if (entrys.isEmpty()) continue;
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                DynamicObject supplier = entry.getDynamicObject("supplier");
                if (supplier == null) continue;
                supplierIds.add(supplier.getPkValue());
            }
        }
        if (supplierIds.isEmpty()) {
            return;
        }
        Map supplierFromDB = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"id,bizfunction,enablevmi", (QFilter[])new QFilter[]{new QFilter("id", "in", supplierIds)});
        if (supplierFromDB == null || supplierFromDB.isEmpty()) {
            return;
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObject bizType = bill.getDynamicObject("biztype");
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                DynamicObject supplier = entry.getDynamicObject("supplier");
                if (supplier == null || (supplier = (DynamicObject)supplierFromDB.get(supplier.getPkValue())) == null) continue;
                boolean validResult = SupplierHelper.validBizFunction((DynamicObject)supplier, (SupplierFunction)SupplierFunction.PURCHASE);
                if (!validResult) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u4f9b\u5e94\u5546\u201c%2$s\u201d\u6ca1\u6709\u91c7\u8d2d\u804c\u80fd\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"PurApplySupplierValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1, supplier.getString("number")));
                }
                if (bizType == null || !BizCategoryHelper.isVMI((Long)((Long)bizType.getPkValue())) || supplier.getBoolean("enablevmi")) continue;
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u4e1a\u52a1\u7c7b\u578b\u9886\u57df\u4e3aVMI\uff0c\u4f9b\u5e94\u5546\u201c%2$s\u201d\u53efVMI\u4e0d\u4e3a\u201c\u662f\u201d\u3002", (String)"PurApplySupplierValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1, supplier.getString("number")));
            }
        }
    }
}

