/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.core.order;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.common.enums.PayModeEnum;
import kd.mpscmm.msbd.common.utils.MetadataUtils;
import kd.mpscmm.msbd.common.utils.MethodParameterUtil;
import kd.mpscmm.msbd.opplugin.AmountPlanValidator;
import kd.scmc.pm.business.helper.BizCategoryHelper;
import kd.scmc.pm.business.helper.PurOrderBillHelper;

public class PayInfoValidator
extends AmountPlanValidator {
    public static String PARA_ISCHECKAMOUNTPLAN = "ischeckamountplan";

    public Set<String> preparePropertys() {
        super.setValidation(new HashMap(PurOrderBillHelper.getPlanCommonFieldMapping()));
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("invoicebiztype");
        preparePropertys.add("paycondition");
        preparePropertys.add("biztype");
        preparePropertys.add("paymode");
        return preparePropertys;
    }

    public void validate() {
        String appId;
        HashMap validation = this.getValidation();
        if (validation == null) {
            validation = new HashMap(8);
        }
        String customparameter = (String)validation.get("customparameter");
        super.setValidation(new HashMap(PurOrderBillHelper.getPlanCommonFieldMapping()));
        if ("true".equalsIgnoreCase(MethodParameterUtil.getValue((Object)customparameter, (String)PARA_ISCHECKAMOUNTPLAN))) {
            super.validate();
        }
        if ((appId = this.getValidateContext().getBillEntityType().getAppId()) == null) {
            return;
        }
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
        String bizCloudId = appInfo.getCloudId();
        QFilter bizCloudQfilter = new QFilter("mulbiz.fbasedataid.id", "=", (Object)bizCloudId);
        Map bizCloudInvoiceBizTypeMap = BusinessDataServiceHelper.loadFromCache((String)"bd_invoicebiztype", (String)"id", (QFilter[])new QFilter[]{bizCloudQfilter});
        ArrayList bizTypeIdList = new ArrayList(8);
        if (bizCloudInvoiceBizTypeMap != null && !bizCloudInvoiceBizTypeMap.isEmpty()) {
            bizTypeIdList.addAll(bizCloudInvoiceBizTypeMap.keySet());
        }
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject payCondition;
            DynamicObject bill = data.getDataEntity();
            DynamicObject invoiceBizType = bill.getDynamicObject("invoicebiztype");
            if (invoiceBizType != null && !bizTypeIdList.contains(invoiceBizType.getPkValue())) {
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u522b\u201c%1$s\u201d\u4e0d\u662f\u4f9b\u5e94\u94fe\u4e91\u9886\u57df\u53ef\u7528\u7684\u53d1\u7968\u7c7b\u522b\u3002", (String)"PayInfoValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), invoiceBizType.get("number")), ErrorLevel.Error);
            }
            if (MetadataUtils.checkProperty((DynamicObject)bill, (String)"paycondition") && (payCondition = bill.getDynamicObject("paycondition")) != null && Boolean.FALSE.equals(payCondition.getBoolean("orderbill"))) {
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6761\u4ef6\u201c%1$s\u201d\u4e0d\u662f\u91c7\u8d2d\u8ba2\u5355\u53ef\u7528\u7684\u4ed8\u6b3e\u6761\u4ef6\u3002", (String)"PayInfoValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), payCondition.get("number")), ErrorLevel.Error);
            }
            DynamicObject bizType = bill.getDynamicObject("biztype");
            String payMode = bill.getString("paymode");
            if (bizType == null || !BizCategoryHelper.isCredit((Long)((Long)bizType.getPkValue())) || PayModeEnum.CREDIT.getValue().equals(payMode)) continue;
            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u201c%1$s\u201d\u65f6\uff0c\u4ed8\u6b3e\u65b9\u5f0f\u201c%2$s\u201d\u4e0d\u80fd\u4e3a\u73b0\u8d2d\u3002", (String)"PayInfoValidator_2", (String)"scmc-pm-opplugin", (Object[])new Object[0]), bizType.getString("number"), payMode, ErrorLevel.Error));
        }
    }
}

