/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.core.order;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.business.helper.BizCategoryHelper;
import kd.scmc.pm.business.helper.SupplierHelper;
import kd.scmc.pm.enums.SupplierFunction;

public class SupplierValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("org");
        preparePropertys.add("biztype");
        preparePropertys.add("supplier");
        preparePropertys.add("providersupplier");
        preparePropertys.add("invoicesupplier");
        preparePropertys.add("receivesupplier");
        preparePropertys.add("linkman");
        preparePropertys.add("providerlinkman");
        return preparePropertys;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Set ids;
            DynamicObject provideLinkMan;
            Set ids2;
            DynamicObject linkMan;
            DynamicObject bizType;
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObject supplier = bill.getDynamicObject("supplier");
            if (supplier == null) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8ba2\u8d27\u4f9b\u5e94\u5546\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SupplierValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            DynamicObject providersupplier = bill.getDynamicObject("providersupplier");
            DynamicObject invoicesupplier = bill.getDynamicObject("invoicesupplier");
            DynamicObject receivesupplier = bill.getDynamicObject("receivesupplier");
            boolean validResult = SupplierHelper.validBizFunction((DynamicObject)supplier, (SupplierFunction)SupplierFunction.PURCHASE);
            if (!validResult) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8ba2\u8d27\u4f9b\u5e94\u5546\u6ca1\u6709\u201c%1$s\u201d\u804c\u80fd\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"SupplierValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), SupplierFunction.PURCHASE.getName()));
            }
            if (providersupplier != null && !(validResult = SupplierHelper.validBizFunction((DynamicObject)providersupplier, (SupplierFunction)SupplierFunction.DELIVER))) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4f9b\u8d27\u4f9b\u5e94\u5546\u6ca1\u6709\u201c%1$s\u201d\u804c\u80fd\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"SupplierValidator_2", (String)"scmc-pm-opplugin", (Object[])new Object[0]), SupplierFunction.DELIVER.getName()));
            }
            if (invoicesupplier != null && !(validResult = SupplierHelper.validBizFunction((DynamicObject)invoicesupplier, (SupplierFunction)SupplierFunction.INVOICE))) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u4f9b\u5e94\u5546\u6ca1\u6709\u201c%1$s\u201d\u804c\u80fd\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"SupplierValidator_3", (String)"scmc-pm-opplugin", (Object[])new Object[0]), SupplierFunction.INVOICE.getName()));
            }
            if (receivesupplier != null && !(validResult = SupplierHelper.validBizFunction((DynamicObject)receivesupplier, (SupplierFunction)SupplierFunction.RECEIVE))) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u4f9b\u5e94\u5546\u6ca1\u6709\u201c%1$s\u201d\u804c\u80fd\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"SupplierValidator_4", (String)"scmc-pm-opplugin", (Object[])new Object[0]), SupplierFunction.RECEIVE.getName()));
            }
            if ((bizType = bill.getDynamicObject("biztype")) != null && BizCategoryHelper.isVMI((Long)((Long)bizType.getPkValue())) && !supplier.getBoolean("enablevmi")) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u9886\u57df\u4e3aVMI\uff0c\u4f9b\u5e94\u5546\u201c%1$s\u201d\u53efVMI\u4e0d\u4e3a\u201c\u662f\u201d\u3002", (String)"SupplierValidator_5", (String)"scmc-pm-opplugin", (Object[])new Object[0]), supplier.getString("number")));
            }
            if (SupplierHelper.isPurchaseHold((DynamicObject)supplier)) {
                String supplierName = supplier.getString("name");
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8ba2\u8d27\u4f9b\u5e94\u5546\u201c%1$s\u201d\u4e3a\u201c\u91c7\u8d2d\u51bb\u7ed3\u201d\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"SupplierValidator_6", (String)"scmc-pm-opplugin", (Object[])new Object[0]), supplierName));
            }
            if ((linkMan = bill.getDynamicObject("linkman")) != null && supplier != null && !(ids2 = SupplierHelper.getAllLinkMans((DynamicObject)supplier)).contains(linkMan.getPkValue())) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8054\u7cfb\u4eba\u201c%1$s\u201d\u4e0d\u662f\u8ba2\u8d27\u4f9b\u5e94\u5546\u201c%2$s\u201d\u7684\u6709\u6548\u8054\u7cfb\u4eba\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"SupplierValidator_7", (String)"scmc-pm-opplugin", (Object[])new Object[0]), linkMan.getString("contactperson"), supplier.getString("number")));
            }
            if ((provideLinkMan = bill.getDynamicObject("providerlinkman")) == null || providersupplier == null || (ids = SupplierHelper.getAllLinkMans((DynamicObject)providersupplier)).contains(provideLinkMan.getPkValue())) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4f9b\u8d27\u8054\u7cfb\u4eba\u201c%1$s\u201d\u4e0d\u662f\u4f9b\u8d27\u4f9b\u5e94\u5546\u201c%2$s\u201d\u7684\u6709\u6548\u8054\u7cfb\u4eba\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"SupplierValidator_8", (String)"scmc-pm-opplugin", (Object[])new Object[0]), provideLinkMan.getString("contactperson"), providersupplier.getString("number")));
        }
    }
}

