/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.notice;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.enums.BizCloseStatusEnum;
import kd.scmc.pm.enums.RowCloseStatusEnum;
import kd.scmc.pm.enums.StatusEnum;

public class PurBillRowCloseValidator
extends AbstractValidator {
    public void validate() {
        block8: for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            Long pk = (Long)bill.getPkValue();
            QFilter billIDFilter = new QFilter("id", "=", (Object)pk);
            DynamicObjectCollection dynamicObject = QueryServiceHelper.query((String)bill.getDataEntityType().getName(), (String)"billno,billstatus,closestatus,billentry.rowclosestatus as rowclosestatus ,billentry.seq as seq", (QFilter[])new QFilter[]{billIDFilter});
            if (dynamicObject == null) {
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"PurBillRowCloseValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), new Object[0]), ErrorLevel.Error);
                return;
            }
            switch (this.getOperateKey()) {
                case "rowunclose": {
                    this.rowCloseValidate(data, dynamicObject, RowCloseStatusEnum.UNROWCLOSE.getValue());
                    continue block8;
                }
                case "rowclose": {
                    this.rowCloseValidate(data, dynamicObject, RowCloseStatusEnum.ROWCLOSE.getValue());
                    QFilter srcBillEntityFilter = new QFilter("billentry.srcbillentity", "=", (Object)"pm_receiptnotice");
                    QFilter srcBillIDFilter = new QFilter("billentry.srcbillid", "=", bill.getPkValue());
                    QFilter billStatusFilter = new QFilter("billstatus", "in", Arrays.asList(StatusEnum.SAVE.getValue(), StatusEnum.SUBMIT.getValue()));
                    if (!QueryServiceHelper.exists((String)"im_purreceivebill", (QFilter[])new QFilter[]{srcBillEntityFilter, srcBillIDFilter, billStatusFilter})) continue block8;
                    String tip = ResManager.loadKDString((String)"\u5b58\u5728\u4fdd\u5b58\u6216\u63d0\u4ea4\u72b6\u6001\u7684\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u8fdb\u884c\u884c\u5173\u95ed\u3002", (String)"PurBillRowCloseValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]);
                    this.addMessage(data, tip, ErrorLevel.Error);
                }
            }
        }
    }

    private void rowCloseValidate(ExtendedDataEntity data, DynamicObjectCollection billS, String rowOpStatus) {
        String tip;
        DynamicObject bill = (DynamicObject)billS.get(0);
        String selectRow = this.getOption().getVariableValue("selectRows", null);
        if (CommonUtils.isNull((Object)selectRow)) {
            tip = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u5f55\u884c\u3002", (String)"PurBillRowCloseValidator_2", (String)"scmc-pm-opplugin", (Object[])new Object[0]);
            this.addMessage(data, tip, ErrorLevel.Error);
        }
        String billStatus = bill.getString("billstatus");
        String closeStatus = bill.getString("closestatus");
        if (!StatusEnum.AUDIT.getValue().equals(billStatus)) {
            tip = ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\uff0c\u624d\u80fd\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PurBillRowCloseValidator_3", (String)"scmc-pm-opplugin", (Object[])new Object[0]);
            this.addMessage(data, tip, ErrorLevel.Error);
        }
        if (!BizCloseStatusEnum.UNCLOSE.getValue().equals(closeStatus)) {
            tip = ResManager.loadKDString((String)"\u5355\u636e\u5173\u95ed\u72b6\u6001\u5fc5\u987b\u4e3a\u201c\u6b63\u5e38\u201d\uff0c\u624d\u80fd\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PurBillRowCloseValidator_4", (String)"scmc-pm-opplugin", (Object[])new Object[0]);
            this.addMessage(data, tip, ErrorLevel.Error);
        }
        List<String> rows = Arrays.asList(selectRow.split(","));
        boolean isSuccess = false;
        for (DynamicObject noticeBillEntryDy : billS) {
            int seq = noticeBillEntryDy.getInt("seq");
            String rowSeq = String.valueOf(seq - 1);
            String rowCloseStatus = noticeBillEntryDy.getString("rowclosestatus");
            if (!rows.contains(rowSeq) || rowOpStatus.equals(rowCloseStatus)) continue;
            isSuccess = true;
        }
        if (!isSuccess && rowOpStatus.equals(RowCloseStatusEnum.UNROWCLOSE.getValue())) {
            tip = ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5206\u5f55\u884c\u4e2d\u6ca1\u6709\u53ef\u53cd\u5173\u95ed\u7684\u884c\u3002", (String)"PurBillRowCloseValidator_5", (String)"scmc-pm-opplugin", (Object[])new Object[0]);
            this.addMessage(data, tip, ErrorLevel.Error);
        } else if (!isSuccess && rowOpStatus.equals(RowCloseStatusEnum.ROWCLOSE.getValue())) {
            tip = ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5206\u5f55\u884c\u4e0d\u53ef\u5173\u95ed\u3002", (String)"PurBillRowCloseValidator_6", (String)"scmc-pm-opplugin", (Object[])new Object[0]);
            this.addMessage(data, tip, ErrorLevel.Error);
        }
    }
}

