/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.common.enums.StatusEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class PoOtherValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        HashSet<String> preparePropertys = super.preparePropertys();
        if (CommonUtils.isNull((Object)preparePropertys)) {
            preparePropertys = new HashSet<String>();
        }
        preparePropertys.add("org");
        preparePropertys.add("billno");
        preparePropertys.add("biztime");
        preparePropertys.add("pricelist");
        preparePropertys.add("supplier");
        preparePropertys.add("billstatus");
        preparePropertys.add("linetype");
        preparePropertys.add("expenseitem");
        preparePropertys.add("amountandtax");
        preparePropertys.add("iscontrolamountup");
        preparePropertys.add("amountup");
        return preparePropertys;
    }

    public void validate() {
        Map expenseitemLineTypesMap = BusinessDataServiceHelper.loadFromCache((String)"bd_linetype", (String)"id", (QFilter[])new QFilter[]{new QFilter("serviceattribute.entity.number", "=", (Object)"er_expenseitemedit")});
        ArrayList expenseitemLineTypeIds = new ArrayList(8);
        if (expenseitemLineTypesMap != null && !expenseitemLineTypesMap.isEmpty()) {
            expenseitemLineTypeIds.addAll(expenseitemLineTypesMap.keySet());
        }
        for (ExtendedDataEntity data : this.dataEntities) {
            String tipMsg;
            DynamicObject bill = data.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null) continue;
            Date bizTime = bill.getDate("biztime");
            DynamicObject pricelist = bill.getDynamicObject("pricelist");
            DynamicObject supplier = bill.getDynamicObject("supplier");
            String billStatus = bill.getString("billstatus");
            if (pricelist != null) {
                String tipMsg2;
                DynamicObject priceSupplier = pricelist.getDynamicObject("supplierid");
                if (priceSupplier != null) {
                    if (!priceSupplier.getPkValue().equals(supplier.getPkValue())) {
                        tipMsg2 = String.format(ResManager.loadKDString((String)"\u201c\u4ef7\u76ee\u8868\u201d\u4f9b\u5e94\u5546\u4e0e\u201c\u8ba2\u8d27\u4f9b\u5e94\u5546\u201d\u4e0d\u540c\u3002", (String)"PoOtherValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), new Object[0]);
                        this.addMessage(data, tipMsg2, ErrorLevel.Error);
                    }
                    DynamicObjectCollection priceEntry = pricelist.getDynamicObjectCollection("priceentryentity");
                    Date effectDate = null;
                    Date expiryDate = null;
                    for (DynamicObject entry : priceEntry) {
                        if (effectDate == null || effectDate.compareTo(entry.getDate("priceeffectdate")) < 0) {
                            effectDate = entry.getDate("priceeffectdate");
                        }
                        if (expiryDate != null && expiryDate.compareTo(entry.getDate("priceexpirydate")) <= 0) continue;
                        expiryDate = entry.getDate("priceexpirydate");
                    }
                    if (bizTime.compareTo(effectDate) < 0 || bizTime.compareTo(expiryDate) > 0) {
                        tipMsg = String.format(ResManager.loadKDString((String)"\u201c\u8ba2\u5355\u65e5\u671f\u201d\u4e0d\u5728\u201c\u4ef7\u76ee\u8868\u201d\u751f\u6548\u65e5\u671f\u548c\u5931\u6548\u65e5\u671f\u8303\u56f4\u5185\u3002", (String)"PoOtherValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), new Object[0]);
                        this.addMessage(data, tipMsg, ErrorLevel.Error);
                    }
                }
                if (!org.getPkValue().equals(pricelist.getDynamicObject("org").getPkValue())) {
                    tipMsg2 = String.format(ResManager.loadKDString((String)"\u201c\u4ef7\u76ee\u8868\u201d\u91c7\u8d2d\u7ec4\u7ec7\u4e0e\u5355\u636e\u7684\u201c\u91c7\u8d2d\u7ec4\u7ec7\u201d\u4e0d\u4e00\u81f4\u3002", (String)"PoOtherValidator_4", (String)"scmc-pm-opplugin", (Object[])new Object[0]), new Object[0]);
                    this.addMessage(data, tipMsg2, ErrorLevel.Error);
                }
            }
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                DynamicObject lineType = entry.getDynamicObject("linetype");
                if (lineType != null && expenseitemLineTypeIds.contains(lineType.getPkValue()) && entry.get("expenseitem") == null) {
                    tipMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u884c\u7c7b\u578b\u4e3a\u8d39\u7528\u9879\u76ee\uff0c\u8d39\u7528\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PoOtherValidator_2", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                    this.addMessage(data, tipMsg, ErrorLevel.Error);
                }
                if (!StatusEnum.AUDIT.getValue().equals(billStatus) && !StatusEnum.SUBMIT.getValue().equals(billStatus)) continue;
                BigDecimal amountAndTax = entry.getBigDecimal("amountandtax");
                BigDecimal amountup = entry.getBigDecimal("amountup");
                if (amountup.compareTo(amountAndTax) >= 0) continue;
                String tipMsg3 = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u4e0a\u9650\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u4ef7\u7a0e\u5408\u8ba1\u3002", (String)"PoOtherValidator_3", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1);
                this.addMessage(data, tipMsg3, ErrorLevel.Error);
            }
        }
    }
}

