/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.order;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.pm.enums.ChangeTypeEnum;

public class PurOrderBillDeliverValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(PurOrderBillDeliverValidator.class);

    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            if (entrys == null || entrys.size() <= 0) continue;
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                BigDecimal qty = entry.getBigDecimal("qty");
                DynamicObjectCollection deliverEntrys = entry.getDynamicObjectCollection("purbillentry_deliver");
                if (qty == null || deliverEntrys == null || deliverEntrys.size() <= 0) continue;
                BigDecimal planQtys = BigDecimal.ZERO;
                for (int j = 0; j < deliverEntrys.size(); ++j) {
                    DynamicObject deliverEntry = (DynamicObject)deliverEntrys.get(j);
                    String changeType = deliverEntry.getString("delentrychangetype");
                    if (ChangeTypeEnum.CANCEL.getValue().equals(changeType)) continue;
                    BigDecimal planQty = deliverEntry.getBigDecimal("planqty");
                    planQtys = planQtys.add(planQty);
                }
                if (planQtys.compareTo(BigDecimal.ZERO) == 0) {
                    return;
                }
                if (planQtys.compareTo(qty) == 0) continue;
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u7269\u6599\u660e\u7ec6\u4e2d\u7684\u6570\u91cf\uff0c\u4e0d\u7b49\u4e8e\u4ea4\u8d27\u8ba1\u5212\u5b50\u5206\u5f55\u4e2d\u8ba1\u5212\u4ea4\u8d27\u6570\u91cf\u4e4b\u548c\u3002", (String)"PurOrderBillDeliverValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
            }
        }
    }
}

