/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.order;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.pm.enums.ChangeTypeEnum;
import kd.sdk.scmc.pm.extpoint.IXPurOrderCasePlugin;

public class XPurOrderBillQtyAmountValidator
extends AbstractValidator {
    private final BigDecimal ZERO = BigDecimal.ZERO;
    private static final String PRETIMEPOINT_CONM = "A";
    private static final String CONM_PURCONTRACT = "conm_purcontract";
    private static final Log LOG = LogFactory.getLog(XPurOrderBillQtyAmountValidator.class);

    public void validate() {
        DynamicObjectCollection entrys;
        DynamicObject bill;
        int seq;
        block2: for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObjectCollection payEntrys;
            Iterator entry2;
            DynamicObject bill2 = data.getDataEntity();
            DynamicObjectCollection entrys2 = bill2.getDynamicObjectCollection("billentry");
            if (entrys2 != null && entrys2.size() > 0) {
                for (Iterator entry2 : entrys2) {
                    DynamicObjectCollection deliverEntrys;
                    String entryChangeType = entry2.getString("entrychangetype");
                    seq = entry2.getInt("seq");
                    BigDecimal joinBaseQty = entry2.getBigDecimal("joinbaseqty");
                    BigDecimal joinPayablePriceQty = entry2.getBigDecimal("joinpayablepriceqty");
                    BigDecimal returnBaseQty = entry2.getBigDecimal("returnbaseqty");
                    BigDecimal returnReceiptBaseQty = entry2.getBigDecimal("returnreceiptbaseqty");
                    BigDecimal joinAmount = entry2.getBigDecimal("joinamount");
                    BigDecimal performAmount = entry2.getBigDecimal("performamount");
                    if (ChangeTypeEnum.CANCEL.getValue().equals(entryChangeType)) {
                        if (this.ZERO.compareTo(joinBaseQty) < 0 || this.ZERO.compareTo(joinPayablePriceQty) < 0 || this.ZERO.compareTo(returnBaseQty) < 0 || this.ZERO.compareTo(returnReceiptBaseQty) < 0) {
                            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u7684\u201c\u5173\u8054\u6570\u91cf\u201d\u6216\u201c\u5173\u8054\u9a8c\u6536\u5e94\u4ed8\u6570\u91cf\u201d\u6216\u201c\u5df2\u9000\u5e93\u6570\u91cf\u201d\u6216\u201c\u5df2\u9000\u9a8c\u6570\u91cf\u201d\u5927\u4e8e0\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"XPurOrderBillQtyAmountValidator_9", (String)"scmc-pm-opplugin", (Object[])new Object[0]), seq), ErrorLevel.Error);
                        }
                        if (this.ZERO.compareTo(joinAmount) < 0 || this.ZERO.compareTo(performAmount) < 0) {
                            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u7684\u201c\u6267\u884c\u91d1\u989d\u201d\u6216\u201c\u5173\u8054\u91d1\u989d\u201d\u5927\u4e8e0\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"XPurOrderBillQtyAmountValidator_17", (String)"scmc-pm-opplugin", (Object[])new Object[0]), seq), ErrorLevel.Error);
                        }
                    }
                    if ((deliverEntrys = entry2.getDynamicObjectCollection("purbillentry_deliver")) == null || deliverEntrys.size() <= 0) continue;
                    for (DynamicObject deliverEntry : deliverEntrys) {
                        int deliverSeq = deliverEntry.getInt("seq");
                        String deliverEntryChangeType = deliverEntry.getString("delentrychangetype");
                        BigDecimal planReciveQty = deliverEntry.getBigDecimal("planreceiveqty");
                        if (this.ZERO.compareTo(planReciveQty) >= 0 || !ChangeTypeEnum.CANCEL.getValue().equals(deliverEntryChangeType)) continue;
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u7684\u4ea4\u8d27\u8ba1\u5212\u7b2c%2$s\u884c\u7684\u201c\u6536\u8d27\u6570\u91cf\u201d\u5927\u4e8e0\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"XPurOrderBillQtyAmountValidator_12", (String)"scmc-pm-opplugin", (Object[])new Object[0]), seq, deliverSeq), ErrorLevel.Error);
                    }
                }
            }
            if ((payEntrys = bill2.getDynamicObjectCollection("purbillentry_pay")) == null || payEntrys.size() <= 0) continue;
            entry2 = payEntrys.iterator();
            while (entry2.hasNext()) {
                DynamicObject payEntry = (DynamicObject)entry2.next();
                int paySeq = payEntry.getInt("seq");
                String payEntryChangeType = payEntry.getString("payentrychangetype");
                BigDecimal payAmount = payEntry.getBigDecimal("payamount");
                BigDecimal joinPayAmount = payEntry.getBigDecimal("joinpayamount");
                Boolean isprepay = payEntry.getBoolean("isprepay");
                String paysrcbillentity = payEntry.getString("paysrcbillentity");
                String pretimepoint = payEntry.getString("pretimepoint");
                if (this.ZERO.compareTo(payAmount) >= 0 && !ChangeTypeEnum.CANCEL.getValue().equals(payEntryChangeType)) {
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ed8\u6b3e\u8ba1\u5212\u201c\u7b2c%1$s\u884c\u201c\u4ed8\u6b3e\u91d1\u989d\u201d\u3002", (String)"XPurOrderBillQtyAmountValidator_16", (String)"scmc-pm-opplugin", (Object[])new Object[0]), paySeq), ErrorLevel.Error);
                }
                if (this.ZERO.compareTo(joinPayAmount) < 0 && ChangeTypeEnum.CANCEL.getValue().equals(payEntryChangeType)) {
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u7b2c%1$s\u884c\u7684\u201c\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\u201d\u5927\u4e8e0\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"XPurOrderBillQtyAmountValidator_14", (String)"scmc-pm-opplugin", (Object[])new Object[0]), paySeq), ErrorLevel.Error);
                }
                if (!isprepay.booleanValue() || !PRETIMEPOINT_CONM.equals(pretimepoint) || !CONM_PURCONTRACT.equals(paysrcbillentity) || !ChangeTypeEnum.CANCEL.getValue().equals(payEntryChangeType)) continue;
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u9884\u4ed8\u65f6\u70b9\u4e3a\u91c7\u8d2d\u5408\u540c\u4e0d\u80fd\u5220\u884c\u3002", (String)"XPurOrderBillQtyAmountValidator_20", (String)"scmc-pm-opplugin", (Object[])new Object[0]), new Object[0]), ErrorLevel.Error);
                continue block2;
            }
        }
        Map cancelResult = null;
        try {
            PluginProxy pluginProxy = PluginProxy.create(null, IXPurOrderCasePlugin.class, (String)"SCMC_PM_XSPURORDERBILL_ACTIVE_CANCELCHECK", null);
            List cancelResults = pluginProxy.callReplace(IXPurOrderCasePlugin::cancelCheck);
            if (cancelResults != null && cancelResults.size() > 0) {
                cancelResult = (Map)cancelResults.get(cancelResults.size() - 1);
            }
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u5ba2\u6237\u5316\u573a\u666f\u201c%1$s\u201d\u63d2\u4ef6\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"XPurOrderBillQtyAmountValidator_19", (String)"scmc-pm-opplugin", (Object[])new Object[0]);
            msg = String.format(msg, "SCMC_PM_XSPURORDERBILL_ACTIVE_CANCELCHECK");
            String msgTotal = msg + e;
            LOG.info(msgTotal);
            throw new KDBizException(msgTotal);
        }
        if (cancelResult == null || cancelResult.get("QTYCHECKCANCEL") == null || !((Boolean)cancelResult.get("QTYCHECKCANCEL")).booleanValue()) {
            for (ExtendedDataEntity data : this.dataEntities) {
                bill = data.getDataEntity();
                entrys = bill.getDynamicObjectCollection("billentry");
                if (entrys == null || entrys.size() <= 0) continue;
                for (DynamicObject entry : entrys) {
                    seq = entry.getInt("seq");
                    String entryChangeType = entry.getString("entrychangetype");
                    BigDecimal qty = entry.getBigDecimal("qty");
                    BigDecimal receiveBaseQtyUp = entry.getBigDecimal("receivebaseqtyup");
                    BigDecimal joinBaseQty = entry.getBigDecimal("joinbaseqty");
                    BigDecimal joinPayablePriceQty = entry.getBigDecimal("joinpayablepriceqty");
                    if (!ChangeTypeEnum.UPDATE.getValue().equals(entryChangeType)) continue;
                    if (receiveBaseQtyUp != null && receiveBaseQtyUp.compareTo(joinBaseQty) < 0) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u53d8\u66f4\u540e\u7684\u201c\u6536\u8d27\u4e0a\u9650\u6570\u91cf\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8ba2\u5355\u7684\u201c\u5173\u8054\u6570\u91cf\u201d\u3002", (String)"XPurOrderBillQtyAmountValidator_10", (String)"scmc-pm-opplugin", (Object[])new Object[0]), seq), ErrorLevel.Error);
                    }
                    if (qty == null || qty.compareTo(joinPayablePriceQty) >= 0) continue;
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u53d8\u66f4\u540e\u7684\u201c\u6570\u91cf\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8ba2\u5355\u7684\u201c\u5173\u8054\u9a8c\u6536\u5e94\u4ed8\u6570\u91cf\u201d\u3002", (String)"XPurOrderBillQtyAmountValidator_11", (String)"scmc-pm-opplugin", (Object[])new Object[0]), seq), ErrorLevel.Error);
                }
            }
        }
        if (cancelResult == null || cancelResult.get("AMOUNTCHECKCANCEL") == null || !((Boolean)cancelResult.get("AMOUNTCHECKCANCEL")).booleanValue()) {
            for (ExtendedDataEntity data : this.dataEntities) {
                DynamicObjectCollection payEntrys;
                bill = data.getDataEntity();
                entrys = bill.getDynamicObjectCollection("billentry");
                if (entrys != null && entrys.size() > 0) {
                    for (DynamicObject entry : entrys) {
                        int seq2 = entry.getInt("seq");
                        String entryChangeType = entry.getString("entrychangetype");
                        BigDecimal amountUp = entry.getBigDecimal("amountup");
                        BigDecimal joinAmount = entry.getBigDecimal("joinamount");
                        BigDecimal performAmount = entry.getBigDecimal("performamount");
                        if (joinAmount == null || performAmount == null || amountUp == null || !ChangeTypeEnum.UPDATE.getValue().equals(entryChangeType) || amountUp.compareTo(joinAmount) >= 0 && amountUp.compareTo(performAmount) >= 0) continue;
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u53d8\u66f4\u540e\u7684\u201c\u4e0a\u9650\u91d1\u989d\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8ba2\u5355\u7684\u201c\u5173\u8054\u91d1\u989d\u201d\u548c\u201c\u6267\u884c\u91d1\u989d\u201d\u3002", (String)"XPurOrderBillQtyAmountValidator_18", (String)"scmc-pm-opplugin", (Object[])new Object[0]), seq2), ErrorLevel.Error);
                    }
                }
                if ((payEntrys = bill.getDynamicObjectCollection("purbillentry_pay")) == null || payEntrys.size() <= 0) continue;
                for (DynamicObject payEntry : payEntrys) {
                    int paySeq = payEntry.getInt("seq");
                    String payEntryChangeType = payEntry.getString("payentrychangetype");
                    BigDecimal payAmount = payEntry.getBigDecimal("payamount");
                    BigDecimal joinPayAmount = payEntry.getBigDecimal("joinpayamount");
                    if (payAmount == null || payAmount.compareTo(joinPayAmount) >= 0 || !ChangeTypeEnum.UPDATE.getValue().equals(payEntryChangeType)) continue;
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u7b2c%1$s\u884c\u53d8\u66f4\u540e\u7684\u201c\u4ed8\u6b3e\u91d1\u989d\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u201c\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\u201d\u3002", (String)"XPurOrderBillQtyAmountValidator_15", (String)"scmc-pm-opplugin", (Object[])new Object[0]), paySeq), ErrorLevel.Error);
                }
            }
        }
    }
}

