/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.pm.enums.ActiveStatusEnum;
import kd.scmc.pm.enums.ChangeTypeEnum;
import kd.scmc.pm.enums.StatusEnum;
import kd.sdk.scmc.pm.extpoint.IXPurOrderCasePlugin;

public class XPurorderBillActiveValidator
extends AbstractValidator {
    private static final Log LOG = LogFactory.getLog(XPurorderBillActiveValidator.class);

    public void validate() {
        DynamicObject srcBill;
        Long srcBillID;
        DynamicObject entity;
        DynamicObject[] srcBills;
        for (ExtendedDataEntity extend : this.dataEntities) {
            ExtendedDataEntity[] entity2 = extend.getDataEntity();
            if (!ActiveStatusEnum.UNACTIVE.getValue().equals(entity2.get("activestatus"))) {
                this.addMessage(extend, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u751f\u6548\uff0c\u4e0d\u80fd\u91cd\u590d\u751f\u6548\u3002", (String)"XPurorderBillActiveValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (StatusEnum.AUDIT.getValue().equals(entity2.get("billstatus"))) continue;
            this.addMessage(extend, ResManager.loadKDString((String)"\u5355\u636e\u672a\u5ba1\u6838\uff0c\u4e0d\u80fd\u751f\u6548\u3002", (String)"XPurorderBillActiveValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
        }
        Map cancelResult = null;
        try {
            PluginProxy pluginProxy = PluginProxy.create(null, IXPurOrderCasePlugin.class, (String)"SCMC_PM_XSPURORDERBILL_ACTIVE_CANCELCHECK", null);
            List cancelResults = pluginProxy.callReplace(IXPurOrderCasePlugin::cancelCheck);
            if (cancelResults != null && cancelResults.size() > 0) {
                cancelResult = (Map)cancelResults.get(cancelResults.size() - 1);
            }
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u5ba2\u6237\u5316\u573a\u666f\u201c%1$s\u201d\u63d2\u4ef6\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"XPurorderBillActiveValidator_6", (String)"scmc-pm-opplugin", (Object[])new Object[0]);
            msg = String.format(msg, "SCMC_PM_XSPURORDERBILL_ACTIVE_CANCELCHECK");
            String msgTotal = msg + e;
            LOG.info(msgTotal);
            throw new KDBizException(msgTotal);
        }
        List<String> queryFields = this.getQueryFields();
        String selectStr = String.join((CharSequence)",", queryFields);
        HashSet<Long> srcBillIDs = new HashSet<Long>(16);
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObject entity3 = extend.getDataEntity();
            Long l = entity3.getLong("sourceid");
            srcBillIDs.add(l);
        }
        HashMap<Long, DynamicObject> srcBillMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dynamicObject : srcBills = BusinessDataServiceHelper.load((String)"pm_purorderbill", (String)selectStr, (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillIDs)})) {
            srcBillMap.put(dynamicObject.getLong("id"), dynamicObject);
        }
        for (DynamicObject dynamicObject : this.dataEntities) {
            entity = dynamicObject.getDataEntity();
            srcBillID = entity.getLong("sourceid");
            srcBill = (DynamicObject)srcBillMap.get(srcBillID);
            this.checkPrePayRate((ExtendedDataEntity)dynamicObject, srcBill);
        }
        if (cancelResult == null || cancelResult.get("QTYCHECKCANCEL") == null || !((Boolean)cancelResult.get("QTYCHECKCANCEL")).booleanValue()) {
            for (DynamicObject dynamicObject : this.dataEntities) {
                entity = dynamicObject.getDataEntity();
                srcBillID = entity.getLong("sourceid");
                srcBill = (DynamicObject)srcBillMap.get(srcBillID);
                this.checkEntryQty((ExtendedDataEntity)dynamicObject, srcBill);
            }
        }
        if (cancelResult == null || cancelResult.get("AMOUNTCHECKCANCEL") == null || !((Boolean)cancelResult.get("AMOUNTCHECKCANCEL")).booleanValue()) {
            for (DynamicObject dynamicObject : this.dataEntities) {
                entity = dynamicObject.getDataEntity();
                srcBillID = entity.getLong("sourceid");
                srcBill = (DynamicObject)srcBillMap.get(srcBillID);
                this.checkEntryAmount((ExtendedDataEntity)dynamicObject, srcBill);
            }
        }
    }

    private void checkPrePayRate(ExtendedDataEntity extend, DynamicObject srcBill) {
        if (srcBill == null) {
            return;
        }
        DynamicObject xBill = extend.getDataEntity();
        BigDecimal xTotalAllAmount = xBill.getBigDecimal("totalallamount");
        BigDecimal srcPaidAllAmount = srcBill.getBigDecimal("paidallamount");
        if (xTotalAllAmount != null && srcPaidAllAmount != null && xTotalAllAmount.compareTo(srcPaidAllAmount) > 0) {
            return;
        }
        DynamicObjectCollection xPayEntrys = xBill.getDynamicObjectCollection("purbillentry_pay");
        DynamicObjectCollection sPayEntrys = srcBill.getDynamicObjectCollection("purbillentry_pay");
        if (xPayEntrys != null && !xPayEntrys.isEmpty()) {
            boolean hasIsPrePayEntry = false;
            for (int i = 0; i < xPayEntrys.size(); ++i) {
                DynamicObject xpayEntry = (DynamicObject)xPayEntrys.get(i);
                boolean isPrePay = xpayEntry.getBoolean("isprepay");
                if (!isPrePay) continue;
                hasIsPrePayEntry = true;
                break;
            }
            if (!hasIsPrePayEntry) {
                return;
            }
            String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\u4ef7\u7a0e\u5408\u8ba1\u5c0f\u4e8e\u7b49\u4e8e\u8ba2\u5355\u5df2\u4ed8\u91d1\u989d\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u4ed8\u6b3e\u8ba1\u5212\u9884\u4ed8\u884c\u7684\u4ed8\u6b3e\u6bd4\u4f8b\u3002", (String)"XPurorderBillActiveValidator_7", (String)"scmc-pm-opplugin", (Object[])new Object[0]), xBill.getString("billno"));
            for (int i = 0; i < xPayEntrys.size(); ++i) {
                DynamicObject xpayEntry = (DynamicObject)xPayEntrys.get(i);
                boolean isPrePay = xpayEntry.getBoolean("isprepay");
                if (!isPrePay) continue;
                Long sourceEntryId = xpayEntry.getLong("sourcepayentryid");
                if (sourceEntryId == null || sourceEntryId.equals(0L)) {
                    this.addMessage(extend, msg, ErrorLevel.Error);
                    return;
                }
                BigDecimal xPayRate = xpayEntry.getBigDecimal("payrate");
                if (sPayEntrys == null || sPayEntrys.isEmpty()) continue;
                for (int j = 0; j < sPayEntrys.size(); ++j) {
                    Long srcPayEntryPkValue;
                    DynamicObject srcPayEntry = (DynamicObject)sPayEntrys.get(j);
                    if (srcPayEntry == null || sourceEntryId.compareTo(srcPayEntryPkValue = (Long)srcPayEntry.getPkValue()) != 0) continue;
                    boolean sIsPrePay = srcPayEntry.getBoolean("isprepay");
                    BigDecimal sPayRate = srcPayEntry.getBigDecimal("payrate");
                    if (sIsPrePay && xPayRate.compareTo(sPayRate) == 0) continue;
                    this.addMessage(extend, msg, ErrorLevel.Error);
                    return;
                }
            }
        }
    }

    private void checkEntryAmount(ExtendedDataEntity extend, DynamicObject srcBill) {
        DynamicObjectCollection entrys = extend.getDataEntity().getDynamicObjectCollection("purbillentry_pay");
        DynamicObjectCollection srcEntrys = srcBill.getDynamicObjectCollection("purbillentry_pay");
        if (srcEntrys == null || srcEntrys.size() == 0) {
            return;
        }
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject billEntry = (DynamicObject)entrys.get(i);
            Long sourceEntryId = billEntry.getLong("sourcepayentryid");
            if (!ChangeTypeEnum.UPDATE.getValue().equals(billEntry.getString("payentrychangetype"))) continue;
            for (DynamicObject srcEntry : srcEntrys) {
                Long srcEntryId = (Long)srcEntry.getPkValue();
                if (srcEntryId.longValue() != sourceEntryId.longValue()) continue;
                BigDecimal amount = billEntry.getBigDecimal("payamount");
                if (srcEntry.getBigDecimal("joinpayamount").compareTo(amount) <= 0) continue;
                int row = i + 1;
                this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u7b2c%1$s\u884c\u8ba2\u5355\u53d8\u66f4\u540e\u7684\u4ed8\u6b3e\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u8ba2\u5355\u7684\u5df2\u6267\u884c\u91d1\u989d\u3002", (String)"XPurorderBillActiveValidator_2", (String)"scmc-pm-opplugin", (Object[])new Object[0]), row), ErrorLevel.Error);
            }
        }
    }

    private void checkEntryQty(ExtendedDataEntity extend, DynamicObject srcBill) {
        DynamicObjectCollection srcEntrys = srcBill.getDynamicObjectCollection("billentry");
        if (srcEntrys == null || srcEntrys.size() == 0) {
            this.addMessage(extend, ResManager.loadKDString((String)"\u6e90\u8ba2\u5355\u4e0d\u5b58\u5728\u7269\u6599\u660e\u7ec6\uff0c\u4e0d\u80fd\u751f\u6548\u3002", (String)"XPurorderBillActiveValidator_4", (String)"scmc-pm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            return;
        }
        DynamicObjectCollection entrys = extend.getDataEntity().getDynamicObjectCollection("billentry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject billEntry = (DynamicObject)entrys.get(i);
            Long sourceEntryId = billEntry.getLong("sourceentryid");
            if (!ChangeTypeEnum.UPDATE.getValue().equals(billEntry.getString("entrychangetype"))) continue;
            for (DynamicObject srcEntry : srcEntrys) {
                Long srcEntryId = (Long)srcEntry.getPkValue();
                if (srcEntryId.longValue() != sourceEntryId.longValue()) continue;
                BigDecimal qty = billEntry.getBigDecimal("qty");
                BigDecimal baseUpQty = billEntry.getBigDecimal("receivebaseqtyup");
                if (srcEntry.getBigDecimal("joinbaseqty").compareTo(baseUpQty) <= 0 && srcEntry.getBigDecimal("joinpayablepriceqty").compareTo(qty) <= 0) continue;
                int row = i + 1;
                this.addMessage(extend, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u53d8\u66f4\u540e\u7684\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u8ba2\u5355\u7684\u5df2\u6267\u884c\u6570\u91cf\u3002", (String)"XPurorderBillActiveValidator_5", (String)"scmc-pm-opplugin", (Object[])new Object[0]), row), ErrorLevel.Error);
            }
        }
    }

    private List<String> getQueryFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("totalallamount");
        fields.add("paidallamount");
        fields.add("billentry.joinbaseqty");
        fields.add("billentry.joinpayablepriceqty");
        fields.add("purbillentry_pay.joinpayamount");
        fields.add("purbillentry_pay.isprepay");
        fields.add("purbillentry_pay.payrate");
        fields.add("purbillentry_pay.isprepay");
        fields.add("purbillentry_pay.id");
        return fields;
    }
}

