/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.order;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.pm.business.helper.BillParameterHelper;
import kd.scmc.pm.enums.ChangeTypeEnum;

public class XPurorderSubmitValidator
extends AbstractValidator {
    private static final BigDecimal ZERO = BigDecimal.ZERO;

    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            if (bill == null) continue;
            Boolean cancelDelete = BillParameterHelper.getIsEnableDeleteLine((String)bill.getDataEntityType().getName());
            Boolean isEnableXSPurOrderBill = BillParameterHelper.getIsEnableXSPurOrderBill();
            if (cancelDelete != null && isEnableXSPurOrderBill.booleanValue() && cancelDelete.booleanValue()) {
                this.checkEntryAndAmount(data);
                continue;
            }
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            boolean isAllCancel = true;
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject billEntry = (DynamicObject)entrys.get(i);
                BigDecimal qty = billEntry.getBigDecimal("qty");
                if (qty == null || BigDecimal.ZERO.compareTo(qty) == 0) {
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%s\u884c\u201c\u6570\u91cf\u201d\u3002", (String)"XPurorderSubmitValidator_2", (String)"scmc-pm-opplugin", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
                }
                if (ChangeTypeEnum.CANCEL.getValue().equals(billEntry.getString("entrychangetype"))) continue;
                isAllCancel = false;
            }
            if (!isAllCancel) continue;
            this.addMessage(data, ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u4e0d\u5141\u8bb8\u5168\u90e8\u53d6\u6d88\u3002", (String)"XPurorderSubmitValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }

    private Map<Long, Object> getSrcBillEntryMap(DynamicObjectCollection xBillEntry) {
        HashMap<Long, Object> srcBillEntryMap = new HashMap<Long, Object>(16);
        HashSet<Long> srcBillEntryIds = new HashSet<Long>(16);
        for (int i = 0; i < xBillEntry.size(); ++i) {
            int seq = i + 1;
            DynamicObject entry = (DynamicObject)xBillEntry.get(i);
            if (entry == null) continue;
            BigDecimal qty = entry.getBigDecimal("qty");
            String changeType = entry.getString("entrychangetype");
            if (qty == null || qty.compareTo(ZERO) != 0 || !ChangeTypeEnum.UPDATE.getValue().equals(changeType)) continue;
            srcBillEntryIds.add(entry.getLong("entrysrcid"));
        }
        if (srcBillEntryIds != null && !srcBillEntryIds.isEmpty()) {
            try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_purorderbill", (String)"id,billentry.id as entryid,billentry.qty as qty", (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", srcBillEntryIds)}, null);){
                while (queryDataSet != null && queryDataSet.hasNext()) {
                    Row bill = queryDataSet.next();
                    Long entryid = bill.getLong("entryid");
                    BigDecimal qty = bill.getBigDecimal("qty");
                    srcBillEntryMap.put(entryid, qty);
                }
            }
        }
        return srcBillEntryMap;
    }

    private void checkEntryAndAmount(ExtendedDataEntity extend) {
        if (extend == null) {
            return;
        }
        DynamicObject xBill = extend.getDataEntity();
        if (xBill == null) {
            return;
        }
        DynamicObjectCollection xBillEntry = xBill.getDynamicObjectCollection("billentry");
        if (xBillEntry == null || xBillEntry.size() == 0) {
            return;
        }
        Map<Long, Object> srcBillEntryMap = this.getSrcBillEntryMap(xBillEntry);
        if (srcBillEntryMap == null || srcBillEntryMap.isEmpty()) {
            return;
        }
        for (int i = 0; i < xBillEntry.size(); ++i) {
            BigDecimal srcQty;
            Long billentrysrcid;
            int seq = i + 1;
            DynamicObject entry = (DynamicObject)xBillEntry.get(i);
            if (entry == null) continue;
            BigDecimal qty = entry.getBigDecimal("qty");
            String changeType = entry.getString("entrychangetype");
            if (qty != null && qty.compareTo(ZERO) == 0 && ChangeTypeEnum.UPDATE.getValue().equals(changeType) && (billentrysrcid = Long.valueOf(entry.getLong("entrysrcid"))) != null && srcBillEntryMap.get(billentrysrcid) != null && (srcQty = (BigDecimal)srcBillEntryMap.get(billentrysrcid)) != null && srcQty.compareTo(ZERO) > 0) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c:\u6570\u91cf\u3002", (String)"XPurContractSubmitValidator_6", (String)"scmc-conm-opplugin", (Object[])new Object[0]);
                this.addMessage(extend, String.format(msg, seq), ErrorLevel.Error);
            }
            if (qty == null || qty.compareTo(ZERO) != 0 || !ChangeTypeEnum.ADDNEW.getValue().equals(changeType)) continue;
            String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7269\u6599\u660e\u7ec6\u201d\u7b2c%1$s\u884c:\u6570\u91cf\u3002", (String)"XPurContractSubmitValidator_6", (String)"scmc-conm-opplugin", (Object[])new Object[0]);
            this.addMessage(extend, String.format(msg, seq), ErrorLevel.Error);
        }
    }
}

