/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.plan;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.scmc.pm.enums.BizCloseStatusEnum;
import kd.scmc.pm.enums.RowCloseStatusEnum;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.utils.CommonUtils;

public class PurPlanBillRowCloseValidator
extends AbstractValidator {
    public void validate() {
        block8: for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObjectCollection dynamicObject = (DynamicObjectCollection)bill.get("billentry");
            switch (this.getOperateKey()) {
                case "rowunclose": {
                    this.rowCloseValidate(data, dynamicObject, RowCloseStatusEnum.UNROWCLOSE.getValue());
                    continue block8;
                }
                case "rowclose": {
                    this.rowCloseValidate(data, dynamicObject, RowCloseStatusEnum.ROWCLOSE.getValue());
                }
            }
        }
    }

    private void rowCloseValidate(ExtendedDataEntity data, DynamicObjectCollection billS, String rowOpStatus) {
        String tip;
        DynamicObject bill = data.getDataEntity();
        String selectRow = this.getOption().getVariableValue("selectRows", null);
        if (CommonUtils.isNull((Object)selectRow)) {
            tip = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5904\u7406\u7684\u7269\u6599\u660e\u7ec6\u884c\u3002", (String)"PurPlanBillRowCloseValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]);
            this.addMessage(data, tip, ErrorLevel.Error);
        }
        String billStatus = bill.getString("billstatus");
        String closeStatus = bill.getString("closestatus");
        if (!StatusEnum.AUDIT.getValue().equals(billStatus)) {
            tip = ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\uff0c\u624d\u80fd\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PurPlanBillRowCloseValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]);
            this.addMessage(data, tip, ErrorLevel.Error);
        }
        if (!BizCloseStatusEnum.UNCLOSE.getValue().equals(closeStatus)) {
            tip = ResManager.loadKDString((String)"\u5355\u636e\u5173\u95ed\u72b6\u6001\u5fc5\u987b\u4e3a\u201c\u6b63\u5e38\u201d\uff0c\u624d\u80fd\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PurPlanBillRowCloseValidator_2", (String)"scmc-pm-opplugin", (Object[])new Object[0]);
            this.addMessage(data, tip, ErrorLevel.Error);
        }
        List<String> rows = Arrays.asList(selectRow.split(","));
        boolean isSuccess = false;
        for (int i = 0; i < billS.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)billS.get(i);
            String rowSeq = String.valueOf(i);
            String rowCloseStatus = dynamicObject.getString("rowclosestatus");
            if (!rows.contains(rowSeq) || rowOpStatus.equals(rowCloseStatus)) continue;
            isSuccess = true;
        }
        if (!isSuccess && rowOpStatus.equals(RowCloseStatusEnum.UNROWCLOSE.getValue())) {
            tip = ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5206\u5f55\u884c\u4e2d\u6ca1\u6709\u53ef\u53cd\u5173\u95ed\u7684\u884c\u3002", (String)"PurPlanBillRowCloseValidator_3", (String)"scmc-pm-opplugin", (Object[])new Object[0]);
            this.addMessage(data, tip, ErrorLevel.Error);
        } else if (!isSuccess && rowOpStatus.equals(RowCloseStatusEnum.ROWCLOSE.getValue())) {
            tip = ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5206\u5f55\u884c\u4e0d\u53ef\u5173\u95ed\u3002", (String)"PurPlanBillRowCloseValidator_4", (String)"scmc-pm-opplugin", (Object[])new Object[0]);
            this.addMessage(data, tip, ErrorLevel.Error);
        }
    }
}

