/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.validation.tpl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.scmc.pm.enums.BizCancelStatusEnum;
import kd.scmc.pm.enums.BizCloseStatusEnum;
import kd.scmc.pm.enums.RowCloseStatusEnum;
import kd.scmc.pm.enums.StatusEnum;

public class BizStatusValidator
extends AbstractValidator {
    public void validate() {
        switch (this.getOperateKey()) {
            case "delete": {
                for (ExtendedDataEntity data : this.dataEntities) {
                    DynamicObject bill = data.getDataEntity();
                    String cancelStatus = bill.getString("cancelstatus");
                    if (!BizCancelStatusEnum.CANCEL.getValue().equals(cancelStatus)) continue;
                    this.addMessage(data, ResManager.loadKDString((String)"\u53ea\u6709\u672a\u4f5c\u5e9f\u7684\u6570\u636e\u624d\u80fd\u5220\u9664\u3002", (String)"BizStatusValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
                break;
            }
            case "submit": {
                for (ExtendedDataEntity data : this.dataEntities) {
                    DynamicObject bill = data.getDataEntity();
                    String cancelStatus = bill.getString("cancelstatus");
                    if (!BizCancelStatusEnum.CANCEL.getValue().equals(cancelStatus)) continue;
                    this.addMessage(data, ResManager.loadKDString((String)"\u53ea\u6709\u672a\u4f5c\u5e9f\u7684\u6570\u636e\u624d\u80fd\u63d0\u4ea4\u3002", (String)"BizStatusValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
                break;
            }
            case "unaudit": {
                for (ExtendedDataEntity data : this.dataEntities) {
                    DynamicObject bill = data.getDataEntity();
                    String closeStatus = bill.getString("closestatus");
                    if (!BizCloseStatusEnum.CLOSE.getValue().equals(closeStatus)) continue;
                    this.addMessage(data, ResManager.loadKDString((String)"\u5173\u95ed\u72b6\u6001\u5fc5\u987b\u4e3a\u201c\u6b63\u5e38\u201d\u624d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"BizStatusValidator_2", (String)"scmc-pm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
                break;
            }
            case "bizclose": {
                for (ExtendedDataEntity data : this.dataEntities) {
                    DynamicObject bill = data.getDataEntity();
                    String billStatus = bill.getString("billstatus");
                    String closeStatus = bill.getString("closestatus");
                    if (BizCloseStatusEnum.CLOSE.getValue().equals(closeStatus)) {
                        this.addMessage(data, ResManager.loadKDString((String)"\u5173\u95ed\u72b6\u6001\u5fc5\u987b\u4e3a\u201c\u6b63\u5e38\u201d\u624d\u80fd\u5173\u95ed\u3002", (String)"BizStatusValidator_3", (String)"scmc-pm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    if (StatusEnum.AUDIT.getValue().equals(billStatus)) continue;
                    this.addMessage(data, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u201c\u5df2\u5ba1\u6838\u201d\u624d\u80fd\u5173\u95ed\u3002", (String)"BizStatusValidator_4", (String)"scmc-pm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
                break;
            }
            case "bizunclose": {
                for (ExtendedDataEntity data : this.dataEntities) {
                    DynamicObjectCollection entrys;
                    DynamicObject bill = data.getDataEntity();
                    String closeStatus = bill.getString("closestatus");
                    String dataEntityType = bill.getDataEntityType().getName();
                    if (BizCloseStatusEnum.UNCLOSE.getValue().equals(closeStatus)) {
                        this.addMessage(data, ResManager.loadKDString((String)"\u5173\u95ed\u72b6\u6001\u5fc5\u987b\u4e3a\u201c\u5df2\u5173\u95ed\u201d\u624d\u80fd\u53cd\u5173\u95ed\u3002", (String)"BizStatusValidator_5", (String)"scmc-pm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    if (dataEntityType.equals("pm_purorderbill") || dataEntityType.equals("pm_om_purorderbill") || dataEntityType.equals("pm_receiptnotice") || dataEntityType.equals("pm_purplanbill") || dataEntityType.equals("pm_purapplybill") || (entrys = bill.getDynamicObjectCollection("billentry")) == null || entrys.size() <= 0) continue;
                    boolean allRowClose = true;
                    for (DynamicObject entry : entrys) {
                        String rowCloseStatus = entry.getString("rowclosestatus");
                        if (!RowCloseStatusEnum.UNROWCLOSE.getValue().equals(rowCloseStatus)) continue;
                        allRowClose = false;
                    }
                    if (!allRowClose) continue;
                    this.addMessage(data, ResManager.loadKDString((String)"\u81ea\u52a8\u5173\u95ed\u7684\u5355\u636e\u4e0d\u80fd\u624b\u52a8\u53cd\u5173\u95ed\u3002", (String)"BizStatusValidator_6", (String)"scmc-pm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
                break;
            }
            case "cancel": {
                for (ExtendedDataEntity data : this.dataEntities) {
                    DynamicObject bill = data.getDataEntity();
                    String billStatus = bill.getString("billstatus");
                    String cancelStatus = bill.getString("cancelstatus");
                    if (BizCancelStatusEnum.UNCANCEL.getValue().equals(cancelStatus)) {
                        this.addMessage(data, ResManager.loadKDString((String)"\u4f5c\u5e9f\u72b6\u6001\u5fc5\u987b\u4e3a\u201c\u672a\u4f5c\u5e9f\u201d\u624d\u80fd\u4f5c\u5e9f\u3002", (String)"BizStatusValidator_7", (String)"scmc-pm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    if (StatusEnum.SAVE.getValue().equals(billStatus)) continue;
                    this.addMessage(data, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u201c\u6682\u5b58\u201d\u624d\u80fd\u4f5c\u5e9f\u3002", (String)"BizStatusValidator_8", (String)"scmc-pm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
                break;
            }
        }
    }
}

