/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pmp.validation.adjust;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class PurPriceAdjustSubmitValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            boolean istax = bill.getBoolean("istax");
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("priceentryentity");
            if (entries == null || entries.size() <= 0) continue;
            for (DynamicObject entry : entries) {
                BigDecimal priceandtax = entry.getBigDecimal("adjpriceandtax");
                BigDecimal price = entry.getBigDecimal("adjprice");
                if (istax) {
                    if (priceandtax == null || BigDecimal.ZERO.compareTo(priceandtax) == 0) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8c03\u6574\u660e\u7ec6\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\u201c\u542b\u7a0e\u5355\u4ef7\u201d\u3002", (String)"PurPriceAdjustSubmitValidator_3", (String)"scmc-pm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                    }
                } else if (price == null || BigDecimal.ZERO.compareTo(price) == 0) {
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8c03\u6574\u660e\u7ec6\u5355\u636e\u4f53\u201d\u7b2c%s\u884c\u201c\u5355\u4ef7\u201d\u3002", (String)"PurPriceAdjustSubmitValidator_2", (String)"scmc-pm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                }
                BigDecimal priceFloor = entry.getBigDecimal("adjpricefloor");
                BigDecimal priceCeiling = entry.getBigDecimal("adjpriceceiling");
                if (priceCeiling.compareTo(BigDecimal.ZERO) > 0 && priceFloor.compareTo(priceCeiling) > 0) {
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8c03\u6574\u660e\u7ec6\u7b2c%s\u884c\u6700\u9ad8\u9650\u4ef7\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u6700\u4f4e\u9650\u4ef7\u3002", (String)"PurPriceAdjustSubmitValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                }
                if (priceandtax != null && BigDecimal.ZERO.compareTo(priceandtax) < 0) {
                    if (priceFloor.compareTo(BigDecimal.ZERO) > 0 && priceandtax.compareTo(priceFloor) < 0) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8c03\u6574\u660e\u7ec6\u7b2c%s\u884c\u542b\u7a0e\u5355\u4ef7\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u6700\u4f4e\u9650\u4ef7\u3002", (String)"PurPriceAdjustSubmitValidator_4", (String)"scmc-pm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                    }
                    if (priceCeiling.compareTo(BigDecimal.ZERO) > 0 && priceandtax.compareTo(priceCeiling) > 0) {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8c03\u6574\u660e\u7ec6\u7b2c%s\u884c\u542b\u7a0e\u5355\u4ef7\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u6700\u9ad8\u9650\u4ef7\u3002", (String)"PurPriceAdjustSubmitValidator_5", (String)"scmc-pm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
                    }
                }
                Date priceEffDate = entry.getDate("adjpriceeffectdate");
                Date priceExpDate = entry.getDate("adjpriceexpirydate");
                if (priceExpDate == null || priceEffDate == null || !priceEffDate.after(priceExpDate)) continue;
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8c03\u6574\u660e\u7ec6\u7b2c%s\u884c\u4ef7\u683c\u751f\u6548\u65e5\u671f\u9700\u5c0f\u4e8e\u7b49\u4e8e\u4ef7\u683c\u5931\u6548\u65e5\u671f\u3002", (String)"PurPriceAdjustSubmitValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), entry.getInt("seq")));
            }
        }
    }
}

