/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pmp.validation.price;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.business.helper.MaterialHelper;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.msbd.common.utils.CommonUtils;

public class PurPriceListMaterialValidator
extends AbstractValidator {
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String MASTERID = "masterid";
    private static final String BASEUNIT = "baseunit";

    public Set<String> preparePropertys() {
        HashSet<String> prepareProperties = super.preparePropertys();
        if (CommonUtils.isNull((Object)prepareProperties)) {
            prepareProperties = new HashSet<String>(8);
        }
        prepareProperties.add("istax");
        prepareProperties.add("material");
        prepareProperties.add("taxrate");
        prepareProperties.add("unit");
        prepareProperties.add("priceeffectdate");
        prepareProperties.add("priceexpirydate");
        prepareProperties.add("price");
        prepareProperties.add("priceandtax");
        prepareProperties.add("pricefloor");
        prepareProperties.add("priceceiling");
        return prepareProperties;
    }

    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length == 0) {
            return;
        }
        Map<Object, DynamicObject> materialMap = this.getMaterialMap();
        for (ExtendedDataEntity entity : this.getDataEntities()) {
            DynamicObject bill = entity.getDataEntity();
            if (bill == null) continue;
            boolean isTax = bill.getBoolean("istax");
            DynamicObjectCollection priceEntryEntity = bill.getDynamicObjectCollection("priceentryentity");
            if (priceEntryEntity.isEmpty()) continue;
            for (int row = 0; row < priceEntryEntity.size(); ++row) {
                DynamicObject entry = (DynamicObject)priceEntryEntity.get(row);
                DynamicObject materialPurInfo = entry.getDynamicObject("material");
                DynamicObject material = null;
                if (materialPurInfo != null && materialMap != null) {
                    material = materialMap.get(materialPurInfo.getPkValue());
                }
                BigDecimal taxRate = entry.getBigDecimal("taxrate");
                DynamicObject unit = entry.getDynamicObject("unit");
                if (material != null) {
                    boolean checkUnit;
                    DynamicObject baseUnit = material.getDynamicObject(BASEUNIT);
                    if (unit != null && baseUnit != null && !unit.getPkValue().equals(baseUnit.getPkValue()) && !(checkUnit = MaterialHelper.checkUnit((Long)material.getLong(ID), (Long)((Long)baseUnit.getPkValue()), (Long)((Long)unit.getPkValue())))) {
                        this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u8ba1\u91cf\u5355\u4f4d\u7f16\u7801\u201c%2$s\u201d\u4e0d\u662f\u7269\u6599\u7f16\u7801\u201c%3$s\u201d\u7684\u53ef\u7528\u8ba1\u91cf\u5355\u4f4d\u3002", (String)"PurPriceListMaterialValidator_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]), row + 1, unit.getString(NUMBER), material.getString(NUMBER)), ErrorLevel.Error);
                    }
                }
                Date priceEffectDate = entry.getDate("priceeffectdate");
                Date priceExpiryDate = entry.getDate("priceexpirydate");
                if (priceExpiryDate != null && priceEffectDate != null && priceEffectDate.after(priceExpiryDate)) {
                    this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u4ef7\u683c\u751f\u6548\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u4ef7\u683c\u5931\u6548\u65e5\u671f\u3002", (String)"PurPriceListMaterialValidator_1", (String)"scmc-pm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
                }
                this.handlePriceAndTax(entry, entity, isTax, taxRate, row);
            }
        }
    }

    private Map<Object, DynamicObject> getMaterialMap() {
        HashSet<Object> materialPurInfoIdSet = new HashSet<Object>(8);
        for (ExtendedDataEntity entity : this.getDataEntities()) {
            DynamicObjectCollection priceEntryEntity;
            DynamicObject bill = entity.getDataEntity();
            if (bill == null || ObjectUtils.isEmpty((Object)(priceEntryEntity = bill.getDynamicObjectCollection("priceentryentity")))) continue;
            for (int row = 0; row < priceEntryEntity.size(); ++row) {
                DynamicObject entry = (DynamicObject)priceEntryEntity.get(row);
                DynamicObject materialPurInfo = entry.getDynamicObject("material");
                if (materialPurInfo == null) continue;
                materialPurInfoIdSet.add(materialPurInfo.getPkValue());
            }
        }
        if (ObjectUtils.isEmpty(materialPurInfoIdSet)) {
            return Collections.emptyMap();
        }
        Map idAndMaterialPurInfoMap = BusinessDataServiceHelper.loadFromCache((String)"bd_materialpurchaseinfo", (String)"id,masterid.id,masterid.number,masterid.baseunit", (QFilter[])new QFilter[]{new QFilter(ID, "in", materialPurInfoIdSet)});
        HashMap<Object, DynamicObject> resMap = new HashMap<Object, DynamicObject>(idAndMaterialPurInfoMap.size());
        for (Map.Entry entry : idAndMaterialPurInfoMap.entrySet()) {
            resMap.put(entry.getKey(), ((DynamicObject)entry.getValue()).getDynamicObject(MASTERID));
        }
        return resMap;
    }

    private void handlePriceAndTax(DynamicObject entry, ExtendedDataEntity entity, boolean isTax, BigDecimal taxRate, int row) {
        BigDecimal priceAndTax = entry.getBigDecimal("priceandtax");
        BigDecimal price = entry.getBigDecimal("price");
        BigDecimal minPrice = entry.getBigDecimal("pricefloor");
        BigDecimal maxPrice = entry.getBigDecimal("priceceiling");
        if (isTax) {
            if (BigDecimalUtil.isBlank((BigDecimal)priceAndTax)) {
                this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u542b\u7a0e\u4e3a\u201c\u662f\u201d\uff0c\u8bf7\u5f55\u5165\u542b\u7a0e\u5355\u4ef7\u3002", (String)"PurPriceListMaterialValidator_2", (String)"scmc-pm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
                return;
            }
            BigDecimal expectPrice = priceAndTax.divide(BigDecimalUtil.ONE.add(BigDecimalUtil.div100((BigDecimal)taxRate)), 10, RoundingMode.HALF_UP);
            if (BigDecimalUtil.notEquals((BigDecimal)price, (BigDecimal)expectPrice)) {
                this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u201c\u5355\u4ef7*\uff081+\u7a0e\u7387\uff09\u201d\u4e0d\u7b49\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"PurPriceListMaterialValidator_7", (String)"scmc-pm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
            }
        } else {
            if (BigDecimalUtil.isBlank((BigDecimal)price)) {
                this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u542b\u7a0e\u4e3a\u201c\u5426\u201d\uff0c\u8bf7\u5f55\u5165\u5355\u4ef7\u3002", (String)"PurPriceListMaterialValidator_3", (String)"scmc-pm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
                return;
            }
            BigDecimal expectPriceAndTax = price.multiply(BigDecimalUtil.ONE.add(BigDecimalUtil.div100((BigDecimal)taxRate))).setScale(10, RoundingMode.HALF_UP);
            if (BigDecimalUtil.notEquals((BigDecimal)priceAndTax, (BigDecimal)expectPriceAndTax)) {
                this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u201c\u5355\u4ef7*\uff081+\u7a0e\u7387\uff09\u201d\u4e0d\u7b49\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"PurPriceListMaterialValidator_7", (String)"scmc-pm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
            }
        }
        if (BigDecimalUtil.isNotBlank((BigDecimal)priceAndTax) && BigDecimalUtil.lessThan((BigDecimal)priceAndTax, (BigDecimal)minPrice)) {
            this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u542b\u7a0e\u5355\u4ef7\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u6700\u4f4e\u9650\u4ef7\u3002", (String)"PurPriceListMaterialValidator_4", (String)"scmc-pm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
        }
        if (BigDecimalUtil.isNotBlank((BigDecimal)maxPrice)) {
            if (BigDecimalUtil.lessThan((BigDecimal)maxPrice, (BigDecimal)minPrice)) {
                this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u6700\u9ad8\u9650\u4ef7\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u6700\u4f4e\u9650\u4ef7\u3002", (String)"PurPriceListMaterialValidator_5", (String)"scmc-pm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
            }
            if (BigDecimalUtil.largeThan((BigDecimal)priceAndTax, (BigDecimal)maxPrice)) {
                this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u4ef7\u683c\u660e\u7ec6\u7b2c%1$s\u884c\u542b\u7a0e\u5355\u4ef7\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u6700\u9ad8\u9650\u4ef7\u3002", (String)"PurPriceListMaterialValidator_6", (String)"scmc-pm-opplugin", (Object[])new Object[0]), row + 1, ErrorLevel.Error));
            }
        }
    }
}

