/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.botp.runtime.SourceRowReport;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.scmc.pm.vmi.business.helper.GenerateTargetBill;
import kd.scmc.pm.vmi.business.pojo.GenerateTargetResult;

public class BotpHelper {
    private static final Log log = LogFactory.getLog(BotpHelper.class);
    private static final char BLANK = ' ';

    public static Map<Long, String> botpPushFail(ConvertOperationResult convertResult, String botpid) {
        HashMap<Long, String> billIDAndErrMsg = new HashMap<Long, String>(10);
        String headInfo = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u8f6c\u6362\u89c4\u5219ID\uff1a%2$s\u3002", (String)"BotpHelper_0", (String)"scmc-pm-vmi", (Object[])new Object[0]), convertResult.getMessage(), botpid);
        List reports = convertResult.getBillReports();
        for (SourceBillReport report : reports) {
            StringBuilder message = new StringBuilder();
            message.append(headInfo);
            Object billId = report.getBillId();
            List rowReports = report.getLinkEntityRowReports();
            for (SourceRowReport rowReport : rowReports) {
                message.append(BotpHelper.theEntry(rowReport.getEntrySeq()));
                List failMessages = rowReport.getFailMessages();
                for (String faiMessage : failMessages) {
                    message.append(' ');
                    message.append(faiMessage);
                }
            }
            billIDAndErrMsg.put((Long)billId, message.toString());
        }
        log.info(convertResult.getSourceEntityNumber() + " \u4e0b\u63a8 " + convertResult.getTargetEntityNumber() + "\u5931\u8d25\u4fe1\u606f \uff1a" + billIDAndErrMsg);
        return billIDAndErrMsg;
    }

    public static String theEntry(Object seq) {
        return String.format(ResManager.loadKDString((String)" \u5206\u5f55\u7b2c%s\u884c\uff1a", (String)"BotpHelper_1", (String)"scmc-pm-vmi", (Object[])new Object[0]), seq);
    }

    public static List<DynamicObject> getTargetBillFromConvertResult(ConvertOperationResult convertResult, String targetEntity) {
        ArrayList<DynamicObject> targetBills = new ArrayList(10);
        if (StringUtils.isBlank((CharSequence)targetEntity)) {
            targetEntity = convertResult.getTargetEntityNumber();
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)targetEntity);
        IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] dataEntitys, IDataEntityType dataType) {
                BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dataType);
            }
        };
        targetBills = convertResult.loadTargetDataObjects(refDataProvider, mainType);
        return targetBills;
    }

    public static ConvertOperationResult pushTargetBill(Map<Long, Long> entryIdAndBillIdMap, String srcEntity, String targetEntity, String entryEntity, String botpId, Map<String, String> param) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(srcEntity);
        pushArgs.setTargetEntityNumber(targetEntity);
        pushArgs.setBuildConvReport(true);
        if (param != null) {
            for (Map.Entry<String, String> entry : param.entrySet()) {
                pushArgs.addCustomParam(entry.getKey(), entry.getValue());
            }
        }
        pushArgs.setRuleId(botpId);
        ArrayList<ListSelectedRow> sourceEntryRows = new ArrayList<ListSelectedRow>(entryIdAndBillIdMap.size());
        for (Map.Entry<Long, Long> entry : entryIdAndBillIdMap.entrySet()) {
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue((Object)entry.getValue());
            row.setEntryPrimaryKeyValue((Object)entry.getKey());
            row.setEntryEntityKey(entryEntity);
            sourceEntryRows.add(row);
        }
        pushArgs.setSelectedRows(sourceEntryRows);
        ConvertOperationResult convertOperationResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        return convertOperationResult;
    }

    public static GenerateTargetResult pushAndSaveTargetBill(String srcEntity, String targetEntity, String targetEntryEntity, String botpId, Map<Long, Long> entryIdAndBillIdMap, Map<String, String> paramMap) {
        GenerateTargetBill obj = new GenerateTargetBill(srcEntity, targetEntity, targetEntryEntity, botpId, entryIdAndBillIdMap, paramMap);
        log.info("\u4e0b\u63a8\u5e76\u4fdd\u5b58\u53c2\u6570\u4e3a\uff1a" + obj);
        return obj.generateTargetBill();
    }
}

