/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.pm.vmi.business.pojo.VMIFocusSettleRuleInfo;

public class VMIFocusSettleRuleHelper {
    private static final char SETTLESIGN = '&';

    public static Map<String, Long> getSettleOrgMap(List<VMIFocusSettleRuleInfo> infos) {
        if (infos == null || infos.size() == 0) {
            return null;
        }
        int size = infos.size();
        ArrayList<Long> purOrgIds = new ArrayList<Long>(size);
        ArrayList<Long> reqOrgIds = new ArrayList<Long>(size);
        for (VMIFocusSettleRuleInfo info : infos) {
            if (info == null) continue;
            purOrgIds.add(info.getPurOrg());
            reqOrgIds.add(info.getReqOrg());
        }
        QFilter q1 = new QFilter("org", "in", purOrgIds);
        QFilter q2 = new QFilter("reqorg", "in", reqOrgIds);
        QFilter q4 = new QFilter("enable", "=", (Object)"1");
        Map loadFromCaches = BusinessDataServiceHelper.loadFromCache((String)"pm_vmifocussettlerule", (String)"id,org,reqorg,material.masterid,settleorg,enable", (QFilter[])new QFilter[]{q1, q2, q4});
        if (loadFromCaches == null || loadFromCaches.size() < 1) {
            return null;
        }
        HashMap<String, Long> settleOrgMap = new HashMap<String, Long>(loadFromCaches.size());
        block1: for (VMIFocusSettleRuleInfo info : infos) {
            if (info == null) continue;
            Long purOrgId = info.getPurOrg();
            Long reqOrgId = info.getReqOrg();
            Long materialId = info.getMaterial();
            if (purOrgId == null || reqOrgId == null || materialId == null) continue;
            StringBuilder uniqueKey = new StringBuilder();
            uniqueKey.append(purOrgId).append('&').append(reqOrgId).append('&').append(materialId);
            String key = uniqueKey.toString();
            for (DynamicObject dyn : loadFromCaches.values()) {
                if (settleOrgMap.get(key) == null && purOrgId.equals(dyn.getLong("org.id")) && reqOrgId.equals(dyn.getLong("reqorg.id")) && (dyn.get("material.masterid.id") == null || Long.valueOf(0L).equals(dyn.getLong("material.masterid.id")))) {
                    settleOrgMap.put(key, dyn.getLong("settleorg.id"));
                }
                if (!purOrgId.equals(dyn.getLong("org.id")) || !reqOrgId.equals(dyn.getLong("reqorg.id")) || !materialId.equals(dyn.getLong("material.masterid.id"))) continue;
                settleOrgMap.put(key, dyn.getLong("settleorg.id"));
                continue block1;
            }
        }
        return settleOrgMap;
    }
}

