/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;

public class VMIMutexHelper {
    private static final Log log = LogFactory.getLog(VMIMutexHelper.class);
    private static String VMI_OP = "vmioperate";
    private static String GROUP_ID = "default_netctrl";

    public static Set<Long> addDoVMIOPMutex(Map<Long, String> billIdAndNoMapping) {
        log.info("\u589e\u52a0\u7f51\u7edc\u4e92\u65a5\u5355\u636e\u4e3a\uff1a" + billIdAndNoMapping);
        HashSet<Long> addMutexSuccessIds = new HashSet<Long>(16);
        if (billIdAndNoMapping == null || billIdAndNoMapping.isEmpty()) {
            return addMutexSuccessIds;
        }
        log.info("\u589e\u52a0\u7f51\u7edc\u4e92\u65a5\u5355\u636e\u4e3a\u6570\u91cf\u4e3a\uff1a" + billIdAndNoMapping.size());
        String entityKey = "pm_transferbill";
        ArrayList mutexRequireList = new ArrayList(10);
        try (DataMutex dataMutex = DataMutex.create();){
            for (Map.Entry<Long, String> entry : billIdAndNoMapping.entrySet()) {
                Long billId = entry.getKey();
                if (billId == null || billId.compareTo(0L) == 0) continue;
                HashMap<String, Object> requireParam = new HashMap<String, Object>();
                String billNo = entry.getValue();
                requireParam.put("dataObjId", billId.toString());
                requireParam.put("dataObjNumber", billNo);
                requireParam.put("groupId", GROUP_ID);
                requireParam.put("entityKey", entityKey);
                requireParam.put("operationKey", VMI_OP);
                requireParam.put("isStrict", true);
                requireParam.put("callSource", "default");
                mutexRequireList.add(requireParam);
            }
            Map mutexResult = dataMutex.batchrequire(mutexRequireList);
            for (Map.Entry mutexItem : mutexResult.entrySet()) {
                String objId = (String)mutexItem.getKey();
                Boolean ret = (Boolean)mutexItem.getValue();
                if (!ret.booleanValue()) continue;
                addMutexSuccessIds.add(Long.parseLong(objId));
            }
        }
        catch (Exception e) {
            log.error("VMI\u6279\u91cf\u7533\u8bf7\u4e92\u65a5\u9501\u5f02\u5e38", (Throwable)e);
            VMIMutexHelper.releaseVMIOPMutex(addMutexSuccessIds);
            addMutexSuccessIds.clear();
        }
        log.info("\u589e\u52a0\u7f51\u7edc\u4e92\u65a5\u6210\u529f\u5730\u5355\u636e\u4e3a\uff1a" + addMutexSuccessIds);
        log.info("\u589e\u52a0\u7f51\u7edc\u4e92\u65a5\u6210\u529f\u5730\u5355\u636e\u6570\u91cf\u4e3a\uff1a" + addMutexSuccessIds.size());
        return addMutexSuccessIds;
    }

    public static Set<Long> releaseVMIOPMutex(Set<Long> billids) {
        log.info("\u91ca\u653e\u7f51\u7edc\u4e92\u65a5\u9501\u5f00\u59cb\uff0c" + billids);
        HashSet<Long> releaseSuccessIds = new HashSet<Long>(10);
        if (billids == null || billids.isEmpty()) {
            return releaseSuccessIds;
        }
        String entityKey = "pm_transferbill";
        try (DataMutex dataMutex = DataMutex.create();){
            ArrayList mutexRequireList = new ArrayList(1);
            for (Long billId : billids) {
                if (billId == null || billId.compareTo(0L) == 0) continue;
                HashMap<String, String> requireParam = new HashMap<String, String>();
                requireParam.put("dataObjId", billId.toString());
                requireParam.put("groupId", GROUP_ID);
                requireParam.put("entityKey", entityKey);
                requireParam.put("operationKey", VMI_OP);
                mutexRequireList.add(requireParam);
            }
            Map mutexResult = dataMutex.batchRelease(mutexRequireList);
            for (Map.Entry mutexItem : mutexResult.entrySet()) {
                String objId = (String)mutexItem.getKey();
                Boolean ret = (Boolean)mutexItem.getValue();
                if (!ret.booleanValue()) continue;
                releaseSuccessIds.add(Long.parseLong(objId));
            }
        }
        catch (Exception e) {
            log.error("VMI\u91ca\u653e\u4e92\u65a5\u9501\u5f02\u5e38\uff0c", (Throwable)e);
        }
        log.info("\u91ca\u653e\u7f51\u7edc\u4e92\u65a5\u9501\u7ed3\u675f\uff0c\u91ca\u653e\u6210\u529f\u5730\u5355\u636e\u4e3a" + releaseSuccessIds.size() + " \u8be6\u60c5\u4e3a " + releaseSuccessIds);
        return releaseSuccessIds;
    }
}

