/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.vmi.business.helper.OperateHelper;
import kd.scmc.pm.vmi.business.pojo.VMISettleRecordEntryInfo;
import kd.scmc.pm.vmi.business.pojo.VMISettleRecordInfo;
import kd.scmc.pm.vmi.business.service.settle.VMISettleReverseService;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleParam;
import kd.scmc.pm.vmi.common.enums.VMISettleResultEnum;
import kd.scmc.pm.vmi.common.utils.DateUtil;

public class VMISettleRecordHelper {
    public static List<String> paramFileList = new ArrayList<String>(Arrays.asList("qty", "baseqty", "auxqty", "istax", "price", "taxrateid", "taxrate", "priceandtax", "amountandtax"));
    public static String VMISETTLERECORD_TABLE = "t_pm_vmisrecord";
    public static final String dateTimeFormatString = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final Log log = LogFactory.getLog(VMISettleRecordHelper.class);

    public static Map<Long, VMISettleRecordInfo> buildTransferBillInfo4Record(List<DynamicObject> transferBills, VMISettleParam settleParam) {
        String settledate;
        Map<Long, VMISettleRecordInfo> recordInfoMap = new HashMap<Long, VMISettleRecordInfo>(10);
        Date settleDate = new Date();
        Map<String, String> paramMap = settleParam.getParam();
        if (paramMap != null && (settledate = paramMap.get("settledate")) != null) {
            settleDate = new Date(Long.parseLong(settledate));
        }
        long[] recordPks = DB.genLongIds((String)"t_pm_vmisrecord", (int)transferBills.size());
        long currentUserId = UserServiceHelper.getCurrentUserId();
        for (int i = 0; i < transferBills.size(); ++i) {
            DynamicObject bill = transferBills.get(i);
            String paramJson = VMISettleRecordHelper.buildSettleParam(bill, paramMap);
            Long id = (Long)bill.getPkValue();
            Long invOrgId = (Long)bill.getDynamicObject("org").getPkValue();
            Long purOrgId = (Long)bill.getDynamicObject("purorg").getPkValue();
            VMISettleRecordInfo recordInfo = new VMISettleRecordInfo(settleDate, invOrgId, purOrgId, settleParam.getSettleType().getValue(), currentUserId, paramJson);
            recordInfo.setId(recordPks[i]);
            String srcBillForm = bill.getDynamicObject("srcbillform").getPkValue().toString();
            DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
            HashMap<Long, VMISettleRecordEntryInfo> recordEntryInfos = new HashMap<Long, VMISettleRecordEntryInfo>(10);
            String billno = bill.getString("billno");
            for (int j = 0; j < billEntry.size(); ++j) {
                DynamicObject row = (DynamicObject)billEntry.get(j);
                Long material = row.getLong("material.masterid.id");
                Long supplier = (Long)row.getDynamicObject("supplier").getPkValue();
                Long entryid = row.getLong("id");
                Long unit = (Long)row.getDynamicObject("unit").getPkValue();
                Long baseunit = (Long)row.getDynamicObject("baseunit").getPkValue();
                DynamicObject auxunitDym = row.getDynamicObject("auxunit");
                Long auxunit = auxunitDym == null ? Long.valueOf(0L) : (Long)auxunitDym.getPkValue();
                Integer seq = row.getInt("seq");
                BigDecimal qty = row.getBigDecimal("qty");
                BigDecimal baseqty = row.getBigDecimal("baseqty");
                BigDecimal auxqty = row.getBigDecimal("auxqty");
                VMISettleRecordEntryInfo entryInfo = new VMISettleRecordEntryInfo(material, supplier, unit, baseunit, auxunit, "pm_transferbill", id, entryid, seq, billno, srcBillForm, qty, baseqty, auxqty);
                recordEntryInfos.put(entryid, entryInfo);
            }
            recordInfo.setEntryInfos(recordEntryInfos);
            recordInfoMap.put(id, recordInfo);
        }
        recordInfoMap = VMISettleRecordHelper.addBillNoAndLotNo(recordInfoMap);
        return recordInfoMap;
    }

    private static Map<Long, VMISettleRecordInfo> addBillNoAndLotNo(Map<Long, VMISettleRecordInfo> recordInfoMap) {
        if (CommonUtils.isNull(recordInfoMap)) {
            return recordInfoMap;
        }
        Map<Long, DynamicObject> recordDymMap = VMISettleRecordHelper.getAllRecordDym(recordInfoMap);
        if (CommonUtils.isNull(recordDymMap)) {
            return recordInfoMap;
        }
        ArrayList billIdList = new ArrayList(10);
        ArrayList recordList = new ArrayList(10);
        recordDymMap.entrySet().forEach(entry -> {
            billIdList.add(entry.getKey());
            recordList.add(entry.getValue());
        });
        List<String> billNos = new ArrayList(8);
        long[] ids = DBServiceHelper.genLongIds((String)VMISETTLERECORD_TABLE, (int)recordList.size());
        try {
            billNos = CodeRuleServiceHelper.getNumbers((String)"pm_vmisettlerecord", recordList);
            for (int i = 0; i < billNos.size(); ++i) {
                String billNo = (String)billNos.get(i);
                if (!kd.bos.util.StringUtils.isEmpty((String)billNo)) continue;
                billNos.set(i, String.valueOf(ids[i]));
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6VMI\u7ed3\u7b97\u8bb0\u5f55\u7f16\u7801\u89c4\u5219\u51fa\u9519\uff1a" + Arrays.toString(e.getStackTrace()));
            for (int i = 0; i < ids.length; ++i) {
                billNos.add(String.valueOf(ids[i]));
            }
        }
        String settleRecordLotNumber = DateUtil.formatDateHasMs(TimeServiceHelper.now());
        for (int i = 0; i < billNos.size(); ++i) {
            String billNo = (String)billNos.get(i);
            Long billId = (Long)billIdList.get(i);
            VMISettleRecordInfo recordInfo = recordInfoMap.get(billId);
            recordInfo.setBillno(billNo);
            recordInfo.setSettleLotNo(settleRecordLotNumber);
        }
        return recordInfoMap;
    }

    public static Map<Long, DynamicObject> getAllRecordDym(Map<Long, VMISettleRecordInfo> recordInfoMap) {
        HashMap<Long, DynamicObject> records = new HashMap<Long, DynamicObject>(10);
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"pm_vmisettlerecord");
        for (Map.Entry<Long, VMISettleRecordInfo> recordInfoEntry : recordInfoMap.entrySet()) {
            VMISettleRecordInfo recordInfo = recordInfoEntry.getValue();
            DynamicObject record = VMISettleRecordHelper.buildRecord2DynamicObject(recordInfo, (DynamicObjectType)type);
            records.put(recordInfoEntry.getKey(), record);
        }
        return records;
    }

    public static Map<Long, VMISettleRecordInfo> updateRecordStatusBySettle(Map<Long, String> purInBillIdAndStatusMap, Map<Long, String> invBillIdAndStatusMap, Map<Long, VMISettleRecordInfo> settleRecordInfoMap) {
        if (CommonUtils.isNull(purInBillIdAndStatusMap) && CommonUtils.isNull(invBillIdAndStatusMap) && CommonUtils.isNull(settleRecordInfoMap)) {
            return null;
        }
        for (Map.Entry<Long, VMISettleRecordInfo> recordInfoEntry : settleRecordInfoMap.entrySet()) {
            Map<Long, VMISettleRecordEntryInfo> entryInfos;
            VMISettleRecordInfo record = recordInfoEntry.getValue();
            if (CommonUtils.isNull((Object)record) || CommonUtils.isNull(entryInfos = record.getEntryInfos())) continue;
            boolean success = true;
            boolean hasVirBill = false;
            for (Map.Entry<Long, VMISettleRecordEntryInfo> entry : entryInfos.entrySet()) {
                VMISettleRecordEntryInfo recordEntryInfo = entry.getValue();
                Long purInBillId = recordEntryInfo.getPurInBillId();
                Long invBillId = recordEntryInfo.getInvBillId();
                if (purInBillId == null || purInBillId.compareTo(0L) == 0 || invBillId == null || invBillId.compareTo(0L) == 0) {
                    success = false;
                    break;
                }
                hasVirBill = true;
                String purInStatus = purInBillIdAndStatusMap.get(purInBillId);
                if (!"C".equals(purInStatus)) {
                    success = false;
                }
                recordEntryInfo.setPurInBillStatus(purInStatus);
                if (invBillId == null || invBillId.compareTo(0L) == 0) continue;
                String invStatus = invBillIdAndStatusMap.get(invBillId);
                if (!"C".equals(invStatus)) {
                    success = false;
                }
                recordEntryInfo.setInvBillStatus(invStatus);
            }
            if (!hasVirBill) {
                record.setSelttleResult(VMISettleResultEnum.WARNNING);
                continue;
            }
            if (!success) continue;
            record.setSettledetails(null);
            record.setSelttleResult(VMISettleResultEnum.SETTLESCUESS);
        }
        return settleRecordInfoMap;
    }

    public static Map<Long, VMISettleRecordInfo> addTargetBillOpFailMsg(Map<Long, VMISettleRecordInfo> records, Map<Long, String> opFialMsg, VMISettleResultEnum resultEnum) {
        if (CommonUtils.isNull(records) || CommonUtils.isNull(opFialMsg)) {
            return records;
        }
        for (Map.Entry<Long, VMISettleRecordInfo> recordEntry : records.entrySet()) {
            HashMap<Long, String> tempFailMsg = new HashMap<Long, String>(opFialMsg);
            VMISettleRecordInfo recordInfo = recordEntry.getValue();
            Map<Long, VMISettleRecordEntryInfo> entryInfos = recordInfo.getEntryInfos();
            if (CommonUtils.isNull(entryInfos)) continue;
            recordInfo.setSelttleResult(resultEnum);
            for (Map.Entry<Long, VMISettleRecordEntryInfo> entry : entryInfos.entrySet()) {
                String invErrorMsg;
                String purInErrorMsg;
                VMISettleRecordEntryInfo entryInfo = entry.getValue();
                Long purInBillId = entryInfo.getPurInBillId();
                Long invBillId = entryInfo.getInvBillId();
                if (purInBillId != null && kd.bos.util.StringUtils.isNotEmpty((String)(purInErrorMsg = tempFailMsg.get(purInBillId)))) {
                    tempFailMsg.remove(purInBillId);
                    recordInfo.addSettledetails(purInErrorMsg);
                    continue;
                }
                if (invBillId == null || !kd.bos.util.StringUtils.isNotEmpty((String)(invErrorMsg = tempFailMsg.get(invBillId)))) continue;
                tempFailMsg.remove(invBillId);
                recordInfo.addSettledetails(invErrorMsg);
            }
        }
        return records;
    }

    public static Map<Long, VMISettleRecordInfo> addExceptionMsg(Map<Long, VMISettleRecordInfo> records, Collection<Long> transferBillIds, String exceptionMsg, VMISettleResultEnum resultEnum) {
        if (CommonUtils.isNull(records) || CommonUtils.isNull(transferBillIds) || CommonUtils.isNull((Object)exceptionMsg)) {
            return records;
        }
        for (Long transferBillId : transferBillIds) {
            VMISettleRecordInfo recordInfo = records.get(transferBillId);
            recordInfo.setSelttleResult(resultEnum);
            recordInfo.addSettledetails(exceptionMsg);
        }
        return records;
    }

    public static Map<Long, VMISettleRecordInfo> convertDynamic2Info(List<DynamicObject> records, VMISettleResultEnum tarSettleSult) {
        HashMap<Long, VMISettleRecordInfo> settleNoAndRecrods = new HashMap<Long, VMISettleRecordInfo>(10);
        if (records == null || records.size() == 0) {
            return settleNoAndRecrods;
        }
        for (DynamicObject recordDym : records) {
            VMISettleRecordInfo info = new VMISettleRecordInfo();
            String lotNo = recordDym.getString("settlelotno");
            Long id = recordDym.getLong("id");
            info.setId(id);
            info.setSettleLotNo(lotNo);
            info.setSettledetails("");
            info.setSelttleResult(tarSettleSult);
            HashMap<Long, VMISettleRecordEntryInfo> entryInfos = new HashMap<Long, VMISettleRecordEntryInfo>();
            Long tranferBillId = null;
            DynamicObjectCollection billEntry = recordDym.getDynamicObjectCollection("billentry");
            for (DynamicObject rowDym : billEntry) {
                tranferBillId = rowDym.getLong("srcbillid");
                String tranferBillNo = rowDym.getString("srcbillnumber");
                String srcForm = (String)rowDym.getDynamicObject("srcbillform").getPkValue();
                Long tranferEntryId = rowDym.getLong("srcbillentryid");
                BigDecimal qty = rowDym.getBigDecimal("qty");
                BigDecimal baseQty = rowDym.getBigDecimal("baseqty");
                BigDecimal auxQty = rowDym.getBigDecimal("auxqty");
                Long invBillId = rowDym.getLong("invbillid");
                String invbillentity = rowDym.getString("invbillentity");
                String invBillNo = rowDym.getString("invbillnumber");
                int invSeq = rowDym.getInt("invbillentryseq");
                long invBillEntryID = rowDym.getLong("invbillentryid");
                String invbillStatus = rowDym.getString("invbillstatus");
                String purinentity = rowDym.getString("purinbillentity");
                Long purInBillId = rowDym.getLong("purinbillid");
                String purInBillNo = rowDym.getString("purinbillnumber");
                int purInSeq = rowDym.getInt("purinbillentryseq");
                long purInEntryId = rowDym.getLong("purinbillentryid");
                String purInBillStatus = rowDym.getString("purinbillstatus");
                VMISettleRecordEntryInfo recordEntryInfo = new VMISettleRecordEntryInfo(tranferBillId, tranferEntryId, invBillId, invbillentity, invBillEntryID, invSeq, invBillNo, invbillStatus, purInBillId, purinentity, purInEntryId, purInSeq, purInBillNo, purInBillStatus, srcForm);
                recordEntryInfo.setSrcBillId(tranferBillId);
                recordEntryInfo.setSrcBillNumber(tranferBillNo);
                recordEntryInfo.setQty(qty);
                recordEntryInfo.setBaseQty(baseQty);
                recordEntryInfo.setAuxQty(auxQty);
                entryInfos.put(tranferEntryId, recordEntryInfo);
            }
            info.setEntryInfos(entryInfos);
            settleNoAndRecrods.put(tranferBillId, info);
        }
        return settleNoAndRecrods;
    }

    public static void saveVMIRecord(Map<Long, VMISettleRecordInfo> records, boolean firstSave) {
        if (records == null || records.isEmpty()) {
            return;
        }
        if (firstSave) {
            Map<Long, DynamicObject> allRecordDym = VMISettleRecordHelper.getAllRecordDym(records);
            if (CommonUtils.isNull(allRecordDym)) {
                return;
            }
            Collection<DynamicObject> values = allRecordDym.values();
            SaveServiceHelper.saveOperate((String)"pm_vmisettlerecord", (DynamicObject[])values.toArray(new DynamicObject[0]), (OperateOption)OperateHelper.getOperateOption());
        } else {
            HashMap<Long, VMISettleRecordInfo> recordIdMap = new HashMap<Long, VMISettleRecordInfo>(10);
            records.values().forEach(recordInfo -> recordIdMap.put(recordInfo.getId(), (VMISettleRecordInfo)recordInfo));
            DynamicObject[] recordDyms = BusinessDataServiceHelper.load((String)"pm_vmisettlerecord", (String)VMISettleRecordHelper.getUpdateRecordFields(), (QFilter[])new QFilter[]{new QFilter("id", "in", recordIdMap.keySet())});
            List<DynamicObject> updateRecordDym = VMISettleRecordHelper.getAllUpdateRecordDym(recordIdMap, Arrays.asList(recordDyms));
            SaveServiceHelper.saveOperate((String)"pm_vmisettlerecord", (DynamicObject[])updateRecordDym.toArray(new DynamicObject[0]), (OperateOption)OperateHelper.getOperateOption());
        }
    }

    public static void updateVMIRecord(Map<Long, VMISettleRecordInfo> records) {
        if (records == null || records.isEmpty()) {
            return;
        }
        HashMap<Long, VMISettleRecordInfo> recordIdMap = new HashMap<Long, VMISettleRecordInfo>(10);
        records.values().forEach(recordInfo -> recordIdMap.put(recordInfo.getId(), (VMISettleRecordInfo)recordInfo));
        DynamicObject[] recordDyms = BusinessDataServiceHelper.load((String)"pm_vmisettlerecord", (String)VMISettleRecordHelper.getUpdateRecordFields(), (QFilter[])new QFilter[]{new QFilter("id", "in", recordIdMap.keySet())});
        List<DynamicObject> updateRecordDym = VMISettleRecordHelper.getAllUpdateRecordDym(recordIdMap, Arrays.asList(recordDyms));
        if (CommonUtils.isNull(updateRecordDym)) {
            return;
        }
        SaveServiceHelper.update((DynamicObject[])updateRecordDym.toArray(new DynamicObject[0]));
    }

    private static String getUpdateRecordFields() {
        return "settleresult,settledetail,settledetail_tag,billentry,billentry.srcbillentryid,billentry.srcbillid,billentry.purinbillstatus,billentry.purinbillentity,billentry.purinbillid,billentry.purinbillnumber,billentry.purinbillentryid,billentry.purinbillentryseq,billentry.invbillstatus,billentry.invbillentity,billentry.invbillid,billentry.invbillnumber,billentry.invbillentryid,billentry.invbillentryseq";
    }

    private static List<DynamicObject> getAllUpdateRecordDym(Map<Long, VMISettleRecordInfo> settleRecordInfoMap, List<DynamicObject> recordList) {
        ArrayList<DynamicObject> updateRecordList = new ArrayList<DynamicObject>(10);
        if (CommonUtils.isNull(settleRecordInfoMap) || CommonUtils.isNull(recordList)) {
            return updateRecordList;
        }
        for (DynamicObject recordDym : recordList) {
            Object pkValue = recordDym.getPkValue();
            VMISettleRecordInfo recordInfo = settleRecordInfoMap.get(pkValue);
            if (CommonUtils.isNull((Object)recordInfo)) continue;
            DynamicObjectCollection billEntry = recordDym.getDynamicObjectCollection("billentry");
            String settledetails = recordInfo.getSettledetails();
            recordDym.set("settleresult", (Object)recordInfo.getSelttleResult());
            recordDym.set("settledetail_tag", (Object)settledetails);
            recordDym.set("settledetail", (Object)VMISettleRecordHelper.getShortMsg(settledetails));
            Map<Long, VMISettleRecordEntryInfo> entryInfos = recordInfo.getEntryInfos();
            for (DynamicObject row : billEntry) {
                Long transferBillEntryId = row.getLong("srcbillentryid");
                VMISettleRecordEntryInfo recordEntryInfo = entryInfos.get(transferBillEntryId);
                row.set("purinbillstatus", (Object)recordEntryInfo.getPurInBillStatus());
                row.set("purinbillid", (Object)recordEntryInfo.getPurInBillId());
                row.set("purinbillentity", (Object)recordEntryInfo.getPurInBillEntity());
                row.set("purinbillentryid", (Object)recordEntryInfo.getPurInBillEntryId());
                row.set("purinbillentryseq", (Object)recordEntryInfo.getPurInBillEntrySeq());
                row.set("purinbillnumber", (Object)recordEntryInfo.getPurInBillNumber());
                row.set("invbillstatus", (Object)recordEntryInfo.getInvBillStatus());
                row.set("invbillid", (Object)recordEntryInfo.getInvBillId());
                row.set("invbillentity", (Object)recordEntryInfo.getInvBillEntity());
                row.set("invbillentryid", (Object)recordEntryInfo.getInvBillEntryId());
                row.set("invbillentryseq", (Object)recordEntryInfo.getInvBillEntrySeq());
                row.set("invbillnumber", (Object)recordEntryInfo.getInvBillNumber());
            }
            updateRecordList.add(recordDym);
        }
        return updateRecordList;
    }

    private static DynamicObject buildRecord2DynamicObject(VMISettleRecordInfo recordInfo, DynamicObjectType type) {
        DynamicObject record = new DynamicObject(type);
        Long id = recordInfo.getId();
        if (id != null) {
            record.set("id", (Object)id);
        }
        record.set("org_id", (Object)recordInfo.getPurOrdId());
        record.set("recorg_id", (Object)recordInfo.getRecOrgId());
        record.set("billno", (Object)recordInfo.getBillno());
        record.set("settlelotno", (Object)recordInfo.getSettleLotNo());
        record.set("settledate", (Object)recordInfo.getSettleDate());
        record.set("settlementman_id", (Object)recordInfo.getSettlementMan());
        record.set("settletype", (Object)recordInfo.getSettleType());
        record.set("settleresult", (Object)recordInfo.getSelttleResult());
        record.set("settleparam_tag", (Object)recordInfo.getSettlePram());
        record.set("settleparam", (Object)VMISettleRecordHelper.getShortMsg(recordInfo.getSettlePram()));
        String settledetails = recordInfo.getSettledetails();
        record.set("settledetail_tag", (Object)settledetails);
        record.set("settledetail", (Object)VMISettleRecordHelper.getShortMsg(settledetails));
        record.set("creator_id", (Object)UserServiceHelper.getCurrentUserId());
        record.set("createtime", (Object)TimeServiceHelper.now());
        Map<Long, VMISettleRecordEntryInfo> entryInfos = recordInfo.getEntryInfos();
        DynamicObjectCollection billEntry = record.getDynamicObjectCollection("billentry");
        for (Map.Entry<Long, VMISettleRecordEntryInfo> entry : entryInfos.entrySet()) {
            VMISettleRecordEntryInfo entryInfo = entry.getValue();
            DynamicObject row = billEntry.addNew();
            row.set("material", (Object)entryInfo.getMaterial());
            row.set("supplier", (Object)entryInfo.getSupplier());
            row.set("qty", (Object)entryInfo.getQty());
            row.set("baseqty", (Object)entryInfo.getBaseQty());
            row.set("auxqty", (Object)entryInfo.getAuxQty());
            row.set("unit", (Object)entryInfo.getUnit());
            row.set("baseunit", (Object)entryInfo.getBaseUnit());
            row.set("auxunit", (Object)entryInfo.getAuxUnit());
            row.set("srcbillentity", (Object)entryInfo.getSrcBillEntity());
            row.set("srcbillentryid", (Object)entryInfo.getSrcBillEntryId());
            row.set("srcbillentryseq", (Object)entryInfo.getSrcBillEntrySeq());
            row.set("srcbillid", (Object)entryInfo.getSrcBillId());
            row.set("srcbillnumber", (Object)entryInfo.getSrcBillNumber());
            row.set("invbillentity", (Object)entryInfo.getInvBillEntity());
            row.set("invbillentryid", (Object)entryInfo.getInvBillEntryId());
            row.set("invbillentryseq", (Object)entryInfo.getInvBillEntrySeq());
            row.set("invbillid", (Object)entryInfo.getInvBillId());
            row.set("invbillnumber", (Object)entryInfo.getInvBillNumber());
            row.set("invbillstatus", (Object)entryInfo.getInvBillStatus());
            row.set("purinbillentity", (Object)entryInfo.getPurInBillEntity());
            row.set("purinbillentryid", (Object)entryInfo.getPurInBillEntryId());
            row.set("purinbillentryseq", (Object)entryInfo.getPurInBillEntrySeq());
            row.set("purinbillid", (Object)entryInfo.getPurInBillId());
            row.set("purinbillnumber", (Object)entryInfo.getPurInBillNumber());
            row.set("purinbillstatus", (Object)entryInfo.getPurInBillStatus());
            row.set("srcbillform", (Object)entryInfo.getSrcBillForm());
        }
        return record;
    }

    private static String getShortMsg(String largeMsg) {
        if (CommonUtils.isNull((Object)largeMsg)) {
            return "";
        }
        return largeMsg.length() > 512 ? largeMsg.substring(0, 512) : largeMsg;
    }

    protected static String buildSettleParam(DynamicObject bill, Map<String, String> param) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(10);
        DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
        if (param != null) {
            HashMap currentParam = new HashMap();
            String entryinfo = param.get("entryinfo");
            Map entryInfoMap = (Map)SerializationUtils.fromJsonString((String)entryinfo, HashMap.class);
            for (DynamicObject row : billEntry) {
                Long pkValue = (Long)row.getPkValue();
                Object oneRowInfo = entryInfoMap.get(String.valueOf(pkValue));
                currentParam.put(pkValue, oneRowInfo);
            }
            paramMap.put("settledate", param.get("settledate"));
            paramMap.put("entryinfo", currentParam);
        } else {
            Map<Long, Map<String, Object>> map = VMISettleRecordHelper.buildCurrenctSettleParam(billEntry);
            paramMap.put("entryinfo", map);
        }
        return SerializationUtils.toJsonString(paramMap);
    }

    protected static Map<Long, Map<String, Object>> buildCurrenctSettleParam(DynamicObjectCollection billEntry) {
        HashMap<Long, Map<String, Object>> param = new HashMap<Long, Map<String, Object>>(16);
        for (DynamicObject oneRow : billEntry) {
            Long entryId = (Long)oneRow.getPkValue();
            HashMap<String, Object> para = new HashMap<String, Object>(16);
            for (String field : paramFileList) {
                Object value = oneRow.get(field);
                if (value == null) {
                    value = 0L;
                } else if (value instanceof DynamicObject) {
                    value = ((DynamicObject)value).getPkValue();
                }
                para.put(field, value);
            }
            param.put(entryId, para);
        }
        return param;
    }

    public static void setFieldList4Param(List<String> fieldList) {
        paramFileList = fieldList;
    }

    public static Map<String, HashSet<Long>> buildEntityAndVBillIds(List<VMISettleRecordInfo> recordInfoList) {
        HashMap<String, HashSet<Long>> map = new HashMap<String, HashSet<Long>>(16);
        for (VMISettleRecordInfo record : recordInfoList) {
            String settlelotno = record.getSettleLotNo();
            if (!StringUtils.isNotBlank((CharSequence)settlelotno)) continue;
            Map<Long, VMISettleRecordEntryInfo> entryInfos = record.getEntryInfos();
            for (Map.Entry<Long, VMISettleRecordEntryInfo> entry : entryInfos.entrySet()) {
                VMISettleRecordEntryInfo row = entry.getValue();
                Long purinbillid = row.getPurInBillId();
                Long invbillid = row.getInvBillId();
                String invBillEntity = row.getInvBillEntity();
                String purInBillentity = row.getPurInBillEntity();
                HashSet<Long> purinbillids = (HashSet<Long>)map.get(purInBillentity);
                HashSet<Long> invbillids = (HashSet<Long>)map.get(invBillEntity);
                if (purinbillids == null) {
                    purinbillids = new HashSet<Long>(16);
                }
                if (invbillids == null) {
                    invbillids = new HashSet<Long>(16);
                }
                if (purinbillid != null && !purinbillid.equals(0L)) {
                    purinbillids.add(purinbillid);
                }
                if (invbillid != null && !invbillid.equals(0L)) {
                    invbillids.add(invbillid);
                }
                map.put(purInBillentity, purinbillids);
                map.put(invBillEntity, invbillids);
            }
        }
        return map;
    }

    public static Map<String, ArrayList<Long>> groupBySettle(DynamicObject[] records) {
        HashMap<String, ArrayList<Long>> result = new HashMap<String, ArrayList<Long>>(10);
        for (int i = 0; i < records.length; ++i) {
            DynamicObject record = records[i];
            String lotNo = record.getString("settlelotno");
            ArrayList<Long> recordList = (ArrayList<Long>)result.get(lotNo);
            if (recordList == null) {
                recordList = new ArrayList<Long>(10);
            }
            recordList.add((Long)record.getPkValue());
            result.put(lotNo, recordList);
        }
        return result;
    }

    public static Map<Long, VMISettleRecordInfo> updateRecordVirBillStatus(Map<Long, VMISettleRecordInfo> settleRecordInfoMap) {
        if (CommonUtils.isNull(settleRecordInfoMap)) {
            return settleRecordInfoMap;
        }
        ArrayList<VMISettleRecordInfo> list = new ArrayList<VMISettleRecordInfo>(settleRecordInfoMap.values());
        Map<String, HashSet<Long>> buildEntityAndVBillIds = VMISettleRecordHelper.buildEntityAndVBillIds(list);
        for (Map.Entry<String, HashSet<Long>> bill : buildEntityAndVBillIds.entrySet()) {
            String key = bill.getKey();
            HashSet<Long> billIds = bill.getValue();
            if (kd.bos.util.StringUtils.isEmpty((String)key) || CommonUtils.isNull(billIds)) continue;
            DynamicObjectCollection vBillStatusCol = QueryServiceHelper.query((String)key, (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
            HashMap vBillStatusMap = new HashMap(5);
            vBillStatusCol.forEach(billDB -> vBillStatusMap.put(billDB.getLong("id"), billDB.getString("billstatus")));
            for (VMISettleRecordInfo record : settleRecordInfoMap.values()) {
                String settlelotno = record.getSettleLotNo();
                if (!StringUtils.isNotBlank((CharSequence)settlelotno)) continue;
                Map<Long, VMISettleRecordEntryInfo> entryInfos = record.getEntryInfos();
                for (Map.Entry<Long, VMISettleRecordEntryInfo> entry : entryInfos.entrySet()) {
                    VMISettleRecordEntryInfo row = entry.getValue();
                    String invBillEntity = row.getInvBillEntity();
                    String purInBillentity = row.getPurInBillEntity();
                    Long purinbillid = row.getPurInBillId();
                    Long invbillid = row.getInvBillId();
                    if ((purinbillid == null || purinbillid.compareTo(0L) == 0) && (invbillid == null || invbillid.compareTo(0L) == 0)) continue;
                    if (kd.bos.util.StringUtils.isNotEmpty((String)invBillEntity) && kd.bos.util.StringUtils.isNotEmpty((String)key) && invBillEntity.equals(key)) {
                        String invBillStatus = (String)vBillStatusMap.get(invbillid);
                        if (CommonUtils.isNull((Object)invBillStatus)) {
                            row.clearInvInfo();
                        } else {
                            row.setInvBillStatus(invBillStatus);
                        }
                    }
                    if (!kd.bos.util.StringUtils.isNotEmpty((String)purInBillentity) || !kd.bos.util.StringUtils.isNotEmpty((String)key) || !purInBillentity.equals(key)) continue;
                    String purInBillStatus = (String)vBillStatusMap.get(purinbillid);
                    if (CommonUtils.isNull((Object)purInBillStatus)) {
                        row.clearPurInInfo();
                        continue;
                    }
                    row.setPurInBillStatus(purInBillStatus);
                }
            }
        }
        return settleRecordInfoMap;
    }

    public static DataSet queryTransferBillAndRecord(String[] settleLotNos, QFilter settleResultFilter) {
        ArrayList<QFilter> fitlers = new ArrayList<QFilter>(10);
        fitlers.add(new QFilter("settlelotno", "in", (Object)settleLotNos));
        if (settleResultFilter != null) {
            fitlers.add(settleResultFilter);
        }
        DataSet record = QueryServiceHelper.queryDataSet((String)VMISettleReverseService.class.getName(), (String)"pm_vmisettlerecord", (String)"id as recordid,settlelotno,billentry.srcbillid as transferbillid", (QFilter[])fitlers.toArray(new QFilter[0]), null);
        DataSet recordDataSet = record.groupBy(new String[]{"transferbillid", "settlelotno", "recordid"}).finish().select(new String[]{"transferbillid", "settlelotno", "recordid"});
        QFilter innerDealFilter = new QFilter("isintertransaction", "=", (Object)Boolean.TRUE);
        DataSet trnasferBillDataSet = QueryServiceHelper.queryDataSet((String)VMISettleReverseService.class.getName(), (String)"pm_transferbill", (String)"id as transferbillid,isintertransaction", (QFilter[])new QFilter[]{innerDealFilter}, null);
        DataSet finish = recordDataSet.leftJoin(trnasferBillDataSet).on("transferbillid", "transferbillid").select(new String[]{"transferbillid", "settlelotno", "recordid"}, new String[]{"isintertransaction"}).finish();
        return finish;
    }
}

