/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.service.settle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.vmi.business.helper.BotpHelper;
import kd.scmc.pm.vmi.business.helper.OperateHelper;
import kd.scmc.pm.vmi.business.helper.VMISettleLogHelper;
import kd.scmc.pm.vmi.business.helper.VMISettleModelHelper;
import kd.scmc.pm.vmi.business.helper.VMISettleRecordHelper;
import kd.scmc.pm.vmi.business.pojo.GenerateTargetResult;
import kd.scmc.pm.vmi.business.pojo.VMISettleModelInfo;
import kd.scmc.pm.vmi.business.pojo.VMISettleRecordEntryInfo;
import kd.scmc.pm.vmi.business.pojo.VMISettleRecordInfo;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMIRecordPurInInfo;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleLogInfo;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleParam;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleResult;
import kd.scmc.pm.vmi.common.enums.VMISettleOpEnum;
import kd.scmc.pm.vmi.common.enums.VMISettleResultEnum;
import kd.scmc.pm.vmi.common.enums.VMISettleTypeEnum;

public class VMIInnerDealService {
    List<DynamicObject> settleBills;
    VMISettleParam settleParam;
    private VMISettleLogInfo settleLogInfo;
    private static String ENTITY_MATERIALREQOUTBILL = "im_materialreqoutbill";
    private static String ENTITY_PURINBILL = "im_purinbill";
    private Map<Long, Long> transferEntryIdAndBillIdMap;
    private Map<Long, VMISettleRecordInfo> settleRecordInfoMap;
    HashSet<Object> purInBillIds = new HashSet(8);
    List<DynamicObject> purInBillList = new ArrayList<DynamicObject>(8);
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private Map<String, List<Long>> innerDealRecordIds;
    private static final Log log = LogFactory.getLog(VMIInnerDealService.class);
    private VMISettleResult result = new VMISettleResult();
    private static List<String> fieldList = new ArrayList<String>();

    public VMIInnerDealService(List<DynamicObject> settleBills, VMISettleParam settleParam) {
        this.settleBills = settleBills;
        this.settleParam = settleParam;
    }

    public static VMISettleResult innerDealSettle(List<DynamicObject> settleBills, VMISettleParam settleParam) {
        VMIInnerDealService service = new VMIInnerDealService(settleBills, settleParam);
        return service.VMISettle();
    }

    private VMISettleResult VMISettle() {
        VMISettleTypeEnum settleType = this.settleParam.getSettleType();
        this.settleBills = this.beforeDoSettle(this.settleBills, settleType);
        return this.settle(this.settleBills, this.settleParam);
    }

    private VMISettleResult settle(List<DynamicObject> settleBills, VMISettleParam settleParam) {
        this.settleLogInfo = VMISettleLogHelper.buildLogInfoBySettleParam(settleParam, VMISettleOpEnum.SETTLE);
        VMISettleLogHelper.addTransferBillInfo(this.settleLogInfo, settleBills.toArray(new DynamicObject[0]));
        Map<String, VMISettleModelInfo> settleModelInfoMap = this.getSettleModelFromSettleBills(settleBills);
        log.info("vmiSettle\u65b9\u6cd5 \u83b7\u53d6\u7684\u7ed3\u7b97\u6a21\u578b\u7684\u4fe1\u606f\u4e3a\uff1a" + settleModelInfoMap);
        Map<String, List<DynamicObject>> groupBySrcBillEntity = this.groupBySrcEntity(settleBills);
        this.result = this.doSettle(settleModelInfoMap, groupBySrcBillEntity, settleParam);
        if (!this.result.isSuccess()) {
            this.settleLogInfo.addSettleLogTag(this.result.getSettleFailBillNoAndMsgs().toString());
            this.settleLogInfo.setSettleResult(VMISettleResultEnum.SETTLEFAIL.getValue());
        } else {
            this.settleLogInfo.setSettleResult(VMISettleResultEnum.SETTLESCUESS.getValue());
        }
        VMISettleLogHelper.save(Collections.singletonList(this.settleLogInfo));
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VMISettleResult doSettle(Map<String, VMISettleModelInfo> settleModelInfoMap, Map<String, List<DynamicObject>> groupBySrcBillEntity, VMISettleParam settleParam) {
        String checkSettleModelErrMsg = this.checkSettleModel(groupBySrcBillEntity, settleModelInfoMap);
        if (!CommonUtils.isNull((Object)checkSettleModelErrMsg)) {
            this.settleLogInfo.addSettleLogTag(checkSettleModelErrMsg);
            VMISettleLogHelper.save(Collections.singletonList(this.settleLogInfo));
            this.result.setSuccess(false);
            this.result.setMessage(checkSettleModelErrMsg);
            return this.result;
        }
        this.transferEntryIdAndBillIdMap = this.getSettleTransferEntryIdAndBillIdMap(this.settleBills);
        this.settleRecordInfoMap = VMISettleRecordHelper.buildTransferBillInfo4Record(this.settleBills, settleParam);
        VMISettleModelInfo vmiSettleModelInfo = null;
        if (settleModelInfoMap != null && !settleModelInfoMap.isEmpty()) {
            for (VMISettleModelInfo info : settleModelInfoMap.values()) {
                if (info == null) continue;
                vmiSettleModelInfo = info;
                break;
            }
        }
        if (vmiSettleModelInfo == null || kd.bos.util.StringUtils.isEmpty((String)vmiSettleModelInfo.getToPurInBillRuleID())) {
            String errorMsg = ResManager.loadKDString((String)"VMI\u7ed3\u7b97\u6a21\u578b\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u8fdb\u884c\u7ed3\u7b97\u3002", (String)"VMIInnerDealService_0", (String)"scmc-pm-vmi", (Object[])new Object[0]);
            log.error("\u5185\u90e8\u4ea4\u6613 " + errorMsg);
            VMISettleRecordHelper.addExceptionMsg(this.settleRecordInfoMap, settleParam.getTransferEntryIdAndBillIdMap().values(), errorMsg, VMISettleResultEnum.SETTLEFAIL);
            this.settleLogInfo.addSettleLogTag(errorMsg);
            this.result.setSuccess(false);
            this.result.setMessage(errorMsg);
            return this.result;
        }
        String toPurInBillRuleID = vmiSettleModelInfo.getToPurInBillRuleID();
        try {
            this.filterHasQtyAndAmountInfo(this.settleBills);
            this.generatePurInBill(toPurInBillRuleID, settleParam.getParam());
            this.addRecordInfo();
            this.doPurInBillOperate();
            this.updateRecordInfo();
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u5185\u90e8\u4ea4\u6613\u7ed3\u7b97\u51fa\u9519\uff1a %1$s\u3002", (String)"VMIInnerDealService_12", (String)"scmc-pm-vmi", (Object[])new Object[0]), Arrays.toString(e.getStackTrace()));
            log.error(msg);
            VMISettleRecordHelper.addExceptionMsg(this.settleRecordInfoMap, this.transferEntryIdAndBillIdMap.values(), msg, VMISettleResultEnum.SETTLEFAIL);
        }
        finally {
            VMISettleRecordHelper.saveVMIRecord(this.settleRecordInfoMap, true);
        }
        return this.buildSettleResult(this.settleRecordInfoMap);
    }

    private void filterHasQtyAndAmountInfo(List<DynamicObject> settleBills) {
        if (CommonUtils.isNull(settleBills) || CommonUtils.isNull(this.transferEntryIdAndBillIdMap)) {
            return;
        }
        Iterator<DynamicObject> iterator = new ArrayList<DynamicObject>(settleBills).iterator();
        ArrayList<Long> hasNoAmountInfoBillIdList = new ArrayList<Long>();
        block0: while (iterator.hasNext()) {
            DynamicObject bill = iterator.next();
            Long billId = (Long)bill.getPkValue();
            DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
            for (int i = 0; i < billEntrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)billEntrys.get(i);
                BigDecimal price = entry.getBigDecimal("price");
                BigDecimal priceAndTax = entry.getBigDecimal("priceandtax");
                BigDecimal amountAndTax = entry.getBigDecimal("amountandtax");
                if (price != null && priceAndTax != null && amountAndTax != null && price.compareTo(ZERO) != 0 && priceAndTax.compareTo(ZERO) != 0 && amountAndTax.compareTo(ZERO) != 0) continue;
                hasNoAmountInfoBillIdList.add(billId);
                iterator.remove();
                continue block0;
            }
        }
        if (hasNoAmountInfoBillIdList.isEmpty()) {
            return;
        }
        this.transferEntryIdAndBillIdMap.values().removeAll(hasNoAmountInfoBillIdList);
        for (Long hasNoAmountInfoBillId : hasNoAmountInfoBillIdList) {
            VMISettleRecordInfo recordInfo = this.settleRecordInfoMap.get(hasNoAmountInfoBillId);
            recordInfo.setSettleSuccess(false);
            recordInfo.setSettledetails(ResManager.loadKDString((String)"\u4ef7\u683c\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u7ed3\u7b97\u3002", (String)"VMIInnerDealService_1", (String)"scmc-pm-vmi", (Object[])new Object[0]));
        }
    }

    private void updateRecordInfo() {
        Map<String, HashSet<Long>> entityAndBillIds = VMISettleRecordHelper.buildEntityAndVBillIds(new ArrayList<VMISettleRecordInfo>(this.settleRecordInfoMap.values()));
        log.info("\u66f4\u65b0\u7ed3\u7b97\u8bb0\u5f55 \u7ed3\u7b97\u865a\u5355\u4fe1\u606f\uff1a" + entityAndBillIds);
        HashSet<Long> purInBillIds = entityAndBillIds.get(ENTITY_PURINBILL);
        log.info("\u66f4\u65b0\u7ed3\u7b97\u8bb0\u5f55 \u5165\u5e93\u865a\u5355ID\u4fe1\u606f\uff1a" + purInBillIds);
        Map<Long, String> purInBillIdAndStatusMap = this.queryBillStatus(ENTITY_PURINBILL, purInBillIds);
        log.info("\u66f4\u65b0\u7ed3\u7b97\u8bb0\u5f55 \u5165\u5e93\u5355\u5355\u636e\u72b6\u6001\uff1a" + purInBillIdAndStatusMap);
        this.settleRecordInfoMap = this.updateRecordStatusBySettle(purInBillIdAndStatusMap, new HashMap<Long, String>(10), this.settleRecordInfoMap);
        log.info("\u66f4\u65b0\u7ed3\u7b97\u8bb0\u5f55 \u7ed3\u675f\uff1a" + this.settleRecordInfoMap);
    }

    private Map<Long, VMISettleRecordInfo> updateRecordStatusBySettle(Map<Long, String> purInBillIdAndStatusMap, Map<Long, String> invBillIdAndStatusMap, Map<Long, VMISettleRecordInfo> settleRecordInfoMap) {
        if (CommonUtils.isNull(purInBillIdAndStatusMap) && CommonUtils.isNull(invBillIdAndStatusMap) && CommonUtils.isNull(settleRecordInfoMap)) {
            return null;
        }
        for (Map.Entry<Long, VMISettleRecordInfo> recordInfoEntry : settleRecordInfoMap.entrySet()) {
            Map<Long, VMISettleRecordEntryInfo> entryInfos;
            VMISettleRecordInfo record = recordInfoEntry.getValue();
            if (CommonUtils.isNull((Object)record) || CommonUtils.isNull(entryInfos = record.getEntryInfos())) continue;
            boolean success = true;
            for (Map.Entry<Long, VMISettleRecordEntryInfo> entry : entryInfos.entrySet()) {
                VMISettleRecordEntryInfo recordEntryInfo = entry.getValue();
                Long purInBillId = recordEntryInfo.getPurInBillId();
                Long invBillId = recordEntryInfo.getInvBillId();
                if (purInBillId == null || purInBillId.compareTo(0L) == 0) {
                    success = false;
                    break;
                }
                String purInStatus = purInBillIdAndStatusMap.get(purInBillId);
                if (!"C".equals(purInStatus)) {
                    success = false;
                }
                recordEntryInfo.setPurInBillStatus(purInStatus);
                if (invBillId == null || invBillId.compareTo(0L) == 0) continue;
                String invStatus = invBillIdAndStatusMap.get(invBillId);
                if (!"C".equals(invStatus)) {
                    success = false;
                }
                recordEntryInfo.setInvBillStatus(invStatus);
            }
            if (!success) continue;
            record.setSettledetails(null);
            record.setSelttleResult(VMISettleResultEnum.SETTLESCUESS);
        }
        return settleRecordInfoMap;
    }

    private Map<Long, String> queryBillStatus(String tarBillEntity, Collection<Long> billIDs) {
        HashMap<Long, String> billStatusMap = new HashMap<Long, String>(10);
        if (CommonUtils.isNull(billIDs)) {
            return billStatusMap;
        }
        DynamicObjectCollection billStatusDB = QueryServiceHelper.query((String)tarBillEntity, (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", billIDs)});
        for (DynamicObject bill : billStatusDB) {
            billStatusMap.put((Long)bill.get("id"), bill.getString("billstatus"));
        }
        return billStatusMap;
    }

    private void doPurInBillOperate() {
        String exceptionMsg;
        if (CommonUtils.isNull(this.purInBillIds)) {
            return;
        }
        DynamicObject[] purInBills = BusinessDataServiceHelper.load((String)ENTITY_PURINBILL, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", this.purInBillIds)});
        this.purInBillList = new ArrayList<DynamicObject>(Arrays.asList(purInBills));
        List innerDealSubmitSuccess = new ArrayList(10);
        Collection<Long> transferBillIds = this.transferEntryIdAndBillIdMap.values();
        try {
            OperationResult purInSubmitOpR = OperateHelper.invokeBillOp("submit", ENTITY_PURINBILL, this.purInBillIds.toArray());
            if (!purInSubmitOpR.isSuccess()) {
                VMISettleRecordHelper.addTargetBillOpFailMsg(this.settleRecordInfoMap, OperateHelper.handleFailInfo("submit", purInSubmitOpR, this.purInBillList), VMISettleResultEnum.SETTLEFAIL);
            }
            innerDealSubmitSuccess = purInSubmitOpR.getSuccessPkIds();
            log.info("\u5185\u90e8\u4ea4\u6613 \u5165\u5e93\u5355\u63d0\u4ea4\u6210\u529f\u5730ID\u4e3a\uff1a" + innerDealSubmitSuccess);
            if (innerDealSubmitSuccess.isEmpty()) {
                this.purInBillIds.clear();
            }
            for (Object id : innerDealSubmitSuccess) {
                if (this.purInBillIds.contains(id)) continue;
                this.purInBillIds.add(id);
            }
        }
        catch (Exception e) {
            exceptionMsg = e.toString().concat(Arrays.toString(e.getStackTrace()));
            log.error("\u5185\u90e8\u4ea4\u6613 \u5165\u5e93\u63d0\u4ea4 or \u5ba1\u6838 \u51fa\u9519" + exceptionMsg);
            this.purInBillIds.clear();
            VMISettleRecordHelper.addExceptionMsg(this.settleRecordInfoMap, transferBillIds, exceptionMsg, VMISettleResultEnum.SETTLEFAIL);
        }
        if (CommonUtils.isNull(this.purInBillIds)) {
            return;
        }
        try {
            OperationResult purInAuditOpR = OperateHelper.invokeBillOp("audit", ENTITY_PURINBILL, this.purInBillIds.toArray());
            if (!purInAuditOpR.isSuccess()) {
                Map<Long, String> auditFialMsg = OperateHelper.handleFailInfo("audit", purInAuditOpR, this.purInBillList);
                VMISettleRecordHelper.addTargetBillOpFailMsg(this.settleRecordInfoMap, auditFialMsg, VMISettleResultEnum.SETTLEFAIL);
            }
            log.info("\u5185\u90e8\u4ea4\u6613 \u5165\u5e93\u5355\u5ba1\u6838\u6210\u529f\u5730ID\u4e3a\uff1a" + purInAuditOpR.getSuccessPkIds());
        }
        catch (Exception e) {
            exceptionMsg = e.toString().concat(Arrays.toString(e.getStackTrace()));
            log.error("\u5185\u90e8\u4ea4\u6613 \u5165\u5e93\u63d0\u4ea4 or \u5ba1\u6838 \u51fa\u9519" + exceptionMsg);
            VMISettleRecordHelper.addExceptionMsg(this.settleRecordInfoMap, transferBillIds, exceptionMsg, VMISettleResultEnum.SETTLEFAIL);
        }
    }

    private void addRecordInfo() {
        if (CommonUtils.isNull(this.purInBillIds) || CommonUtils.isNull(this.transferEntryIdAndBillIdMap)) {
            return;
        }
        log.info("\u67e5\u8be2\u865a\u5355\u94fe\u8def\u4fe1\u606f \u5f00\u59cb\uff1a" + System.currentTimeMillis());
        List targetRowIds = BFTrackerServiceHelper.loadTargetRowIds((String)"pm_transferbill", (String)"billentry", (Long[])this.transferEntryIdAndBillIdMap.values().toArray(new Long[0]), (Long[])this.transferEntryIdAndBillIdMap.keySet().toArray(new Long[0]), (OperateOption)OperateHelper.getBFTrackerOperateOption());
        log.info("\u67e5\u8be2\u865a\u5355\u94fe\u8def\u4fe1\u606f \u7ed3\u675f\uff1a" + System.currentTimeMillis());
        TableDefine purInTableDefine = ConvertMetaServiceHelper.loadTableDefine((String)ENTITY_PURINBILL, (String)"billentry");
        Map<Long, Long> TFRowIDAndPInRowID = this.getTFRowIdANdTargetRowId(targetRowIds, purInTableDefine.getTableId(), this.purInBillIds);
        this.addPurInBillInfo(this.transferEntryIdAndBillIdMap, TFRowIDAndPInRowID);
    }

    private Map<Long, Long> getTFRowIdANdTargetRowId(List<BFRow> targetRowIds, Long targetTableID, HashSet<Object> targetBillIDs) {
        HashMap<Long, Long> tFRowIDAndTargetRowID = new HashMap<Long, Long>(targetRowIds.size());
        for (BFRow bfRow : targetRowIds) {
            BFRowId sId = bfRow.getSId();
            BFRowId id = bfRow.getId();
            Long tableId = id.getTableId();
            Long sEntryId = sId.getEntryId();
            Long tEntryId = id.getEntryId();
            Long tbillId = id.getBillId();
            if (!targetTableID.equals(tableId) || !targetBillIDs.contains(tbillId)) continue;
            tFRowIDAndTargetRowID.put(sEntryId, tEntryId);
        }
        return tFRowIDAndTargetRowID;
    }

    private void generatePurInBill(String toPurInBillRuleID, Map<String, String> param) {
        GenerateTargetResult genPurInAndSaveOpResult;
        Throwable throwable;
        TraceSpan span;
        block17: {
            block18: {
                block19: {
                    span = Tracer.create((String)this.getClass().getName(), (String)"doInnderSettle");
                    throwable = null;
                    genPurInAndSaveOpResult = BotpHelper.pushAndSaveTargetBill("pm_transferbill", ENTITY_PURINBILL, "billentry", toPurInBillRuleID, this.transferEntryIdAndBillIdMap, param);
                    log.info("\u5165\u5e93\u5355\u4e0b\u63a8\u5e76\u4fdd\u5b58\u7ed3\u679c\uff1a" + genPurInAndSaveOpResult);
                    if (genPurInAndSaveOpResult.isSuccess()) break block17;
                    this.handleFailGenResult(genPurInAndSaveOpResult, this.transferEntryIdAndBillIdMap.values());
                    if (span == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        span.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                span.close();
            }
            return;
        }
        try {
            try {
                this.purInBillIds.addAll(genPurInAndSaveOpResult.getSaveSuccessTarIds());
            }
            catch (Exception e) {
                String errorMsg = Arrays.toString(e.getStackTrace());
                VMISettleRecordHelper.addExceptionMsg(this.settleRecordInfoMap, this.transferEntryIdAndBillIdMap.values(), errorMsg, VMISettleResultEnum.SETTLEFAIL);
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (span != null) {
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    span.close();
                }
            }
        }
    }

    private VMISettleResult buildSettleResult(Map<Long, VMISettleRecordInfo> settleRecordInfoMap) {
        VMISettleResult result = new VMISettleResult();
        ArrayList<Long> settleFailId = new ArrayList<Long>(10);
        ArrayList<Long> successId = new ArrayList<Long>(10);
        ArrayList<Object> recordIds = new ArrayList<Object>(10);
        HashMap<Long, String> failIdAndErrorMsg = new HashMap<Long, String>(10);
        HashMap<String, String> failBillNoAndErrorMsg = new HashMap<String, String>(10);
        boolean success = true;
        for (Map.Entry<Long, VMISettleRecordInfo> entry : settleRecordInfoMap.entrySet()) {
            Long billId = entry.getKey();
            VMISettleRecordInfo recordInfo = entry.getValue();
            if (!VMISettleResultEnum.SETTLESCUESS.getValue().equals(recordInfo.getSelttleResult())) {
                VMISettleRecordEntryInfo row;
                Map<Long, VMISettleRecordEntryInfo> entryInfos = recordInfo.getEntryInfos();
                if (!CommonUtils.isNull(entryInfos) && (row = entryInfos.entrySet().iterator().next().getValue()) != null) {
                    failBillNoAndErrorMsg.put(row.getSrcBillNumber(), recordInfo.getSettledetails());
                }
                success = false;
                settleFailId.add(billId);
                failIdAndErrorMsg.put(billId, recordInfo.getSettledetails());
                continue;
            }
            recordIds.add(recordInfo.getId());
            successId.add(billId);
        }
        result.setSuccess(success);
        result.setFailIds(settleFailId);
        result.setSuccessIds(successId);
        result.setSettleSuccessRecordIds(recordIds);
        result.setSettleFailMsgs(failIdAndErrorMsg);
        result.setSettleFailBillNoAndMsgs(failBillNoAndErrorMsg);
        return result;
    }

    private String checkSettleModel(Map<String, List<DynamicObject>> groupBySrcBillEntity, Map<String, VMISettleModelInfo> schemes) {
        if (schemes == null || schemes.isEmpty()) {
            return ResManager.loadKDString((String)"\u8bf7\u914d\u7f6eVMI\u7ed3\u7b97\u6a21\u578b\u540e\u518d\u8fdb\u884c\u7ed3\u7b97\u3002", (String)"VMIInnerDealService_2", (String)"scmc-pm-vmi", (Object[])new Object[0]);
        }
        ArrayList<String> modelEntityList = new ArrayList<String>(schemes.keySet());
        ArrayList<String> srcEntityList = new ArrayList<String>(groupBySrcBillEntity.keySet());
        if (srcEntityList.contains(null)) {
            return ResManager.loadKDString((String)"\u7269\u6743\u8f6c\u79fb\u5355\u6e90\u5355\u5b9e\u4f53\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u7ed3\u7b97\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u8bd5\u3002", (String)"VMIInnerDealService_3", (String)"scmc-pm-vmi", (Object[])new Object[0]);
        }
        srcEntityList.removeAll(modelEntityList);
        if (srcEntityList.size() > 0) {
            return String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u672a\u627e\u5230\u5339\u914d\u7684\u7ed3\u7b97\u6a21\u578b\u3002", (String)"VMIInnerDealService_4", (String)"scmc-pm-vmi", (Object[])new Object[0]), srcEntityList);
        }
        return null;
    }

    private List<DynamicObject> beforeDoSettle(List<DynamicObject> settleBills, VMISettleTypeEnum settleType) {
        if (VMISettleTypeEnum.CYCLE == settleType) {
            for (DynamicObject bill : settleBills) {
                DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
                for (int i = 0; i < billEntrys.size(); ++i) {
                    DynamicObject entry = (DynamicObject)billEntrys.get(i);
                    BigDecimal joinQty = entry.getBigDecimal("joinqty");
                    BigDecimal joinBaseQty = entry.getBigDecimal("joinbaseqty");
                    BigDecimal joinAuxQty = entry.getBigDecimal("joinauxqty");
                    BigDecimal qty = entry.getBigDecimal("qty");
                    BigDecimal baseQty = entry.getBigDecimal("baseqty");
                    BigDecimal auxQty = entry.getBigDecimal("auxqty");
                    entry.set("qty", (Object)qty.subtract(joinQty));
                    entry.set("baseqty", (Object)baseQty.subtract(joinBaseQty));
                    entry.set("auxqty", (Object)auxQty.subtract(joinAuxQty));
                }
            }
            return settleBills;
        }
        if (VMISettleTypeEnum.MANUAL == settleType) {
            Map<String, String> param = this.settleParam.getParam();
            Map<Long, Map<String, BigDecimal>> entryIdAndQtyMap = this.getQtyMap(param);
            for (DynamicObject bill : settleBills) {
                DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
                for (int i = billEntrys.size() - 1; i >= 0; --i) {
                    DynamicObject entry = (DynamicObject)billEntrys.get(i);
                    Long entryPkValue = (Long)entry.getPkValue();
                    Map<String, BigDecimal> qtyMap = entryIdAndQtyMap.get(entryPkValue);
                    for (Map.Entry<String, BigDecimal> mapEntry : qtyMap.entrySet()) {
                        String fieldKey = mapEntry.getKey();
                        BigDecimal qtyValue = mapEntry.getValue();
                        entry.set(fieldKey, (Object)qtyValue);
                    }
                }
            }
            this.settleParam.setParam(param);
        }
        return settleBills;
    }

    private Map<Long, Map<String, BigDecimal>> getQtyMap(Map<String, String> param) {
        String entryinfoString = param.get("entryinfo");
        Map entryInfoMap = (Map)SerializationUtils.fromJsonString((String)entryinfoString, HashMap.class);
        HashMap<Long, Map<String, BigDecimal>> currentySettleQty = new HashMap<Long, Map<String, BigDecimal>>(10);
        for (Map.Entry entryInfo : entryInfoMap.entrySet()) {
            Map map = (Map)entryInfo.getValue();
            HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>(10);
            Long entryId = Long.parseLong(String.valueOf(entryInfo.getKey()));
            for (String qtyFieldKey : fieldList) {
                Object obj = map.get(qtyFieldKey);
                BigDecimal value = null;
                if (obj instanceof Integer) {
                    value = new BigDecimal((Integer)obj);
                } else if (obj instanceof BigDecimal) {
                    value = (BigDecimal)obj;
                }
                qtyMap.put(qtyFieldKey, value);
            }
            currentySettleQty.put(entryId, qtyMap);
        }
        return currentySettleQty;
    }

    protected Map<Long, Long> getSettleTransferEntryIdAndBillIdMap(List<DynamicObject> settleBills) {
        HashMap<Long, Long> transferEntryIdAndBillIdMap = new HashMap<Long, Long>();
        for (DynamicObject bill : settleBills) {
            Long billId = (Long)bill.getPkValue();
            DynamicObjectCollection billentry = (DynamicObjectCollection)bill.get("billentry");
            if (billentry == null || billentry.size() <= 0) continue;
            for (int i = 0; i < billentry.size(); ++i) {
                Long billEntryId = (Long)((DynamicObject)billentry.get(i)).getPkValue();
                transferEntryIdAndBillIdMap.put(billEntryId, billId);
            }
        }
        return transferEntryIdAndBillIdMap;
    }

    protected Map<String, VMISettleModelInfo> getSettleModelFromSettleBills(List<DynamicObject> settleBills) {
        HashSet<String> srcEntitys = new HashSet<String>();
        for (DynamicObject bill : settleBills) {
            DynamicObject srcEntityDymObj = bill.getDynamicObject("srcbillform");
            String srcEntityDymObjPkValue = (String)srcEntityDymObj.getPkValue();
            srcEntitys.add(srcEntityDymObjPkValue);
        }
        ArrayList<String> list = new ArrayList<String>(srcEntitys);
        Map<String, VMISettleModelInfo> vmiSettleModelInfos = VMISettleModelHelper.getVMISettleModelInfoMap(list);
        return vmiSettleModelInfos;
    }

    private Map<String, List<DynamicObject>> groupBySrcEntity(List<DynamicObject> settleBills) {
        HashMap<String, List<DynamicObject>> map = new HashMap<String, List<DynamicObject>>(10);
        for (DynamicObject bill : settleBills) {
            DynamicObject srcBillEntityDym = (DynamicObject)bill.get("srcbillform");
            String srcBillEntity = srcBillEntityDym == null ? null : (String)srcBillEntityDym.getPkValue();
            ArrayList<DynamicObject> oneSrcEntitySettleBills = (ArrayList<DynamicObject>)map.get(srcBillEntity);
            if (oneSrcEntitySettleBills == null) {
                oneSrcEntitySettleBills = new ArrayList<DynamicObject>(10);
            }
            oneSrcEntitySettleBills.add(bill);
            map.put(srcBillEntity, oneSrcEntitySettleBills);
        }
        return map;
    }

    private void handleFailGenResult(GenerateTargetResult genAndSaveOpResult, Collection<Long> transferBillIds) {
        transferBillIds = new HashSet<Long>(transferBillIds);
        if (!CommonUtils.isNull((Object)genAndSaveOpResult.getExceptionMsg())) {
            this.addExceptionMsg(genAndSaveOpResult, transferBillIds);
        } else if (!genAndSaveOpResult.isPushSrcSuccess()) {
            this.buildPushErrorInfo2Record(genAndSaveOpResult);
        } else {
            this.buildSaveErrorInfo2Record(transferBillIds, genAndSaveOpResult);
        }
    }

    private void addExceptionMsg(GenerateTargetResult genAndSaveOpResult, Collection<Long> tranferBillIds) {
        String exceptionMsg = genAndSaveOpResult.getExceptionMsg() == null ? "" : genAndSaveOpResult.getExceptionMsg();
        for (Long transferBillId : tranferBillIds) {
            VMISettleRecordInfo recordInfo = this.settleRecordInfoMap.get(transferBillId);
            recordInfo.addSettledetails(recordInfo.getSettledetails() + exceptionMsg);
            recordInfo.setSettleSuccess(false);
        }
    }

    private void buildSaveErrorInfo2Record(Collection<Long> tranferBillIds, GenerateTargetResult genOpResult) {
        Map<Long, String> saveFailMsgMap = genOpResult.getSaveFailMsgMap();
        String msg = Arrays.toString(saveFailMsgMap.values().toArray());
        for (Long transferBillId : tranferBillIds) {
            VMISettleRecordInfo recordInfo = this.settleRecordInfoMap.get(transferBillId);
            recordInfo.addSettledetails(recordInfo.getSettledetails() + msg);
            recordInfo.setSettleSuccess(false);
        }
    }

    private void buildPushErrorInfo2Record(GenerateTargetResult genOpResult) {
        Map<Long, VMISettleRecordInfo> settleRecordInfoMap = this.settleRecordInfoMap;
        Map<Long, String> pushFailMsgMap = genOpResult.getPushFailMsgMap();
        for (Map.Entry<Long, String> entry : pushFailMsgMap.entrySet()) {
            VMISettleRecordInfo vmiSettleRecordInfo = settleRecordInfoMap.get(entry.getKey());
            String msg = vmiSettleRecordInfo.getSettledetails() + entry.getValue();
            vmiSettleRecordInfo.addSettledetails(msg);
            vmiSettleRecordInfo.setSettleSuccess(false);
        }
    }

    private Map<Long, VMISettleRecordInfo> addPurInBillInfo(Map<Long, Long> transferEntryIdAndBillIdMap, Map<Long, Long> TFRowIDAndPInRowID) {
        QFilter purInQfilter = new QFilter("billentry.id", "in", (Object)TFRowIDAndPInRowID.values().toArray(new Long[TFRowIDAndPInRowID.size()]));
        DynamicObjectCollection purInCollection = QueryServiceHelper.query((String)ENTITY_PURINBILL, (String)String.join((CharSequence)",", VMIInnerDealService.getPurInBillField()), (QFilter[])new QFilter[]{purInQfilter});
        HashMap<Long, VMIRecordPurInInfo> purInEntryIdAndPurInInfoMap = new HashMap<Long, VMIRecordPurInInfo>();
        for (DynamicObject dynamicObject : purInCollection) {
            Long purInBillId = (Long)dynamicObject.get("id");
            String purInBillno = (String)dynamicObject.get("billno");
            Long purInBillEntryId = (Long)dynamicObject.get("billentry.id");
            Integer purInBillEntrySeq = (Integer)dynamicObject.get("billentry.seq");
            String purInBillStatus = dynamicObject.getString("billstatus");
            VMIRecordPurInInfo purInInfo = new VMIRecordPurInInfo(ENTITY_PURINBILL, purInBillId, purInBillno, purInBillEntryId, purInBillEntrySeq, purInBillStatus);
            purInEntryIdAndPurInInfoMap.put(purInBillEntryId, purInInfo);
        }
        purInCollection.clear();
        for (Map.Entry<Long, Long> entry : TFRowIDAndPInRowID.entrySet()) {
            Long tFRowId = entry.getKey();
            Long tFId = transferEntryIdAndBillIdMap.get(tFRowId);
            VMISettleRecordInfo recordInfo = this.settleRecordInfoMap.get(tFId);
            Map<Long, VMISettleRecordEntryInfo> entryInfos = recordInfo.getEntryInfos();
            for (Map.Entry<Long, VMISettleRecordEntryInfo> recordOneEntry : entryInfos.entrySet()) {
                Long tfRowId = recordOneEntry.getKey();
                Long purInRowId = TFRowIDAndPInRowID.get(tfRowId);
                VMIRecordPurInInfo vmiRecordPurInInfo = (VMIRecordPurInInfo)purInEntryIdAndPurInInfoMap.get(purInRowId);
                VMISettleRecordEntryInfo entryInfo = recordOneEntry.getValue();
                entryInfo.setPurInBillId(vmiRecordPurInInfo.getPurInBillId());
                entryInfo.setPurInBillEntryId(vmiRecordPurInInfo.getPurInBillEntryId());
                entryInfo.setPurInBillEntity(vmiRecordPurInInfo.getPurInBillEntity());
                entryInfo.setPurInBillNumber(vmiRecordPurInInfo.getPurInBillNumber());
                entryInfo.setPurInBillEntrySeq(vmiRecordPurInInfo.getPurInBillEntrySeq());
                entryInfo.setPurInBillStatus(vmiRecordPurInInfo.getPurInBillStatus());
            }
        }
        return this.settleRecordInfoMap;
    }

    protected static List<String> getPurInBillField() {
        ArrayList<String> list = new ArrayList<String>(16);
        Collections.addAll(list, "billno", "id", "billstatus", "billentry.seq", "billentry.id", "billentry.srcbillentryid,billentry.material.masterid");
        return list;
    }

    public static OperationResult innerDealSettleReverse(Map<String, List<Long>> innerDealRecordIds) {
        VMIInnerDealService service = new VMIInnerDealService(innerDealRecordIds);
        return service.doReverseSettle(innerDealRecordIds);
    }

    private VMIInnerDealService(Map<String, List<Long>> innerDealRecordIds) {
        this.innerDealRecordIds = innerDealRecordIds;
    }

    private OperationResult doReverseSettle(Map<String, List<Long>> innerDealRecordIds) {
        OperationResult result = new OperationResult();
        try (TraceSpan span = Tracer.create((String)this.getClass().getName(), (String)"doInnerSettleReverse");){
            HashSet recordIds = new HashSet(10);
            innerDealRecordIds.forEach((k, v) -> recordIds.addAll(v));
            QFilter settleNofilter = new QFilter("id", "in", recordIds);
            DynamicObjectCollection records = QueryServiceHelper.query((String)this.getClass().getName(), (String)"pm_vmisettlerecord", (String)"settlelotno,settletype,id,billentry.purinbillid,billentry.purinbillnumber,billentry.purinbillentity ,billentry.srcbillnumber srcbillnumber,billentry.srcbillid srcbillid", (QFilter[])new QFilter[]{settleNofilter}, null);
            Map<String, Map<String, HashSet<Long>>> param = this.buildParamBySettleLotNo(records);
            log.info("\u53cd\u7ed3\u7b97 \u62fc\u88c5\u6279\u53f7\u4e0e\u7ed3\u7b97\u865a\u5355\u5173\u7cfb\u4e3a\uff1a" + param);
            log.info("VMI\u53cd\u7ed3\u7b97\u7684param ".concat(String.valueOf(param.size())));
            try {
                for (Map.Entry<String, Map<String, HashSet<Long>>> oneSettleLot : param.entrySet()) {
                    String settleLotNo = oneSettleLot.getKey();
                    List<Long> recordIDs = innerDealRecordIds.get(settleLotNo);
                    Map<String, HashSet<Long>> settleBills = oneSettleLot.getValue();
                    OperationResult opResult = this.excuteSettleReverse(settleBills, recordIDs, settleLotNo, OperateHelper.getOperateOption());
                    OperateHelper.merageOpR(result, opResult);
                    if (!opResult.isSuccess()) continue;
                    this.deleteRecord(recordIDs);
                }
                result.setMessage(result.isSuccess() ? ResManager.loadKDString((String)"\u53cd\u7ed3\u7b97\u6210\u529f\u3002", (String)"VMIInnerDealService_5", (String)"scmc-pm-vmi", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53cd\u7ed3\u7b97\u5931\u8d25\u3002", (String)"VMIInnerDealService_6", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            }
            catch (Exception e) {
                log.error(e.fillInStackTrace());
                throw e;
            }
            OperationResult operationResult = result;
            return operationResult;
        }
    }

    private Map<String, Map<String, HashSet<Long>>> buildParamBySettleLotNo(DynamicObjectCollection records) {
        HashMap<String, Map<String, HashSet<Long>>> param = new HashMap<String, Map<String, HashSet<Long>>>(16);
        for (DynamicObject record : records) {
            String settlelotno = record.getString("settlelotno");
            if (!StringUtils.isNotBlank((CharSequence)settlelotno)) continue;
            HashMap<String, HashSet<Long>> map = (HashMap<String, HashSet<Long>>)param.get(settlelotno);
            if (map == null) {
                map = new HashMap<String, HashSet<Long>>(16);
            }
            Long purinbillid = record.getLong("billentry.purinbillid");
            String purInBillentity = record.getString("billentry.purinbillentity");
            HashSet<Long> purinbillids = (HashSet<Long>)map.get(purInBillentity);
            if (purinbillids == null) {
                purinbillids = new HashSet<Long>(16);
            }
            purinbillids.add(purinbillid);
            map.put(purInBillentity, purinbillids);
            param.put(settlelotno, map);
        }
        return param;
    }

    private void deleteRecord(List<Long> recordIDs) {
        DeleteServiceHelper.delete((String)"pm_vmisettlerecord", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)recordIDs.toArray())});
    }

    private OperationResult excuteSettleReverse(Map<String, HashSet<Long>> settleBills, List<Long> recordIDs, String settleLotNo, OperateOption option) {
        Throwable throwable = null;
        try (TraceSpan span = Tracer.create((String)this.getClass().getName(), (String)"doSettleReverseInnerDeal");){
            HashSet<Long> billIds;
            OperationResult opR;
            block26: {
                opR = new OperationResult();
                try {
                    billIds = settleBills.get(ENTITY_PURINBILL);
                    if (!CommonUtils.isNull(billIds)) break block26;
                    log.info("VMI\u53cd\u7ed3\u7b97 \u5f53\u524d\u6279\u53f7\u865a\u5355\u5185\u5bb9\u6709\u8bef\u3002");
                    opR.setSuccess(false);
                    OperateErrorInfo errorInfo = new OperateErrorInfo();
                    errorInfo.setTitle(ResManager.loadKDString((String)"\u53cd\u7ed3\u7b97\u5931\u8d25\u3002", (String)"VMIInnerDealService_6", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    String msg = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u6279\u53f7\u201c%1$s\u201d\u53cd\u7ed3\u7b97\u5931\u8d25,VMI\u53cd\u7ed3\u7b97\u5f53\u524d\u6279\u53f7\u865a\u5355\u5185\u5bb9\u6709\u8bef \u3002", (String)"VMIInnerDealService_14", (String)"scmc-pm-vmi", (Object[])new Object[0]), settleLotNo);
                    errorInfo.setMessage(msg);
                    errorInfo.setLevel(ErrorLevel.Error);
                    opR.addErrorInfo(errorInfo);
                    OperationResult operationResult = this.buildOpResultByVirBillOpR(opR, settleLotNo, recordIDs);
                    return operationResult;
                }
                catch (Exception e) {
                    try {
                        log.error((Throwable)e);
                        throw e;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
            OperationResult unaduitopR = OperationServiceHelper.executeOperate((String)"unaudit", (String)ENTITY_PURINBILL, (Object[])billIds.toArray(), (OperateOption)option);
            if (!unaduitopR.isSuccess()) {
                OperationResult msg = this.buildOpResultByVirBillOpR(unaduitopR, settleLotNo, recordIDs);
                return msg;
            }
            OperationResult deleteopR = OperationServiceHelper.executeOperate((String)"delete", (String)ENTITY_PURINBILL, (Object[])billIds.toArray(), (OperateOption)option);
            if (!deleteopR.isSuccess()) {
                OperationResult operationResult = this.buildOpResultByVirBillOpR(deleteopR, settleLotNo, recordIDs);
                return operationResult;
            }
            OperationResult operationResult = this.buildOpResultByVirBillOpR(opR, settleLotNo, recordIDs);
            return operationResult;
        }
    }

    private OperationResult buildOpResultByVirBillOpR(OperationResult virBillOpR, String settleLotNo, List<Long> recordIDs) {
        OperationResult result = new OperationResult();
        if (virBillOpR == null) {
            return result;
        }
        result.setSuccess(virBillOpR.isSuccess());
        if (!virBillOpR.isSuccess()) {
            StringBuilder sb = new StringBuilder();
            List allErrorOrValidateInfo = virBillOpR.getAllErrorOrValidateInfo();
            allErrorOrValidateInfo.forEach(errorInfo -> sb.append(errorInfo.getMessage()));
            String errorMsg = sb.length() > 1000 ? sb.substring(0, 1000) : sb.toString();
            OperateErrorInfo errorInfo2 = new OperateErrorInfo();
            errorInfo2.setTitle(ResManager.loadKDString((String)"\u53cd\u7ed3\u7b97\u5931\u8d25\u3002", (String)"VMIInnerDealService_6", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            String msg = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u6279\u53f7\u201c%1$s\u201d\u53cd\u7ed3\u7b97\u5931\u8d25\uff1a%2$s\u3002", (String)"VMIInnerDealService_15", (String)"scmc-pm-vmi", (Object[])new Object[0]), settleLotNo, errorMsg);
            errorInfo2.setMessage(msg);
            errorInfo2.setLevel(ErrorLevel.Error);
            result.setSuccess(false);
            result.addErrorInfo(errorInfo2);
        } else {
            result.getSuccessPkIds().addAll(recordIDs);
        }
        return result;
    }

    public static OperationResult innerDealSettleRetry(Map<String, List<Long>> innerDealRecordIds) {
        OperationResult result = new OperationResult();
        if (innerDealRecordIds == null || innerDealRecordIds.isEmpty()) {
            return result;
        }
        ArrayList allRecordIds = new ArrayList(10);
        innerDealRecordIds.values().forEach(recordids -> allRecordIds.addAll(recordids));
        result.setBillCount(allRecordIds.size());
        Set<String> lotNos = innerDealRecordIds.keySet();
        List allErrorInfo = result.getAllErrorInfo();
        lotNos.forEach(lotNo -> {
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setTitle(ResManager.loadKDString((String)"\u91cd\u8bd5\u7ed3\u7b97\u5931\u8d25\u3002", (String)"VMIInnerDealService_16", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            String msg = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u6279\u53f7\u201c%1$s\u201d\u91cd\u8bd5\u7ed3\u7b97\u5931\u8d25\uff0c\u5185\u90e8\u4ea4\u6613\u5355\u636e\u6682\u4e0d\u652f\u6301\u91cd\u8bd5\u7ed3\u7b97\u3002", (String)"VMIInnerDealService_17", (String)"scmc-pm-vmi", (Object[])new Object[0]), lotNo);
            errorInfo.setMessage(msg);
            errorInfo.setLevel(ErrorLevel.Error);
            allErrorInfo.add(errorInfo);
        });
        result.setSuccess(false);
        result.setAllErrorInfo(allErrorInfo);
        return result;
    }

    static {
        fieldList.add("qty");
        fieldList.add("baseqty");
        fieldList.add("auxqty");
        fieldList.add("price");
        fieldList.add("priceandtax");
        fieldList.add("amountandtax");
    }
}

