/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.service.settle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.vmi.business.helper.OperateHelper;
import kd.scmc.pm.vmi.business.helper.VMIMutexHelper;
import kd.scmc.pm.vmi.business.helper.VMISettleLogHelper;
import kd.scmc.pm.vmi.business.helper.VMISettleRecordHelper;
import kd.scmc.pm.vmi.business.pojo.VMISettleRecordEntryInfo;
import kd.scmc.pm.vmi.business.pojo.VMISettleRecordInfo;
import kd.scmc.pm.vmi.business.service.settle.SettleReverseHandler;
import kd.scmc.pm.vmi.business.service.settle.VMIInnerDealService;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleLogInfo;
import kd.scmc.pm.vmi.common.enums.VMISettleResultEnum;
import kd.scmc.pm.vmi.common.utils.CommonUtil;

public class VMISettleReverseService {
    private static final Log log = LogFactory.getLog(VMISettleReverseService.class);
    private VMISettleLogInfo settleLogInfo;
    private static String queryRecordField = "id,settletype,settlelotno,settleresult,billentry.qty,billentry.baseqty,billentry.auxqty,billentry.purinbillentity,billentry.purinbillid,billentry.purinbillstatus,billentry.purinbillnumber,billentry.purinbillentryseq,billentry.purinbillentryid,billentry.invbillentity,billentry.invbillid,billentry.invbillstatus,billentry.invbillnumber,billentry.invbillentryid,billentry.invbillentryseq,billentry.srcbillentryid,billentry.srcbillnumber,billentry.srcbillid,billentry.srcbillform";

    public static OperationResult settleReverse(String ... allSettleLotNos) {
        log.info("\u8fdb\u5165\u53cd\u7ed3\u7b97\u7684\u7ed3\u7b97\u6279\u53f7\u4e3a\uff1a" + Arrays.toString(allSettleLotNos));
        List<List<String>> partition = CommonUtil.partition(Arrays.asList(allSettleLotNos), 100);
        OperationResult result = new OperationResult();
        for (int i = 0; i < partition.size(); ++i) {
            List<String> settleLotNos = partition.get(i);
            QFilter settleResultFilter = new QFilter("settleresult", "in", (Object)new String[]{VMISettleResultEnum.SETTLESCUESS.getValue(), VMISettleResultEnum.REVERSEFAIL.getValue()});
            DataSet query = VMISettleRecordHelper.queryTransferBillAndRecord(settleLotNos.toArray(new String[0]), settleResultFilter);
            HashMap<String, List<Long>> innerDealRecordIds = new HashMap<String, List<Long>>(10);
            HashMap<String, List<Long>> isNotInnerDealRecordIds = new HashMap<String, List<Long>>(10);
            for (Row row : query) {
                String settlelotno = row.getString("settlelotno");
                Boolean isintertransaction = row.getBoolean("isintertransaction");
                Long recordid = row.getLong("recordid");
                if (isintertransaction == null || Boolean.FALSE.equals(isintertransaction)) {
                    ArrayList<Long> notRecordIds = (ArrayList<Long>)isNotInnerDealRecordIds.get(settlelotno);
                    if (notRecordIds == null) {
                        notRecordIds = new ArrayList<Long>(5);
                    }
                    notRecordIds.add(recordid);
                    isNotInnerDealRecordIds.put(settlelotno, notRecordIds);
                    continue;
                }
                ArrayList<Long> innerRecordIds = (ArrayList<Long>)innerDealRecordIds.get(settlelotno);
                if (innerRecordIds == null) {
                    innerRecordIds = new ArrayList<Long>(5);
                }
                innerRecordIds.add(recordid);
                innerDealRecordIds.put(settlelotno, innerRecordIds);
            }
            query.close();
            OperationResult innnerSettleNoReverseOpR = new OperationResult();
            OperationResult notInnerSettleNoReverseOpR = new OperationResult();
            if (!CommonUtils.isNull(innerDealRecordIds)) {
                innnerSettleNoReverseOpR = VMIInnerDealService.innerDealSettleReverse(innerDealRecordIds);
            }
            if (!CommonUtils.isNull(isNotInnerDealRecordIds)) {
                notInnerSettleNoReverseOpR = VMISettleReverseService.getInstance().simpleSettleReverse(isNotInnerDealRecordIds);
            }
            result = VMISettleReverseService.mergeResult(result, innnerSettleNoReverseOpR, notInnerSettleNoReverseOpR);
        }
        return result;
    }

    private static VMISettleReverseService getInstance() {
        return new VMISettleReverseService();
    }

    private static OperationResult mergeResult(OperationResult result, OperationResult innnerSettleNoReverseOpR, OperationResult notInnerSettleNoReverseOpR) {
        if (innnerSettleNoReverseOpR != null) {
            OperateHelper.merageOpR(result, innnerSettleNoReverseOpR);
        }
        if (notInnerSettleNoReverseOpR != null) {
            OperateHelper.merageOpR(result, notInnerSettleNoReverseOpR);
        }
        result.setMessage(result.isSuccess() ? ResManager.loadKDString((String)"\u53cd\u7ed3\u7b97\u6210\u529f\u3002", (String)"VMISettleReverseService_8", (String)"scmc-pm-vmi", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53cd\u7ed3\u7b97\u5931\u8d25\u3002", (String)"VMISettleReverseService_9", (String)"scmc-pm-vmi", (Object[])new Object[0]));
        return result;
    }

    public static OperationResult singleSettleReverse(Long recordId, String settleNo) {
        HashMap<String, List<Long>> oneBatch = new HashMap<String, List<Long>>(2);
        oneBatch.put(settleNo, Collections.singletonList(recordId));
        return VMISettleReverseService.getInstance().simpleSettleReverse(oneBatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult simpleSettleReverse(Map<String, List<Long>> isNotInnerDealRecordIds) {
        log.info("simpleSettleReverse\u53cd\u7ed3\u7b97\u7684\u7ed3\u7b97\uff1a" + isNotInnerDealRecordIds);
        try (TraceSpan span = Tracer.create((String)this.getClass().getName(), (String)"doSettleReverse");){
            OperationResult result = new OperationResult();
            HashSet oneBatchRecordIds = new HashSet(10);
            isNotInnerDealRecordIds.forEach((k, v) -> oneBatchRecordIds.addAll(v));
            QFilter settleNofilter = new QFilter("id", "in", oneBatchRecordIds);
            DynamicObject[] records = BusinessDataServiceHelper.load((String)"pm_vmisettlerecord", (String)"id,settlelotno,settletype,billentry.srcbillnumber,billentry.srcbillid", (QFilter[])new QFilter[]{settleNofilter});
            this.settleLogInfo = VMISettleLogHelper.buildSettleLog(isNotInnerDealRecordIds.keySet().toArray(new String[0]), records);
            Map<String, ArrayList<Long>> settleNoAndRecordDym = VMISettleRecordHelper.groupBySettle(records);
            for (Map.Entry<String, ArrayList<Long>> oneSetlleNoEntry : settleNoAndRecordDym.entrySet()) {
                String settleLotNo = oneSetlleNoEntry.getKey();
                log.info("\u5f53\u524d\u8fdb\u884c\u53cd\u7ed3\u7b97\u7684\u6279\u6b21\u4e3a\uff1a" + settleLotNo);
                ArrayList<Long> recordIdList = oneSetlleNoEntry.getValue();
                DynamicObject[] oneLotRecord = BusinessDataServiceHelper.load((String)"pm_vmisettlerecord", (String)queryRecordField, (QFilter[])new QFilter[]{new QFilter("id", "in", recordIdList)});
                if (oneLotRecord == null || oneLotRecord.length == 0) continue;
                log.info("\u5f53\u524d\u8fdb\u884c\u53cd\u7ed3\u7b97\u7684\u6279\u6b21\u7ed3\u7b97\u8bb0\u5f55\u6570\u91cf\u4e3a " + oneLotRecord.length);
                List<DynamicObject> recordList = Arrays.asList(oneLotRecord);
                Map<Long, VMISettleRecordInfo> settleRecordInfoMap = VMISettleRecordHelper.convertDynamic2Info(recordList, VMISettleResultEnum.REVERSESUCCESS);
                Set<Long> addDoVMIOPMutex = null;
                try {
                    OperationResult oneSettleLotOpR;
                    Map<Long, String> transferBillIdAndNo = this.getTransferBillIdAndNo(settleRecordInfoMap);
                    addDoVMIOPMutex = VMIMutexHelper.addDoVMIOPMutex(transferBillIdAndNo);
                    if (addDoVMIOPMutex == null || addDoVMIOPMutex.isEmpty() || addDoVMIOPMutex.size() != transferBillIdAndNo.size()) {
                        oneSettleLotOpR = new OperationResult();
                        oneSettleLotOpR.setBillCount(settleRecordInfoMap.size());
                        OperateErrorInfo errorInfo2 = new OperateErrorInfo();
                        errorInfo2.setTitle(ResManager.loadKDString((String)"\u53cd\u7ed3\u7b97\u5931\u8d25\u3002", (String)"VMISettleReverseService_9", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                        String msg = String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u6279\u53f7\u4e3a %1$s \u53cd\u7ed3\u7b97\u5931\u8d25\uff0c\u5f53\u524d\u6279\u6b21\u6b63\u5728\u6267\u884cVMI\u5176\u4ed6\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"VMISettleReverseService_16", (String)"scmc-pm-vmi", (Object[])new Object[0]), settleLotNo);
                        errorInfo2.setMessage(msg);
                        errorInfo2.setLevel(ErrorLevel.Error);
                        oneSettleLotOpR.setSuccess(false);
                        oneSettleLotOpR.addErrorInfo(errorInfo2);
                        OperateHelper.merageOpR(result, oneSettleLotOpR);
                        result.setMessage(result.isSuccess() ? ResManager.loadKDString((String)"\u53cd\u7ed3\u7b97\u6210\u529f\u3002", (String)"VMISettleReverseService_8", (String)"scmc-pm-vmi", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53cd\u7ed3\u7b97\u5931\u8d25\u3002", (String)"VMISettleReverseService_9", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                        log.info("\u5f53\u524d\u53cd\u7ed3\u7b97\u7ed3\u675f\u7684\u7ed3\u679c\u4e3a\uff1a" + oneSettleLotOpR);
                        continue;
                    }
                    oneSettleLotOpR = new SettleReverseHandler(settleRecordInfoMap).settleReverse();
                    OperateHelper.merageOpR(result, oneSettleLotOpR);
                    result.setMessage(result.isSuccess() ? ResManager.loadKDString((String)"\u53cd\u7ed3\u7b97\u6210\u529f\u3002", (String)"VMISettleReverseService_8", (String)"scmc-pm-vmi", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53cd\u7ed3\u7b97\u5931\u8d25\u3002", (String)"VMISettleReverseService_9", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    log.info("\u5f53\u524d\u53cd\u7ed3\u7b97\u7ed3\u675f\u7684\u7ed3\u679c\u4e3a\uff1a" + oneSettleLotOpR);
                }
                catch (Exception e) {
                    String msg = e.getMessage() + Arrays.toString(e.getStackTrace());
                    log.error("\u975e\u5185\u90e8\u4ea4\u6613\u53cd\u7ed3\u7b97\u51fa\u9519\uff1a" + msg);
                    this.settleLogInfo.addSettleLogTag(msg);
                    this.settleLogInfo.setSettleResult(VMISettleResultEnum.REVERSEFAIL.getValue());
                    VMISettleRecordHelper.addExceptionMsg(settleRecordInfoMap, settleRecordInfoMap.keySet(), msg, VMISettleResultEnum.REVERSEFAIL);
                    VMISettleRecordHelper.updateVMIRecord(settleRecordInfoMap);
                }
                finally {
                    if (addDoVMIOPMutex == null || addDoVMIOPMutex.isEmpty()) continue;
                    VMIMutexHelper.releaseVMIOPMutex(addDoVMIOPMutex);
                }
            }
            this.settleLogInfo.setSettleResult(result.isSuccess() ? VMISettleResultEnum.REVERSESUCCESS.getValue() : VMISettleResultEnum.REVERSEFAIL.getValue());
            if (!result.isSuccess()) {
                result.getAllErrorOrValidateInfo().forEach(errorInfo -> this.settleLogInfo.addSettleLogTag(errorInfo.getMessage()));
            }
            VMISettleLogHelper.save(Collections.singletonList(this.settleLogInfo));
            OperationResult operationResult = result;
            return operationResult;
        }
    }

    private Map<Long, String> getTransferBillIdAndNo(Map<Long, VMISettleRecordInfo> settleRecordInfoMap) {
        HashMap<Long, String> billIdAndNo = new HashMap<Long, String>(10);
        if (settleRecordInfoMap == null || settleRecordInfoMap.isEmpty()) {
            return billIdAndNo;
        }
        settleRecordInfoMap.values().forEach(rec -> {
            Map<Long, VMISettleRecordEntryInfo> entryInfos = rec.getEntryInfos();
            if (entryInfos != null && !entryInfos.isEmpty()) {
                entryInfos.values().forEach(row -> billIdAndNo.put(row.getSrcBillId(), row.getSrcBillNumber()));
            }
        });
        return billIdAndNo;
    }
}

