/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.service.settle.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.vmi.business.helper.OperateHelper;
import kd.scmc.pm.vmi.business.helper.VMISettleLogHelper;
import kd.scmc.pm.vmi.business.helper.VMISettleRecordHelper;
import kd.scmc.pm.vmi.business.pojo.VMISettleRecordInfo;
import kd.scmc.pm.vmi.business.service.settle.action.AbstractVMISettleAction;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleContext;
import kd.scmc.pm.vmi.common.enums.VMISettleResultEnum;

public class DoVirtualBillAuditOperationAction
extends AbstractVMISettleAction {
    private static final Log log = LogFactory.getLog(DoVirtualBillAuditOperationAction.class);

    public DoVirtualBillAuditOperationAction(VMISettleContext context, Map<Long, VMISettleRecordInfo> settleRecordInfoMap) {
        this.settleContext = context;
        this.settleRecordInfoMap = settleRecordInfoMap;
    }

    @Override
    public void doAction() {
        log.info("\u6267\u884c\u865a\u5355\u64cd\u4f5c \u5f00\u59cb\uff1a" + this.settleContext);
        log.info("\u6267\u884c\u865a\u5355\u64cd\u4f5c \u5f00\u59cb\uff1a" + this.settleRecordInfoMap);
        List<Object> isNotInnerDealPurInIds = this.settleContext.getIsNotInnerDealPurInIds();
        List<Object> invIds = this.settleContext.getInvIds();
        log.info("\u5e93\u5b58\u5355 id\uff1a" + invIds);
        if (CommonUtils.isNull(invIds) || CommonUtils.isNull(isNotInnerDealPurInIds)) {
            return;
        }
        try (TraceSpan span = Tracer.create((String)this.getClass().getName(), (String)"DoVirtualBillAuditAction");){
            this.doIsNotInnerDealBillAudit();
        }
        log.info("\u6267\u884c\u865a\u5355\u64cd\u4f5c \u7ed3\u675f\uff1a" + this.settleContext);
        log.info("\u6267\u884c\u865a\u5355\u64cd\u4f5c \u7ed3\u675f\uff1a" + this.settleRecordInfoMap);
    }

    private void doIsNotInnerDealBillAudit() {
        List<Object> submitSuccessInvBillId = this.settleContext.getInvIds();
        List<Object> submitSuccessPurInBillId = this.settleContext.getIsNotInnerDealPurInIds();
        if (CommonUtils.isNull(submitSuccessInvBillId) || CommonUtils.isNull(submitSuccessPurInBillId)) {
            return;
        }
        Collection<Long> transferBillIds = this.settleContext.getIsNotInnerDealEntryIdAndBillIdMap().values();
        VMISettleLogHelper.addStepBegin(this.settleLogInfo, String.format(ResManager.loadKDString((String)"%1$s \u5ba1\u6838\u5165\u5e93\u865a\u5355", (String)"DoVirtualBillAuditOperationAction_2", (String)"scmc-pm-vmi", (Object[])new Object[0]), this.settleContext.getSettleModelInfo().getVMISettleSrcBillEntity()), TimeServiceHelper.now());
        List<Object> purInAuditSuccessIds = this.getSuccessID4Audit(transferBillIds, submitSuccessPurInBillId.toArray(), this.settleContext.getPurInEntity(), this.settleContext.getPurInBillList());
        VMISettleLogHelper.addStepEnd(this.settleLogInfo, TimeServiceHelper.now());
        log.info("\u975e\u5185\u90e8\u4ea4\u6613 \u5165\u5e93\u5ba1\u6838\u6210\u529f\u7684id \uff1a" + purInAuditSuccessIds);
        if (CommonUtils.isNull(purInAuditSuccessIds)) {
            return;
        }
        VMISettleLogHelper.addStepBegin(this.settleLogInfo, String.format(ResManager.loadKDString((String)"%1$s \u5ba1\u6838\u5e93\u5b58\u5e93\u865a\u5355", (String)"DoVirtualBillAuditOperationAction_3", (String)"scmc-pm-vmi", (Object[])new Object[0]), this.settleContext.getSettleModelInfo().getVMISettleSrcBillEntity()), TimeServiceHelper.now());
        HashSet<Object> needAuditInvBillIds = this.getNeedAuditInvBillIds(transferBillIds, purInAuditSuccessIds, submitSuccessInvBillId);
        log.info("\u975e\u5185\u90e8\u4ea4\u6613 \u53ef\u4ee5\u8fdb\u884c\u5ba1\u6838\u7684\u5e93\u5b58\u865a\u5355id\u4e3a " + needAuditInvBillIds);
        if (CommonUtils.isNull(needAuditInvBillIds)) {
            return;
        }
        List<Object> invAuditSuccessIds = this.getSuccessID4Audit(transferBillIds, needAuditInvBillIds.toArray(), this.settleContext.getInvInEntity(), this.settleContext.getInvBillsList());
        VMISettleLogHelper.addStepEnd(this.settleLogInfo, TimeServiceHelper.now());
        log.info("\u975e\u5185\u90e8\u4ea4\u6613 \u5e93\u5b58\u5ba1\u6838\u6210\u529f\u7684id \uff1a" + invAuditSuccessIds);
    }

    private HashSet<Object> getNeedAuditInvBillIds(Collection<Long> transferBillIds, List<Object> purInAuditSuccessIds, List<Object> submitSuccessInvBillId) {
        Long tBillId;
        BFRowId id;
        BFRowId sId;
        HashSet<Object> needAuditInvBillIds = new HashSet<Object>(10);
        List<BFRow> targetRowIds = this.settleContext.getTargetRowIds();
        ArrayList<Long> auditSuccessPurInTranserEntryId = new ArrayList<Long>(10);
        for (BFRow bfRow : targetRowIds) {
            sId = bfRow.getSId();
            id = bfRow.getId();
            Long sBillId = sId.getBillId();
            tBillId = id.getBillId();
            if (!transferBillIds.contains(sBillId) || !purInAuditSuccessIds.contains(tBillId)) continue;
            auditSuccessPurInTranserEntryId.add(sId.getEntryId());
        }
        for (BFRow bfRow : targetRowIds) {
            sId = bfRow.getSId();
            id = bfRow.getId();
            Long sEntryId = sId.getEntryId();
            tBillId = id.getBillId();
            if (!auditSuccessPurInTranserEntryId.contains(sEntryId) || !submitSuccessInvBillId.contains(tBillId)) continue;
            needAuditInvBillIds.add(tBillId);
        }
        return needAuditInvBillIds;
    }

    private List<Object> getSuccessID4Audit(Collection<Long> transferBillIds, Object[] tarBillIds, String tarEntity, List<DynamicObject> tarBillList) {
        List<Object> successIds = new ArrayList<Object>(10);
        try {
            OperationResult purInAuditResult = null;
            try (TraceSpan span = Tracer.create((String)this.getClass().getName(), (String)("DoVirtualBillAuditAction" + tarEntity));){
                purInAuditResult = OperationServiceHelper.executeOperate((String)"audit", (String)tarEntity, (Object[])tarBillIds, (OperateOption)OperateHelper.getOperateOption());
            }
            if (!purInAuditResult.isSuccess()) {
                Map<Long, String> opFialMsg = OperateHelper.handleFailInfo("audit", purInAuditResult, tarBillList);
                VMISettleRecordHelper.addTargetBillOpFailMsg(this.settleRecordInfoMap, opFialMsg, VMISettleResultEnum.SETTLEFAIL);
            }
            successIds = purInAuditResult.getSuccessPkIds();
        }
        catch (Exception e) {
            String exceptionMsg = e.toString().concat(Arrays.toString(e.getStackTrace()));
            log.info(tarEntity + " \u5ba1\u6838\u53d1\u751f\u5f02\u5e38\uff1a" + exceptionMsg);
            VMISettleRecordHelper.addExceptionMsg(this.settleRecordInfoMap, transferBillIds, exceptionMsg, VMISettleResultEnum.SETTLEFAIL);
            return successIds;
        }
        return successIds;
    }
}

