/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.service.settle.async;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.vmi.business.service.settle.VMISettleService;
import kd.scmc.pm.vmi.business.service.settle.async.VMIAsyncSettle;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleParam;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleResult;
import kd.scmc.pm.vmi.common.enums.VMISettleExcutedStatusEnum;
import kd.scmc.pm.vmi.common.enums.VMISettleTypeEnum;

public class VMIAsyncSettleByMQ
extends VMIAsyncSettle
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(VMIAsyncSettleByMQ.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        try {
            if (resend) {
                acker.ack(messageId);
                return;
            }
            log.info("VMI\u5f02\u6b65MQ\u7ed3\u7b97\u5f00\u59cb\u3002");
            if (StringUtils.isBlank((Object)message)) {
                return;
            }
            List billids = (List)SerializationUtils.fromJsonString((String)message.toString(), List.class);
            if (CommonUtils.isNull((Object)billids)) {
                return;
            }
            QFilter idFilter = new QFilter("id", "in", (Object)billids);
            QFilter filter = new QFilter("billentry.excutedstatus", "=", (Object)VMISettleExcutedStatusEnum.UNEXCUTED.getValue());
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"pm_transferbill", (String)"id,billno,billentry,purorg", (QFilter[])new QFilter[]{idFilter, filter});
            if (bills == null || bills.length < 1) {
                return;
            }
            HashMap<Long, Long> sourceIdMap = new HashMap<Long, Long>(16);
            HashMap<Long, String> sourceIdAndBillNoMap = new HashMap<Long, String>(16);
            VMISettleParam settleParam = new VMISettleParam(VMISettleTypeEnum.REALTIME);
            for (int i = 0; i < bills.length; ++i) {
                DynamicObject bill = bills[i];
                Long billId = (Long)bill.getPkValue();
                String billNo = bill.getString("billno");
                sourceIdAndBillNoMap.put(billId, billNo);
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : entrys) {
                    sourceIdMap.put((Long)entry.getPkValue(), billId);
                }
            }
            if (CommonUtils.isNull(sourceIdMap)) {
                return;
            }
            settleParam.setTransferEntryIdAndBillIdMap(sourceIdMap);
            log.info("\u5b9e\u65f6\u7ed3\u7b97\u5f00\u59cb\u65f6\u95f4\uff1a" + System.currentTimeMillis());
            VMISettleResult vmiSettleResult = VMISettleService.vmiSettle(settleParam);
            log.info("\u5b9e\u65f6\u7ed3\u7b97\u7ed3\u675f\u65f6\u95f4\uff1a" + System.currentTimeMillis());
            if (vmiSettleResult != null && !vmiSettleResult.isSuccess()) {
                List<Long> failIds = vmiSettleResult.getFailIds();
                StringBuilder failBillNo = new StringBuilder();
                failIds.forEach(id -> failBillNo.append((String)sourceIdAndBillNoMap.get(id)).append('\uff0c'));
                this.sendMsgToUser(String.format(ResManager.loadKDString((String)"\u7269\u6743\u8f6c\u79fb\u5355 %s \u7ed3\u7b97\u5931\u8d25\u3002", (String)"VMIAsyncSettleByMQ_0", (String)"scmc-pm-vmi", (Object[])new Object[0]), failBillNo.substring(0, failBillNo.lastIndexOf("\uff0c"))));
            }
        }
        catch (Exception e) {
            log.error("\u5f02\u6b65\u7ed3\u7b97\u5f02\u5e38\uff1a" + e.getMessage() + Arrays.toString(e.getStackTrace()));
        }
        finally {
            acker.ack(messageId);
        }
        log.info("VMI\u5f02\u6b65MQ\u7ed3\u7b97\u7ed3\u675f\u3002");
    }

    @Override
    public void doAsyncSettle(List<Long> transferBillId) {
        try (MessagePublisher pub = null;){
            pub = MQFactory.get().createSimplePublisher("scmc", "kd.scmc.pm.vmiasyncsettle_queue");
            QFilter[] qFilter = new QFilter[]{new QFilter("id", "in", transferBillId)};
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"pm_transferbill", (String)"id,purorg", (QFilter[])qFilter);
            if (bills == null || bills.length < 1) {
                return;
            }
            Set<Long> realTimeSettlePurOrgId = this.getRealTimeSettlePurOrgId(bills);
            ArrayList<Long> needSettleBillId = new ArrayList<Long>(16);
            for (int i = 0; i < bills.length; ++i) {
                Long purorgPkValue;
                DynamicObject bill = bills[i];
                DynamicObject purorg = (DynamicObject)bill.get("purorg");
                if (purorg == null || !realTimeSettlePurOrgId.contains(purorgPkValue = (Long)purorg.getPkValue())) continue;
                Long billId = (Long)bill.getPkValue();
                needSettleBillId.add(billId);
            }
            log.info("\u5b9e\u65f6\u7ed3\u7b97\u7684ID\u4e3a\uff1a" + needSettleBillId);
            if (CommonUtils.isNull(needSettleBillId)) {
                return;
            }
            String needSettleBillIdJson = SerializationUtils.toJsonString(needSettleBillId);
            pub.publish(needSettleBillIdJson);
        }
    }
}

