/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.business.service.settle.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.pm.vmi.business.service.settle.VMISettleService;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleParam;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleResult;

public class ManualSettleServiceImpl
extends VMISettleService {
    private static final Log log = LogFactory.getLog(ManualSettleServiceImpl.class);
    private static List<String> fieldList = new ArrayList<String>();

    @Override
    public DynamicObject[] beforeDoSettleAction(DynamicObject[] bills, VMISettleParam settleParam) {
        this.deleteFailBill(settleParam);
        Map<String, String> param = settleParam.getParam();
        Map<Long, Map<String, BigDecimal>> entryIdAndQtyMap = this.getQtyMap(param);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
            for (int i = billEntrys.size() - 1; i >= 0; --i) {
                DynamicObject entry = (DynamicObject)billEntrys.get(i);
                Long entryPkValue = (Long)entry.getPkValue();
                Map<String, BigDecimal> qtyMap = entryIdAndQtyMap.get(entryPkValue);
                for (Map.Entry<String, BigDecimal> mapEntry : qtyMap.entrySet()) {
                    String fieldKey = mapEntry.getKey();
                    BigDecimal qtyValue = mapEntry.getValue();
                    entry.set(fieldKey, (Object)qtyValue);
                }
            }
        }
        settleParam.setParam(param);
        return bills;
    }

    @Override
    protected void afterDoSettleAction(VMISettleResult vmiSettleResult) {
    }

    private Map<Long, Map<String, BigDecimal>> getQtyMap(Map<String, String> param) {
        String entryinfoString = param.get("entryinfo");
        Map entryInfoMap = (Map)SerializationUtils.fromJsonString((String)entryinfoString, HashMap.class);
        HashMap<Long, Map<String, BigDecimal>> currentySettleQty = new HashMap<Long, Map<String, BigDecimal>>(10);
        for (Map.Entry entryInfo : entryInfoMap.entrySet()) {
            Map map = (Map)entryInfo.getValue();
            HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>(10);
            Long entryId = Long.parseLong(String.valueOf(entryInfo.getKey()));
            for (String qtyFieldKey : fieldList) {
                Object obj = map.get(qtyFieldKey);
                BigDecimal value = null;
                if (obj instanceof Integer) {
                    value = new BigDecimal((Integer)obj);
                } else if (obj instanceof BigDecimal) {
                    value = (BigDecimal)obj;
                }
                qtyMap.put(qtyFieldKey, value);
            }
            currentySettleQty.put(entryId, qtyMap);
        }
        return currentySettleQty;
    }

    @Override
    protected void afterMutexControl(Set<Long> addMutexSuccessIds) {
        if (addMutexSuccessIds.isEmpty()) {
            VMISettleResult result = this.getResult();
            result.setSuccess(false);
            result.setMessage(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u5f85\u7ed3\u7b97\u8bb0\u5f55\u6b63\u5728\u6267\u884c\u5176\u4ed6VMI\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ManualSettleServiceImpl_0", (String)"scmc-pm-vmi", (Object[])new Object[0]));
        }
    }

    static {
        fieldList.add("qty");
        fieldList.add("baseqty");
        fieldList.add("auxqty");
        fieldList.add("price");
        fieldList.add("priceandtax");
        fieldList.add("amountandtax");
    }
}

