/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.vmi.business.service.settle.VMISettleRetryService;
import kd.scmc.pm.vmi.business.service.settle.VMISettleReverseService;
import kd.scmc.pm.vmi.common.enums.VMISettleOpEnum;
import kd.scmc.pm.vmi.common.enums.VMISettleResultEnum;
import kd.scmc.pm.vmi.common.utils.CommonUtil;

public class VMIRecordListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(VMIRecordListPlugin.class);
    private static final String OPKEY_SETTLEREVERSE = "settlereverse";
    private static final String OPKEY_RETRYSETTLE = "retrysettle";
    private static final String ENTITY_PURINBILL = "im_purinbill";
    private static final String ENTITY_BUSBILL = "ap_busbill";
    private static final String ENTITY_FINAPBILL = "ap_finapbill";
    private static final int MAX_SELECTEDCOUNT = 5000;
    private static final String LINE_BREAK = "\r\n";
    private static String[] excludeItemKeys = new String[]{"baritemap1", "settlereverse", "tblrefresh", "tblclose", "export"};

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (!Arrays.asList(excludeItemKeys).contains(itemKey)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows == null || CommonUtils.isNull((Object)selectedRows)) {
                return;
            }
            DynamicObjectCollection records = this.querySelectRecord(selectedRows.getPrimaryKeyValues());
            if (CommonUtils.isNull((Object)records)) {
                return;
            }
            boolean allSuccess = true;
            for (DynamicObject record : records) {
                if (VMISettleResultEnum.SETTLESCUESS.getValue().equals(record.getString("settleresult"))) continue;
                allSuccess = false;
                break;
            }
            if (!allSuccess) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7ed3\u7b97\u8bb0\u5f55\u4e2d\u5305\u542b\u7ed3\u7b97\u7ed3\u679c\u4e3a\u5931\u8d25\u7684\u6570\u636e\uff0c\u8bf7\u7ed3\u7b97\u6210\u529f\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"VMIRecordListPlugin_10", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            return;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String operateKey = op.getOperateKey();
        boolean isCancel = false;
        if (!OPKEY_RETRYSETTLE.equals(operateKey) && !OPKEY_SETTLEREVERSE.equals(operateKey)) {
            return;
        }
        String opName = OPKEY_SETTLEREVERSE.equals(operateKey) ? VMISettleOpEnum.REVERSE.getName() : VMISettleOpEnum.RETRY.getName();
        Object[] seletedPks = this.getSeletedPks();
        if (seletedPks != null && seletedPks.length > 500000) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6700\u591a\u652f\u6301500000\u884c\u6570\u636e\u8fdb\u884c%1$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"VMIRecordListPlugin_16", (String)"scmc-pm-vmi", (Object[])new Object[0]), opName));
            e.setCancel(true);
            return;
        }
        DynamicObjectCollection queryRecord = this.queryRecord(new QFilter("id", "in", (Object)seletedPks));
        if (queryRecord == null || queryRecord.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"VMIRecordListPlugin_27", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        for (DynamicObject record : queryRecord) {
            if (!StringUtils.isBlank((CharSequence)record.getString("settlelotno"))) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5b58\u5728\u7ed3\u7b97\u6279\u53f7\u4e3a\u7a7a\uff0c\u65e0\u6cd5%1$s\u3002", (String)"VMIRecordListPlugin_17", (String)"scmc-pm-vmi", (Object[])new Object[0]), opName));
            e.setCancel(true);
            return;
        }
        if (OPKEY_RETRYSETTLE.equals(operateKey)) {
            isCancel = this.checkRetryRecordOp(queryRecord);
        } else if (OPKEY_SETTLEREVERSE.equals(operateKey)) {
            isCancel = this.checkReverseOp(queryRecord);
        }
        if (isCancel) {
            e.setCancel(true);
            return;
        }
    }

    private boolean checkReverseOp(DynamicObjectCollection queryRecord) {
        if (queryRecord == null || queryRecord.isEmpty()) {
            return true;
        }
        HashSet<String> settleLots = new HashSet<String>(10);
        for (DynamicObject record : queryRecord) {
            String settleResult = record.getString("settleresult");
            if (!VMISettleResultEnum.SETTLESCUESS.getValue().equals(settleResult) && !VMISettleResultEnum.REVERSEFAIL.getValue().equals(settleResult)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u7b97\u7ed3\u679c\u4e3a\u201c\u7ed3\u7b97\u6210\u529f\u201d\u6216\u201c\u53cd\u7ed3\u7b97\u5931\u8d25\u201d\u7684\u6570\u636e\u53cd\u7ed3\u7b97\u3002", (String)"VMIRecordListPlugin_18", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                return true;
            }
            settleLots.add(record.getString("settlelotno"));
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_vmisettlerecord", (String)"id,settleresult,settlelotno,billentry.purinbillid as purinbillid", (QFilter[])new QFilter[]{new QFilter("settlelotno", "in", settleLots)}, null);
        DataSet copy = dataSet.copy();
        int settleLotRecordCount = dataSet.count("id", true);
        if (settleLotRecordCount > 5000) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u6b21\u53cd\u7ed3\u7b97\u65f6\u7ed3\u7b97\u6279\u53f7\u4e0b\u7ed3\u7b97\u8bb0\u5f55\u4e0d\u80fd\u8d85\u8fc75000\u6761\uff0c\u8bf7\u5206\u6279\u53cd\u7ed3\u7b97\u3002", (String)"VMIRecordListPlugin_19", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            return true;
        }
        HashSet<String> hasSettleFailLotNo = new HashSet<String>(10);
        HashMap<String, Set<Long>> settleLotAndPurInBillIds = new HashMap<String, Set<Long>>(10);
        for (Row row : copy) {
            HashSet<Long> purInBillIds;
            String settleResult = row.getString("settleresult");
            String settleLotNo = row.getString("settlelotno");
            if (VMISettleResultEnum.SETTLEFAIL.getValue().equals(settleResult) && hasSettleFailLotNo.size() <= 100) {
                hasSettleFailLotNo.add(settleLotNo);
            }
            if ((purInBillIds = (HashSet<Long>)settleLotAndPurInBillIds.get(settleLotNo)) == null) {
                purInBillIds = new HashSet<Long>(10);
            }
            purInBillIds.add(row.getLong("purinbillid"));
            settleLotAndPurInBillIds.put(settleLotNo, purInBillIds);
        }
        if (!hasSettleFailLotNo.isEmpty()) {
            OperationResult op = new OperationResult();
            op.setBillCount(settleLotRecordCount);
            op.setSuccess(false);
            List allErrorInfo = op.getAllErrorInfo();
            for (String lotNo : hasSettleFailLotNo) {
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setLevel(ErrorLevel.Error);
                errorInfo.setMessage(String.format(ResManager.loadKDString((String)"\u6240\u9009\u7ed3\u7b97\u6279\u53f7\u201c%1$s\u201d\u53cd\u7ed3\u7b97\u5931\u8d25\uff0c\u5176\u4e0b\u7ed3\u7b97\u8bb0\u5f55\u4e2d\u5b58\u5728\u7ed3\u7b97\u5931\u8d25\u7684\u6570\u636e\u3002", (String)"VMIRecordListPlugin_20", (String)"scmc-pm-vmi", (Object[])new Object[0]), lotNo));
                allErrorInfo.add(errorInfo);
            }
            this.getView().showOperationResult(op);
            return true;
        }
        List<OperateErrorInfo> errorInfos = this.getHasTargetBillMsg(settleLotAndPurInBillIds);
        if (errorInfos != null && !errorInfos.isEmpty()) {
            OperationResult op = new OperationResult();
            op.setBillCount(settleLotRecordCount);
            op.setAllErrorInfo(errorInfos);
            op.setSuccess(false);
            this.getView().showOperationResult(op);
            return true;
        }
        if (this.getSeletedPks().length != settleLotRecordCount) {
            ConfirmCallBackListener listener = new ConfirmCallBackListener(OPKEY_SETTLEREVERSE, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u7ed3\u7b97\u6279\u53f7\u5173\u8054\u591a\u5f20\u7ed3\u7b97\u8bb0\u5f55\u5c06\u4e00\u8d77\u53cd\u7ed3\u7b97\uff0c\u662f\u5426\u786e\u8ba4\u64cd\u4f5c\uff1f", (String)"VMIRecordListPlugin_21", (String)"scmc-pm-vmi", (Object[])new Object[0]), MessageBoxOptions.OKCancel, listener);
            return true;
        }
        return false;
    }

    private boolean checkRetryRecordOp(DynamicObjectCollection queryRecord) {
        if (queryRecord == null || queryRecord.isEmpty()) {
            return true;
        }
        HashSet<String> settleLots = new HashSet<String>(10);
        for (DynamicObject record : queryRecord) {
            String settleResult = record.getString("settleresult");
            Long purInBillId = record.getLong("purinbillid");
            if (!VMISettleResultEnum.SETTLEFAIL.getValue().equals(settleResult) && !VMISettleResultEnum.REVERSEFAIL.getValue().equals(settleResult) || purInBillId == null || Long.compare(purInBillId, 0L) == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u7b97\u7ed3\u679c\u4e3a\u201c\u7ed3\u7b97\u5931\u8d25\u201d\u6216\u201c\u53cd\u7ed3\u7b97\u5931\u8d25\u201d\u4e14\u865a\u5355\u4e0d\u4e3a\u7a7a\u7684\u6570\u636e\u91cd\u8bd5\u7ed3\u7b97\u3002", (String)"VMIRecordListPlugin_22", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                return true;
            }
            settleLots.add(record.getString("settlelotno"));
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_vmisettlerecord", (String)"id", (QFilter[])new QFilter[]{new QFilter("settlelotno", "in", settleLots)}, null);
        int settleLotRecordCount = dataSet.count("id", true);
        if (settleLotRecordCount > 5000) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u6b21\u91cd\u8bd5\u65f6\u7ed3\u7b97\u6279\u53f7\u4e0b\u7ed3\u7b97\u8bb0\u5f55\u4e0d\u80fd\u8d85\u8fc75000\u6761\uff0c\u8bf7\u5206\u6279\u91cd\u8bd5\u7ed3\u7b97\u3002", (String)"VMIRecordListPlugin_23", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            return true;
        }
        if (this.getSeletedPks().length != settleLotRecordCount) {
            ConfirmCallBackListener listener = new ConfirmCallBackListener(OPKEY_RETRYSETTLE, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u7ed3\u7b97\u6279\u53f7\u5173\u8054\u591a\u5f20\u7ed3\u7b97\u8bb0\u5f55\u5c06\u4e00\u8d77\u91cd\u8bd5\u7ed3\u7b97\uff0c\u662f\u5426\u786e\u8ba4\u64cd\u4f5c\uff1f", (String)"VMIRecordListPlugin_24", (String)"scmc-pm-vmi", (Object[])new Object[0]), MessageBoxOptions.OKCancel, listener);
            return true;
        }
        return false;
    }

    private Object[] getSeletedPks() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        return selectedRows.getPrimaryKeyValues();
    }

    private DynamicObjectCollection queryRecord(QFilter filter) {
        return QueryServiceHelper.query((String)"pm_vmisettlerecord", (String)"id,billno,settlelotno,settleresult,billentry.purinbillid as purinbillid", (QFilter[])new QFilter[]{filter});
    }

    private List<OperateErrorInfo> getHasTargetBillMsg(Map<String, Set<Long>> settleLotAndPurInBillIds) {
        if (CommonUtils.isNull(settleLotAndPurInBillIds)) {
            return null;
        }
        ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>(10);
        HashSet purInBillIdSet = new HashSet(10);
        settleLotAndPurInBillIds.values().forEach(row -> purInBillIdSet.addAll(row));
        if (purInBillIdSet.isEmpty()) {
            return null;
        }
        TableDefine busBillTablieDef = ConvertMetaServiceHelper.loadMainTableDefine((String)ENTITY_BUSBILL);
        Long busBillTableId = busBillTablieDef.getTableId();
        TableDefine finapBillTablieDef = ConvertMetaServiceHelper.loadMainTableDefine((String)ENTITY_FINAPBILL);
        Long finapBillTableId = finapBillTablieDef.getTableId();
        List partition = CommonUtil.partition(new ArrayList(purInBillIdSet), 1000);
        block0: for (int i = 0; i < partition.size(); ++i) {
            HashSet<Long> hasBusBillPurInBillIds = new HashSet<Long>(10);
            HashSet<Long> hasFinApBillPurInBillIds = new HashSet<Long>(10);
            List purInBillIds = partition.get(i);
            Map dirtTargetBills = BFTrackerServiceHelper.findDirtTargetBills((String)ENTITY_PURINBILL, (Long[])purInBillIds.toArray(new Long[0]));
            for (Map.Entry entry : dirtTargetBills.entrySet()) {
                Long key = (Long)entry.getKey();
                List bfRows = (List)entry.getValue();
                if (bfRows == null || bfRows.isEmpty()) continue;
                for (BFRow bfRow : bfRows) {
                    BFRowId id = bfRow.getId();
                    Long mainTableId = id.getMainTableId();
                    if (busBillTableId != null && mainTableId != null && busBillTableId.compareTo(mainTableId) == 0) {
                        hasBusBillPurInBillIds.add(key);
                        continue;
                    }
                    if (finapBillTableId == null || mainTableId == null || finapBillTableId.compareTo(mainTableId) != 0) continue;
                    hasFinApBillPurInBillIds.add(key);
                }
            }
            for (Map.Entry<Object, Object> entry : settleLotAndPurInBillIds.entrySet()) {
                OperateErrorInfo errorInfo;
                String key;
                Set purInBillIdByRecord = (Set)entry.getValue();
                if (this.hasSameElement(purInBillIdByRecord, hasBusBillPurInBillIds)) {
                    key = (String)entry.getKey();
                    if (errorInfos.size() >= 100) continue block0;
                    errorInfo = new OperateErrorInfo();
                    errorInfo.setLevel(ErrorLevel.Error);
                    errorInfo.setMessage(String.format(ResManager.loadKDString((String)"\u6240\u9009\u7ed3\u7b97\u6279\u53f7\u201c%1$s\u201d\u53cd\u7ed3\u7b97\u5931\u8d25\uff0c\u5176\u4e0b\u7ed3\u7b97\u8bb0\u5f55\u4e2d\u91c7\u8d2d\u5165\u5e93\u865a\u5355\u5df2\u7ecf\u4e0b\u63a8\u6682\u4f30\u5e94\u4ed8\u5355\u3002", (String)"VMIRecordListPlugin_25", (String)"scmc-pm-vmi", (Object[])new Object[0]), key));
                    errorInfos.add(errorInfo);
                }
                if (!this.hasSameElement(purInBillIdByRecord, hasFinApBillPurInBillIds)) continue;
                key = (String)entry.getKey();
                if (errorInfos.size() >= 100) continue block0;
                errorInfo = new OperateErrorInfo();
                errorInfo.setLevel(ErrorLevel.Error);
                errorInfo.setMessage(String.format(ResManager.loadKDString((String)"\u6240\u9009\u7ed3\u7b97\u6279\u53f7\u201c%1$s\u201d\u53cd\u7ed3\u7b97\u5931\u8d25\uff0c\u5176\u4e0b\u7ed3\u7b97\u8bb0\u5f55\u4e2d\u91c7\u8d2d\u5165\u5e93\u865a\u5355\u5df2\u7ecf\u4e0b\u63a8\u8d22\u52a1\u5e94\u4ed8\u5355\u3002", (String)"VMIRecordListPlugin_26", (String)"scmc-pm-vmi", (Object[])new Object[0]), key));
                errorInfos.add(errorInfo);
            }
        }
        return errorInfos;
    }

    private boolean hasSameElement(Collection<Long> col1, Collection<Long> col2) {
        if (col1 == null || col1.isEmpty()) {
            return false;
        }
        if (col2 == null || col2.isEmpty()) {
            return false;
        }
        for (Long id : col1) {
            if (!col2.contains(id)) continue;
            return true;
        }
        return false;
    }

    private DynamicObjectCollection querySelectRecord(Object[] ids) {
        if (ids == null || ids.length < 1) {
            return null;
        }
        QFilter filter = new QFilter("id", "in", (Object)ids);
        return QueryServiceHelper.query((String)"pm_vmisettlerecord", (String)"id,billno,settlelotno,settleresult", (QFilter[])new QFilter[]{filter});
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        log.info("afterDoOperation \u64cd\u4f5ckey " + operateKey);
        if (!OPKEY_SETTLEREVERSE.equals(operateKey) && !OPKEY_RETRYSETTLE.equals(operateKey)) {
            return;
        }
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        DynamicObjectCollection selectRecords = this.querySelectRecord(primaryKeyValues);
        HashSet settleLotNo = new HashSet(10);
        if (selectRecords != null && !selectRecords.isEmpty()) {
            selectRecords.forEach(record -> settleLotNo.add(record.getString("settlelotno")));
            if (OPKEY_SETTLEREVERSE.equals(operateKey)) {
                log.info("afterDoOperation\u6267\u884c\u53cd\u7ed3\u7b97" + SerializationUtils.toJsonString(settleLotNo));
                this.settleReverse(settleLotNo.toArray(new String[0]));
            } else if (OPKEY_RETRYSETTLE.equals(operateKey)) {
                this.retrySettle(settleLotNo.toArray(new String[0]));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String actionId = e.getCallBackId();
        if (!OPKEY_SETTLEREVERSE.equals(actionId) && !OPKEY_RETRYSETTLE.equals(actionId)) {
            return;
        }
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        DynamicObjectCollection selectRecords = this.querySelectRecord(primaryKeyValues);
        HashSet settleLotNo = new HashSet(10);
        if (selectRecords != null && !selectRecords.isEmpty()) {
            selectRecords.forEach(record -> settleLotNo.add(record.getString("settlelotno")));
            if (OPKEY_SETTLEREVERSE.equals(actionId)) {
                if (e.getResult() == MessageBoxResult.Yes) {
                    log.info("confirmCallBack\u6267\u884c\u53cd\u7ed3\u7b97" + SerializationUtils.toJsonString(settleLotNo));
                    this.settleReverse(settleLotNo.toArray(new String[0]));
                }
            } else if (OPKEY_RETRYSETTLE.equals(actionId) && e.getResult() == MessageBoxResult.Yes) {
                this.retrySettle(settleLotNo.toArray(new String[0]));
            }
        }
    }

    private void retrySettle(String[] settlelotnos) {
        OperationResult result = VMISettleRetryService.retrySettle(settlelotnos);
        if (result != null) {
            if (result.isSuccess() && result.getAllErrorOrValidateInfo().isEmpty()) {
                this.getView().showSuccessNotification(result.getMessage());
            } else {
                this.getView().showOperationResult(result);
            }
        }
        this.getView().invokeOperation("refresh");
    }

    private void settleReverse(String[] settlelotnos) {
        OperationResult result = VMISettleReverseService.settleReverse(settlelotnos);
        if (result != null) {
            if (result.isSuccess() && result.getAllErrorOrValidateInfo().isEmpty()) {
                this.getView().showSuccessNotification(result.getMessage());
            } else {
                this.getView().showOperationResult(result);
            }
        }
        this.getView().invokeOperation("refresh");
    }
}

