/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.vmi.business.service.settle.VMISettleRetryService;
import kd.scmc.pm.vmi.business.service.settle.VMISettleReverseService;
import kd.scmc.pm.vmi.common.enums.VMISettleOpEnum;
import kd.scmc.pm.vmi.common.enums.VMISettleResultEnum;

public class VMIRecordPlugin
extends AbstractBillPlugIn {
    private static final String OPKEY_SETTLEREVERSE = "settlereverse";
    private static final String OPKEY_RETRYSETTLE = "retrysettle";
    private static final String CACHE_RECORDLOTNO = "settlelotno";
    private static final String ENTITY_PURINBILL = "im_purinbill";
    private static final String ENTITY_BUSBILL = "ap_busbill";
    private static final String ENTITY_FINAPBILL = "ap_finapbill";
    private static String[] excludeItemKeys = new String[]{"baritemap", "settlereverse", "bar_close", "singlesettlereverse"};
    private static final int MAX_SELECTEDCOUNT = 5000;

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (!Arrays.asList(excludeItemKeys).contains(itemKey)) {
            String settleResultStr;
            Object settleResult = this.getModel().getValue("settleresult");
            String string = settleResultStr = settleResult == null ? "" : settleResult.toString();
            if (!VMISettleResultEnum.SETTLESCUESS.getValue().equals(settleResultStr)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ed3\u7b97\u8bb0\u5f55\u4e2d\u5305\u542b\u7ed3\u7b97\u7ed3\u679c\u4e3a\u5931\u8d25\u7684\u6570\u636e\uff0c\u8bf7\u7ed3\u7b97\u6210\u529f\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"VMIRecordPlugin_8", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String opName;
        super.beforeDoOperation(e);
        String operateKey = ((AbstractOperate)e.getSource()).getOperateKey();
        Object settleLotNo = this.getModel().getValue(CACHE_RECORDLOTNO);
        if (!OPKEY_RETRYSETTLE.equals(operateKey) && !OPKEY_SETTLEREVERSE.equals(operateKey)) {
            return;
        }
        String string = opName = OPKEY_SETTLEREVERSE.equals(operateKey) ? VMISettleOpEnum.REVERSE.getName() : VMISettleOpEnum.RETRY.getName();
        if (StringUtils.isBlank((Object)settleLotNo)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ed3\u7b97\u6279\u53f7\uff0c\u624d\u80fd\u201c%1$s\u201d\u3002", (String)"VMIRecordPlugin_14", (String)"scmc-pm-vmi", (Object[])new Object[0]), opName));
            e.setCancel(true);
            return;
        }
        boolean isCancel = false;
        if (OPKEY_RETRYSETTLE.equals(operateKey)) {
            isCancel = this.checkRetry();
        } else if (OPKEY_SETTLEREVERSE.equals(operateKey)) {
            isCancel = this.checkReverse();
        }
        if (isCancel) {
            e.setCancel(true);
            return;
        }
    }

    private boolean checkReverse() {
        IDataModel model = this.getModel();
        String currentResult = (String)model.getValue("settleresult");
        if (!VMISettleResultEnum.SETTLESCUESS.getValue().equals(currentResult) && !VMISettleResultEnum.REVERSEFAIL.getValue().equals(currentResult)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u7b97\u7ed3\u679c\u4e3a\u201c\u7ed3\u7b97\u6210\u529f\u201d\u6216\u201c\u53cd\u7ed3\u7b97\u5931\u8d25\u201d\u7684\u6570\u636e\u53cd\u7ed3\u7b97\u3002", (String)"VMIRecordPlugin_15", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            return true;
        }
        String settleLotNo = (String)this.getModel().getValue(CACHE_RECORDLOTNO);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_vmisettlerecord", (String)"id,settleresult,settlelotno,billentry.purinbillid as purinbillid", (QFilter[])new QFilter[]{new QFilter(CACHE_RECORDLOTNO, "=", (Object)settleLotNo)}, null);
        HashSet<Long> purInBillIds = new HashSet<Long>(10);
        HashSet<Long> recordIds = new HashSet<Long>(10);
        for (Row row : dataSet) {
            String settleResult = row.getString("settleresult");
            if (VMISettleResultEnum.SETTLEFAIL.getValue().equals(settleResult)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u7ed3\u7b97\u6279\u53f7\u201c%1$s\u201d\u53cd\u7ed3\u7b97\u5931\u8d25\uff0c\u5176\u4e0b\u7ed3\u7b97\u8bb0\u5f55\u4e2d\u5b58\u5728\u7ed3\u7b97\u5931\u8d25\u7684\u6570\u636e\u3002", (String)"VMIRecordPlugin_16", (String)"scmc-pm-vmi", (Object[])new Object[0]), settleLotNo));
                return true;
            }
            recordIds.add(row.getLong("id"));
            purInBillIds.add(row.getLong("purinbillid"));
        }
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)ENTITY_PURINBILL, (Long[])purInBillIds.toArray(new Long[0]));
        HashSet busbillIds = (HashSet)targetBills.get(ENTITY_BUSBILL);
        HashSet finapBillIds = (HashSet)targetBills.get(ENTITY_FINAPBILL);
        if (busbillIds != null && busbillIds.size() > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u7ed3\u7b97\u6279\u53f7\u201c%1$s\u201d\u53cd\u7ed3\u7b97\u5931\u8d25\uff0c\u5176\u4e0b\u7ed3\u7b97\u8bb0\u5f55\u4e2d\u91c7\u8d2d\u5165\u5e93\u865a\u5355\u5df2\u7ecf\u4e0b\u63a8\u6682\u4f30\u5e94\u4ed8\u5355\u3002", (String)"VMIRecordPlugin_17", (String)"scmc-pm-vmi", (Object[])new Object[0]), settleLotNo));
            return true;
        }
        if (finapBillIds != null && finapBillIds.size() > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u7ed3\u7b97\u6279\u53f7\u201c%1$s\u201d\u53cd\u7ed3\u7b97\u5931\u8d25\uff0c\u5176\u4e0b\u7ed3\u7b97\u8bb0\u5f55\u4e2d\u91c7\u8d2d\u5165\u5e93\u865a\u5355\u5df2\u7ecf\u4e0b\u63a8\u8d22\u52a1\u5e94\u4ed8\u5355\u3002", (String)"VMIRecordPlugin_18", (String)"scmc-pm-vmi", (Object[])new Object[0]), settleLotNo));
            return true;
        }
        if (recordIds.size() > 1) {
            ConfirmCallBackListener listener = new ConfirmCallBackListener(OPKEY_SETTLEREVERSE, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u7ed3\u7b97\u6279\u53f7\u5173\u8054\u591a\u5f20\u7ed3\u7b97\u8bb0\u5f55\u5c06\u4e00\u8d77\u53cd\u7ed3\u7b97\uff0c\u662f\u5426\u786e\u8ba4\u64cd\u4f5c\uff1f", (String)"VMIRecordPlugin_19", (String)"scmc-pm-vmi", (Object[])new Object[0]), MessageBoxOptions.OKCancel, listener);
            return true;
        }
        return false;
    }

    private boolean checkRetry() {
        IDataModel model = this.getModel();
        String result = (String)model.getValue("settleresult");
        String settleLotNo = (String)this.getModel().getValue(CACHE_RECORDLOTNO);
        DynamicObjectCollection billEntry = model.getDataEntity(true).getDynamicObjectCollection("billentry");
        boolean hasTargetBill = true;
        if (CommonUtils.isNull((Object)billEntry)) {
            return true;
        }
        for (DynamicObject row : billEntry) {
            Long purInBillId = row.getLong("purinbillid");
            if (purInBillId != null && !purInBillId.equals(0L)) continue;
            hasTargetBill = false;
        }
        if (!VMISettleResultEnum.SETTLEFAIL.getValue().equals(result) && !VMISettleResultEnum.REVERSEFAIL.getValue().equals(result) || !hasTargetBill) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u7b97\u7ed3\u679c\u4e3a\u201c\u7ed3\u7b97\u5931\u8d25\u201d\u6216\u201c\u53cd\u7ed3\u7b97\u5931\u8d25\u201d\u4e14\u865a\u5355\u4e0d\u4e3a\u7a7a\u7684\u6570\u636e\u91cd\u8bd5\u7ed3\u7b97\u3002", (String)"VMIRecordPlugin_20", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            return true;
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_vmisettlerecord", (String)"id", (QFilter[])new QFilter[]{new QFilter(CACHE_RECORDLOTNO, "=", (Object)settleLotNo)}, null);
        int settleLotRecordCount = dataSet.count("id", true);
        if (settleLotRecordCount > 1) {
            ConfirmCallBackListener listener = new ConfirmCallBackListener(OPKEY_RETRYSETTLE, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u7ed3\u7b97\u6279\u53f7\u5173\u8054\u591a\u5f20\u7ed3\u7b97\u8bb0\u5f55\u5c06\u4e00\u8d77\u91cd\u8bd5\u7ed3\u7b97\uff0c\u662f\u5426\u786e\u8ba4\u64cd\u4f5c\uff1f", (String)"VMIRecordPlugin_21", (String)"scmc-pm-vmi", (Object[])new Object[0]), MessageBoxOptions.OKCancel, listener);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if (OPKEY_SETTLEREVERSE.equals(operateKey)) {
            OperationResult operationResult = e.getOperationResult();
            if (!operationResult.isSuccess()) {
                return;
            }
            IDataModel model = this.getModel();
            String settlelotno = (String)model.getValue(CACHE_RECORDLOTNO);
            String billno = (String)model.getValue("billno");
            if (!StringUtils.isNotBlank((CharSequence)settlelotno)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u53cd\u7ed3\u7b97\u5931\u8d25\uff0c\u7ed3\u7b97\u6279\u53f7\u4e3a\u7a7a\u3002", (String)"VMIRecordPlugin_1", (String)"scmc-pm-vmi", (Object[])new Object[0]), billno));
                return;
            }
            QFilter filter = new QFilter(CACHE_RECORDLOTNO, "=", (Object)settlelotno);
            DynamicObjectCollection records = QueryServiceHelper.query((String)"pm_vmisettlerecord", (String)"id", (QFilter[])new QFilter[]{filter});
            ArrayList recordIds = new ArrayList();
            records.forEach(record -> recordIds.add((Long)record.get("id")));
            this.getView().getPageCache().put(CACHE_RECORDLOTNO, settlelotno);
            if (recordIds.size() > 1) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(operateKey, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u7ed3\u7b97\u6279\u53f7\u5173\u8054\u591a\u5f20\u7ed3\u7b97\u8bb0\u5f55\uff0c\u662f\u5426\u4e00\u540c\u53cd\u7ed3\u7b97\uff1f", (String)"VMIRecordPlugin_0", (String)"scmc-pm-vmi", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                return;
            }
            this.settleReverse(settlelotno);
            return;
        }
        if (!OPKEY_RETRYSETTLE.equals(operateKey)) {
            if (!"singlesettlereverse".equals(operateKey)) return;
            this.getView().invokeOperation("refresh");
            return;
        }
        OperationResult operationResult = e.getOperationResult();
        if (!operationResult.isSuccess()) {
            return;
        }
        String settleLotNo = (String)this.getModel().getValue(CACHE_RECORDLOTNO);
        DynamicObjectCollection currentLotNoRecords = QueryServiceHelper.query((String)"pm_vmisettlerecord", (String)"id,settleresult,settlelotno", (QFilter[])new QFilter[]{new QFilter(CACHE_RECORDLOTNO, "=", (Object)settleLotNo)});
        if (currentLotNoRecords.size() > 1) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(operateKey, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u7ed3\u7b97\u6279\u53f7\u5173\u8054\u591a\u5f20\u7ed3\u7b97\u8bb0\u5f55\uff0c\u662f\u5426\u540c\u65f6\u91cd\u8bd5\u7ed3\u7b97\uff1f", (String)"VMIRecordPlugin_12", (String)"scmc-pm-vmi", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            return;
        }
        this.retrySettle(settleLotNo);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String settleLotNo;
        super.confirmCallBack(e);
        String actionId = e.getCallBackId();
        if (OPKEY_SETTLEREVERSE.equals(actionId)) {
            if (e.getResult() == MessageBoxResult.Yes) {
                String settlelotno = (String)this.getModel().getValue(CACHE_RECORDLOTNO);
                this.settleReverse(settlelotno);
            }
        } else if (OPKEY_RETRYSETTLE.equals(actionId) && e.getResult() == MessageBoxResult.Yes && this.validateRecord(settleLotNo = (String)this.getModel().getValue(CACHE_RECORDLOTNO))) {
            this.retrySettle(settleLotNo);
        }
    }

    private boolean validateRecord(String settleLotNo) {
        DynamicObjectCollection currentLotNoRecords = QueryServiceHelper.query((String)"pm_vmisettlerecord", (String)"id,settleresult,settlelotno,billentry.purinbillid", (QFilter[])new QFilter[]{new QFilter(CACHE_RECORDLOTNO, "=", (Object)settleLotNo)});
        for (DynamicObject row : currentLotNoRecords) {
            Long purinBillId = row.getLong("billentry.purinbillid");
            if (purinBillId != null && !purinBillId.equals(0L)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u5355\u636e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u91cd\u8bd5\u7ed3\u7b97\u3002", (String)"VMIRecordPlugin_13", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void settleReverse(String settlelotno) {
        OperationResult result = VMISettleReverseService.settleReverse(settlelotno);
        if (result == null) {
            return;
        }
        this.getView().showOperationResult(result);
        this.getView().invokeOperation("refresh");
    }

    private void retrySettle(String settleLotNo) {
        if (!this.validateRecord(settleLotNo)) {
            return;
        }
        OperationResult operationResult = VMISettleRetryService.retrySettle(settleLotNo);
        if (operationResult == null) {
            return;
        }
        this.getView().showOperationResult(operationResult);
        this.getView().invokeOperation("refresh");
    }
}

