/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.formplugin;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scmc.pm.vmi.common.utils.DateUtil;

public class VMISettleLogPlugin
extends AbstractBillPlugIn {
    private static final Log log = LogFactory.getLog(VMISettleLogPlugin.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String progressJson = (String)this.getModel().getValue("progressjson_tag");
        if (StringUtils.isBlank((CharSequence)progressJson)) {
            return;
        }
        List list = (List)SerializationUtils.fromJsonString((String)progressJson, List.class);
        if (list == null || list.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("progressentry", list.size());
        Date beginTime = null;
        Date endTime = null;
        try {
            for (int i = 0; i < list.size(); ++i) {
                Map map = (Map)list.get(i);
                if (i == 0) {
                    beginTime = DateUtil.getDateFormat(TimeServiceHelper.getDateTimeFormatString()).parse(map.get("begintime").toString());
                }
                if (i == list.size() - 1) {
                    endTime = DateUtil.getDateFormat(TimeServiceHelper.getDateTimeFormatString()).parse(map.get("endtime").toString());
                }
                for (Map.Entry entry : map.entrySet()) {
                    this.getModel().setValue((String)entry.getKey(), entry.getValue(), i);
                }
            }
            if (endTime != null && beginTime != null) {
                long costTime = endTime.getTime() - beginTime.getTime();
                this.getModel().setValue("allcosttime", (Object)BigDecimal.valueOf(costTime).divide(BigDecimal.valueOf(1000L), 1, 4));
            }
        }
        catch (Exception ee) {
            log.error("\u89e3\u6790\u8fdb\u5ea6json\u51fa\u9519", (Throwable)ee);
        }
        this.getModel().setDataChanged(false);
    }
}

