/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.opplugin.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.business.helper.FetchPriceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.business.helper.AmountHelper;
import kd.scmc.pm.business.pojo.AmountInfo;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.vmi.business.helper.VMIFocusSettleRuleHelper;
import kd.scmc.pm.vmi.business.helper.VMISettleModelHelper;
import kd.scmc.pm.vmi.business.pojo.VMIFocusSettleRuleInfo;
import kd.scmc.pm.vmi.business.pojo.VMISettleModelInfo;
import kd.scmc.pm.vmi.business.service.settle.async.VMIAsyncSettle;

public class TransferBillAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(TransferBillAuditOp.class);
    private final String CUR_AMTPRECISION = "amtprecision";
    private final BigDecimal ZERO = BigDecimal.ZERO;
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private static final String QUOTSIGN = "$$";
    private static final String QUOTSIGN_SPLIT = "\\$\\$";
    private static final String SETTLESIGN = "&";
    private static final String[] fields = new String[]{"istax", "taxrate", "taxrateid", "price", "priceandtax"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        Map quoteKeyResult;
        super.onPreparePropertys(e);
        e.getFieldKeys().add("purorg");
        e.getFieldKeys().add("settlecurrency");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("srcbillform");
        e.getFieldKeys().add("billentry");
        e.getFieldKeys().add("seq");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("amountandtax");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("entryreqorg");
        e.getFieldKeys().add("entrysettleorg");
        for (String field : fields) {
            e.getFieldKeys().add(field);
        }
        Map quoteResultFieldMap = FetchPriceHelper.fetchPriceConditonKey(new HashSet(), (String)"pm_transferbill", (boolean)false);
        if (quoteResultFieldMap != null && quoteResultFieldMap.get(Long.valueOf("0")) != null && !(quoteKeyResult = (Map)quoteResultFieldMap.get(Long.valueOf("0"))).isEmpty() && quoteKeyResult.get("success") instanceof Boolean && ((Boolean)quoteKeyResult.get("success")).booleanValue()) {
            List headFields = (List)quoteKeyResult.get("header");
            List entryFields = (List)quoteKeyResult.get("entry");
            List allresultFields = (List)quoteKeyResult.get("allresult");
            this.addQuoteField4Selector(e, headFields);
            this.addQuoteField4Selector(e, entryFields);
            this.addQuoteField4Selector(e, allresultFields);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        try (TraceSpan auditSpan = Tracer.create((String)"TransferBillAuditOp.audit", (String)"audit");){
            DynamicObject[] bills = e.getDataEntities();
            if (bills == null || bills.length < 1) {
                return;
            }
            int length = bills.length;
            HashMap<Long, List<DynamicObject>> paramMap = new HashMap<Long, List<DynamicObject>>(length);
            ArrayList<VMIFocusSettleRuleInfo> paramList = new ArrayList<VMIFocusSettleRuleInfo>(length);
            String VMISettleSrcBill = bills[0].getString("srcbillform.number");
            VMISettleModelInfo modelInfo = VMISettleModelHelper.getVMISettleModelInfo(VMISettleSrcBill);
            for (DynamicObject bill : bills) {
                Long purOrgID = bill.get("purorg") instanceof DynamicObject ? (Long)bill.getDynamicObject("purorg").getPkValue() : null;
                ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)paramMap.get(purOrgID);
                if (list == null) {
                    list = new ArrayList<DynamicObject>();
                    list.add(bill);
                    paramMap.put(purOrgID, list);
                } else {
                    list.add(bill);
                }
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : entrys) {
                    Long entryReqOrgID = entry.get("entryreqorg") instanceof DynamicObject ? (Long)entry.getDynamicObject("entryreqorg").getPkValue() : null;
                    Long materialID = entry.get("material") instanceof DynamicObject ? Long.valueOf(entry.getDynamicObject("material").getLong("masterid.id")) : null;
                    VMIFocusSettleRuleInfo ruleInfo = new VMIFocusSettleRuleInfo();
                    ruleInfo.setMaterial(materialID);
                    ruleInfo.setPurOrg(purOrgID);
                    ruleInfo.setReqOrg(entryReqOrgID);
                    paramList.add(ruleInfo);
                }
            }
            this.setEntrySettleOrg(bills, paramList);
            this.quoteAndCalAmount(paramMap, modelInfo);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        if (bills == null || bills.length < 1) {
            return;
        }
        final ArrayList<Long> billIds = new ArrayList<Long>(10);
        for (DynamicObject bill : bills) {
            String billStatus = bill.getString("billstatus");
            if (!StatusEnum.AUDIT.getValue().equals(billStatus)) continue;
            billIds.add((Long)bill.getPkValue());
        }
        if (!CommonUtils.isNull(billIds)) {
            try {
                TX.addCommitListener((CommitListener)new CommitListener(){

                    public void onEnded(boolean rollbacked) {
                        if (!rollbacked) {
                            VMIAsyncSettle.asyncSettle(billIds, "B");
                        }
                    }
                });
            }
            catch (IllegalStateException ex) {
                log.info("TransferBillAuditOp No transaction exists " + ex.getMessage());
            }
        }
    }

    private void setEntrySettleOrg(DynamicObject[] bills, List<VMIFocusSettleRuleInfo> paramList) {
        if (bills == null || paramList == null) {
            return;
        }
        Map<String, Long> settleOrgIds = VMIFocusSettleRuleHelper.getSettleOrgMap(paramList);
        log.info("\u83b7\u53d6\u7684\u7ed3\u7b97\u7ec4\u7ec7\u4fe1\u606f\u4e3a\uff1a" + settleOrgIds);
        if (settleOrgIds == null || settleOrgIds.isEmpty()) {
            return;
        }
        for (DynamicObject bill : bills) {
            if (bill == null) continue;
            Long purOrgID = bill.get("purorg") instanceof DynamicObject ? (Long)bill.getDynamicObject("purorg").getPkValue() : null;
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                String key;
                Long value;
                Long materialID;
                if (entry == null) continue;
                Long entryReqOrgID = entry.get("entryreqorg") instanceof DynamicObject ? (Long)entry.getDynamicObject("entryreqorg").getPkValue() : null;
                Long l = materialID = entry.get("material") instanceof DynamicObject ? Long.valueOf(entry.getDynamicObject("material").getLong("masterid.id")) : null;
                if (purOrgID == null || entryReqOrgID == null || materialID == null || (value = settleOrgIds.get(key = purOrgID + SETTLESIGN + entryReqOrgID + SETTLESIGN + materialID)) == null || value == 0L) continue;
                entry.set("entrysettleorg", (Object)value);
            }
        }
    }

    private void quoteAndCalAmount(Map<Long, List<DynamicObject>> map, VMISettleModelInfo modelInfo) {
        if (map == null || modelInfo == null || map.isEmpty() || !modelInfo.getIsQuotePrice().booleanValue()) {
            return;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        this.quoteByBills(map, resultMap);
        if (resultMap.isEmpty()) {
            return;
        }
        HashMap<Long, BigDecimal> allTaxRate = new HashMap<Long, BigDecimal>(10);
        for (List<DynamicObject> values : map.values()) {
            for (DynamicObject bill : values) {
                if (bill == null) break;
                Long id = (Long)bill.getPkValue();
                DynamicObject settlecurrency = bill.getDynamicObject("settlecurrency");
                int amtPrecision = settlecurrency == null ? 10 : settlecurrency.getInt("amtprecision");
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : entrys) {
                    this.calRowAmountInfo(id, entry, resultMap, amtPrecision, allTaxRate);
                }
            }
        }
    }

    private Map<Long, BigDecimal> getAllTaxRateIdAndRate() {
        HashMap<Long, BigDecimal> map = new HashMap<Long, BigDecimal>(10);
        Map taxRateMap = BusinessDataServiceHelper.loadFromCache((String)"bd_taxrate", (String)"id,taxrate", (QFilter[])new QFilter[0]);
        if (taxRateMap != null && !taxRateMap.isEmpty()) {
            taxRateMap.entrySet().forEach(entry -> map.put((Long)entry.getKey(), ((DynamicObject)entry.getValue()).getBigDecimal("taxrate")));
        }
        return map;
    }

    private void quoteByBills(Map<Long, List<DynamicObject>> map, Map<String, Object> resultMap) {
        try {
            Map priceResult = FetchPriceHelper.integrationFetchPrice(map, (String)"pm_transferbill", new HashMap());
            if (priceResult != null) {
                priceResult.forEach((k, v) -> {
                    if (v != null && !v.isEmpty() && v.get("success") instanceof Boolean && ((Boolean)v.get("success")).booleanValue()) {
                        resultMap.putAll((Map<String, Object>)v);
                    }
                });
            }
        }
        catch (Exception e) {
            log.error("mpscmm-msbd : fetchPriceHelper exception --> ", (Throwable)e);
        }
    }

    private void calRowAmountInfo(Long id, DynamicObject entry, Map<String, Object> resultMap, int amtPrecision, Map<Long, BigDecimal> allTaxRate) {
        if (id == null || entry == null || resultMap == null || entry.getPkValue() == null) {
            return;
        }
        Long entryId = (Long)entry.getPkValue();
        for (Map.Entry<String, Object> entrySet : resultMap.entrySet()) {
            String field;
            String[] split;
            String key = entrySet.getKey();
            Object value = entrySet.getValue();
            StringBuilder keyStr = new StringBuilder();
            keyStr.append(id).append(QUOTSIGN).append(entryId).append(QUOTSIGN);
            if (key == null || !key.contains(keyStr.toString()) || (split = key.split(QUOTSIGN_SPLIT)) == null || split.length <= 0 || !StringUtils.isNotBlank((CharSequence)(field = split[split.length - 1])) || "iscover".equals(field)) continue;
            entry.set(field, value);
        }
        this.calAmount(entry, amtPrecision, allTaxRate);
    }

    private void calAmount(DynamicObject entry, int currencyAmtPrecision, Map<Long, BigDecimal> allTaxRate) {
        BigDecimal qty = entry.getBigDecimal("qty");
        BigDecimal price = entry.getBigDecimal("price");
        Boolean isTax = entry.getBoolean("istax");
        BigDecimal priceAndTax = entry.getBigDecimal("priceandtax");
        BigDecimal taxRate = entry.getBigDecimal("taxrate");
        Object taxRateId = entry.get("taxrateid");
        if (taxRateId != null && taxRate != null && taxRate.compareTo(BigDecimal.ZERO) == 0) {
            BigDecimal queryTaxRate;
            Long taxId = null;
            if (taxRateId instanceof DynamicObject) {
                taxId = (Long)((DynamicObject)taxRateId).getPkValue();
            } else if (taxRateId instanceof Long) {
                taxId = (Long)taxRateId;
            }
            if (allTaxRate.isEmpty()) {
                allTaxRate.putAll(this.getAllTaxRateIdAndRate());
            }
            if ((queryTaxRate = allTaxRate.get(taxId)) != null) {
                taxRate = queryTaxRate;
                entry.set("taxrate", (Object)taxRate);
            }
        }
        AmountInfo amountInfo = new AmountInfo();
        amountInfo.setTax(isTax.booleanValue());
        amountInfo.setQty(qty);
        amountInfo.setPrice(price);
        amountInfo.setPriceAndTax(priceAndTax);
        amountInfo.setTaxRate(taxRate);
        amountInfo.setSettlePricePrecision(10);
        amountInfo.setSettleAmtPrecision(currencyAmtPrecision);
        amountInfo = AmountHelper.getAmount((AmountInfo)amountInfo);
        if (isTax.booleanValue()) {
            entry.set("price", (Object)amountInfo.getPrice());
        } else {
            entry.set("priceandtax", (Object)amountInfo.getPriceAndTax());
        }
        BigDecimal amountAndTax = amountInfo.getAmountAndTax();
        entry.set("amountandtax", (Object)amountAndTax);
    }

    private void addQuoteField4Selector(PreparePropertysEventArgs e, List<String> quoteFields) {
        if (quoteFields != null && quoteFields.size() > 0) {
            quoteFields.forEach(f -> {
                if (!e.getFieldKeys().contains(f)) {
                    e.getFieldKeys().add(f);
                }
            });
        }
    }
}

