/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.opplugin.opplugin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.scmc.pm.utils.DateUtil;
import kd.scmc.pm.vmi.business.service.settle.VMISettleRetryService;
import kd.scmc.pm.vmi.common.enums.VMISettleResultEnum;
import kd.scmc.pm.vmi.common.utils.CommonUtil;

public class VMIAutoRetrySettleTask
extends AbstractTask {
    private Log log = LogFactory.getLog(VMIAutoRetrySettleTask.class);
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public void execute(RequestContext context, Map<String, Object> parm) throws KDException {
        this.log.info("VMI\u81ea\u52a8\u91cd\u8bd5\u7ed3\u7b97\u53c2\u6570\u4fe1\u606f" + parm);
        if (!this.checkEffectiveParam(parm)) {
            return;
        }
        List<QFilter> qfilters = this.getVMIRetrySettleFilter(parm);
        HashSet<String> settleLotSet = this.queryVMISRAndGetSettleLotNo(qfilters);
        OperationResult retryOpR = this.retrySettle(settleLotSet);
        this.sendSettleResultToUser(retryOpR);
    }

    private OperationResult retrySettle(HashSet<String> settleLotSet) {
        if (settleLotSet == null || settleLotSet.isEmpty()) {
            return null;
        }
        return VMISettleRetryService.retrySettle(settleLotSet.toArray(new String[0]));
    }

    private void sendSettleResultToUser(OperationResult retryOpR) {
        if (retryOpR == null) {
            return;
        }
        int billCount = retryOpR.getBillCount();
        List successPkIds = retryOpR.getSuccessPkIds();
        int succeccCount = successPkIds.size();
        String msg = String.format(ResManager.loadKDString((String)"VMI\u91cd\u8bd5\u7ed3\u7b97\u8c03\u5ea6\u4f5c\u4e1a\uff0c\u91cd\u8bd5%1$s\u5355\uff0c\u6210\u529f%2$s\u5355\uff0c\u5931\u8d25%3$s\u5355\uff0c\u5982\u6709\u5931\u8d25\u8bf7\u67e5\u770bVMI\u7ed3\u7b97\u8bb0\u5f55\u7ed3\u7b97\u8be6\u60c5\u3002", (String)"VMIAutoRetrySettleTask_9", (String)"scmc-pm-vmi", (Object[])new Object[0]), billCount, succeccCount, billCount - succeccCount);
        this.sendMsgToUser(msg, true);
    }

    private HashSet<String> queryVMISRAndGetSettleLotNo(List<QFilter> qfilters) {
        HashSet<String> settleLotSet = new HashSet<String>(10);
        if (qfilters == null || qfilters.size() == 0) {
            return settleLotSet;
        }
        DataSet recordDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_vmisettlerecord", (String)this.getQueryVMISRFieldKeys(), (QFilter[])qfilters.toArray(new QFilter[qfilters.size()]), (String)"billentry.srcbillform,settlelotno");
        Map<String, VirtualBillMapping> recordMap = this.buildVMIInfoMap(recordDataSet);
        if (recordMap.isEmpty()) {
            return settleLotSet;
        }
        List<Map<String, VirtualBillMapping>> partition = CommonUtil.partition(recordMap, 100);
        for (int i = 0; i < partition.size(); ++i) {
            Map<String, VirtualBillMapping> oneBatch = partition.get(i);
            settleLotSet.addAll(this.canRetrySettleLot(oneBatch));
        }
        return settleLotSet;
    }

    private HashSet<String> canRetrySettleLot(Map<String, VirtualBillMapping> oneBatch) {
        HashSet<String> result = new HashSet<String>(10);
        Map<String, HashSet<Long>> entityAndBillIdMap = this.getEntityAndBillIdMap(oneBatch);
        Map<String, HashSet<Long>> invalidBillIds = this.queryVirBill(entityAndBillIdMap);
        Iterator<Map.Entry<String, VirtualBillMapping>> iterator = oneBatch.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, VirtualBillMapping> entry = iterator.next();
            VirtualBillMapping value = entry.getValue();
            String invEntity = value.getInvEntity();
            List<Long> invBillIds = value.getInvBillIds();
            String purinEntity = value.getPurinEntity();
            List<Long> purInBillIds = value.getPurInBillIds();
            HashSet<Long> invalidInvBillIds = invalidBillIds.get(invEntity);
            HashSet<Long> invalidPurinBillIds = invalidBillIds.get(purinEntity);
            if ((invalidInvBillIds == null || invalidInvBillIds.isEmpty() || !this.hasInvalidBillId(invBillIds, invalidInvBillIds)) && (invalidPurinBillIds == null || invalidPurinBillIds.isEmpty() || !this.hasInvalidBillId(purInBillIds, invalidPurinBillIds))) continue;
            iterator.remove();
        }
        result.addAll(oneBatch.keySet());
        return result;
    }

    private boolean hasInvalidBillId(List<Long> virBillIds, HashSet<Long> invalidBillIds) {
        if (virBillIds != null && !virBillIds.isEmpty()) {
            for (Long virBillId : virBillIds) {
                if (!invalidBillIds.contains(virBillId)) continue;
                return true;
            }
        }
        return false;
    }

    private Map<String, HashSet<Long>> queryVirBill(Map<String, HashSet<Long>> entityAndBillIdMap) {
        HashMap<String, HashSet<Long>> result = new HashMap<String, HashSet<Long>>(10);
        for (Map.Entry<String, HashSet<Long>> entry : entityAndBillIdMap.entrySet()) {
            String entity = entry.getKey();
            HashSet<Long> billIds = entry.getValue();
            if (StringUtils.isBlank((CharSequence)entity)) {
                result.put(entity, billIds);
                continue;
            }
            QFilter filter = new QFilter("id", "in", billIds);
            DynamicObjectCollection id = QueryServiceHelper.query((String)entity, (String)"id", (QFilter[])new QFilter[]{filter});
            ArrayList billIds4DB = new ArrayList((int)((double)id.size() / 0.75 + 1.0));
            id.forEach(dym -> billIds4DB.add(dym.getLong("id")));
            billIds.removeAll(billIds4DB);
            if (billIds.isEmpty()) continue;
            result.put(entity, billIds);
        }
        return result;
    }

    private Map<String, HashSet<Long>> getEntityAndBillIdMap(Map<String, VirtualBillMapping> oneBatch) {
        HashMap<String, HashSet<Long>> entityAndBillIdMap = new HashMap<String, HashSet<Long>>(10);
        if (oneBatch == null || oneBatch.isEmpty()) {
            return entityAndBillIdMap;
        }
        for (VirtualBillMapping mapping : oneBatch.values()) {
            String invEntity = mapping.getInvEntity();
            List<Long> invBillIds = mapping.getInvBillIds();
            List<Long> purInBillIds = mapping.getPurInBillIds();
            String purinEntity = mapping.getPurinEntity();
            HashSet<Long> allInvBillIds = (HashSet<Long>)entityAndBillIdMap.get(invEntity);
            if (allInvBillIds == null) {
                allInvBillIds = new HashSet<Long>(10);
            }
            allInvBillIds.addAll(invBillIds);
            entityAndBillIdMap.put(invEntity, allInvBillIds);
            HashSet<Long> allPurInBillIds = (HashSet<Long>)entityAndBillIdMap.get(purinEntity);
            if (allPurInBillIds == null) {
                allPurInBillIds = new HashSet<Long>(10);
            }
            allPurInBillIds.addAll(purInBillIds);
            entityAndBillIdMap.put(purinEntity, allPurInBillIds);
        }
        return entityAndBillIdMap;
    }

    private boolean checkEffectiveParam(Map<String, Object> parm) {
        DynamicObject purOrg;
        if (parm == null || parm.isEmpty()) {
            this.sendMsgToUser(ResManager.loadKDString((String)"VMI\u81ea\u52a8\u91cd\u8bd5\u7ed3\u7b97\u53c2\u6570\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884cVMI\u91cd\u8bd5\u7ed3\u7b97\u3002", (String)"VMIAutoRetrySettleTask_1", (String)"scmc-pm-vmi", (Object[])new Object[0]), false);
            return false;
        }
        String invOrgNumber = (String)parm.get("invorg_no");
        if (StringUtils.isBlank((CharSequence)invOrgNumber)) {
            this.sendMsgToUser(ResManager.loadKDString((String)"VMI\u81ea\u52a8\u91cd\u8bd5\u7ed3\u7b97\u5e93\u5b58\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"VMIAutoRetrySettleTask_2", (String)"scmc-pm-vmi", (Object[])new Object[0]), false);
            return false;
        }
        DynamicObject invOrg = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)invOrgNumber)});
        if (invOrg == null) {
            this.sendMsgToUser(ResManager.loadKDString((String)"VMI\u81ea\u52a8\u91cd\u8bd5\u7ed3\u7b97\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"VMIAutoRetrySettleTask_3", (String)"scmc-pm-vmi", (Object[])new Object[0]), false);
            return false;
        }
        String purOrgNo = (String)parm.get("purorg_no");
        if (StringUtils.isNotBlank((CharSequence)purOrgNo) && (purOrg = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)purOrgNo)})) == null) {
            this.sendMsgToUser(ResManager.loadKDString((String)"VMI\u81ea\u52a8\u91cd\u8bd5\u7ed3\u7b97\u91c7\u8d2d\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"VMIAutoRetrySettleTask_4", (String)"scmc-pm-vmi", (Object[])new Object[0]), false);
            return false;
        }
        Object beforebasisdaysObj = parm.get("beforebasisdays");
        try {
            int beforedays;
            if (beforebasisdaysObj != null && ((beforedays = Integer.parseInt(beforebasisdaysObj.toString())) > 30 || beforedays < 0)) {
                this.sendMsgToUser(ResManager.loadKDString((String)"VMI\u81ea\u52a8\u91cd\u8bd5\u7ed3\u7b97\u7684\u63d0\u524d\u5929\u6570\u5fc5\u5f55\uff0c\u4e14\u63a7\u5236\u57280\u523030\u5929\u4e4b\u95f4\u3002", (String)"VMIAutoRetrySettleTask_5", (String)"scmc-pm-vmi", (Object[])new Object[0]), false);
                return false;
            }
        }
        catch (Exception e) {
            this.sendMsgToUser(ResManager.loadKDString((String)"VMI\u81ea\u52a8\u91cd\u8bd5\u7ed3\u7b97\u7684\u63d0\u524d\u5929\u6570\u8bbe\u7f6e\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u8bd5\u3002", (String)"VMIAutoRetrySettleTask_6", (String)"scmc-pm-vmi", (Object[])new Object[0]), false);
            return false;
        }
        return true;
    }

    protected String getQueryVMISRFieldKeys() {
        return "id,settlelotno,billentry.purinbillentity as purinbillentity,billentry.purinbillid as purinbillid,billentry.invbillentity as invbillentity ,billentry.invbillid as invbillid";
    }

    private Map<String, VirtualBillMapping> buildVMIInfoMap(DataSet recordDataSet) {
        HashMap<String, VirtualBillMapping> recordMap = new HashMap<String, VirtualBillMapping>(10);
        for (Row row : recordDataSet) {
            String settleLotNo = row.getString("settlelotno");
            VirtualBillMapping virtualBillMapping = (VirtualBillMapping)recordMap.get(settleLotNo);
            if (virtualBillMapping == null) {
                virtualBillMapping = new VirtualBillMapping();
            }
            String purInEntity = row.getString("purinbillentity");
            Long purInbillId = row.getLong("purinbillid");
            String invEntity = row.getString("invbillentity");
            Long invBillId = row.getLong("invbillid");
            virtualBillMapping.setInvEntity(invEntity);
            virtualBillMapping.setPurinEntity(purInEntity);
            virtualBillMapping.addInvBillId(invBillId);
            virtualBillMapping.addPurInBillId(purInbillId);
            recordMap.put(settleLotNo, virtualBillMapping);
        }
        return recordMap;
    }

    protected List<QFilter> getVMIRetrySettleFilter(Map<String, Object> parm) {
        String invOrgNumber = (String)parm.get("invorg_no");
        String purOrgNumber = (String)parm.get("purorg_no");
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(16);
        if (StringUtils.isNotBlank((CharSequence)purOrgNumber)) {
            qfilters.add(new QFilter("org.number", "=", (Object)purOrgNumber));
        }
        if (StringUtils.isNotBlank((CharSequence)invOrgNumber)) {
            qfilters.add(new QFilter("recorg.number", "=", (Object)invOrgNumber));
        }
        Date basisday = TimeServiceHelper.today();
        Object basisdayObj = parm.get("basisday");
        if (basisdayObj != null) {
            try {
                basisday = this.sdf.parse(basisdayObj.toString());
            }
            catch (ParseException e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u65e5\u671f\u9519\u8bef\u3002", (String)"VMIAutoRetrySettleTask_10", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            }
        }
        int beforeCurrnetDatas = 7;
        Object beforebasisdaysObj = parm.get("beforebasisdays");
        if (beforebasisdaysObj != null && (beforeCurrnetDatas = Integer.parseInt(beforebasisdaysObj.toString())) > 30) {
            beforeCurrnetDatas = 7;
        }
        Date endOfDay = DateUtil.getEndOfDay((Date)basisday);
        QFilter endOfDataFilter = new QFilter("createtime", "<=", (Object)endOfDay);
        qfilters.add(endOfDataFilter);
        Calendar instance = Calendar.getInstance();
        instance.setTime(endOfDay);
        instance.add(5, -beforeCurrnetDatas);
        Date startOfDay = DateUtil.getStartOfDay((Date)instance.getTime());
        QFilter startOfDataFilter = new QFilter("createtime", ">=", (Object)startOfDay);
        qfilters.add(startOfDataFilter);
        qfilters.add(new QFilter("settleresult", "=", (Object)VMISettleResultEnum.SETTLEFAIL.getValue()));
        qfilters.add(new QFilter("billentry.purinbillid", "!=", (Object)0L));
        qfilters.add(new QFilter("billentry.invbillid", "!=", (Object)0L));
        return qfilters;
    }

    private void sendMsgToUser(String msg, boolean success) {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        ArrayList<Long> userIDS = new ArrayList<Long>(5);
        userIDS.add(currentUserId);
        String sucStr = success ? ResManager.loadKDString((String)"\u81ea\u52a8\u91cd\u8bd5\u7ed3\u7b97\u4efb\u52a1\u6210\u529f\u3002", (String)"VMIAutoRetrySettleTask_7", (String)"scmc-pm-vmi", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u81ea\u52a8\u91cd\u8bd5\u7ed3\u7b97\u4efb\u52a1\u5931\u8d25\u3002", (String)"VMIAutoRetrySettleTask_8", (String)"scmc-pm-vmi", (Object[])new Object[0]);
        MessageInfo msgInfo = new MessageInfo();
        msgInfo.setNotifyType(MessageChannels.MC.getNumber());
        msgInfo.setUserIds(userIDS);
        msgInfo.setTitle(sucStr);
        msgInfo.setContent(msg);
        MessageCenterServiceHelper.sendMessage((MessageInfo)msgInfo);
    }

    static class VirtualBillMapping {
        List<Long> invBillIds;
        List<Long> purInBillIds;
        String invEntity;
        String purinEntity;

        VirtualBillMapping() {
        }

        public String getInvEntity() {
            return this.invEntity;
        }

        public void setInvEntity(String invEntity) {
            if (!StringUtils.isBlank((CharSequence)invEntity)) {
                this.invEntity = invEntity;
            }
        }

        public String getPurinEntity() {
            return this.purinEntity;
        }

        public void setPurinEntity(String purinEntity) {
            if (!StringUtils.isBlank((CharSequence)purinEntity)) {
                this.purinEntity = purinEntity;
            }
        }

        public void addInvBillId(Long invBillId) {
            if (this.invBillIds == null) {
                this.invBillIds = new ArrayList<Long>(5);
            }
            this.invBillIds.add(invBillId);
        }

        public void addPurInBillId(Long purInBillId) {
            if (this.purInBillIds == null) {
                this.purInBillIds = new ArrayList<Long>(5);
            }
            this.purInBillIds.add(purInBillId);
        }

        public List<Long> getInvBillIds() {
            return this.invBillIds;
        }

        public List<Long> getPurInBillIds() {
            return this.purInBillIds;
        }
    }
}

