/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.opplugin.opplugin;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.scmc.pm.utils.CommonUtils;
import kd.scmc.pm.utils.DateUtil;
import kd.scmc.pm.vmi.business.service.settle.VMISettleService;
import kd.scmc.pm.vmi.business.service.settle.factory.VMISettleFactory;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleParam;
import kd.scmc.pm.vmi.business.service.settle.pojo.VMISettleResult;
import kd.scmc.pm.vmi.common.enums.VMISettleTypeEnum;

public class VMICycleSettleTask
extends AbstractTask {
    private Log log = LogFactory.getLog(VMICycleSettleTask.class);
    private int batchBillSize = 100;
    private boolean settleHasPrice = false;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public void execute(RequestContext context, Map<String, Object> parm) throws KDException {
        this.log.info("VMI\u5468\u671f\u7ed3\u7b97\u53c2\u6570\u4fe1\u606f" + parm);
        if (!this.checkParam(parm)) {
            return;
        }
        List<QFilter> qFilters = this.getTransferBillFilter(parm);
        this.settle(qFilters, context);
    }

    private boolean checkParam(Map<String, Object> parm) {
        String invOrgNumber;
        Object settleHasPriceObj;
        if (parm == null) {
            this.sendMsgToUser(ResManager.loadKDString((String)"VMI\u5468\u671f\u7ed3\u7b97\u53c2\u6570\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884cVMI\u7ed3\u7b97\u3002", (String)"VMICycleSettleTask_0", (String)"scmc-pm-vmi", (Object[])new Object[0]), false);
            return false;
        }
        Object batchCount = parm.get("batchcount");
        if (batchCount != null) {
            Integer integer = Integer.valueOf(batchCount.toString());
            if (integer > 500) {
                this.batchBillSize = 500;
            } else if (this.batchBillSize > 0 && this.batchBillSize <= 500) {
                this.batchBillSize = integer;
            }
        }
        if ((settleHasPriceObj = parm.get("settlehasprice")) != null) {
            this.settleHasPrice = Boolean.parseBoolean(settleHasPriceObj.toString());
        }
        if (StringUtils.isBlank((CharSequence)(invOrgNumber = (String)parm.get("invorg_no")))) {
            this.sendMsgToUser(ResManager.loadKDString((String)"VMI\u5468\u671f\u7ed3\u7b97\u5e93\u5b58\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"VMICycleSettleTask_1", (String)"scmc-pm-vmi", (Object[])new Object[0]), false);
            return false;
        }
        DynamicObject invOrg = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)invOrgNumber)});
        if (CommonUtils.isNull((Object)invOrg)) {
            this.sendMsgToUser(ResManager.loadKDString((String)"VMI\u5468\u671f\u7ed3\u7b97\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"VMICycleSettleTask_2", (String)"scmc-pm-vmi", (Object[])new Object[0]), false);
            return false;
        }
        return true;
    }

    protected void settle(List<QFilter> qfilters, RequestContext context) {
        if (qfilters == null || qfilters.size() == 0) {
            return;
        }
        DataSet transferBillDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_transferbill", (String)"id", (QFilter[])qfilters.toArray(new QFilter[qfilters.size()]), (String)"id");
        List<Set<Long>> allNeedSettleBillIdList = this.getAllNeedSettleBillIdList(transferBillDataSet);
        if (CommonUtils.isNull(allNeedSettleBillIdList)) {
            this.log.info("VMI\u5468\u671f\u7ed3\u7b97\u4e2d\u6ca1\u6709\u7b26\u5408\u5468\u671f\u7ed3\u7b97\u7684\u7269\u6743\u8f6c\u79fb\u5355\u3002");
            return;
        }
        for (Set<Long> billIds : allNeedSettleBillIdList) {
            if (billIds == null || billIds.isEmpty()) continue;
            HashMap<Long, Long> sourceIdMap = new HashMap<Long, Long>(10);
            ArrayList<QFilter> containsIdFilter = new ArrayList<QFilter>(qfilters);
            containsIdFilter.add(new QFilter("id", "in", billIds));
            DataSet idAndEntryIdDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_transferbill", (String)"id,billentry.id", (QFilter[])containsIdFilter.toArray(new QFilter[qfilters.size()]), null);
            for (Row row : idAndEntryIdDataSet) {
                Long billID = (Long)row.get("id");
                Long billEntryID = (Long)row.get("billentry.id");
                sourceIdMap.put(billEntryID, billID);
            }
            VMISettleParam settleParam = new VMISettleParam(VMISettleTypeEnum.CYCLE);
            settleParam.setTransferEntryIdAndBillIdMap(sourceIdMap);
            VMISettleService settleService = VMISettleFactory.getInstance(settleParam.getSettleType());
            if (settleService == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u5931\u8d25\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7ed3\u7b97\u7c7b\u578b\u3002", (String)"VMICycleSettleTask_8", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            }
            VMISettleResult vmiSettleResult = VMISettleService.vmiSettle(settleParam);
            if (vmiSettleResult == null) {
                return;
            }
            if (!vmiSettleResult.isSuccess()) {
                this.settleFail(qfilters);
                return;
            }
            List<Object> successList = vmiSettleResult.getSettleSuccessRecordIds();
            if (CommonUtils.isNull(successList)) continue;
            QFilter recordIDFilter = new QFilter("id", "in", successList);
            DynamicObjectCollection recordBills = QueryServiceHelper.query((String)"pm_vmisettlerecord", (String)"billno", (QFilter[])new QFilter[]{recordIDFilter});
            HashSet<String> successRecordNos = new HashSet<String>(16);
            for (DynamicObject record : recordBills) {
                successRecordNos.add(record.getString("billno"));
            }
            this.sendMsgToUser(String.format(ResManager.loadKDString((String)"\u7269\u6743\u8f6c\u79fb\u5355\u7ed3\u7b97\u6210\u529f\uff0c\u7ed3\u7b97\u8bb0\u5f55\u4e3a\u201c%1$s\u201d\u3002", (String)"VMICycleSettleTask_4", (String)"scmc-pm-vmi", (Object[])new Object[0]), successRecordNos), true);
        }
    }

    private void settleFail(List<QFilter> qfilters) {
        HashSet<String> settleFailBillNo = new HashSet<String>(16);
        DynamicObjectCollection settleFailBill = QueryServiceHelper.query((String)"pm_transferbill", (String)"billno", (QFilter[])qfilters.toArray(new QFilter[qfilters.size()]));
        if (!CommonUtils.isNull((Object)settleFailBill)) {
            for (DynamicObject bill : settleFailBill) {
                settleFailBillNo.add(bill.getString("billno"));
            }
            this.sendMsgToUser(String.format(ResManager.loadKDString((String)"\u7269\u6743\u8f6c\u79fb\u5355\u201c%s\u201d\u7ed3\u7b97\u5931\u8d25\u3002", (String)"VMICycleSettleTask_5", (String)"scmc-pm-vmi", (Object[])new Object[0]), settleFailBillNo), false);
        }
    }

    private List<Set<Long>> getAllNeedSettleBillIdList(DataSet transferBillDataSet) {
        ArrayList<Set<Long>> allBillIdList = new ArrayList<Set<Long>>(10);
        HashSet<Long> oneBatchBillIds = new HashSet<Long>(10);
        for (Row row : transferBillDataSet) {
            oneBatchBillIds.add(row.getLong("id"));
            if (oneBatchBillIds.size() < this.batchBillSize) continue;
            allBillIdList.add(oneBatchBillIds);
            oneBatchBillIds = new HashSet(10);
        }
        if (oneBatchBillIds.size() > 0) {
            allBillIdList.add(oneBatchBillIds);
        }
        return allBillIdList;
    }

    protected List<QFilter> getTransferBillFilter(Map<String, Object> parm) {
        String invOrgNumber = (String)parm.get("invorg_no");
        String purOrgNumber = (String)parm.get("purorg_no");
        String supNoFrom = (String)parm.get("supplier_no_from");
        String supNoTo = (String)parm.get("supplier_no_to");
        String matNoFrom = (String)parm.get("material_no_from");
        String matNoTo = (String)parm.get("material_no_to");
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(16);
        qfilters.add(new QFilter("org.number", "=", (Object)invOrgNumber));
        if (StringUtils.isNotBlank((CharSequence)purOrgNumber)) {
            qfilters.add(new QFilter("purorg.number", "=", (Object)purOrgNumber));
        }
        if (StringUtils.isNotBlank((CharSequence)supNoFrom)) {
            qfilters.add(new QFilter("billentry.supplier.number", ">=", (Object)supNoFrom));
        }
        if (StringUtils.isNotBlank((CharSequence)supNoTo)) {
            qfilters.add(new QFilter("billentry.supplier.number", "<=", (Object)supNoTo));
        }
        if (StringUtils.isNotBlank((CharSequence)matNoFrom)) {
            qfilters.add(new QFilter("billentry.material.masterid.number", ">=", (Object)matNoFrom));
        }
        if (StringUtils.isNotBlank((CharSequence)matNoTo)) {
            qfilters.add(new QFilter("billentry.material.masterid.number", "<=", (Object)matNoTo));
        }
        qfilters.add(new QFilter("billentry.settlestatus", "!=", (Object)"C"));
        qfilters.add(new QFilter("billstatus", "=", (Object)"C"));
        qfilters.add(new QFilter("billentry.excutedstatus", "!=", (Object)"B"));
        if (this.settleHasPrice) {
            qfilters.add(new QFilter("billentry.price", "!=", (Object)BigDecimal.ZERO));
            qfilters.add(new QFilter("billentry.priceandtax", "!=", (Object)BigDecimal.ZERO));
        }
        Date basisday = TimeServiceHelper.today();
        Object basisdayObj = parm.get("basisday");
        if (basisdayObj != null) {
            try {
                basisday = this.sdf.parse(basisdayObj.toString());
            }
            catch (ParseException e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u65e5\u671f\u9519\u8bef\u3002", (String)"VMICycleSettleTask_9", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            }
        }
        int beforeCurrnetDatas = 7;
        Object beforebasisdaysObj = parm.get("beforebasisdays");
        if (beforebasisdaysObj != null && ((beforeCurrnetDatas = Integer.parseInt(beforebasisdaysObj.toString())) > 30 || beforeCurrnetDatas < 0)) {
            beforeCurrnetDatas = 7;
        }
        Date endOfDay = DateUtil.getEndOfDay((Date)basisday);
        QFilter endOfDataFilter = new QFilter("createtime", "<=", (Object)endOfDay);
        qfilters.add(endOfDataFilter);
        Calendar instance = Calendar.getInstance();
        instance.setTime(endOfDay);
        instance.add(5, -beforeCurrnetDatas);
        Date startOfDay = DateUtil.getStartOfDay((Date)instance.getTime());
        QFilter startOfDataFilter = new QFilter("createtime", ">=", (Object)startOfDay);
        qfilters.add(startOfDataFilter);
        return qfilters;
    }

    private void sendMsgToUser(String msg, boolean success) {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        ArrayList<Long> userIDS = new ArrayList<Long>(5);
        userIDS.add(currentUserId);
        String sucStr = success ? ResManager.loadKDString((String)"\u5468\u671f\u7ed3\u7b97\u4efb\u52a1\u5df2\u5b8c\u6210\u3002", (String)"VMICycleSettleTask_6", (String)"scmc-pm-vmi", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5468\u671f\u7ed3\u7b97\u4efb\u52a1\u5931\u8d25\u3002", (String)"VMICycleSettleTask_7", (String)"scmc-pm-vmi", (Object[])new Object[0]);
        MessageInfo msgInfo = new MessageInfo();
        msgInfo.setNotifyType(MessageChannels.MC.getNumber());
        msgInfo.setUserIds(userIDS);
        MainEntityType transferBill = MetadataServiceHelper.getDataEntityType((String)"pm_transferbill");
        LocaleString disPlayName = transferBill.getDisplayName();
        msgInfo.setEntityNumber(transferBill.getName());
        msgInfo.setTitle(disPlayName.toString() + sucStr);
        msgInfo.setContent(msg);
        MessageCenterServiceHelper.sendMessage((MessageInfo)msgInfo);
    }
}

