/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.opplugin.opplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.pm.vmi.business.service.settle.VMISettleReverseService;
import kd.scmc.pm.vmi.opplugin.validation.VMISRSingleValidator;

public class VMISRSingleSettleReverseOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(VMISRSingleSettleReverseOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("settlelotno");
        e.getFieldKeys().add("settleresult");
        e.getFieldKeys().add("billentry");
        e.getFieldKeys().add("purinbillid");
        e.getFieldKeys().add("srcbillid");
        e.getFieldKeys().add("invbillid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new VMISRSingleValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (!this.operationResult.isSuccess() || dataEntities == null || dataEntities.length == 0) {
            return;
        }
        DynamicObject dataEntity = dataEntities[0];
        String settleLotNo = dataEntity.getString("settlelotno");
        Long pkValue = (Long)dataEntity.getPkValue();
        OperationResult result = VMISettleReverseService.singleSettleReverse(pkValue, settleLotNo);
        OperationResult operationResult = this.getOperationResult();
        this.mergeOperateResult(operationResult, result);
    }

    private void mergeOperateResult(OperationResult operationResult, OperationResult opResult) {
        if (opResult == null) {
            return;
        }
        operationResult.setSuccess(opResult.isSuccess());
        operationResult.setBillCount(opResult.getBillCount());
        operationResult.setMessage(opResult.getMessage());
        operationResult.setSuccessPkIds(opResult.getSuccessPkIds());
        operationResult.getAllErrorInfo().addAll(opResult.getAllErrorInfo());
        for (ValidateResult vResult : opResult.getValidateResult().getValidateErrors()) {
            operationResult.getValidateResult().addValidateError(vResult.getValidatorKey(), vResult);
        }
    }
}

