/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.opplugin.opplugin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.scmc.pm.utils.DateUtil;

public class VMISettleRecordCleanTask
extends AbstractTask {
    private Log log = LogFactory.getLog(VMISettleRecordCleanTask.class);
    private int days = 180;
    private int maxCount = 10000000;
    private String vmiRecordEntity = "pm_vmisettlerecord";
    private String vmiRecordHeadTable = "t_pm_vmisrecord";
    private String vmiRecordEntryTable = "t_pm_vmisrecordentry";
    private String dateFieldKey = "createtime";
    private static int BATCH_COUNT = 10000;
    private String[] settleResult = null;
    private Long invOrgId;
    private Long purOrgId;
    private Date basicDate = TimeServiceHelper.today();
    private int allRecordCount = 0;
    private int cleanRecordCount = 0;

    public void execute(RequestContext context, Map<String, Object> parm) throws KDException {
        this.log.info("VMI\u7ed3\u7b97\u8bb0\u5f55\u6e05\u7406\u5f00\u59cb\u3002" + SerializationUtils.toJsonString(parm));
        if (!this.checkParam(parm)) {
            return;
        }
        this.cleanVMISettleRecordByDate();
        this.log.info("VMI\u65e5\u671f\u6e05\u7406\u7ed3\u675f\u3002");
    }

    private boolean checkParam(Map<String, Object> parm) {
        Object basicdateObj;
        String recordSaveDaysStr;
        Object recordSaveDays;
        Object invOrgNoString;
        if (parm == null || parm.isEmpty()) {
            this.sendMsgToUser(ResManager.loadKDString((String)"\u6e05\u7406VMI\u7ed3\u7b97\u8bb0\u5f55\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u914d\u7f6e\u53c2\u6570\u540e\u518d\u6267\u884c\u6e05\u7406\u7a0b\u5e8f\u3002", (String)"VMISettleRecordCleanTask_0", (String)"scmc-pm-vmi", (Object[])new Object[0]), true);
            return false;
        }
        Object settleResultString = parm.get("settleresult");
        if (StringUtils.isNotBlank((Object)settleResultString)) {
            this.settleResult = settleResultString.toString().split("\\,");
        }
        if (StringUtils.isBlank((Object)(invOrgNoString = parm.get("invorg_no")))) {
            this.sendMsgToUser(ResManager.loadKDString((String)"\u6e05\u7406VMI\u7ed3\u7b97\u8bb0\u5f55\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801\u5fc5\u5f55\uff0c\u8bf7\u914d\u7f6e\u540e\u518d\u6267\u884c\u6e05\u7406\u7a0b\u5e8f\u3002", (String)"VMISettleRecordCleanTask_1", (String)"scmc-pm-vmi", (Object[])new Object[0]), true);
            return false;
        }
        List invOrgPks = QueryServiceHelper.queryPrimaryKeys((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("number", "=", invOrgNoString)}, null, (int)1);
        if (invOrgPks == null || invOrgPks.isEmpty()) {
            this.sendMsgToUser(ResManager.loadKDString((String)"\u6e05\u7406VMI\u7ed3\u7b97\u8bb0\u5f55\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"VMISettleRecordCleanTask_2", (String)"scmc-pm-vmi", (Object[])new Object[0]), true);
            return false;
        }
        this.invOrgId = (Long)invOrgPks.get(0);
        Object purOrgNoString = parm.get("purorg_no");
        if (!StringUtils.isBlank((Object)purOrgNoString)) {
            List purOrgPks = QueryServiceHelper.queryPrimaryKeys((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("number", "=", purOrgNoString)}, null, (int)1);
            if (purOrgPks == null || purOrgPks.isEmpty()) {
                this.sendMsgToUser(ResManager.loadKDString((String)"\u6e05\u7406VMI\u7ed3\u7b97\u8bb0\u5f55\u91c7\u8d2d\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"VMISettleRecordCleanTask_3", (String)"scmc-pm-vmi", (Object[])new Object[0]), true);
                return false;
            }
            this.purOrgId = (Long)purOrgPks.get(0);
        }
        if ((recordSaveDays = parm.get("recordsavedays")) != null && StringUtils.isNotBlank((CharSequence)(recordSaveDaysStr = recordSaveDays.toString()))) {
            this.days = Integer.parseInt(recordSaveDays.toString());
        }
        if ((basicdateObj = parm.get("basicdate")) != null) {
            if (basicdateObj instanceof Date) {
                this.basicDate = (Date)basicdateObj;
            } else if (basicdateObj instanceof String && StringUtils.isNotBlank((Object)basicdateObj)) {
                try {
                    SimpleDateFormat newDataeFormat = new SimpleDateFormat("yyyy-MM-dd");
                    newDataeFormat.setTimeZone(TimeServiceHelper.getSysTimeZone().getTimeZone());
                    this.basicDate = newDataeFormat.parse(basicdateObj.toString());
                }
                catch (ParseException e) {
                    this.log.error(e.getMessage());
                    this.sendMsgToUser(ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\u3002", (String)"VMISettleRecordCleanTask_10", (String)"scmc-pm-vmi", (Object[])new Object[0]), false);
                    return false;
                }
            }
        }
        return true;
    }

    private void sendMsgToUser(String msg, boolean success) {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        ArrayList<Long> userIDS = new ArrayList<Long>(5);
        userIDS.add(currentUserId);
        String sucStr = success ? ResManager.loadKDString((String)"\u81ea\u52a8\u6e05\u7406VMI\u7ed3\u7b97\u8bb0\u5f55\u4efb\u52a1\u6210\u529f\u3002", (String)"VMISettleRecordCleanTask_8", (String)"scmc-pm-vmi", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u81ea\u52a8\u6e05\u7406VMI\u7ed3\u7b97\u8bb0\u5f55\u4efb\u52a1\u5931\u8d25\u3002", (String)"VMISettleRecordCleanTask_9", (String)"scmc-pm-vmi", (Object[])new Object[0]);
        MessageInfo msgInfo = new MessageInfo();
        msgInfo.setNotifyType(MessageChannels.MC.getNumber());
        msgInfo.setUserIds(userIDS);
        msgInfo.setTitle(sucStr);
        msgInfo.setContent(msg);
        MessageCenterServiceHelper.sendMessage((MessageInfo)msgInfo);
    }

    private void cleanVMISettleRecordByDate() {
        this.log.info("VMI\u7ed3\u7b97\u8bb0\u5f55\u6e05\u7406\u5f00\u59cb\u3002");
        List<List<Long>> needCleanLogIds = this.getNeedCleanRecordIds(null, this.maxCount);
        this.deleteLogPkId(needCleanLogIds);
        this.sendMsgToUser(String.format(ResManager.loadKDString((String)"VMI\u7ed3\u7b97\u8bb0\u5f55\u6e05\u7406\u6210\u529f\uff0c\u5171\u6709\u7b26\u5408\u6761\u4ef6\u7684\u7ed3\u7b97\u8bb0\u5f55%1$s\u5355\uff0c\u6e05\u7406%2$s\u5355\u3002", (String)"VMISettleRecordCleanTask_6", (String)"scmc-pm-vmi", (Object[])new Object[0]), this.allRecordCount, this.cleanRecordCount), true);
        this.log.info("\u6e05\u7406\u7ed3\u675f\u3002");
    }

    private List<List<Long>> getNeedCleanRecordIds(String orderByKeys, int tops) {
        ArrayList deletePkIDList = new ArrayList(8);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter("recorg", "=", (Object)this.invOrgId));
        Calendar instance = Calendar.getInstance();
        instance.setTime(DateUtil.getStartOrEndDate((Date)this.basicDate, (boolean)false));
        instance.add(5, -this.days);
        filters.add(new QFilter(this.dateFieldKey, "<=", (Object)instance.getTime()));
        if (this.purOrgId != null) {
            filters.add(new QFilter("org", "=", (Object)this.purOrgId));
        }
        if (this.settleResult != null && this.settleResult.length > 0) {
            filters.add(new QFilter("settleresult", "in", (Object)this.settleResult));
        }
        try (DataSet ids = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)this.vmiRecordEntity, (String)"id", (QFilter[])filters.toArray(new QFilter[0]), (String)orderByKeys);){
            this.allRecordCount = ids.count("id", false);
        }
        this.log.info("\u7b26\u5408\u6761\u4ef6\u7684\u7ed3\u7b97\u8bb0\u5f55\u6570\uff1a" + this.allRecordCount);
        ids = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)this.vmiRecordEntity, (String)"id", (QFilter[])filters.toArray(new QFilter[0]), (String)orderByKeys, (int)tops);
        var7_7 = null;
        try {
            ids.forEach(value -> deletePkIDList.add(value.getLong("id")));
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (ids != null) {
                if (var7_7 != null) {
                    try {
                        ids.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    ids.close();
                }
            }
        }
        this.cleanRecordCount = deletePkIDList.size();
        this.log.info("\u6e05\u7406ID\u6570\u91cf\uff1a" + this.cleanRecordCount);
        List<List<Long>> partitionList = VMISettleRecordCleanTask.partition(deletePkIDList, BATCH_COUNT);
        return partitionList;
    }

    /*
     * Exception decompiling
     */
    public void deleteLogPkId(List<List<Long>> pks) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void exeDeleteSql(List<Object[]> deleteList, String logEntityTableName) {
        String deleteSql = String.format("delete  from  %s  where  fid=?", logEntityTableName);
        DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)deleteSql, deleteList);
    }

    public static <T> List<List<T>> partition(List<T> originalList, int batchSize) {
        ArrayList<List<T>> result = new ArrayList<List<T>>(16);
        if (originalList == null) {
            return result;
        }
        int remainder = originalList.size() % batchSize;
        int number = originalList.size() / batchSize;
        for (int i = 0; i < number; ++i) {
            List<T> value = originalList.subList(i * batchSize, (i + 1) * batchSize);
            result.add(value);
        }
        if (remainder > 0) {
            result.add(originalList.subList(number * batchSize, originalList.size()));
        }
        return result;
    }
}

