/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.pm.utils.DateUtil;

public class VmiSettleDetailRptQuery
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List<QFilter> filters = VmiSettleDetailRptQuery.getFilters(filterInfo);
        String selectVMIField = VmiSettleDetailRptQuery.getSelectVMIField();
        String selectpurinField = VmiSettleDetailRptQuery.getSelectPurinField();
        DataSet settleData = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_vmisettlerecord", (String)selectVMIField, (QFilter[])filters.toArray(new QFilter[filters.size()]), null);
        QFilter billstatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter srcbillentity = new QFilter("billentry.srcbillentity", "=", (Object)"pm_transferbill");
        DataSet purinData = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_purinbill", (String)selectpurinField, (QFilter[])new QFilter[]{billstatus, srcbillentity}, null);
        DataSet dataSet = settleData.join(purinData, JoinType.LEFT).on("vmisettepurid", "purandentryid").select(new String[]{"entry_purorg", "entry_supplier", "entry_material", "unit", "settleqty", "settledate", "transferbillno", "transfer_entryseq"}, new String[]{"auxpty", "entry_project", "amountandtax", "settlecurrency", "priceandtax", "settleorg", "taxrateid"}).finish();
        return dataSet.select(this.getShowField());
    }

    private String getShowField() {
        return "entry_purorg,entry_supplier,entry_material,auxpty,entry_project,unit,settleqty,priceandtax,taxrateid,priceandtax * settleqty as amountandtax,settlecurrency,settleorg,settledate,transferbillno,transfer_entryseq";
    }

    private static List<QFilter> getFilters(FilterInfo filterInfo) {
        DynamicObjectCollection materials;
        DynamicObjectCollection supplers;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        Date startDate = filterInfo.getDate("startdate");
        filters.add(new QFilter("settledate", ">=", (Object)DateUtil.getStartOrEndDate((Date)startDate, (boolean)false)));
        Date endDate = filterInfo.getDate("enddate");
        filters.add(new QFilter("settledate", "<=", (Object)DateUtil.getStartOrEndDate((Date)endDate, (boolean)true)));
        DynamicObject purOrg = filterInfo.getDynamicObject("purorg");
        if (purOrg != null) {
            filters.add(new QFilter("org", "=", purOrg.getPkValue()));
        }
        if ((supplers = filterInfo.getDynamicObjectCollection("supplier")) != null && supplers.size() > 0) {
            Object[] supplerids = VmiSettleDetailRptQuery.getBaseDataPkIds(supplers);
            filters.add(new QFilter("billentry.supplier", "in", (Object)supplerids));
        }
        if ((materials = filterInfo.getDynamicObjectCollection("material")) != null && materials.size() > 0) {
            Object[] materialIds = VmiSettleDetailRptQuery.getBaseDataPkIds(materials);
            filters.add(new QFilter("billentry.material.masterid", "in", (Object)materialIds));
        }
        filters.add(new QFilter("settleresult", "=", (Object)"A"));
        return filters;
    }

    private static String getSelectVMIField() {
        ArrayList<String> selectorSet = new ArrayList<String>(16);
        selectorSet.add("org as entry_purorg");
        selectorSet.add("billentry.supplier as entry_supplier");
        selectorSet.add("billentry.material.id as entry_material");
        selectorSet.add("billentry.unit as unit");
        selectorSet.add("billentry.qty as settleqty");
        selectorSet.add("settledate as settledate");
        selectorSet.add("billentry.srcbillnumber as transferbillno");
        selectorSet.add("billentry.srcbillentryseq as transfer_entryseq");
        selectorSet.add("concat(billentry.purinbillid,billentry.purinbillentryid) as vmisettepurid");
        return String.join((CharSequence)",", selectorSet);
    }

    private static String getSelectPurinField() {
        ArrayList<String> selectorSet = new ArrayList<String>(16);
        selectorSet.add("id as id");
        selectorSet.add("billentry.auxpty as auxpty");
        selectorSet.add("billentry.project as entry_project");
        selectorSet.add("billentry.priceandtax as priceandtax");
        selectorSet.add("billentry.unit as unit");
        selectorSet.add("billentry.taxrateid as taxrateid");
        selectorSet.add("billentry.amountandtax as amountandtax");
        selectorSet.add("settlecurrency as settlecurrency");
        selectorSet.add("billentry.entrysettleorg as settleorg");
        selectorSet.add("billentry.srcbillnumber as srcbillnumber");
        selectorSet.add("concat(id,billentry.id) as purandentryid");
        return String.join((CharSequence)",", selectorSet);
    }

    private static Object[] getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        Object[] pkIds = new Object[col.size()];
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds[i] = baseData.getPkValue();
        }
        return pkIds;
    }
}

