/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.report.vmicondetail;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scmc.pm.utils.DateUtil;
import kd.scmc.pm.vmi.report.helper.MultiOrgHelper;
import kd.scmc.pm.vmi.report.vmicondetail.VmiConDetailRptTransform;

public class VmiConDetailsReportHandler
implements IReportDataHandle {
    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        Map params = ctx.getParams();
        List<QFilter> generalFs = this.getGeneralFilter(params);
        for (SrcBlockConf srcBlockConf : blockCollector) {
            String srcEntity = srcBlockConf.getSrcEntity();
            QFilter dataFs = srcBlockConf.getDataFs();
            if (dataFs == null) {
                dataFs = QFilter.of((String)"1=1", (Object[])new Object[0]);
                srcBlockConf.setDataFs(dataFs);
            }
            if (!"pm_transferbill".equals(srcEntity)) continue;
            for (QFilter ctxFixedFs : generalFs) {
                dataFs.and(ctxFixedFs);
            }
        }
    }

    private List<QFilter> getGeneralFilter(Map<String, Object> filterInfo) {
        DynamicObjectCollection billNos;
        DynamicObjectCollection srcentitys;
        DynamicObject warehouse;
        DynamicObject project;
        DynamicObjectCollection materials;
        DynamicObjectCollection supplers;
        DynamicObjectCollection purOrg;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        Date startDate = (Date)filterInfo.get("startdate");
        filters.add(new QFilter("biztime", ">=", (Object)DateUtil.getStartOrEndDate((Date)startDate, (boolean)false)));
        Date endDate = (Date)filterInfo.get("enddate");
        filters.add(new QFilter("biztime", "<=", (Object)DateUtil.getStartOrEndDate((Date)endDate, (boolean)true)));
        DynamicObjectCollection org = (DynamicObjectCollection)filterInfo.get("invorg");
        if (org != null && org.size() > 0) {
            Object[] orgPkIds = VmiConDetailsReportHandler.getBaseDataPkIds(org);
            filters.add(new QFilter("org", "in", (Object)orgPkIds));
        }
        if ((purOrg = (DynamicObjectCollection)filterInfo.get("purorg")) != null && purOrg.size() > 0) {
            Object[] purOrgPkIds = VmiConDetailsReportHandler.getBaseDataPkIds(purOrg);
            filters.add(new QFilter("purorg", "in", (Object)purOrgPkIds));
        }
        if ((supplers = (DynamicObjectCollection)filterInfo.get("supplier")) != null && supplers.size() > 0) {
            Object[] supplerids = MultiOrgHelper.getMasterIds(supplers);
            filters.add(new QFilter("billentry.supplier.masterid", "in", (Object)supplerids));
        }
        if ((materials = (DynamicObjectCollection)filterInfo.get("material")) != null && materials.size() > 0) {
            Object[] materialIds = VmiConDetailsReportHandler.getBaseDataPkIds(materials);
            filters.add(new QFilter("billentry.material.masterid", "in", (Object)materialIds));
        }
        if ((project = (DynamicObject)filterInfo.get("project")) != null) {
            filters.add(new QFilter("billentry.project", "in", project.getPkValue()));
        }
        if ((warehouse = (DynamicObject)filterInfo.get("warehouse")) != null) {
            filters.add(new QFilter("billentry.warehouse", "in", warehouse.getPkValue()));
        }
        if ((srcentitys = (DynamicObjectCollection)filterInfo.get("srcentityno")) != null && srcentitys.size() > 0) {
            Object[] srcentityIds = VmiConDetailsReportHandler.getBaseDataPkIds(srcentitys);
            filters.add(new QFilter("srcbillform", "in", (Object)srcentityIds));
        }
        if ((billNos = (DynamicObjectCollection)filterInfo.get("transferbillno")) != null && billNos.size() > 0) {
            Object[] billIds = VmiConDetailsReportHandler.getBaseDataPkIds(billNos);
            filters.add(new QFilter("id", "in", (Object)billIds));
        }
        return filters;
    }

    private static Object[] getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        Object[] pkIds = new Object[col.size()];
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds[i] = baseData.getPkValue();
        }
        return pkIds;
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("entry_invorg");
        repoColFilter.add("entry_purorg");
        repoColFilter.add("entry_supplier");
        repoColFilter.add("entry_date");
        repoColFilter.add("srcbillform");
        repoColFilter.add("entry_material");
        repoColFilter.add("auxpty");
        repoColFilter.add("entry_project");
        repoColFilter.add("lotnumber");
        repoColFilter.add("unit");
        repoColFilter.add("expqty");
        repoColFilter.add("entry_warehouse");
        repoColFilter.add("joinqty");
        repoColFilter.add("comment");
    }

    public void handleBlockDataSelectCols(Set<String> repoColFilter, SrcBlockConf blockConf, ReportDataCtx ctx) {
        String srcEntity = blockConf.getSrcEntity();
        if ("pm_transferbill".equals(srcEntity)) {
            Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
            repoColFullSrcColMap.putIfAbsent("billentryseq", "billentry.seq");
            repoColFullSrcColMap.putIfAbsent("id", "id");
        }
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new VmiConDetailRptTransform());
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        ReportColumn reportCol = null;
        for (AbstractReportColumn col : cols) {
            if (!(col instanceof ReportColumn)) continue;
            reportCol = (ReportColumn)col;
            String fieldKey = reportCol.getFieldKey();
            if ("billno".equals(fieldKey)) {
                reportCol.setHyperlink(true);
            }
            if (!"summarytype".equals(fieldKey)) continue;
            reportCol.setZeroShow(true);
        }
        return cols;
    }
}

