/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.report.vmisettledetail;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class JoinImFunction
extends GroupReduceFunction {
    private RowMeta rowMeta;
    private Map<Integer, Field> indexMap;
    private Map<String, Integer> fieldMap;
    private QFilter im_QFilter;
    private String imSelectCols;
    private String[] imShowCols;
    private String[] contractShowCols;

    public JoinImFunction(RowMeta rowMeta, String selectCols, QFilter qFilter, String[] imShowCols, String[] contractShowCols) {
        this.rowMeta = rowMeta;
        this.imSelectCols = selectCols;
        this.im_QFilter = qFilter;
        this.imShowCols = imShowCols;
        this.contractShowCols = contractShowCols;
        Field[] fields = rowMeta.getFields();
        if (this.indexMap == null) {
            this.indexMap = new HashMap<Integer, Field>(fields.length);
        }
        if (this.fieldMap == null) {
            this.fieldMap = new HashMap<String, Integer>(fields.length);
        }
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            this.indexMap.putIfAbsent(i, field);
            this.fieldMap.putIfAbsent(field.getName(), i);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        HashSet<Long> entryIds = new HashSet<Long>();
        Iterator<RowX> iterator = iterable.iterator();
        int size = this.indexMap.size();
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        while (iterator.hasNext()) {
            Object[] objs = new Object[size];
            RowX rowX = iterator.next();
            for (int i = 0; i < size; ++i) {
                Object value = rowX.get(i);
                Field field = this.indexMap.get(i);
                objs[i] = value == null && field.getDataType() instanceof BigDecimalType ? BigDecimal.ZERO : value;
                if (value == null || !"purinbillentryid".equals(field.getName()) || (Long)value == 0L) continue;
                entryIds.add((Long)value);
            }
            list.add(objs);
        }
        Algo algo = Algo.create((String)"queryOrderData");
        DataSet srcData = algo.createDataSet(list.iterator(), this.rowMeta);
        QFilter imQFilter = this.im_QFilter.and(new QFilter("billentry.id", "in", entryIds));
        DataSet orderDataSet = QueryServiceHelper.queryDataSet((String)"queryOrder", (String)"im_purinbill", (String)this.imSelectCols, (QFilter[])imQFilter.toArray(), null);
        if (orderDataSet.hasNext()) {
            DataSet finish = srcData.leftJoin(orderDataSet).on("purinbillentryid", "entryid_im").select(this.contractShowCols, this.imShowCols).finish();
            while (finish.hasNext()) {
                Row next = finish.next();
                Object[] objs = new Object[size];
                for (int i = 0; i < size; ++i) {
                    Object value;
                    Field field = this.indexMap.get(i);
                    objs[i] = value = next.get(field.getName());
                }
                collector.collect(new RowX(objs));
            }
        } else {
            for (Object[] objs : list) {
                collector.collect(new RowX(objs));
            }
        }
    }
}

