/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.report.vmisettledetail;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scmc.pm.utils.DateUtil;
import kd.scmc.pm.vmi.report.helper.MultiOrgHelper;
import kd.scmc.pm.vmi.report.vmisettledetail.JoinImTransForm;

public class VmiSettleDetailReportHandler
implements IReportDataHandle {
    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("purinbillid");
        repoColFilter.add("purinbillentryid");
        repoColFilter.add("entry_purorg");
        repoColFilter.add("entry_supplier");
        repoColFilter.add("entry_material");
        repoColFilter.add("unit");
        repoColFilter.add("settleqty");
        repoColFilter.add("transferbillno");
        repoColFilter.add("transfer_entryseq");
        repoColFilter.add("id_im");
        repoColFilter.add("entryid_im");
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        LinkedList<AbstractReportColumn> showCols = new LinkedList<AbstractReportColumn>();
        for (AbstractReportColumn col : cols) {
            ReportColumn column = (ReportColumn)col;
            String fieldKey = column.getFieldKey();
            HashSet showAllCols = new HashSet(32);
            showAllCols.addAll(ctx.getShowKeyCols());
            showAllCols.addAll(ctx.getShowQtyCols());
            if (!showAllCols.contains(fieldKey)) continue;
            showCols.add(col);
        }
        return showCols;
    }

    public void handleBlockDataSelectCols(Set<String> repoColFilter, SrcBlockConf blockConf, ReportDataCtx ctx) {
        String srcEntity = blockConf.getSrcEntity();
        if ("im_purinbill".equals(srcEntity)) {
            Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
            repoColFullSrcColMap.putIfAbsent("id_im", "id");
            repoColFullSrcColMap.putIfAbsent("entryid_im", "billentry.id");
            Map repoColSrcColMap = blockConf.getRepoColSrcColMap();
            repoColSrcColMap.putIfAbsent("id_im", "id_im");
            repoColSrcColMap.putIfAbsent("entryid_im", "entryid_im");
        } else if ("pm_vmisettlerecord".equals(srcEntity)) {
            Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
            repoColFullSrcColMap.putIfAbsent("entry_purorg", "org");
            repoColFullSrcColMap.putIfAbsent("entry_supplier", "supplier");
            repoColFullSrcColMap.putIfAbsent("entry_material", "material.id");
            repoColFullSrcColMap.putIfAbsent("unit", "billentry.unit");
            repoColFullSrcColMap.putIfAbsent("settleqty", "billentry.qty");
            repoColFullSrcColMap.putIfAbsent("transferbillno", "billentry.srcbillnumber");
            repoColFullSrcColMap.putIfAbsent("transfer_entryseq", "billentry.srcbillentryseq");
        }
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        Map params = ctx.getParams();
        List<QFilter> generalFs = this.getGeneralFilter(params);
        for (SrcBlockConf srcBlockConf : blockCollector) {
            String srcEntity = srcBlockConf.getSrcEntity();
            QFilter dataFs = srcBlockConf.getDataFs();
            if (dataFs == null) {
                dataFs = QFilter.of((String)"1=1", (Object[])new Object[0]);
                srcBlockConf.setDataFs(dataFs);
            }
            if ("pm_vmisettlerecord".equals(srcEntity)) {
                for (QFilter ctxFixedFs : generalFs) {
                    dataFs.and(ctxFixedFs);
                }
                continue;
            }
            if (!"im_purinbill".equals(srcEntity)) continue;
            dataFs.and(QFilter.of((String)"1!=1", (Object[])new Object[0]));
        }
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new JoinImTransForm(ctx));
    }

    private List<QFilter> getGeneralFilter(Map<String, Object> filterInfo) {
        DynamicObjectCollection materials;
        DynamicObjectCollection supplers;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        Date startDate = (Date)filterInfo.get("startdate");
        filters.add(new QFilter("settledate", ">=", (Object)DateUtil.getStartOrEndDate((Date)startDate, (boolean)false)));
        Date endDate = (Date)filterInfo.get("enddate");
        filters.add(new QFilter("settledate", "<=", (Object)DateUtil.getStartOrEndDate((Date)endDate, (boolean)true)));
        DynamicObjectCollection purOrg = (DynamicObjectCollection)filterInfo.get("purorg");
        if (purOrg != null && purOrg.size() > 0) {
            Object[] purOrgIds = VmiSettleDetailReportHandler.getBaseDataPkIds(purOrg);
            filters.add(new QFilter("org", "in", (Object)purOrgIds));
        }
        if ((supplers = (DynamicObjectCollection)filterInfo.get("supplier")) != null && supplers.size() > 0) {
            Object[] supplerids = MultiOrgHelper.getMasterIds(supplers);
            filters.add(new QFilter("billentry.supplier.masterid", "in", (Object)supplerids));
        }
        if ((materials = (DynamicObjectCollection)filterInfo.get("material")) != null && materials.size() > 0) {
            Object[] materialIds = VmiSettleDetailReportHandler.getBaseDataPkIds(materials);
            filters.add(new QFilter("billentry.material.masterid", "in", (Object)materialIds));
        }
        filters.add(new QFilter("settleresult", "=", (Object)"A"));
        return filters;
    }

    private static Object[] getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        Object[] pkIds = new Object[col.size()];
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds[i] = baseData.getPkValue();
        }
        return pkIds;
    }
}

