/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.report.vmisettlementsum;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scmc.pm.utils.DateUtil;
import kd.scmc.pm.vmi.report.helper.MultiOrgHelper;
import kd.scmc.pm.vmi.report.vmisettlementsum.GroupTransform;

public class VmiSettlementSumReportHandler
implements IReportDataHandle {
    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        Map params = ctx.getParams();
        List<QFilter> generalFs = this.getGeneralFilter(params);
        for (SrcBlockConf srcBlockConf : blockCollector) {
            String srcEntity = srcBlockConf.getSrcEntity();
            QFilter dataFs = srcBlockConf.getDataFs();
            if (dataFs == null) {
                dataFs = QFilter.of((String)"1=1", (Object[])new Object[0]);
                srcBlockConf.setDataFs(dataFs);
            }
            if (!"pm_vmisettlerecord".equals(srcEntity)) continue;
            for (QFilter ctxFixedFs : generalFs) {
                dataFs.and(ctxFixedFs);
            }
        }
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new GroupTransform());
    }

    private List<QFilter> getGeneralFilter(Map<String, Object> filterInfo) {
        DynamicObjectCollection materials;
        DynamicObjectCollection supplers;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        Date startDate = (Date)filterInfo.get("startdate");
        filters.add(new QFilter("settledate", ">=", (Object)DateUtil.getStartOrEndDate((Date)startDate, (boolean)false)));
        Date endDate = (Date)filterInfo.get("enddate");
        filters.add(new QFilter("settledate", "<=", (Object)DateUtil.getStartOrEndDate((Date)endDate, (boolean)true)));
        DynamicObjectCollection purOrg = (DynamicObjectCollection)filterInfo.get("purorg");
        if (purOrg != null) {
            Object[] orgPkIds = VmiSettlementSumReportHandler.getBaseDataPkIds(purOrg);
            filters.add(new QFilter("org", "in", (Object)orgPkIds));
        }
        if ((supplers = (DynamicObjectCollection)filterInfo.get("supplier")) != null && supplers.size() > 0) {
            Object[] supplerids = MultiOrgHelper.getMasterIds(supplers);
            filters.add(new QFilter("billentry.supplier.masterid", "in", (Object)supplerids));
        }
        if ((materials = (DynamicObjectCollection)filterInfo.get("material")) != null && materials.size() > 0) {
            Object[] materialIds = VmiSettlementSumReportHandler.getBaseDataPkIds(materials);
            filters.add(new QFilter("billentry.material.masterid", "in", (Object)materialIds));
        }
        filters.add(new QFilter("settleresult", "=", (Object)"A"));
        return filters;
    }

    private static Object[] getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        Object[] pkIds = new Object[col.size()];
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds[i] = baseData.getPkValue();
        }
        return pkIds;
    }
}

