/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.vmi.report.vmisettlementsum;

import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.vmi.report.helper.MultiOrgHelper;

public class VmiSettlementSumReportPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final String HAS_PERMISSION_PUR_ORG = "hasPermissionPurOrg";

    public void registerListener(EventObject e) {
        BasedataEdit supplier;
        BasedataEdit material;
        super.registerListener(e);
        BasedataEdit purorg = (BasedataEdit)this.getView().getControl("purorg");
        if (purorg != null) {
            purorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((material = (BasedataEdit)this.getView().getControl("material")) != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplier = (BasedataEdit)this.getView().getControl("supplier")) != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        String formId = this.getView().getFormShowParameter().getFormId();
        long orgId = RequestContext.get().getOrgId();
        List purorgList = OrgHelper.getHasPermissionOrg((String)formId, (String)OrgViewTypeEnum.IS_PURCHASE.getViewType());
        if (purorgList != null && !purorgList.isEmpty()) {
            if (purorgList.contains(orgId)) {
                model.setValue("purorg", (Object)new Object[]{orgId});
            } else {
                model.setValue("purorg", (Object)new Object[]{purorgList.get(0)});
            }
            this.getPageCache().put(HAS_PERMISSION_PUR_ORG, SerializationUtils.toJsonString((Object)purorgList));
            Object startdate = model.getValue("startdate");
            Object enddate = model.getValue("enddate");
            if (startdate == null && enddate == null) {
                this.setdefaultDate();
            }
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        queryParam.getCustomParam().put("purorg", filterInfo.getDynamicObjectCollection("purorg"));
        queryParam.getCustomParam().put("supplier", filterInfo.getDynamicObjectCollection("supplier"));
        queryParam.getCustomParam().put("startdate", filterInfo.getDate("startdate"));
        queryParam.getCustomParam().put("enddate", filterInfo.getDate("enddate"));
        queryParam.getCustomParam().put("material", filterInfo.getDynamicObjectCollection("material"));
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObjectCollection orghead = (DynamicObjectCollection)this.getModel().getValue("purorg");
        List<Long> listOrgId = null;
        switch (fieldKey) {
            case "purorg": {
                String purpkSet = this.getPageCache().get(HAS_PERMISSION_PUR_ORG);
                if (purpkSet == null || purpkSet.length() < 1) {
                    String formId = this.getView().getFormShowParameter().getFormId();
                    List orgList = OrgHelper.getHasPermissionOrg((String)formId, (String)OrgViewTypeEnum.IS_PURCHASE.getViewType());
                    this.getPageCache().put(HAS_PERMISSION_PUR_ORG, SerializationUtils.toJsonString((Object)orgList));
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)orgList));
                    break;
                }
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", SerializationUtils.fromJsonString((String)purpkSet, List.class)));
                break;
            }
            case "material": {
                if (orghead == null || orghead.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"VmiSettlementSumReportPlugin_0", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                listOrgId = MultiOrgHelper.getBaseDataLongIds(this.getView(), "purorg");
                QFilter bd_material = MultiOrgHelper.getBaseDataFilter("bd_material", listOrgId);
                if (bd_material != null) {
                    showParameter.getListFilterParameter().setFilter(bd_material);
                }
                showParameter.setShowApproved(false);
                break;
            }
            case "supplier": {
                if (orghead == null || orghead.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"VmiSettlementSumReportPlugin_0", (String)"scmc-pm-vmi", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                listOrgId = MultiOrgHelper.getBaseDataLongIds(this.getView(), "purorg");
                QFilter bd_supplier = MultiOrgHelper.getBaseDataFilter("bd_supplier", listOrgId);
                if (bd_supplier != null) {
                    showParameter.getListFilterParameter().setFilter(bd_supplier);
                }
                showParameter.setShowApproved(false);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        if (!CommonUtils.isRealChanged((ChangeData)e.getChangeSet()[0])) {
            return;
        }
        switch (key = e.getProperty().getName()) {
            case "purorg": {
                this.getModel().setValue("supplier", null);
                this.getModel().setValue("material", null);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        DynamicObjectCollection org = filter.getDynamicObjectCollection("purorg");
        if (org == null || org.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"VmiSettlementSumReportPlugin_0", (String)"scmc-pm-vmi", (Object[])new Object[0]));
            return false;
        }
        Date startdate = filter.getDate("startdate");
        Date enddate = filter.getDate("enddate");
        if (startdate != null && enddate != null) {
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"VmiSettlementSumReportPlugin_1", (String)"scmc-pm-vmi", (Object[])new Object[0]));
        return false;
    }

    private void setdefaultDate() {
        IDataModel model = this.getModel();
        Calendar cal = Calendar.getInstance();
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        model.setValue("startdate", (Object)cal.getTime());
        model.setValue("enddate", (Object)cal.getTime());
    }
}

