/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.mservice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.common.utils.PartitionUtils;
import kd.scmc.pm.business.helper.PurApplyBillHelper;
import kd.scmc.pm.enums.ChangeStatusEnum;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.mservice.api.PurApplyService;

public class PurApplyServiceImpl
implements PurApplyService {
    private static final Log log = LogFactory.getLog(PurApplyServiceImpl.class);
    private static final int MAX_QUERY_NUM = 1000;
    private static final int BATCH_COUNT = 500000;

    public Map<String, Object> getQtyAndJoinQtyByEntryId(List<Long> entryIds) {
        if (entryIds == null || entryIds.isEmpty()) {
            log.info("\u6267\u884c\u91c7\u8d2d\u7533\u8bf7\u5355\u5fae\u670d\u52a1\uff1agetQtyAndJoinQtyByEntryId \u53c2\u6570\u4e3a\u7a7a");
            return this.failure(ResManager.loadKDString((String)"\u67e5\u8be2\u7533\u8bf7\u5355\u5206\u5f55ID\u4e3a\u7a7a\u3002", (String)"PurApplyServiceImpl_0", (String)"scmc-pm-mservice", (Object[])new Object[0]));
        }
        if ((entryIds = entryIds.stream().distinct().collect(Collectors.toList())).size() > 1000) {
            log.info("\u6267\u884c\u91c7\u8d2d\u7533\u8bf7\u5355\u5fae\u670d\u52a1\uff1agetQtyAndJoinQtyByEntryId \u8d85\u8fc7\u67e5\u8be2\u4e0a\u9650\uff1a1000");
            return this.failure(ResManager.loadKDString((String)"\u8d85\u8fc7\u6700\u5927\u67e5\u8be2\u6570\u91cf\u3002", (String)"PurApplyServiceImpl_1", (String)"scmc-pm-mservice", (Object[])new Object[0]));
        }
        log.info("\u6267\u884c\u91c7\u8d2d\u7533\u8bf7\u5355\u5fae\u670d\u52a1\uff1agetQtyAndJoinQtyByEntryId \u53c2\u6570\uff1a" + entryIds);
        DynamicObjectCollection queryResult = this.queryByEntryIds(entryIds);
        if (queryResult == null || queryResult.isEmpty()) {
            log.info("\u6267\u884c\u91c7\u8d2d\u7533\u8bf7\u5355\u5fae\u670d\u52a1\uff1agetQtyAndJoinQtyByEntryId \u6570\u636e\u4e0d\u5b58\u5728");
            return this.failure(ResManager.loadKDString((String)"\u672a\u67e5\u5230\u5bf9\u5e94\u7684\u91c7\u8d2d\u7533\u8bf7\u5355\u884c\u3002", (String)"PurApplyServiceImpl_2", (String)"scmc-pm-mservice", (Object[])new Object[0]));
        }
        ArrayList<Map<String, Object>> returnList = new ArrayList<Map<String, Object>>(queryResult.size());
        for (DynamicObject row : queryResult) {
            if (row == null) continue;
            HashMap<String, Number> map = new HashMap<String, Number>(8);
            map.put("entryid", row.getLong("billentry.id"));
            map.put("qty", row.getBigDecimal("billentry.qty"));
            map.put("joinqty", row.getBigDecimal("billentry.joinqty"));
            returnList.add(map);
        }
        log.info("\u6267\u884c\u91c7\u8d2d\u7533\u8bf7\u5355\u5fae\u670d\u52a1\uff1agetQtyAndJoinQtyByEntryId \u8fd4\u56de\u6570\u636e\uff1a" + returnList);
        return this.success(returnList);
    }

    private DynamicObjectCollection queryByEntryIds(List<Long> entryIds) {
        String selectProperties = "id,billentry.id,billentry.qty,billentry.joinqty";
        QFilter qFilter = new QFilter("billentry.id", "in", entryIds);
        return QueryServiceHelper.query((String)"pm_purapplybill", (String)selectProperties, (QFilter[])qFilter.toArray());
    }

    private Map<String, Object> buildResult(Boolean success, String message, List<Map<String, Object>> data) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put("success", success);
        result.put("message", message);
        result.put("data", data);
        return result;
    }

    private Map<String, Object> success(List<Map<String, Object>> data) {
        return this.buildResult(Boolean.TRUE, "", data);
    }

    private Map<String, Object> failure(String message) {
        return this.buildResult(Boolean.FALSE, message, Collections.emptyList());
    }

    public List<DynamicObject> batchSetPRDefValue(List<DynamicObject> bills) {
        List batchSetPRDefValue = PurApplyBillHelper.batchSetPurApplyDefValue(bills);
        return batchSetPRDefValue;
    }

    @Deprecated
    public Map<String, Map<String, Object>> getMaterialFitOperator(Long orgPkValue, Set<String> materialIDSet) {
        return PurApplyBillHelper.getMaterialFitOperator((Long)orgPkValue, materialIDSet);
    }

    public Map<Long, Map<String, Object>> getMaterialFitOperatorNew(Long orgPkValue, Set<Long> materialIDSet) {
        return PurApplyBillHelper.getMaterialFitOperatorNew((Long)orgPkValue, materialIDSet);
    }

    public List<Map<String, Object>> updateOperatorAndGroup(Map<Long, Map<String, Object>> params) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(8);
        if (params == null || params.isEmpty()) {
            return result;
        }
        result.addAll(this.checkInPutParamForUpdate(params, true));
        if (result != null && result.size() > 0) {
            return result;
        }
        if (params == null || params.isEmpty()) {
            return result;
        }
        Iterator<Map.Entry<Long, Map<String, Object>>> iterator = params.entrySet().iterator();
        HashMap<Long, Long> mapIDs = new HashMap<Long, Long>(params.size());
        while (iterator.hasNext()) {
            Map.Entry<Long, Map<String, Object>> entrys = iterator.next();
            if (entrys == null) continue;
            Long purapplybillentryid = entrys.getKey();
            Map<String, Object> value = entrys.getValue();
            if (value == null) continue;
            Long id = (Long)value.get("id");
            mapIDs.put(purapplybillentryid, id);
        }
        Map<Long, Long> purApplyBillEntryIDsAndIDs = this.getPurApplyBillEntryIDsAndIDs(params);
        result.addAll(this.notExistEntryIDs(params, mapIDs, purApplyBillEntryIDsAndIDs));
        if (result != null && result.size() > 0) {
            return result;
        }
        if (params.isEmpty()) {
            return result;
        }
        DynamicObject[] purApplyBills = BusinessDataServiceHelper.load((String)"pm_purapplybill", (String)"id,billentry.entryoperatorgroup,billentry.entryoperator,billentry.purmethod", (QFilter[])new QFilter[]{new QFilter("id", "in", purApplyBillEntryIDsAndIDs.values())});
        if (purApplyBills == null || purApplyBills.length == 0) {
            return result;
        }
        OperationResult operationResult = this.modifyBillEntry(purApplyBills, params);
        result.addAll(this.addResultByOpR(purApplyBillEntryIDsAndIDs, mapIDs));
        return result;
    }

    public Map<Long, Boolean> getPurApplyChangeStatus(Set<Long> billIDSet) {
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>();
        if (billIDSet == null || billIDSet.isEmpty()) {
            return result;
        }
        log.info("\u6267\u884c\u91c7\u8d2d\u7533\u8bf7\u5355\u53d8\u66f4\u72b6\u6001\u67e5\u8be2\u5fae\u670d\u52a1\uff1agetPurApplyChangeStatus--begin:" + billIDSet.size());
        List lists = new ArrayList<ArrayList<Long>>();
        if (billIDSet.size() > 500000) {
            lists = PartitionUtils.partition(new ArrayList<Long>(billIDSet), (int)500000);
        } else {
            lists.add(new ArrayList<Long>(billIDSet));
        }
        if (lists == null || lists.isEmpty()) {
            return result;
        }
        for (List list : lists) {
            DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pm_purapplybill", (String)"id,changestatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)list)}, null);
            Throwable throwable = null;
            try {
                while (queryDataSet != null && queryDataSet.hasNext()) {
                    Row bill = queryDataSet.next();
                    Long id = bill.getLong("id");
                    String changestatus = bill.getString("changestatus");
                    if (!ChangeStatusEnum.CHANGING.getValue().equals(changestatus) && !ChangeStatusEnum.REVISING.getValue().equals(changestatus) && !ChangeStatusEnum.SUBMIT.getValue().equals(changestatus)) continue;
                    result.put(id, Boolean.TRUE);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (queryDataSet == null) continue;
                if (throwable != null) {
                    try {
                        queryDataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                queryDataSet.close();
            }
        }
        log.info("\u6267\u884c\u91c7\u8d2d\u7533\u8bf7\u5355\u53d8\u66f4\u72b6\u6001\u67e5\u8be2\u5fae\u670d\u52a1\uff1agetPurApplyChangeStatus--end:" + result.size());
        return result;
    }

    private List<Map<String, Object>> addResultByOpR(Map<Long, Long> entryIdAndIdMap, Map<Long, Long> mapIDs) {
        ArrayList<Map<String, Object>> resultByOpr = new ArrayList<Map<String, Object>>(8);
        for (Long entryId : entryIdAndIdMap.keySet()) {
            HashMap<String, Object> map = new HashMap<String, Object>(5);
            map.put("reason", "");
            map.put("success", Boolean.TRUE);
            map.put("purapplybillentryid", entryId);
            map.put("id", mapIDs.get(entryId));
            resultByOpr.add(map);
        }
        return resultByOpr;
    }

    private OperationResult modifyBillEntry(DynamicObject[] purApplyBills, Map<Long, Map<String, Object>> params) {
        OperationResult saveResult = null;
        if (params == null || params.isEmpty()) {
            return saveResult;
        }
        Set<Long> longs = params.keySet();
        ArrayList<DynamicObject> purApplyList = new ArrayList<DynamicObject>();
        if (purApplyBills == null || purApplyBills.length == 0) {
            return saveResult;
        }
        for (DynamicObject purApplyDyn : purApplyBills) {
            if (purApplyDyn == null) continue;
            DynamicObjectCollection billentrys = purApplyDyn.getDynamicObjectCollection("billentry");
            boolean change = false;
            for (DynamicObject entry : billentrys) {
                Map<String, Object> paramMap;
                if (entry == null || !longs.contains(entry.getPkValue()) || (paramMap = params.get(entry.getPkValue())) == null) continue;
                if (paramMap.get("entryoperator") != null) {
                    entry.set("entryoperator", paramMap.get("entryoperator"));
                    change = true;
                }
                if (paramMap.get("entryoperatorgroup") != null) {
                    entry.set("entryoperatorgroup", paramMap.get("entryoperatorgroup"));
                    change = true;
                }
                if (paramMap.get("purmethod") == null) continue;
                entry.set("purmethod", paramMap.get("purmethod"));
                change = true;
            }
            if (!change) continue;
            purApplyList.add(purApplyDyn);
        }
        if (purApplyList != null) {
            SaveServiceHelper.update((DynamicObject[])purApplyList.toArray(new DynamicObject[0]));
        }
        return saveResult;
    }

    private OperateOption createOperateOption() {
        OperateOption option = OperateOption.create();
        return option;
    }

    private List<Map<String, Object>> notExistEntryIDs(Map<Long, Map<String, Object>> params, Map<Long, Long> mapIDs, Map<Long, Long> purApplyBillEntryIDsAndIDs) {
        ArrayList<Map<String, Object>> errorMsg = new ArrayList<Map<String, Object>>(8);
        if (params == null || params.isEmpty()) {
            return errorMsg;
        }
        Set<Object> notExistEntryIDs = new HashSet();
        if (purApplyBillEntryIDsAndIDs != null && !purApplyBillEntryIDsAndIDs.isEmpty()) {
            Set<Long> entryIDs = params.keySet();
            for (Long entryID : entryIDs) {
                if (purApplyBillEntryIDsAndIDs.containsKey(entryID)) continue;
                notExistEntryIDs.add(entryID);
            }
        } else {
            notExistEntryIDs = params.keySet();
        }
        for (Long l : notExistEntryIDs) {
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put("reason", ResManager.loadKDString((String)"\u91c7\u8d2d\u7533\u8bf7\u5355\u884cID\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u5df2\u5ba1\u6838\u72b6\u6001\u3002", (String)"PurApplyServiceImpl_7", (String)"scmc-pm-mservice", (Object[])new Object[0]));
            map.put("success", Boolean.FALSE);
            map.put("id", mapIDs != null ? mapIDs.get(l) : null);
            map.put("purapplybillentryid", l);
            errorMsg.add(map);
            params.remove(l);
        }
        return errorMsg;
    }

    private Map<Long, Long> getPurApplyBillEntryIDsAndIDs(Map<Long, Map<String, Object>> params) {
        HashMap<Long, Long> ids = new HashMap<Long, Long>();
        if (params == null || params.isEmpty()) {
            return ids;
        }
        QFilter entryIdFilter = new QFilter("billentry.id", "in", params.keySet());
        QFilter auditFilter = new QFilter("billstatus", "=", (Object)StatusEnum.AUDIT.getValue());
        DynamicObjectCollection entrys = QueryServiceHelper.query((String)"pm_purapplybill", (String)"id,billentry.id", (QFilter[])new QFilter[]{entryIdFilter, auditFilter});
        for (DynamicObject entry : entrys) {
            if (entry == null) continue;
            ids.put((Long)entry.get("billentry.id"), (Long)entry.get("id"));
        }
        return ids;
    }

    private List<Map<String, Object>> checkInPutParamForUpdate(Map<Long, Map<String, Object>> params, boolean termOfValidity) {
        ArrayList<Map<String, Object>> errorMsg = new ArrayList<Map<String, Object>>(8);
        if (params == null || params.isEmpty()) {
            return errorMsg;
        }
        HashMap<Object, Long> operatorGrpMap = new HashMap<Object, Long>();
        Map<Object, DynamicObject> operatorMap = this.getOperators(params);
        if (operatorMap != null && !operatorMap.isEmpty()) {
            for (Map.Entry<Object, DynamicObject> operator : operatorMap.entrySet()) {
                DynamicObject operatorValue;
                if (operator == null || (operatorValue = operator.getValue()) == null) continue;
                Long operatorgrpid = operatorValue.getLong("operatorgrpid");
                operatorGrpMap.put(operatorValue.getPkValue(), operatorgrpid);
            }
        }
        ArrayList<String> purmethodList = new ArrayList<String>();
        purmethodList.add("order");
        purmethodList.add("mall");
        purmethodList.add("sourc");
        Iterator<Map.Entry<Long, Map<String, Object>>> iterator = params.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, Map<String, Object>> param = iterator.next();
            if (param == null) continue;
            Long purapplybillentryidentryid = param.getKey();
            Map<String, Object> value = param.getValue();
            if (value == null || value.isEmpty()) {
                HashMap<String, Object> map = new HashMap<String, Object>(4);
                map.put("reason", ResManager.loadKDString((String)"\u540c\u6b65\u91c7\u8d2d\u7533\u8bf7\u5355\u53c2\u6570\u9519\u8bef\u3002", (String)"PurApplyServiceImpl_3", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                map.put("success", Boolean.FALSE);
                map.put("id", value);
                map.put("purapplybillentryid", purapplybillentryidentryid);
                errorMsg.add(map);
                iterator.remove();
                break;
            }
            if (value != null && (purapplybillentryidentryid == null || Long.valueOf("0").equals(purapplybillentryidentryid))) {
                HashMap<String, Object> map = new HashMap<String, Object>(4);
                map.put("reason", ResManager.loadKDString((String)"\u540c\u6b65\u91c7\u8d2d\u7533\u8bf7\u5355\u53c2\u6570\u9519\u8bef\uff0c\u91c7\u8d2d\u7533\u8bf7\u5355\u884cID\u4e3a\u7a7a\u3002", (String)"PurApplyServiceImpl_4", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                map.put("success", Boolean.FALSE);
                map.put("id", value.get("id"));
                map.put("purapplybillentryid", purapplybillentryidentryid);
                errorMsg.add(map);
                iterator.remove();
                break;
            }
            if (value != null && purmethodList != null && !purmethodList.isEmpty() && value.get("purmethod") != null && !purmethodList.contains(value.get("purmethod"))) {
                HashMap<String, Object> map = new HashMap<String, Object>(4);
                map.put("reason", ResManager.loadKDString((String)"\u201c\u91c7\u8d2d\u65b9\u5f0f\u201d\u4e0d\u7b26\u5408\u6761\u4ef6\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PurApplyServiceImpl_5", (String)"scmc-pm-mservice", (Object[])new Object[0]));
                map.put("success", Boolean.FALSE);
                map.put("id", value.get("id"));
                map.put("purapplybillentryid", purapplybillentryidentryid);
                errorMsg.add(map);
                iterator.remove();
                break;
            }
            if (value == null || operatorGrpMap == null || operatorGrpMap.isEmpty() || value.get("entryoperator") == null || value.get("entryoperatorgroup") == null || operatorGrpMap.get(value.get("entryoperator")) == null || operatorGrpMap.get(value.get("entryoperator")).equals(value.get("entryoperatorgroup"))) continue;
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put("reason", ResManager.loadKDString((String)"\u201c\u91c7\u8d2d\u5458\u201d\u4e0d\u5728\u201c\u91c7\u8d2d\u7ec4\u201d\u4e4b\u4e2d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PurApplyServiceImpl_6", (String)"scmc-pm-mservice", (Object[])new Object[0]));
            map.put("success", Boolean.FALSE);
            map.put("id", value.get("id"));
            map.put("purapplybillentryid", purapplybillentryidentryid);
            errorMsg.add(map);
            iterator.remove();
            break;
        }
        return errorMsg;
    }

    private Map<Object, DynamicObject> getOperators(Map<Long, Map<String, Object>> params) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        ArrayList<Object> operators = new ArrayList<Object>();
        Iterator<Map.Entry<Long, Map<String, Object>>> iterator = params.entrySet().iterator();
        if (iterator == null) {
            return null;
        }
        while (iterator.hasNext()) {
            Map<String, Object> value;
            Map.Entry<Long, Map<String, Object>> param = iterator.next();
            if (param == null || (value = param.getValue()) == null || value.get("entryoperatorgroup") == null) continue;
            operators.add(value.get("entryoperatorgroup"));
        }
        QFilter qFilter02 = new QFilter("opergrptype", "=", (Object)"CGZ");
        QFilter qFilter03 = new QFilter("operatorgrpid", "in", operators);
        QFilter qFilter04 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
        Map operatorMap = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (String)"id,operatorid,operatornumber,operatorname,operatorgrpid,opergrpnumber,opergrpname,opergrptype,invalid", (QFilter[])new QFilter[]{qFilter02, qFilter03, qFilter04});
        return operatorMap;
    }
}

