/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.mservice;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.pm.business.pojo.SourceListInfo;
import kd.scmc.pm.enums.EnableStatusEnum;
import kd.scmc.pm.enums.FrozenStatusEnum;
import kd.scmc.pm.enums.SourceListTypeEnum;
import kd.scmc.pm.enums.StatusEnum;

public class PurBatchControlServiceImpl {
    private static final Log log = LogFactory.getLog(PurBatchControlServiceImpl.class);

    public List<Map<String, Object>> queryPurBatchControl(List<Map<String, Object>> params) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
        if (params == null || params.isEmpty()) {
            return result;
        }
        for (Map<String, Object> param : params) {
            Object entry;
            Object orgObj = param.get("org");
            if (orgObj == null) continue;
            Long org = orgObj instanceof Long ? (Long)orgObj : Long.parseLong(orgObj.toString());
            Date biztime = this.getBizTime(param);
            if (biztime == null || !((entry = param.get("entry")) instanceof List) || ((List)entry).isEmpty()) continue;
            List entryList = (List)entry;
            HashSet<Long> materialMasterIds = new HashSet<Long>(10);
            HashSet<Long> supplierIds = new HashSet<Long>(10);
            HashSet<Long> materialGrpIds = new HashSet<Long>(10);
            for (Map row : entryList) {
                Object materialObj = row.get("material");
                Object materialmasterObj = row.get("materialmaster");
                Object materialgroupObj = row.get("materialgroup");
                Object supplierObj = row.get("supplier");
                if (materialObj == null || materialmasterObj == null || materialgroupObj == null || supplierObj == null) continue;
                Long materialmaster = materialmasterObj instanceof Long ? (Long)materialmasterObj : Long.parseLong(materialmasterObj.toString());
                Long materialgroup = materialgroupObj instanceof Long ? (Long)materialgroupObj : Long.parseLong(materialgroupObj.toString());
                Long supplier = supplierObj instanceof Long ? (Long)supplierObj : Long.parseLong(supplierObj.toString());
                materialMasterIds.add(materialmaster);
                materialGrpIds.add(materialgroup);
                supplierIds.add(supplier);
            }
            Map<String, SourceListInfo> sourceListInfoMap = this.querySourceListInfo(org, biztime, materialMasterIds, supplierIds, materialGrpIds);
            materialMasterIds = null;
            supplierIds = null;
            materialGrpIds = null;
            HashSet<Long> noSourceListMatSet = new HashSet<Long>(10);
            Iterator iterator = entryList.iterator();
            while (iterator.hasNext()) {
                Map row = (Map)iterator.next();
                Object materialObj = row.get("material");
                Object materialmasterObj = row.get("materialmaster");
                Object materialgroupObj = row.get("materialgroup");
                Object supplierObj = row.get("supplier");
                if (materialObj == null || materialmasterObj == null || materialgroupObj == null || supplierObj == null) continue;
                Long materialmaster = materialmasterObj instanceof Long ? (Long)materialmasterObj : Long.parseLong(materialmasterObj.toString());
                Long materialgroup = materialgroupObj instanceof Long ? (Long)materialgroupObj : Long.parseLong(materialgroupObj.toString());
                Long supplier = supplierObj instanceof Long ? (Long)supplierObj : Long.parseLong(supplierObj.toString());
                Long material = materialObj instanceof Long ? (Long)materialObj : Long.parseLong(materialObj.toString());
                String dimenKey = this.getDimenKey(org, materialmaster, 0L, supplier);
                SourceListInfo sourceListInfo = sourceListInfoMap.get(dimenKey);
                if (sourceListInfo == null) {
                    dimenKey = this.getDimenKey(org, 0L, materialgroup, supplier);
                    sourceListInfo = sourceListInfoMap.get(dimenKey);
                }
                if (sourceListInfo == null) {
                    noSourceListMatSet.add(material);
                    continue;
                }
                Map<String, Object> outParam = this.buildResult(org, biztime, material, supplier, sourceListInfo);
                if (outParam == null) continue;
                result.add(outParam);
                iterator.remove();
            }
            result.addAll(this.addNoSourcePurBatchInfo(noSourceListMatSet, entryList, org, biztime));
        }
        return result;
    }

    private Date getBizTime(Map<String, Object> param) {
        SimpleDateFormat simpleFomate = new SimpleDateFormat("yyyy-MM-dd");
        Date biztime = null;
        Object biztimeObj = param.get("biztime");
        if (biztimeObj instanceof Date) {
            biztime = (Date)biztimeObj;
        } else if (biztimeObj instanceof String) {
            try {
                biztime = simpleFomate.parse((String)biztimeObj);
            }
            catch (ParseException e) {
                log.error("\u89e3\u6790\u65e5\u671f\u62a5\u9519\u3002", (Throwable)e);
            }
        }
        return biztime;
    }

    private List<Map<String, Object>> addNoSourcePurBatchInfo(Set<Long> noSourceListMatSet, List<Map<String, Object>> entryList, Long org, Date biztime) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
        if (!noSourceListMatSet.isEmpty()) {
            Map load = BusinessDataServiceHelper.loadFromCache((String)"bd_materialpurchaseinfo", (String)"maxbillbaseqty,minbillbaseqty,packingbaseqty", (QFilter[])new QFilter[]{new QFilter("id", "in", noSourceListMatSet)});
            for (Map<String, Object> row : entryList) {
                BigDecimal packingbaseqty;
                BigDecimal maxorderbaseqty;
                BigDecimal minorderbaseqty;
                SourceListInfo info;
                Map<String, Object> outParam;
                Object materialObj = row.get("material");
                Object materialmasterObj = row.get("materialmaster");
                Object materialgroupObj = row.get("materialgroup");
                Object supplierObj = row.get("supplier");
                if (materialObj == null || materialmasterObj == null || materialgroupObj == null || supplierObj == null) continue;
                Long material = materialObj instanceof Long ? (Long)materialObj : Long.parseLong(materialObj.toString());
                Long supplier = supplierObj instanceof Long ? (Long)supplierObj : Long.parseLong(supplierObj.toString());
                DynamicObject mat = (DynamicObject)load.get(material);
                if (mat == null || (outParam = this.buildResult(org, biztime, material, supplier, info = new SourceListInfo(minorderbaseqty = mat.getBigDecimal("minbillbaseqty"), maxorderbaseqty = mat.getBigDecimal("maxbillbaseqty"), packingbaseqty = mat.getBigDecimal("packingbaseqty")))) == null) continue;
                result.add(outParam);
            }
        }
        return result;
    }

    private Map<String, Object> buildResult(Long org, Date bizTime, Long material, Long supplier, SourceListInfo info) {
        HashMap<String, Object> outPutParam = new HashMap<String, Object>(10);
        if (info == null || org == null || bizTime == null || material == null || supplier == null) {
            return null;
        }
        outPutParam.put("org", org);
        outPutParam.put("biztime", bizTime);
        outPutParam.put("material", material);
        outPutParam.put("supplier", supplier);
        outPutParam.put("maxbillbaseqty", info.getMaxOrderBaseQty());
        outPutParam.put("minbillbaseqty", info.getMinOrderBaseQty());
        outPutParam.put("packingbaseqty", info.getPackingBaseQty());
        return outPutParam;
    }

    private Map<String, SourceListInfo> querySourceListInfo(Object org, Date biztime, Set<Long> materialMasterIds, Set<Long> supplierIds, Set<Long> materialGrpIds) {
        HashMap<String, SourceListInfo> result = new HashMap<String, SourceListInfo>(10);
        if (!materialMasterIds.isEmpty() && !supplierIds.isEmpty()) {
            QFilter q1 = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
            QFilter q2 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
            QFilter q3 = new QFilter("org", "=", org);
            QFilter q4 = new QFilter("supplier", "in", supplierIds);
            QFilter q5 = new QFilter("entryentity.effectdate", "<=", (Object)biztime);
            QFilter q6 = new QFilter("entryentity.expirydate", ">=", (Object)biztime);
            QFilter q7 = null;
            QFilter q71 = new QFilter("entryentity.type", "=", (Object)SourceListTypeEnum.MATERIAL.getValue());
            QFilter q72 = new QFilter("entryentity.material.masterid", "in", materialMasterIds);
            QFilter q8 = new QFilter("entryentity.frozenstatus", "=", (Object)FrozenStatusEnum.UNFROZEN.getValue());
            if (materialGrpIds.isEmpty()) {
                q7 = q71.and(q72);
            } else {
                QFilter q73 = new QFilter("entryentity.type", "=", (Object)SourceListTypeEnum.MATERIALGROUP.getValue());
                QFilter q74 = new QFilter("entryentity.materialsort", "in", materialGrpIds);
                q7 = q71.and(q72).or(q73.and(q74));
            }
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"pm_sourcelist", (String)"id,org,supplier,status,enable,entryentity.type type,entryentity.material.masterid material,entryentity.materialsort materialsort,entryentity.minbillbaseqty minbillbaseqty,entryentity.maxbillbaseqty maxbillbaseqty,entryentity.packingbaseqty packingbaseqty", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5, q6, q7, q8}, null);){
                for (Row row : dataSet) {
                    String type = row.getString("type");
                    Long materialId = 0L;
                    Long materialGroupId = 0L;
                    if (SourceListTypeEnum.MATERIAL.getValue().equals(type)) {
                        materialId = row.getLong("material");
                    } else if (SourceListTypeEnum.MATERIALGROUP.getValue().equals(type)) {
                        materialGroupId = row.getLong("materialsort");
                    }
                    Long sourceListOrgId = row.getLong("org");
                    Long sourceListSupplierId = row.getLong("supplier");
                    BigDecimal minorderbaseqty = row.getBigDecimal("minbillbaseqty");
                    BigDecimal maxorderbaseqty = row.getBigDecimal("maxbillbaseqty");
                    BigDecimal packingbaseqty = row.getBigDecimal("packingbaseqty");
                    result.put(this.getDimenKey(sourceListOrgId, materialId, materialGroupId, sourceListSupplierId), new SourceListInfo(minorderbaseqty, maxorderbaseqty, packingbaseqty));
                }
            }
        }
        return result;
    }

    private String getDimenKey(Long orgId, Long materialId, Long materialGroupId, Long supplierId) {
        StringBuilder sb = new StringBuilder();
        sb.append(orgId).append('_').append(materialId).append('_').append(materialGroupId).append('_').append(supplierId);
        return sb.toString();
    }
}

