/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.mservice;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.pm.mservice.api.PurForecastService;

public class PurForecastServiceImpl
implements PurForecastService {
    private static final Log log = LogFactory.getLog(PurForecastServiceImpl.class);
    private static final String ENTITY_NAME = "pm_splitresult";
    private static final String KEY_PLANCALCNUM = "plancalcnum";
    private static final String KEY_STARTDATE = "startdate";
    private static final String KEY_MAR_ENTRY = "mrpentry";
    private static final String KEY_SPLIT_STATUS = "splitstatus";

    public boolean forecastInit(List<Map<String, Object>> params) {
        if (params == null || params.size() == 0) {
            log.info("\u91c7\u8d2d\u9884\u6d4bforecastInit\uff0c\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        log.info("\u91c7\u8d2d\u9884\u6d4bforecastInit\uff0c\u63a5\u6536MRP\u6570\u636e\uff1a" + params);
        List<DynamicObject> list = this.parseParams(params);
        if (list.size() == 0) {
            return false;
        }
        return this.saveEntities(list);
    }

    public Map<Long, Boolean> cancelPublish(String planId, List<Long> mrpEntryIds) {
        Map<Long, Boolean> returnMap = this.getReturnMap(mrpEntryIds);
        if (StringUtils.isBlank((CharSequence)planId) || returnMap.size() == 0) {
            log.info("\u91c7\u8d2d\u9884\u6d4bcancelPublish\uff0c\u53c2\u6570\u7f3a\u5931\uff0c\u53d6\u6d88\u5931\u8d25");
            return returnMap;
        }
        DynamicObjectCollection entities = this.getSplitResultEntity(planId);
        if (entities == null || entities.size() == 0) {
            log.info("\u91c7\u8d2d\u9884\u6d4bcancelPublish\uff0c\u53ef\u5220\u9664\u6570\u636e\u83b7\u53d6\u5931\u8d25", (Object)planId, mrpEntryIds);
            return returnMap;
        }
        return this.deleteSplitResult(returnMap, entities);
    }

    private Map<Long, Boolean> deleteSplitResult(Map<Long, Boolean> returnMap, DynamicObjectCollection entities) {
        Map<Long, List<DynamicObject>> idEntityMap = entities.stream().collect(Collectors.groupingBy(entity -> entity.getLong("id")));
        ArrayList<Object> deleteBillIdList = new ArrayList<Object>();
        ArrayList<Object> deleteMrpEntryIdList = new ArrayList<Object>();
        Set<Long> paramIdSet = returnMap.keySet();
        for (Map.Entry<Long, List<DynamicObject>> entry : idEntityMap.entrySet()) {
            List<DynamicObject> oneBillEntries = entry.getValue();
            if (oneBillEntries == null) continue;
            boolean deleteBill = true;
            ArrayList<Long> deleteEntryIds = new ArrayList<Long>(oneBillEntries.size());
            for (DynamicObject mrpRow : oneBillEntries) {
                long mrpEntryId = mrpRow.getLong("mrpentry.mrp_entryid");
                if (mrpEntryId == 0L || !paramIdSet.contains(mrpEntryId)) {
                    deleteBill = false;
                    continue;
                }
                deleteEntryIds.add(mrpRow.getLong("mrpentry.id"));
                returnMap.put(mrpEntryId, Boolean.TRUE);
            }
            if (deleteBill) {
                deleteBillIdList.add(entry.getKey());
                continue;
            }
            if (deleteEntryIds.size() <= 0) continue;
            deleteMrpEntryIdList.addAll(deleteEntryIds);
        }
        if (deleteBillIdList.size() == 0 && deleteMrpEntryIdList.size() == 0) {
            log.info("\u91c7\u8d2d\u9884\u6d4bcancelPublish\uff0c\u6570\u636e\u5220\u9664\u5931\u8d25");
            return returnMap;
        }
        this.doDelete(deleteBillIdList, deleteMrpEntryIdList);
        return returnMap;
    }

    private void doDelete(List<Object> deleteBillIdList, List<Object> deleteMrpEntryIdList) {
        if (deleteBillIdList.size() > 0) {
            this.invokeBillDelete(deleteBillIdList);
        }
        if (deleteMrpEntryIdList.size() > 0) {
            this.invokeMrpEntryDelete(deleteMrpEntryIdList);
        }
    }

    private void invokeMrpEntryDelete(List<Object> deleteMrpEntryIdList) {
        String sqlTemp = "delete from t_pm_mrpentry%s where ";
        String entryIdKey = "fentryid";
        SqlBuilder builder1 = new SqlBuilder();
        builder1.append(String.format(sqlTemp, ""), new Object[0]);
        builder1.appendIn(entryIdKey, deleteMrpEntryIdList);
        SqlBuilder builder2 = new SqlBuilder();
        builder2.append(String.format(sqlTemp, "_d"), new Object[0]);
        builder2.appendIn(entryIdKey, deleteMrpEntryIdList);
        SqlBuilder builder3 = new SqlBuilder();
        builder3.append(String.format(sqlTemp, "_w"), new Object[0]);
        builder3.appendIn(entryIdKey, deleteMrpEntryIdList);
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)builder1);
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)builder2);
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)builder3);
        log.info("\u91c7\u8d2d\u9884\u6d4bcancelPublish\uff0c\u5206\u5f55\u5220\u9664\uff1a", deleteMrpEntryIdList);
    }

    private void invokeBillDelete(List<Object> deleteBillIdList) {
        QFilter qf = new QFilter("id", "in", deleteBillIdList);
        int delete = DeleteServiceHelper.delete((String)ENTITY_NAME, (QFilter[])qf.toArray());
        log.info("\u91c7\u8d2d\u9884\u6d4bcancelPublish\uff0c\u6574\u5355\u5220\u9664\uff1a" + delete, deleteBillIdList);
    }

    private DynamicObjectCollection getSplitResultEntity(String planId) {
        return QueryServiceHelper.query((String)ENTITY_NAME, (String)"id,plancalcnum,splitstatus,mrpentry.id,mrpentry.mrp_entryid", (QFilter[])this.getQueryFilters(planId));
    }

    private QFilter[] getQueryFilters(String planId) {
        QFilter qf = new QFilter(KEY_PLANCALCNUM, "=", (Object)planId);
        qf.and(KEY_SPLIT_STATUS, "in", (Object)new String[]{"F", "H"});
        return qf.toArray();
    }

    private Map<Long, Boolean> getReturnMap(List<Long> mrpEntryIds) {
        if (mrpEntryIds == null) {
            log.info("\u91c7\u8d2d\u9884\u6d4bcancelPublish,mrpEntryIds\u4e3a\u7a7a");
            return new HashMap<Long, Boolean>(0);
        }
        return mrpEntryIds.stream().filter(id -> id != null && 0L != id).collect(Collectors.toMap(k -> k, v -> Boolean.FALSE, (k1, k2) -> k1));
    }

    private boolean saveEntities(List<DynamicObject> list) {
        Object[] saveResult = SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
        log.info("\u91c7\u8d2d\u9884\u6d4bforecastInit\uff0c\u4fdd\u5b58MRP\u6570\u636e\uff1a" + list.size());
        return saveResult != null && saveResult.length > 0;
    }

    private List<DynamicObject> parseParams(List<Map<String, Object>> params) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(params.size());
        DynamicObjectType dynamicObjectType = this.getEntityType();
        if (dynamicObjectType == null) {
            log.info("\u91c7\u8d2d\u9884\u6d4bforecastInit\uff0c\u5143\u6570\u636eTYPE\u5931\u8d25");
            return list;
        }
        Date now = new Date();
        String planOrgIdKey = "planorgid";
        SimpleDateFormat dateParser = this.getDateParser();
        for (Map<String, Object> param : params) {
            Long purOrgId;
            DynamicObject entity;
            String planCalcNum = (String)param.get(KEY_PLANCALCNUM);
            if (StringUtils.isBlank((CharSequence)planCalcNum)) {
                log.info("\u91c7\u8d2d\u9884\u6d4bforecastInit,\u8ba1\u5212\u8fd0\u7b97\u53f7\u4e3a\u7a7a\uff1a", param);
                continue;
            }
            Date startDate = this.getStartDate((String)param.get(KEY_STARTDATE), dateParser);
            if (startDate == null || (entity = this.getEntityHead(dynamicObjectType, planCalcNum, startDate, purOrgId = this.getPurOrg((Long)param.get(planOrgIdKey)), now)) == null) continue;
            this.setMrpEntry(entity.getDynamicObjectCollection(KEY_MAR_ENTRY), param, purOrgId);
            list.add(entity);
        }
        return list;
    }

    private Long getPurOrg(Long planOrgId) {
        if (planOrgId == null) {
            return null;
        }
        Long org = OrgUnitServiceHelper.getToOrg((String)" ", (String)"02", (Long)planOrgId, (boolean)true);
        return org;
    }

    private SimpleDateFormat getDateParser() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    private DynamicObjectType getEntityType() {
        return EntityMetadataCache.getDataEntityType((String)ENTITY_NAME);
    }

    private void setMrpEntry(DynamicObjectCollection mrpEntry, Map<String, Object> param, Long purOrgId) {
        if (mrpEntry == null) {
            return;
        }
        String key_entry = "entry";
        String key_material = "mrp_material";
        String key_masterId = "masterid";
        List entry = (List)param.get(key_entry);
        if (entry == null || entry.size() == 0) {
            return;
        }
        for (Map row : entry) {
            Long masterId;
            if (row == null || (masterId = (Long)row.get(key_masterId)) == null) continue;
            DynamicObject dynamicObject = this.mapToDynamicObject(mrpEntry.getDynamicObjectType(), row);
            DynamicObject material = dynamicObject.getDynamicObject(key_material);
            if (material == null) {
                dynamicObject.set(key_material, (Object)masterId);
            }
            dynamicObject.set("mrp_splitstatus", (Object)"A");
            if (purOrgId != null) {
                dynamicObject.set("mrp_purorg", (Object)purOrgId);
            }
            mrpEntry.add((Object)dynamicObject);
        }
    }

    private DynamicObject mapToDynamicObject(DynamicObjectType type, Map<String, Object> row) {
        String mrpPrefix = "mrp_";
        DynamicObject dynamicObject = new DynamicObject(type);
        for (Map.Entry<String, Object> entry : row.entrySet()) {
            dynamicObject.set(mrpPrefix + entry.getKey(), entry.getValue());
        }
        return dynamicObject;
    }

    private Date getStartDate(String startDateStr, SimpleDateFormat dateParser) {
        Date startDate = null;
        if (StringUtils.isBlank((CharSequence)startDateStr)) {
            log.info("\u91c7\u8d2d\u9884\u6d4bforecastInit,\u9884\u6d4b\u5f00\u59cb\u65e5\u671f\u4e3a\u7a7a");
            return null;
        }
        try {
            startDate = dateParser.parse(startDateStr);
        }
        catch (ParseException e) {
            log.error("\u91c7\u8d2d\u9884\u6d4bforecastInit,\u9884\u6d4b\u5f00\u59cb\u65e5\u671f\u89e3\u6790\u5931\u8d25\uff1a" + startDateStr + e.getMessage());
        }
        return startDate;
    }

    private DynamicObject getEntityHead(DynamicObjectType type, String planCalcNum, Date startDate, Long purOrgId, Date createDate) {
        DynamicObject bill = new DynamicObject(type);
        bill.set(KEY_PLANCALCNUM, (Object)planCalcNum);
        String billNo = CodeRuleServiceHelper.getNumber((String)ENTITY_NAME, (DynamicObject)bill, (String)"");
        if (StringUtils.isBlank((CharSequence)billNo)) {
            log.info("\u91c7\u8d2d\u9884\u6d4bforecastInit,\u7f16\u7801\u89c4\u5219\u83b7\u53d6\u5931\u8d25");
            return null;
        }
        bill.set("billno", (Object)billNo);
        bill.set("org", (Object)purOrgId);
        bill.set(KEY_STARTDATE, (Object)startDate);
        bill.set("createtime", (Object)createDate);
        bill.set("billstatus", (Object)"C");
        bill.set(KEY_SPLIT_STATUS, (Object)"F");
        return bill;
    }
}

