/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.mservice.mobile;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.mpscmm.msbd.business.helper.AmountPlanHelper;
import kd.mpscmm.msbd.common.context.CommonContext;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.pm.business.helper.AmountHelper;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.PurOrderBillHelper;
import kd.scmc.pm.business.pojo.AmountPropertyKey;
import kd.scmc.pm.enums.UnitConvertDirEnum;
import kd.scmc.pm.mservice.mobile.IPmEntityService;

public class PurOrderService
implements IPmEntityService {
    private static final String FIELD = "field";
    private static final String BILLENTRY_QTY = "billentry.qty";
    private static final String ENTRY_ID = "entryId";
    private static final String UNIT_CONVERT_DIR = "unitconvertdir";

    @Override
    public DynamicObject propChanged(DynamicObject bill, List<Map<String, Object>> changedFields) {
        for (Map<String, Object> changedField : changedFields) {
            String fieldKey = (String)changedField.get(FIELD);
            if (!BILLENTRY_QTY.equals(fieldKey)) continue;
            DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
            Long entryId = (Long)changedField.get(ENTRY_ID);
            for (int i = 0; i < billEntry.size(); ++i) {
                DynamicObject entry = (DynamicObject)billEntry.get(i);
                Long pkValue = (Long)entry.getPkValue();
                if (entryId == null || entryId.compareTo(0L) == 0 || entryId.compareTo(pkValue) != 0) continue;
                this.changeQty(entry);
                this.calReceiveUpAndDownQty(entry);
                this.calAmount(bill, entry, i);
            }
            this.reCalPayPlanAmountByBill(bill);
        }
        return bill;
    }

    @Override
    public DynamicObject deleteRow(DynamicObject bill, String entity, List<Long> rowIds) {
        DynamicObjectCollection entryColl = bill.getDynamicObjectCollection(entity);
        block0: for (int i = 0; i < entryColl.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryColl.get(i);
            Long pkValue = (Long)entry.getPkValue();
            if (pkValue == null || pkValue.compareTo(0L) == 0) continue;
            for (Long row : rowIds) {
                if (row == null || row.compareTo(pkValue) != 0) continue;
                this.reCalHeadAmount(bill, i);
                entryColl.remove(i);
                continue block0;
            }
        }
        this.reCalPayPlanAmountByBill(bill);
        return bill;
    }

    private void changeQty(DynamicObject entry) {
        BigDecimal qty = entry.getBigDecimal("qty");
        DynamicObject material = entry.getDynamicObject("material");
        DynamicObject unit = entry.getDynamicObject("unit");
        if (material == null || unit == null) {
            return;
        }
        DynamicObject materialMaster = material.getDynamicObject("masterid");
        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
        DynamicObject auxUnit = entry.getDynamicObject("auxunit");
        if (baseUnit == null) {
            baseUnit = materialMaster.getDynamicObject("baseunit");
        }
        if (baseUnit != null) {
            Long materialMasterId = (Long)materialMaster.getPkValue();
            BigDecimal baseQty = BillQtyAndUnitHelper.getDesQtyConv((Long)materialMasterId, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
            entry.set("baseqty", (Object)baseQty);
            if (auxUnit != null) {
                String unitConvertDir = materialMaster.getString(UNIT_CONVERT_DIR);
                if (UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                    BigDecimal auxQty = BillQtyAndUnitHelper.getDesQtyConv((Long)materialMasterId, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxUnit);
                    entry.set("auxqty", (Object)auxQty);
                }
            }
        }
    }

    private void calReceiveUpAndDownQty(DynamicObject entry) {
        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
        DynamicObject unit = entry.getDynamicObject("unit");
        BigDecimal qty = entry.getBigDecimal("qty");
        BigDecimal baseQty = BigDecimalUtil.getNotNull((Object)entry.getBigDecimal("baseqty"));
        BigDecimal receiveRateUp = BigDecimalUtil.getNotNull((Object)entry.getBigDecimal("receiverateup"));
        BigDecimal receiveRateDown = BigDecimalUtil.getNotNull((Object)entry.getBigDecimal("receiveratedown"));
        BigDecimal receiveQtyUp = this.getReceiveQtyUp(qty, receiveRateUp, unit);
        BigDecimal receiveQtyDown = this.getReceiveQtyDown(qty, receiveRateDown, unit);
        BigDecimal receiveBaseQtyUp = this.getReceiveQtyUp(baseQty, receiveRateUp, baseUnit);
        BigDecimal receiveBaseQtyDown = this.getReceiveQtyDown(baseQty, receiveRateDown, baseUnit);
        entry.set("receiveqtyup", (Object)receiveQtyUp);
        entry.set("receiveqtydown", (Object)receiveQtyDown);
        entry.set("receivebaseqtyup", (Object)receiveBaseQtyUp);
        entry.set("receivebaseqtydown", (Object)receiveBaseQtyDown);
    }

    private void calAmount(DynamicObject bill, DynamicObject entry, int i) {
        BigDecimal totalAmount = BigDecimalUtil.getNotNull((Object)bill.getBigDecimal("totalamount"));
        BigDecimal totalTaxAmount = BigDecimalUtil.getNotNull((Object)bill.getBigDecimal("totaltaxamount"));
        BigDecimal totalAmountAndTax = BigDecimalUtil.getNotNull((Object)bill.getBigDecimal("totalallamount"));
        BigDecimal oldAmount = BigDecimalUtil.getNotNull((Object)entry.getBigDecimal("amount"));
        BigDecimal oldTaxAmount = BigDecimalUtil.getNotNull((Object)entry.getBigDecimal("taxamount"));
        BigDecimal oldAmountAndTax = BigDecimalUtil.getNotNull((Object)entry.getBigDecimal("amountandtax"));
        AmountPropertyKey propertyKey = AmountPropertyKey.getInstance();
        Map entryAmountMap = AmountHelper.calcAmount((DynamicObject)bill, (AmountPropertyKey)propertyKey, (int)i);
        if (!entryAmountMap.isEmpty()) {
            BigDecimal amountAndTax;
            BigDecimal taxAmount;
            BigDecimal amount = (BigDecimal)entryAmountMap.get(propertyKey.getAmount());
            if (amount != null) {
                bill.set("totalamount", (Object)totalAmount.subtract(oldAmount).add(amount));
            }
            if ((taxAmount = (BigDecimal)entryAmountMap.get(propertyKey.getTaxAmount())) != null) {
                bill.set("totaltaxamount", (Object)totalTaxAmount.subtract(oldTaxAmount).add(taxAmount));
            }
            if ((amountAndTax = (BigDecimal)entryAmountMap.get(propertyKey.getAmountAndTax())) != null) {
                bill.set("totalallamount", (Object)totalAmountAndTax.subtract(oldAmountAndTax).add(amountAndTax));
            }
        }
    }

    private void reCalPayPlanAmountByBill(DynamicObject bill) {
        if (bill == null) {
            return;
        }
        CommonContext context = PurOrderBillHelper.getPayPlanCommonText((String)bill.getDataEntityType().getName());
        AmountPlanHelper.calAmountPlanForDynamicObject((CommonContext)context, (DynamicObject)bill);
    }

    private void reCalHeadAmount(DynamicObject bill, int i) {
        DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
        DynamicObject entry = (DynamicObject)billentry.get(i);
        BigDecimal totalAmount = BigDecimalUtil.getNotNull((Object)bill.getBigDecimal("totalamount"));
        BigDecimal totalTaxAmount = BigDecimalUtil.getNotNull((Object)bill.getBigDecimal("totaltaxamount"));
        BigDecimal totalAllAmount = BigDecimalUtil.getNotNull((Object)bill.getBigDecimal("totalallamount"));
        BigDecimal amount = BigDecimalUtil.getNotNull((Object)entry.getBigDecimal("amount"));
        BigDecimal taxAmount = BigDecimalUtil.getNotNull((Object)entry.getBigDecimal("taxamount"));
        BigDecimal amountAndTax = BigDecimalUtil.getNotNull((Object)entry.getBigDecimal("amountandtax"));
        totalAmount = totalAmount.subtract(amount);
        totalTaxAmount = totalTaxAmount.subtract(taxAmount);
        totalAllAmount = totalAllAmount.subtract(amountAndTax);
        bill.set("totalamount", (Object)totalAmount);
        bill.set("totaltaxamount", (Object)totalTaxAmount);
        bill.set("totalallamount", (Object)totalAllAmount);
    }

    private BigDecimal getReceiveQtyUp(BigDecimal qty, BigDecimal receiveRateUp, DynamicObject unit) {
        return BigDecimalUtil.getByGrowRate((BigDecimal)qty, (BigDecimal)BigDecimalUtil.div100((BigDecimal)receiveRateUp)).setScale(BillQtyAndUnitHelper.getPrecision((DynamicObject)unit), BillQtyAndUnitHelper.getUnitRoundingMode((DynamicObject)unit));
    }

    private BigDecimal getReceiveQtyDown(BigDecimal qty, BigDecimal receiveRateDown, DynamicObject unit) {
        return BigDecimalUtil.getByReduceRate((BigDecimal)qty, (BigDecimal)BigDecimalUtil.div100((BigDecimal)receiveRateDown)).setScale(BillQtyAndUnitHelper.getPrecision((DynamicObject)unit), BillQtyAndUnitHelper.getUnitRoundingMode((DynamicObject)unit));
    }
}

